/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.CommonLogger;
import com.bmc.ctmconvert.Printer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/bmc/ctmconvert/VersionValidator;", "", "currentVersion", "", "printer", "Lcom/bmc/ctmconvert/Printer;", "logger", "Lcom/bmc/ctmconvert/CommonLogger;", "versionUrl", "Ljava/net/URL;", "<init>", "(Ljava/lang/String;Lcom/bmc/ctmconvert/Printer;Lcom/bmc/ctmconvert/CommonLogger;Ljava/net/URL;)V", "getCurrentVersion", "()Ljava/lang/String;", "getPrinter", "()Lcom/bmc/ctmconvert/Printer;", "getVersionUrl", "()Ljava/net/URL;", "checkForNewVersion", "", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nVersionValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionValidator.kt\ncom/bmc/ctmconvert/VersionValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
public final class VersionValidator {
    @NotNull
    private final String currentVersion;
    @NotNull
    private final Printer printer;
    @NotNull
    private final CommonLogger logger;
    @NotNull
    private final URL versionUrl;

    public VersionValidator(@NotNull String currentVersion, @NotNull Printer printer, @NotNull CommonLogger logger, @NotNull URL versionUrl) {
        Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)versionUrl, (String)"versionUrl");
        this.currentVersion = currentVersion;
        this.printer = printer;
        this.logger = logger;
        this.versionUrl = versionUrl;
    }

    public /* synthetic */ VersionValidator(String string, Printer printer, CommonLogger commonLogger, URL uRL, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            uRL = URI.create("https://control-m-conversion.s3.eu-central-1.amazonaws.com/Control-M_Conversions_for_DS/migrateToHelixVersion.txt").toURL();
        }
        this(string, printer, commonLogger, uRL);
    }

    @NotNull
    public final String getCurrentVersion() {
        return this.currentVersion;
    }

    @NotNull
    public final Printer getPrinter() {
        return this.printer;
    }

    @NotNull
    public final URL getVersionUrl() {
        return this.versionUrl;
    }

    public final boolean checkForNewVersion() {
        boolean newVersionAvailable;
        Object object;
        try {
            Object object2 = this.versionUrl.openConnection();
            URLConnection it = object2;
            boolean bl = false;
            it.setReadTimeout(10000);
            it.setConnectTimeout(10000);
            InputStream inputStream = ((URLConnection)object2).getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            object = inputStream;
            object2 = Charsets.UTF_8;
            Reader reader = new InputStreamReader((InputStream)object, (Charset)object2);
            int n = 8192;
            object = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        }
        catch (Exception e) {
            this.logger.error("failed getting migrateToHelixVersion.txt", (Throwable)e);
            this.printer.print("Error checking for new version: " + e.getMessage());
            object = this.currentVersion;
        }
        String latestVersion = object;
        boolean bl = newVersionAvailable = latestVersion.compareTo(this.currentVersion) > 0;
        if (newVersionAvailable) {
            this.printer.print("New version is available:\nYou can download the latest version from: https://control-m-conversion.s3.eu-central-1.amazonaws.com/Control-M_Conversions_for_DS/migration-tool.html");
        }
        return newVersionAvailable;
    }
}

