/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.databaseCommon.Server;
import com.bmc.ctmconvert.excelUtils.ExcelFile;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\nH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0017\u0010\u0015\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/bmc/ctmconvert/ServerMetadataExcelFile;", "Lcom/bmc/ctmconvert/excelUtils/ExcelFile;", "filePath", "", "fileSystem", "Ljava/nio/file/FileSystem;", "<init>", "(Ljava/lang/String;Ljava/nio/file/FileSystem;)V", "hiddenSheetName", "initExcelFile", "", "serverList", "", "Lcom/bmc/ctmconvert/databaseCommon/Server;", "createCtmServerListSheet", "Lorg/apache/poi/xssf/usermodel/XSSFSheet;", "fillWithServerList", "sheet", "createHiddenSheetForTimeZoneList", "createCellWithFontItalicForTimeZone", "Lorg/apache/poi/xssf/usermodel/XSSFRichTextString;", "getFirstDayName", "firstDayOfWeek", "", "(Ljava/lang/Integer;)Ljava/lang/String;", "addTimeZoneDropDownList", "rowIndex", "colIndex", "getTimeZoneList", "", "()[Ljava/lang/String;", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nServerMetadataExcelFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerMetadataExcelFile.kt\ncom/bmc/ctmconvert/ServerMetadataExcelFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,99:1\n774#2:100\n865#2,2:101\n1863#2,2:103\n13474#3,3:105\n*S KotlinDebug\n*F\n+ 1 ServerMetadataExcelFile.kt\ncom/bmc/ctmconvert/ServerMetadataExcelFile\n*L\n43#1:100\n43#1:101,2\n44#1:103,2\n57#1:105,3\n*E\n"})
public final class ServerMetadataExcelFile
extends ExcelFile {
    @NotNull
    private final String filePath;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final String hiddenSheetName;

    public ServerMetadataExcelFile(@NotNull String filePath, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.filePath = filePath;
        this.fileSystem = fileSystem;
        this.hiddenSheetName = "hidden";
    }

    public final void initExcelFile(@NotNull List<Server> serverList) {
        Intrinsics.checkNotNullParameter(serverList, (String)"serverList");
        XSSFSheet sheet = this.createCtmServerListSheet();
        this.createHiddenSheetForTimeZoneList();
        this.fillWithServerList(serverList, sheet);
        Path path = this.fileSystem.getPath(this.filePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        this.writeExcelFile(path);
    }

    private final XSSFSheet createCtmServerListSheet() {
        Object[] objectArray = new String[]{"Control-M Server Name", "New Day Time", "Time Zone", "Start Day"};
        List columns = CollectionsKt.listOf((Object[])objectArray);
        XSSFSheet sheet = this.getWorkbook().createSheet("Control-M Server List");
        Intrinsics.checkNotNull((Object)sheet);
        this.createHeader((Sheet)sheet, columns);
        return sheet;
    }

    /*
     * WARNING - void declaration
     */
    private final void fillWithServerList(List<Server> serverList, XSSFSheet sheet) {
        void $this$filterTo$iv$iv;
        int serverNameColumn = 0;
        int newDayColumn = 1;
        int timeZoneColumn = 2;
        int firstDayColumn = 3;
        XSSFRichTextString cellValue = this.createCellWithFontItalicForTimeZone();
        Iterable $this$filter$iv = serverList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Server server = (Server)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)server.getPlatform(), (Object)"MVS"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue it = (IndexedValue)element$iv;
            boolean bl = false;
            int rowNum = it.getIndex() + 1;
            XSSFRow row = sheet.createRow(rowNum);
            this.addTimeZoneDropDownList(sheet, rowNum, timeZoneColumn);
            Intrinsics.checkNotNull((Object)row);
            this.createReportCell((Row)row, serverNameColumn, ((Server)it.getValue()).getServerName());
            this.createReportCell((Row)row, newDayColumn, ((Server)it.getValue()).getNewDay());
            this.createReportCell((Row)row, timeZoneColumn, cellValue);
            this.createReportCell((Row)row, firstDayColumn, this.getFirstDayName(((Server)it.getValue()).getFirstDayOfWeek()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createHiddenSheetForTimeZoneList() {
        XSSFSheet hiddenSheet = this.getWorkbook().createSheet(this.hiddenSheetName);
        String[] $this$forEachIndexed$iv = this.getTimeZoneList();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (String item$iv : $this$forEachIndexed$iv) {
            void timeZone;
            int n = index$iv++;
            String string = item$iv;
            int index = n;
            boolean bl = false;
            XSSFRow row = hiddenSheet.createRow(index);
            XSSFCell cell = row.createCell(0);
            cell.setCellValue((String)timeZone);
        }
        XSSFName namedCell = this.getWorkbook().createName();
        namedCell.setNameName(this.hiddenSheetName);
        namedCell.setRefersToFormula(this.hiddenSheetName + "!$A$1:$A$" + this.getTimeZoneList().length);
        this.getWorkbook().setSheetHidden(1, true);
    }

    private final XSSFRichTextString createCellWithFontItalicForTimeZone() {
        XSSFFont xSSFFont = this.getWorkbook().createFont();
        Intrinsics.checkNotNullExpressionValue((Object)xSSFFont, (String)"createFont(...)");
        XSSFFont fontItalic = xSSFFont;
        fontItalic.setItalic(true);
        XSSFRichTextString cellValue = new XSSFRichTextString();
        cellValue.append("Choose one from the drop down menu", fontItalic);
        return cellValue;
    }

    private final String getFirstDayName(Integer firstDayOfWeek) {
        String string;
        Integer n;
        Integer n2 = n = firstDayOfWeek;
        int n3 = 1;
        if (n2 != null && n2 == n3) {
            string = "Sunday";
        } else {
            Integer n4 = n;
            n3 = 2;
            if (n4 != null && n4 == n3) {
                string = "Monday";
            } else {
                Integer n5 = n;
                n3 = 3;
                if (n5 != null && n5 == n3) {
                    string = "Tuesday";
                } else {
                    Integer n6 = n;
                    n3 = 4;
                    if (n6 != null && n6 == n3) {
                        string = "Wednesday";
                    } else {
                        Integer n7 = n;
                        n3 = 5;
                        if (n7 != null && n7 == n3) {
                            string = "Thursday";
                        } else {
                            Integer n8 = n;
                            n3 = 6;
                            if (n8 != null && n8 == n3) {
                                string = "Friday";
                            } else {
                                Integer n9 = n;
                                n3 = 7;
                                string = n9 != null && n9 == n3 ? "Saturday" : "Monday";
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    private final void addTimeZoneDropDownList(XSSFSheet sheet, int rowIndex, int colIndex) {
        XSSFDataValidationHelper validationHelper = new XSSFDataValidationHelper(sheet);
        CellRangeAddressList addressList = new CellRangeAddressList(rowIndex, rowIndex, colIndex, colIndex);
        DataValidationConstraint constraint = validationHelper.createFormulaListConstraint(this.hiddenSheetName);
        DataValidation dataValidation = validationHelper.createValidation(constraint, addressList);
        dataValidation.setSuppressDropDownArrow(true);
        sheet.addValidationData(dataValidation);
    }

    private final String[] getTimeZoneList() {
        String[] stringArray = new String[]{"Africa(Abidjan)", "Africa(Accra)", "Africa(Addis_Ababa)", "Africa(Algiers)", "Africa(Asmara)", "Africa(Asmera)", "Africa(Bamako)", "Africa(Bangui)", "Africa(Banjul)", "Africa(Bissau)", "Africa(Blantyre)", "Africa(Brazzaville)", "Africa(Bujumbura)", "Africa(Cairo)", "Africa(Casablanca)", "Africa(Ceuta)", "Africa(Conakry)", "Africa(Dakar)", "Africa(Dar_es_Salaam)", "Africa(Djibouti)", "Africa(Douala)", "Africa(El_Aaiun)", "Africa(Freetown)", "Africa(Gaborone)", "Africa(Harare)", "Africa(Johannesburg)", "Africa(Juba)", "Africa(Kampala)", "Africa(Khartoum)", "Africa(Kigali)", "Africa(Kinshasa)", "Africa(Lagos)", "Africa(Libreville)", "Africa(Lome)", "Africa(Luanda)", "Africa(Lubumbashi)", "Africa(Lusaka)", "Africa(Malabo)", "Africa(Maputo)", "Africa(Maseru)", "Africa(Mbabane)", "Africa(Mogadishu)", "Africa(Monrovia)", "Africa(Nairobi)", "Africa(Ndjamena)", "Africa(Niamey)", "Africa(Nouakchott)", "Africa(Ouagadougou)", "Africa(Porto-Novo)", "Africa(Sao_Tome)", "Africa(Timbuktu)", "Africa(Tripoli)", "Africa(Tunis)", "Africa(Windhoek)", "America(Adak)", "America(Anchorage)", "America(Anguilla)", "America(Antigua)", "America(Araguaina)", "America(Argentina(Buenos_Aires)", "America(Argentina(Catamarca)", "America(Argentina(Cordoba)", "America(Argentina(Jujuy)", "America(Argentina(La_Rioja)", "America(Argentina(Mendoza)", "America(Argentina(Rio_Gallegos)", "America(Argentina(Salta)", "America(Argentina(San_Juan)", "America(Argentina(San_Luis)", "America(Argentina(Tucuman)", "America(Argentina(Ushuaia)", "America(Aruba)", "America(Asuncion)", "America(Atikokan)", "America(Bahia)", "America(Bahia_Banderas)", "America(Barbados)", "America(Belem)", "America(Belize)", "America(Blanc-Sablon)", "America(Boa_Vista)", "America(Bogota)", "America(Boise)", "America(Cambridge_Bay)", "America(Campo_Grande)", "America(Cancun)", "America(Caracas)", "America(Cayenne)", "America(Cayman)", "America(Chicago)", "America(Chihuahua)", "America(Costa_Rica)", "America(Creston)", "America(Cuiaba)", "America(Curacao)", "America(Danmarkshavn)", "America(Dawson)", "America(Dawson_Creek)", "America(Denver)", "America(Detroit)", "America(Dominica)", "America(Edmonton)", "America(Eirunepe)", "America(El_Salvador)", "America(Fort_Nelson)", "America(Fortaleza)", "America(Glace_Bay)", "America(Godthab)", "America(Goose_Bay)", "America(Grand_Turk)", "America(Grenada)", "America(Guadeloupe)", "America(Guatemala)", "America(Guayaquil)", "America(Guyana)", "America(Halifax)", "America(Havana)", "America(Hermosillo)", "America(Indiana(Indianapolis)", "America(Indiana(Knox)", "America(Indiana(Marengo)", "America(Indiana(Petersburg)", "America(Indiana(Tell_City)", "America(Indiana(Vevay)", "America(Indiana(Vincennes)", "America(Indiana(Winamac)", "America(Inuvik)", "America(Iqaluit)", "America(Jamaica)", "America(Juneau)", "America(Kentucky(Louisville)", "America(Kentucky(Monticello)", "America(Kralendijk)", "America(La_Paz)", "America(Lima)", "America(Los_Angeles)", "America(Lower_Princes)", "America(Maceio)", "America(Managua)", "America(Manaus)", "America(Marigot)", "America(Martinique)", "America(Matamoros)", "America(Mazatlan)", "America(Menominee)", "America(Merida)", "America(Metlakatla)", "America(Mexico_City)", "America(Miquelon)", "America(Moncton)", "America(Monterrey)", "America(Montevideo)", "America(Montserrat)", "America(Nassau)", "America(New_York)", "America(Nipigon)", "America(Nome)", "America(Noronha)", "America(North_Dakota(Beulah)", "America(North_Dakota(Center)", "America(North_Dakota(New_Salem)", "America(Ojinaga)", "America(Panama)", "America(Pangnirtung)", "America(Paramaribo)", "America(Phoenix)", "America(Port-au-Prince)", "America(Port_of_Spain)", "America(Porto_Velho)", "America(Puerto_Rico)", "America(Punta_Arenas)", "America(Rainy_River)", "America(Rankin_Inlet)", "America(Recife)", "America(Regina)", "America(Resolute)", "America(Rio_Branco)", "America(Santarem)", "America(Santiago)", "America(Santo_Domingo)", "America(Sao_Paulo)", "America(Scoresbysund)", "America(Sitka)", "America(St_Barthelemy)", "America(St_Johns)", "America(St_Kitts)", "America(St_Lucia)", "America(St_Thomas)", "America(St_Vincent)", "America(Swift_Current)", "America(Tegucigalpa)", "America(Thule)", "America(Thunder_Bay)", "America(Tijuana)", "America(Toronto)", "America(Tortola)", "America(Vancouver)", "America(Whitehorse)", "America(Winnipeg)", "America(Yakutat)", "America(Yellowknife)", "Antarctica(Casey)", "Antarctica(Davis)", "Antarctica(DumontDUrville)", "Antarctica(Macquarie)", "Antarctica(Mawson)", "Antarctica(McMurdo)", "Antarctica(Palmer)", "Antarctica(Rothera)", "Antarctica(South_Pole)", "Antarctica(Syowa)", "Antarctica(Troll)", "Antarctica(Vostok)", "Arctic(Longyearbyen)", "Asia(Aden [EMEA])", "Asia(Almaty )", "Asia(Amman [EMEA])", "Asia(Anadyr [EMEA])", "Asia(Aqtau )", "Asia(Aqtobe )", "Asia(Ashgabat)", "Asia(Ashkhabad)", "Asia(Atyrau )", "Asia(Baghdad [EMEA])", "Asia(Bahrain [EMEA])", "Asia(Baku [EMEA])", "Asia(Bangkok )", "Asia(Barnaul [EMEA])", "Asia(Beirut [EMEA])", "Asia(Bishkek )", "Asia(Brunei)", "Asia(Calcutta)", "Asia(Chita [EMEA])", "Asia(Choibalsan)", "Asia(Chongqing)", "Asia(Chungking)", "Asia(Colombo)", "Asia(Dacca)", "Asia(Damascus [EMEA])", "Asia(Dhaka )", "Asia(Dili)", "Asia(Dubai [EMEA])", "Asia(Dushanbe)", "Asia(Famagusta [EMEA])", "Asia(Gaza [EMEA])", "Asia(Harbin)", "Asia(Hebron [EMEA])", "Asia(Ho_Chi_Minh)", "Asia(Hong_Kong)", "Asia(Hovd)", "Asia(Irkutsk [EMEA])", "Asia(Istanbul [EMEA])", "Asia(Jakarta)", "Asia(Jayapura)", "Asia(Jerusalem [EMEA])", "Asia(Kabul)", "Asia(Kamchatka [EMEA])", "Asia(Karachi)", "Asia(Kashgar)", "Asia(Kathmandu)", "Asia(Katmandu)", "Asia(Khandyga [EMEA])", "Asia(Kolkata)", "Asia(Krasnoyarsk [EMEA])", "Asia(Kuala_Lumpur)", "Asia(Kuching)", "Asia(Kuwait [EMEA])", "Asia(Macao)", "Asia(Macau)", "Asia(Magadan [EMEA])", "Asia(Makassar)", "Asia(Manila)", "Asia(Muscat [EMEA])", "Asia(Nicosia [EMEA])", "Asia(Novokuznetsk [EMEA])", "Asia(Novosibirsk [EMEA])", "Asia(Omsk [EMEA])", "Asia(Oral)", "Asia(Phnom_Penh)", "Asia(Pontianak)", "Asia(Pyongyang)", "Asia(Qatar [EMEA])", "Asia(Qostanay)", "Asia(Qyzylorda)", "Asia(Rangoon)", "Asia(Riyadh [EMEA])", "Asia(Saigon)", "Asia(Sakhalin [EMEA])", "Asia(Samarkand)", "Asia(Seoul)", "Asia(Shanghai)", "Asia(Singapore)", "Asia(Srednekolymsk [EMEA])", "Asia(Taipei)", "Asia(Tashkent)", "Asia(Tbilisi [EMEA])", "Asia(Tehran [EMEA])", "Asia(Tel_Aviv [EMEA])", "Asia(Thimbu)", "Asia(Thimphu)", "Asia(Tokyo)", "Asia(Tomsk [EMEA])", "Asia(Ujung_Pandang)", "Asia(Ulaanbaatar)", "Asia(Ulan_Bator)", "Asia(Urumqi)", "Asia(Ust-Nera [EMEA])", "Asia(Vientiane)", "Asia(Vladivostok [EMEA])", "Asia(Yakutsk [EMEA])", "Asia(Yangon)", "Asia(Yekaterinburg [EMEA])", "Asia(Yerevan [EMEA])", "Atlantic(Azores)", "Atlantic(Bermuda)", "Atlantic(Canary)", "Atlantic(Cape_Verde)", "Atlantic(Faeroe)", "Atlantic(Faroe)", "Atlantic(Jan_Mayen)", "Atlantic(Madeira)", "Atlantic(Reykjavik)", "Atlantic(South_Georgia)", "Atlantic(St_Helena)", "Atlantic(Stanley)", "Australia(ACT)", "Australia(Adelaide)", "Australia(Brisbane)", "Australia(Broken_Hill)", "Australia(Canberra)", "Australia(Currie)", "Australia(Darwin)", "Australia(Eucla)", "Australia(Hobart)", "Australia(LHI)", "Australia(Lindeman)", "Australia(Lord_Howe)", "Australia(Melbourne)", "Australia(NSW)", "Australia(North)", "Australia(Perth)", "Australia(Queensland)", "Australia(South)", "Australia(Sydney)", "Australia(Tasmania)", "Australia(Victoria)", "Australia(West)", "Australia(Yancowinna)", "Europe(Amsterdam)", "Europe(Andorra)", "Europe(Astrakhan)", "Europe(Athens)", "Europe(Belfast)", "Europe(Belgrade)", "Europe(Berlin)", "Europe(Bratislava)", "Europe(Brussels)", "Europe(Bucharest)", "Europe(Budapest)", "Europe(Busingen)", "Europe(Chisinau)", "Europe(Copenhagen)", "Europe(Dublin)", "Europe(Gibraltar)", "Europe(Guernsey)", "Europe(Helsinki)", "Europe(Isle_of_Man)", "Europe(Istanbul)", "Europe(Jersey)", "Europe(Kaliningrad)", "Europe(Kiev)", "Europe(Kirov)", "Europe(Lisbon)", "Europe(Ljubljana)", "Europe(London)", "Europe(Luxembourg)", "Europe(Madrid)", "Europe(Malta)", "Europe(Mariehamn)", "Europe(Minsk)", "Europe(Monaco)", "Europe(Moscow)", "Europe(Nicosia)", "Europe(Oslo)", "Europe(Paris)", "Europe(Podgorica)", "Europe(Prague)", "Europe(Riga)", "Europe(Rome)", "Europe(Samara)", "Europe(San_Marino)", "Europe(Sarajevo)", "Europe(Saratov)", "Europe(Simferopol)", "Europe(Skopje)", "Europe(Sofia)", "Europe(Stockholm)", "Europe(Tallinn)", "Europe(Tirane)", "Europe(Tiraspol)", "Europe(Ulyanovsk)", "Europe(Uzhgorod)", "Europe(Vaduz)", "Europe(Vatican)", "Europe(Vienna)", "Europe(Vilnius)", "Europe(Volgograd)", "Europe(Warsaw)", "Europe(Zagreb)", "Europe(Zaporozhye)", "Europe(Zurich)", "Indian(Antananarivo)", "Indian(Chagos)", "Indian(Christmas)", "Indian(Cocos)", "Indian(Comoro)", "Indian(Kerguelen)", "Indian(Mahe)", "Indian(Maldives)", "Indian(Mauritius)", "Indian(Mayotte)", "Indian(Reunion)", "Pacific(Apia)", "Pacific(Auckland)", "Pacific(Bougainville)", "Pacific(Chatham)", "Pacific(Chuuk)", "Pacific(Easter)", "Pacific(Efate)", "Pacific(Enderbury)", "Pacific(Fakaofo)", "Pacific(Fiji)", "Pacific(Funafuti)", "Pacific(Galapagos)", "Pacific(Gambier)", "Pacific(Guadalcanal)", "Pacific(Guam)", "Pacific(Honolulu)", "Pacific(Johnston)", "Pacific(Kiritimati)", "Pacific(Kosrae)", "Pacific(Kwajalein)", "Pacific(Majuro)", "Pacific(Marquesas)", "Pacific(Midway)", "Pacific(Nauru)", "Pacific(Niue)", "Pacific(Norfolk)", "Pacific(Noumea)", "Pacific(Pago_Pago)", "Pacific(Palau)", "Pacific(Pitcairn)", "Pacific(Pohnpei)", "Pacific(Port_Moresby)", "Pacific(Rarotonga)", "Pacific(Saipan)", "Pacific(Tahiti)", "Pacific(Tarawa)", "Pacific(Tongatapu)", "Pacific(Truk)", "Pacific(Wake)", "Pacific(Wallis)", "Pacific(Yap)"};
        return stringArray;
    }
}

