/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.oozie;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.rbc.RbcNamer;
import com.bmc.ctmconvert.oozie.OozieHierarchyMapping;
import com.bmc.ctmconvert.oozie.OozieProperties;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RbcGenerator {
    private static RbcGenerator instance;
    private static final String[] weekdaysArr;
    private HashMap<String, Properties> rbcMap;
    private HashMap<String, HashSet<ArrayList<String>>> messageMap;
    private Integer anonymous_count = 0;

    private RbcGenerator() {
        this.coordinatorsToRbcs();
    }

    public HashSet<ArrayList<String>> getMessages(String coordinator) {
        HashSet<ArrayList<String>> toRet = new HashSet<ArrayList<String>>();
        if (this.messageMap != null && this.messageMap.containsKey(coordinator)) {
            for (ArrayList<String> toAdd : this.messageMap.get(coordinator)) {
                toRet.add(new ArrayList<String>(toAdd));
            }
        }
        return toRet;
    }

    private void addMessage(String coord, String msgid, String ... msgArgs) {
        if (this.messageMap == null) {
            this.messageMap = new HashMap();
        }
        if (!this.messageMap.containsKey(coord)) {
            this.messageMap.put(coord, new HashSet());
        }
        ArrayList<String> toAdd = new ArrayList<String>();
        toAdd.add(msgid);
        for (int i = 0; i < msgArgs.length; ++i) {
            toAdd.add(msgArgs[i]);
        }
        this.messageMap.get(coord).add(toAdd);
    }

    private void coordinatorsToRbcs() {
        File[] coordinatorFiles = new File(Params.instance().getDatasourcePath() + "coordinator").listFiles();
        for (int i = 0; coordinatorFiles != null && i < coordinatorFiles.length; ++i) {
            if (!coordinatorFiles[i].getName().toLowerCase().endsWith(".xml")) continue;
            this.mapRbc(coordinatorFiles[i]);
        }
    }

    private void mapRbc(File coordinatorXml) {
        OozieProperties varTable = null;
        try {
            varTable = OozieHierarchyMapping.instance().getProperties(coordinatorXml, "coordinator");
        }
        catch (IOException e1) {
            ExceptionHandler.writeToExceptionFile((Exception)e1);
        }
        try {
            File propFile = new File(coordinatorXml.getAbsolutePath().replaceAll("\\.xml", ".properties"));
            if (propFile.exists()) {
                varTable = new OozieProperties(propFile.getAbsolutePath());
            }
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(coordinatorXml);
            NodeList coordinatorNodes = document.getElementsByTagName("coordinator-app");
            for (int i = 0; i < coordinatorNodes.getLength(); ++i) {
                Node FreqNode;
                String freq;
                Node endNode;
                String end;
                String start;
                String coordName = coordinatorNodes.item(i).getAttributes().getNamedItem("name").getNodeValue();
                Properties coordRBC = new Properties();
                Node startNode = coordinatorNodes.item(i).getAttributes().getNamedItem("start");
                String string = start = startNode == null ? "" : startNode.getNodeValue();
                if (start.matches(".*\\$\\{[^\\}]+\\}.*") && (start = this.resolveVariables(start, varTable)).contains("UNRESOLVED:")) {
                    String varName = start.split("UNRESOLVED:")[1].split("\\s+", 2)[0];
                    start = "2010-01-01T00:00Z";
                    this.addMessage(coordName, "WRN12005", varName, "Coordinator start time", start);
                }
                String string2 = end = (endNode = coordinatorNodes.item(i).getAttributes().getNamedItem("end")) == null ? "" : endNode.getNodeValue();
                if (end.matches(".*\\$\\{[^\\}]+\\}.*") && (end = this.resolveVariables(end, varTable)).contains("UNRESOLVED:")) {
                    String varName = end.split("UNRESOLVED:")[1].split("\\s+", 2)[0];
                    end = "";
                    this.addMessage(coordName, "WRN12005", varName, "Coordinator end time", "EMPTY");
                }
                String string3 = freq = (FreqNode = coordinatorNodes.item(i).getAttributes().getNamedItem("frequency")) == null ? "" : FreqNode.getNodeValue();
                if (freq.matches(".*\\$\\{[^\\}]+\\}.*") && (freq = this.resolveVariables(freq, varTable)).contains("UNRESOLVED:")) {
                    String varName = freq.split("UNRESOLVED:")[1].split("\\s+", 2)[0];
                    freq = "";
                    this.addMessage(coordName, "WRN12005", varName, "Coordinator frequency", "EMPTY");
                }
                this.startEndToRbc(start, end, coordRBC);
                this.freqToRbc(freq, start, coordRBC, coordName);
                if (!RbcNamer.nameRbc((Properties)coordRBC, (String)this.firstDayOfTheWeek())) {
                    Object[] objectArray = new Object[1];
                    this.anonymous_count = this.anonymous_count + 1;
                    objectArray[0] = this.anonymous_count;
                    coordRBC.setProperty("NAME", String.format("RBC_%d", objectArray));
                }
                if (!coordRBC.contains("MAXWAIT")) {
                    coordRBC.setProperty("MAXWAIT", RuleManager.instance().getCurrentRules().getStringRule("Oozie rules", new String[]{"MAXWAIT"}));
                }
                if (this.rbcMap == null) {
                    this.rbcMap = new HashMap();
                }
                this.rbcMap.put(coordName, coordRBC);
            }
        }
        catch (ParserConfigurationException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (SAXException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private void freqToRbc(String fullFreq, String start, Properties coordRBC, String coordinatorName) {
        Pattern freqPattern = Pattern.compile("\\$\\{\\s*coord\\s*:\\s*(.+?)\\(([0-9]+)\\)\\}", 2);
        Matcher freqMatcher = freqPattern.matcher(fullFreq);
        String unit = "minutes";
        start = start.isEmpty() || !start.matches("^[0-9]{4}-[0-9]{2}-[0-9]{2}.*") ? "2010-01-01" : start.substring(0, 10);
        if (freqMatcher.matches()) {
            unit = freqMatcher.group(1).toLowerCase();
            Integer freq = Integer.valueOf(freqMatcher.group(2));
            if (unit.equals("days") || unit.equals("endofdays")) {
                RbcGenerator.addAllMonths(coordRBC, true);
                if (freq == 1) {
                    coordRBC.setProperty("DAYS", "ALL");
                } else if (freq == 7) {
                    coordRBC.setProperty("WEEKDAYS", this.yyyymmddToWeekday(start, this.firstDayOfTheWeek()));
                } else {
                    this.addMessage(coordinatorName, "WRN12006", freq.toString(), unit);
                }
            } else if (unit.equals("months") || unit.equals("endofmonths")) {
                RbcGenerator.addAllMonths(coordRBC, false);
                if (12 % freq == 0) {
                    String[] months = GlobalFunctions.getMonthsArray();
                    Integer startMonth = Integer.valueOf(start.split("-")[1]);
                    for (int offset = 0; offset < 12; offset += freq.intValue()) {
                        coordRBC.setProperty(months[(startMonth + offset - 1) % 12], "1");
                    }
                } else {
                    this.addMessage(coordinatorName, "WRN12006", freq.toString(), unit);
                }
                if (unit.equals("endofmonths")) {
                    coordRBC.setProperty("DAYS", "L1");
                } else {
                    coordRBC.setProperty("DAYS", start.split("-")[2]);
                }
            } else {
                this.addMessage(coordinatorName, "WRN12006", freq.toString(), unit);
                RbcGenerator.addAllMonths(coordRBC, true);
                coordRBC.setProperty("DAYS", "ALL");
            }
        } else {
            if (GlobalFunctions.isNumber((String)fullFreq)) {
                this.addMessage(coordinatorName, "WRN12006", fullFreq.toString(), unit);
            }
            RbcGenerator.addAllMonths(coordRBC, false);
            coordRBC.setProperty("NAME", "Unscheduled");
        }
    }

    private String yyyymmddToWeekday(String date, String firstDayOfTheWeek) {
        int offset;
        Calendar tmpCal = Calendar.getInstance();
        String[] dateArr = date.split("-");
        tmpCal.set(Integer.valueOf(dateArr[0]), Integer.valueOf(dateArr[1]) - 1, Integer.valueOf(dateArr[2]));
        Integer weekday = tmpCal.get(7);
        for (offset = 0; offset < weekdaysArr.length && !weekdaysArr[offset].equals(firstDayOfTheWeek); ++offset) {
        }
        weekday = (weekday + (7 - offset)) % 7;
        return weekday.toString();
    }

    private String firstDayOfTheWeek() {
        RulesDataSet oozieRules = RuleManager.instance().getCurrentRules();
        return oozieRules.getStringRule("Oozie rules", new String[]{"FIRST_DAY_OF_WEEK"}).substring(0, 3).toUpperCase();
    }

    private static void addAllMonths(Properties coordRBC, boolean wantedValue) {
        String[] months = GlobalFunctions.getMonthsArray();
        for (int i = 0; i < months.length; ++i) {
            coordRBC.put(months[i], wantedValue ? "1" : "0");
        }
    }

    private void startEndToRbc(String start, String end, Properties coordRBC) {
        if (!start.isEmpty()) {
            String[] rawStartArr = start.split("T");
            String[] startDateArr = rawStartArr[0].split("-");
            coordRBC.setProperty("ACTIVE_FROM", String.format("%s%s%s", startDateArr[0], startDateArr[1], startDateArr[2]));
        }
        if (!end.isEmpty()) {
            String[] rawEndArr = end.split("T");
            String[] endDateArr = rawEndArr[0].split("-");
            coordRBC.setProperty("ACTIVE_TILL", String.format("%s%s%s", endDateArr[0], endDateArr[1], endDateArr[2]));
        }
    }

    private String resolveVariables(String unresolved, OozieProperties varTable) {
        String toRet = unresolved;
        String varRegex = "\\$\\{(.+?)\\}";
        Pattern varPattern = Pattern.compile(varRegex);
        Matcher varMatcher = varPattern.matcher(unresolved);
        while (varMatcher.find()) {
            Object replacement;
            if (varMatcher.group(1).toLowerCase().startsWith("coord:")) continue;
            if (varTable != null) {
                replacement = varTable.getResolvedProperty(varMatcher.group(1));
                if (replacement == null || ((String)replacement).matches(varRegex) && !((String)replacement).matches(".*\\$\\{coord:.+\\}.*")) {
                    replacement = "UNRESOLVED:" + varMatcher.group(1);
                }
            } else {
                replacement = "UNRESOLVED:" + varMatcher.group(1);
            }
            toRet = toRet.replace(varMatcher.group(0), (CharSequence)replacement);
        }
        return toRet;
    }

    public static RbcGenerator instance() {
        if (instance == null) {
            instance = new RbcGenerator();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public Properties getRbc(String coordinatorName) {
        return this.rbcMap.get(coordinatorName);
    }

    public static Properties getEmptyRbc() {
        Properties toRet = new Properties();
        RbcGenerator.addAllMonths(toRet, false);
        toRet.setProperty("NAME", "Unscheduled");
        toRet.setProperty("MAXWAIT", RuleManager.instance().getCurrentRules().getStringRule("Oozie rules", new String[]{"MAXWAIT"}));
        return toRet;
    }

    static {
        weekdaysArr = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
    }
}

