/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.oozie;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.oozie.OozieEntity;
import com.bmc.ctmconvert.oozie.OozieHierarchyMapping;
import com.bmc.ctmconvert.oozie.OozieProperties;
import com.bmc.ctmconvert.oozie.RbcGenerator;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OozieJob
implements SchedEntity {
    private SchedEntity.TYPE entityType;
    private OozieEntity entityData;
    private OozieJob entityParent;
    private OozieEntity entityBundle;
    private OozieProperties entityProperties;
    private OozieProperties entityFullProperties;
    private SourceDefinitions sourceDefinitions;
    private boolean validEntity = true;
    private Properties properties = new Properties();
    private ArrayList<String> optionalProperties = new ArrayList();
    private ArrayList<SchedEntity> children;
    private RulesDataSet rules = null;
    private ArrayList<String> messages = new ArrayList();
    private LinkedHashMap<String, String> autoedits;
    private ArrayList<Properties> onStmts;

    public OozieJob(String oozieType, String entityName, SourceDefinitions sourceDef) {
        this.entityType = SchedEntity.TYPE.SMART_TABLE;
        this.entityData = new OozieEntity(new File(Params.instance().getDatasourcePath() + oozieType + Globs.DIRSEP + entityName));
        this.sourceDefinitions = sourceDef;
        this.initialize();
    }

    public OozieJob(OozieEntity data, OozieJob parent, SourceDefinitions sourceDef) {
        this.entityData = data;
        this.entityParent = parent;
        this.entityType = this.entityData.getEntityFile() != null ? SchedEntity.TYPE.SUB_TABLE : SchedEntity.TYPE.JOB;
        this.sourceDefinitions = sourceDef;
        this.initialize();
    }

    private void initialize() {
        this.autoedits = new LinkedHashMap();
        this.rules = RuleManager.instance().getCurrentRules();
        this.initEntityFullProperties();
        this.initEntityProperties();
        switch (this.entityType) {
            case SMART_TABLE: 
            case TABLE: {
                String tableName = FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", this.entityData.getEntitiyName());
                this.properties.setProperty("TABLE_NAME", tableName);
                this.properties.setProperty("JOBNAME", tableName);
                this.properties.setProperty("TABLE_USERDAILY", "");
                if (this.entityData.getEntityApplicationType().equals("coordinator")) {
                    this.handleEventsStatments();
                }
                this.handleStartEndAttributes();
                this.setTimeZone();
                break;
            }
            case SUB_TABLE: {
                this.properties.setProperty("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", this.entityData.getEntitiyName()));
                this.properties.setProperty("PARENT_TABLE", this.getTablePathForSons());
                this.handleStartEndAttributes();
                break;
            }
            case JOB: {
                this.properties.setProperty("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", this.entityData.getEntitiyName()));
                this.properties.setProperty("PARENT_TABLE", this.getTablePathForSons());
                this.properties.setProperty("CYCLIC", "0");
                this.properties.setProperty("TAG_RELATIONSHIP", "OR");
                this.properties.setProperty("ACTIVE_FROM", "");
                this.properties.setProperty("ACTIVE_TILL", "");
                this.setOptionalAttribute("MAXWAIT", "0");
                this.convertTaskType();
                if (this.rules.getTaskTypeHandler().isToDummy()) {
                    if (!Params.instance().getGUIVersion().equals("7") && !this.properties.getProperty("TASKTYPE").equals("Dummy")) {
                        this.autoedits.put("%%$BMCWAIORIGTYPE", this.properties.getProperty("TASKTYPE"));
                    }
                    this.properties.setProperty("TASKTYPE", "Dummy");
                }
                this.setOptionalAttribute("MAXWAIT", this.rules.getStringRule("Oozie rules", new String[]{"MAXWAIT"}));
                break;
            }
        }
        HashMap<String, String> competitorValues = new HashMap<String, String>();
        if (this.entityData != null) {
            competitorValues.put("bundle", this.getBundleName());
            competitorValues.put("coordinator", this.getTablePathForSons().split("/")[0]);
        }
        if (this.entityData.getEntityApplicationType().equals("workflow")) {
            boolean isSwitchNodeExist;
            boolean isKillNodeExist;
            boolean bl = isKillNodeExist = GlobalFunctions.getFirstChildElementByTagName((Element)this.entityData.getEntitiyData(), (String)"kill") != null;
            if (isKillNodeExist) {
                Reporter.addMessage(this.messages, (String)"WRN12015", (String)this.getJobID(), (String[])new String[]{"kill"});
            }
            boolean bl2 = isSwitchNodeExist = GlobalFunctions.getFirstChildElementByTagName((Element)this.entityData.getEntitiyData(), (String)"decision") != null;
            if (isSwitchNodeExist) {
                Reporter.addMessage(this.messages, (String)"WRN12015", (String)this.getJobID(), (String[])new String[]{"decision"});
            }
        }
        if (this.entityData.getEntityApplicationType().equals("action") || this.entityData.getEntityApplicationType().equals("coordinator")) {
            boolean isSlaNodeExist;
            boolean bl = isSlaNodeExist = GlobalFunctions.getFirstChildElementByTagName((Element)this.entityData.getEntitiyData(), (String)"sla:info") != null;
            if (isSlaNodeExist) {
                Reporter.addMessage(this.messages, (String)"WRN12015", (String)this.getJobID(), (String[])new String[]{"sla:info"});
            }
        }
        this.properties.setProperty("APPLICATION", FieldValidation.instance().validateAndReturnFixedValue("APPLICATION", this.rules.getFieldEditor().generateCTMField("APPLICATION", competitorValues)));
        this.properties.setProperty("GROUP", FieldValidation.instance().validateAndReturnFixedValue("GROUP", this.rules.getFieldEditor().generateCTMField("GROUP", competitorValues)));
        this.properties.setProperty("DESCRIPTION", FieldValidation.instance().validateAndReturnFixedValue("DESCRIPTION", this.rules.getFieldEditor().generateCTMField("DESCRIPTION", competitorValues)));
        this.properties.setProperty("OWNER", FieldValidation.instance().validateAndReturnFixedValue("OWNER", this.rules.getFieldEditor().generateCTMField("OWNER", competitorValues)));
        this.properties.setProperty("AUTHOR", FieldValidation.instance().validateAndReturnFixedValue("AUTHOR", this.rules.getFieldEditor().generateCTMField("AUTHOR", competitorValues)));
    }

    private void setTimeZone() {
        String timeZone = this.getTimeZone();
        if (timeZone != null && !timeZone.isEmpty()) {
            Reporter.addMessage(this.messages, (String)"WRN12014", (String)this.getJobID(), (String[])new String[0]);
        }
    }

    private String getTimeZone() {
        Attr tz;
        String timeZone = "";
        Element e = this.entityData.getEntitiyData();
        if (this.entityData.getEntityApplicationType().equals("coordinator") && (tz = e.getAttributeNode("timezone")) != null) {
            timeZone = tz.getValue();
        }
        return timeZone;
    }

    private void handleEventsStatments() {
        try {
            Element inputEventsElement = GlobalFunctions.getFirstChildElementByTagName((Element)this.entityData.getEntitiyData(), (String)"input-events");
            if (inputEventsElement != null) {
                Reporter.addMessage(this.messages, (String)"WRN12010", (String)this.getJobID(), (String[])new String[0]);
            }
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        try {
            Element outputEventsElement = GlobalFunctions.getFirstChildElementByTagName((Element)this.entityData.getEntitiyData(), (String)"output-events");
            if (outputEventsElement != null) {
                Reporter.addMessage(this.messages, (String)"WRN12011", (String)this.getJobID(), (String[])new String[0]);
            }
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private void handleStartEndAttributes() {
        Element element = this.entityData.getEntitiyData();
        this.setStartEndAttributes(element.getAttributeNode("start"), "TIMEFROM");
        this.setStartEndAttributes(element.getAttributeNode("end"), "TIMETO");
    }

    private void setStartEndAttributes(Attr attr, String GLOBS_START_END) {
        if (attr != null && !attr.getValue().isEmpty()) {
            String tempValue = this.entityFullProperties.resolveString(attr.getValue());
            if (tempValue.matches("\\d{4}-\\d{2}-\\d{2}[A-Za-z](\\d{2}):(\\d{2})[A-Za-z]")) {
                String Hours = tempValue.substring(11, 13);
                String Minutes = tempValue.substring(14, 16);
                String Value = Hours + Minutes;
                this.properties.setProperty(GLOBS_START_END, Value);
                if (!this.entityData.getEntityApplicationType().equals("coordinator")) {
                    Reporter.addMessage(this.messages, (String)"WRN12012", (String)this.getJobID(), (String[])new String[]{this.entityData.getEntitiyName(), this.entityData.getEntityApplicationType(), GLOBS_START_END + ": " + tempValue});
                }
            } else {
                Reporter.addMessage(this.messages, (String)"WRN12013", (String)this.getJobID(), (String[])new String[]{GLOBS_START_END + ": " + tempValue});
            }
        }
    }

    private OozieProperties initEntityProperties() {
        if (this.entityProperties == null) {
            try {
                File entityFile = this.entityData.getEntityFile();
                String path = null;
                if (entityFile != null) {
                    path = entityFile.getAbsolutePath().replace(".xml", ".properties");
                }
                this.entityProperties = this.entityData.getEntityApplicationType().equals("coordinator") ? this.entityFullProperties : new OozieProperties(path);
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        return this.entityProperties;
    }

    public OozieProperties initEntityFullProperties() {
        if (this.entityFullProperties == null) {
            try {
                File entityFile = this.entityData.getEntityFile();
                this.entityFullProperties = entityFile != null ? OozieHierarchyMapping.instance().getProperties(entityFile, this.entityData.getEntityApplicationType()) : this.entityParent.entityFullProperties;
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        return this.entityFullProperties;
    }

    public String getBundleName() {
        String toRet = "";
        if (this.entityBundle == null) {
            if (this.entityData.getEntityApplicationType().equals("coordinator")) {
                ArrayList<OozieEntity> bundlesList = OozieHierarchyMapping.instance().getEntityParents("coordinator", this.entityData.getEntityFile().getName());
                if (bundlesList != null && !bundlesList.isEmpty()) {
                    this.entityBundle = bundlesList.get(0);
                    toRet = this.entityBundle.getEntitiyName();
                    if (bundlesList.size() > 1) {
                        Reporter.addMessage(this.messages, (String)"WRN12009", (String)this.getJobID(), (String[])new String[0]);
                    }
                }
            } else if (this.entityParent != null) {
                toRet = this.entityParent.getBundleName();
            }
        } else {
            toRet = this.entityBundle.getEntitiyName();
        }
        return toRet;
    }

    private void convertTaskType() {
        Element data = this.entityData.getEntitiyData();
        String type = data.getNodeName();
        String taskType = "Dummy";
        String memName = this.getJobName();
        String cmdLine = "";
        if (type.equals("action")) {
            taskType = "Job";
            String oozieJobAction = GlobalFunctions.getFirstChildElement((Element)data).getNodeName();
            String hadoopExecType = "";
            if (oozieJobAction.toLowerCase().equals("java") || oozieJobAction.toLowerCase().equals("map-reduce")) {
                hadoopExecType = "MAP_REDUCE";
                this.setJavaMapReduceAutoedits();
            } else if (oozieJobAction.toLowerCase().equals("pig")) {
                hadoopExecType = "PIG";
                this.setPigAutoedits();
            } else if (oozieJobAction.toLowerCase().equals("hive")) {
                hadoopExecType = "HIVE";
                this.setHiveAutoedits();
            } else if (oozieJobAction.toLowerCase().equals("sqoop")) {
                hadoopExecType = "SQOOP";
                this.setSqoopAutoedits();
            } else {
                if (oozieJobAction.toLowerCase().equals("fs")) {
                    this.setCommandOSJob();
                    return;
                }
                if (oozieJobAction.toLowerCase().equals("email")) {
                    this.setDummyDoMAilJob();
                    return;
                }
                if (oozieJobAction.toLowerCase().equals("sub-workflow")) {
                    return;
                }
                hadoopExecType = "Something Else";
            }
            this.autoedits.put("%%HDP-EXEC_TYPE", hadoopExecType);
            Object account = "DEFAULT_ACCOUNT";
            String jobTracker = GlobalFunctions.getFirstDescendantTextByTagName((Element)data, (String)"job-tracker");
            String nameNode = GlobalFunctions.getFirstDescendantTextByTagName((Element)data, (String)"name-node");
            if (jobTracker != null && nameNode != null) {
                account = jobTracker + "_" + nameNode;
            }
            this.autoedits.put("%%HDP-ACCOUNT", (String)account);
            this.properties.setProperty("OWNER", (String)account);
            HashMap<String, Object> action = new HashMap<String, Object>();
            action.put("ACTENTTYPE", "HADPACC");
            action.put("JOBID", this.getJobName());
            action.put("ACTENTNAME", account);
            action.put("ACTSTATUS", "0");
            Reporter.addAction(action);
            this.setPrepareAutoedits("delete", "rm");
            if (hadoopExecType.equalsIgnoreCase("SQOOP")) {
                this.setPrepareAutoedits("mkdir", "put");
            }
            this.setPropertiesAutoedits();
            this.setFilesAndArchives();
            if (this.autoedits.get("%%HDP-EXEC_TYPE").equalsIgnoreCase("MAP_REDUCE")) {
                this.setReportsMessages();
            }
            this.setOptionalAttribute("APPL_FORM", "Hadoop");
            this.setOptionalAttribute("APPL_TYPE", "HADOOP");
            this.setOptionalAttribute("APPL_VER", "ANY");
            this.setOptionalAttribute("CM_VER", "8.0.0");
            this.properties.setProperty("MEMLIB", "Not in use for Hadoop jobs");
        }
        this.properties.setProperty("TASKTYPE", taskType);
        this.properties.setProperty("MEMNAME", memName);
        FieldValidation.instance().cmdLineValidateAndReportMessages(cmdLine, this.getJobID(), this.messages);
        this.properties.setProperty("CMDLINE", cmdLine);
    }

    private void setDummyDoMAilJob() {
        Element data = this.entityData.getEntitiyData();
        String to = GlobalFunctions.getFirstDescendantTextByTagName((Element)data, (String)"to");
        String cc = GlobalFunctions.getFirstDescendantTextByTagName((Element)data, (String)"cc");
        String subject = GlobalFunctions.getFirstDescendantTextByTagName((Element)data, (String)"subject");
        String body = GlobalFunctions.getFirstDescendantTextByTagName((Element)data, (String)"body");
        if (to == null) {
            return;
        }
        Properties domail = new Properties();
        domail.put("STMT", "*");
        domail.put("CODE", "*");
        domail.put("ACTION", "DOMAIL");
        to = this.entityFullProperties.annotateString(to);
        domail.put("DEST", this.entityFullProperties.resolveString(to));
        if (cc != null) {
            domail.put("CC_DEST", this.entityFullProperties.resolveString(cc));
        }
        if (subject != null) {
            domail.put("SUBJECT", this.entityFullProperties.annotateString(subject));
        }
        if (body != null) {
            domail.put("MESSAGE", this.entityFullProperties.annotateString(body));
        }
        domail.put("URGENCY", "R");
        domail.put("ATTACH_SYSOUT", "No");
        if (this.onStmts == null) {
            this.onStmts = new ArrayList();
        }
        this.onStmts.add(domail);
        this.properties.setProperty("TASKTYPE", "Dummy");
        this.properties.setProperty("NODEID", FieldValidation.instance().validateAndReturnFixedValue("NODEID", this.rules.getFieldEditor().generateCTMField("NODEID", new HashMap())));
    }

    private void setCommandOSJob() {
        Element data = this.entityData.getEntitiyData();
        StringBuilder commandLine = new StringBuilder();
        Element fsElement = GlobalFunctions.getFirstChildElementByTagName((Element)data, (String)"fs");
        ArrayList childs = GlobalFunctions.getChildsElement((Element)fsElement);
        for (Element child : childs) {
            String arg;
            if (childs.indexOf(child) != 0) {
                commandLine.append(" && ");
            }
            String command = child.getNodeName();
            commandLine.append("hdfs dfs ");
            if (command.equalsIgnoreCase("delete")) {
                commandLine.append("-rm ");
                arg = child.getAttribute("path");
                arg = this.entityFullProperties.annotateString(arg);
                commandLine.append(arg).append(" ");
                continue;
            }
            if (command.equalsIgnoreCase("mkdir")) {
                commandLine.append("-mkdir ");
                arg = child.getAttribute("path");
                arg = this.entityFullProperties.annotateString(arg);
                commandLine.append(arg).append(" ");
                continue;
            }
            if (command.equalsIgnoreCase("move")) {
                commandLine.append("-mv ");
                String src = child.getAttribute("source");
                String target = child.getAttribute("target");
                src = this.entityFullProperties.annotateString(src);
                target = this.entityFullProperties.annotateString(target);
                commandLine.append(src).append(" ").append(target).append(" ");
                continue;
            }
            if (!command.equalsIgnoreCase("chmod")) continue;
            commandLine.append("-chmod ");
            String path = child.getAttribute("path");
            String permissions = child.getAttribute("permissions");
            String dirFiles = child.getAttribute("dir-files");
            path = this.entityFullProperties.annotateString(path);
            permissions = this.entityFullProperties.annotateString(permissions);
            if (!dirFiles.isEmpty() && dirFiles.equalsIgnoreCase("true")) {
                commandLine.append("-R ");
            }
            commandLine.append(permissions).append(" ");
            commandLine.append(path).append(" ");
        }
        FieldValidation.instance().cmdLineValidateAndReportMessages(commandLine.toString(), this.getJobID(), this.messages);
        this.properties.setProperty("TASKTYPE", "Command");
        this.properties.setProperty("MEMNAME", "hdfs");
        this.properties.setProperty("CMDLINE", commandLine.toString());
        this.properties.setProperty("NODEID", FieldValidation.instance().validateAndReturnFixedValue("NODEID", this.rules.getFieldEditor().generateCTMField("NODEID", new HashMap())));
    }

    private void setReportsMessages() {
        Element data = this.entityData.getEntitiyData();
        if (GlobalFunctions.getFirstDescendantTextByTagName((Element)data, (String)"capture-output") != null) {
            Reporter.addMessage(this.messages, (String)"WRN12004", (String)this.getJobID(), (String[])new String[]{"capture-output"});
        }
        if (GlobalFunctions.getFirstDescendantTextByTagName((Element)data, (String)"java-opts") != null) {
            Reporter.addMessage(this.messages, (String)"WRN12004", (String)this.getJobID(), (String[])new String[]{"java-opts"});
        }
    }

    private void setFilesAndArchives() {
        Element data = this.entityData.getEntitiyData();
        ArrayList files = GlobalFunctions.getAllDescendantsTextByTagName((Element)data, (String)"file");
        ArrayList archives = GlobalFunctions.getAllDescendantsTextByTagName((Element)data, (String)"archive");
        if (this.autoedits.get("%%HDP-EXEC_TYPE").equalsIgnoreCase("MAP_REDUCE")) {
            if (files.size() > 0) {
                Reporter.addMessage(this.messages, (String)"WRN12002", (String)this.getJobID(), (String[])new String[]{"file"});
            }
            if (archives.size() > 0) {
                Reporter.addMessage(this.messages, (String)"WRN12003", (String)this.getJobID(), (String[])new String[]{"archive"});
            }
        } else {
            String allFiles = GlobalFunctions.join((ArrayList)files, (String)",");
            String allarchives = GlobalFunctions.join((ArrayList)archives, (String)",");
            if (!allFiles.isEmpty()) {
                this.autoedits.put("%%HDP-FILES", allFiles);
            }
            if (!allarchives.isEmpty()) {
                this.autoedits.put("%%HDP-ARCHIVES", allarchives);
            }
        }
    }

    private void setJavaMapReduceAutoedits() {
        Element data = this.entityData.getEntitiyData();
        NodeList filePathElement = data.getElementsByTagName("file");
        String filePath = null;
        filePath = filePathElement != null && filePathElement.getLength() > 0 ? filePathElement.item(0).getTextContent() : "DEFAULT_PATH";
        if (!(filePath = this.entityFullProperties.resolveString(filePath)).equals(".jar")) {
            Reporter.addMessage(this.messages, (String)"WRN12007", (String)this.getJobID(), (String[])new String[0]);
        }
        this.autoedits.put("%%HDP-JAVA_JAR_NAME", filePath);
        String mainClass = GlobalFunctions.getFirstDescendantTextByTagName((Element)data, (String)"main-class");
        if (mainClass != null) {
            this.autoedits.put("%%HDP-JAVA_MAIN_CLASS", mainClass);
        }
        ArrayList argList = GlobalFunctions.getAllDescendantsTextByTagName((Element)data, (String)"arg");
        for (int i = 0; i < argList.size(); ++i) {
            this.autoedits.put(String.format("%%%%HDP-JAVA-N%03d-ARG", i + 1), (String)argList.get(i));
        }
    }

    private void setHiveAutoedits() {
        Element data = this.entityData.getEntitiyData();
        String script = GlobalFunctions.getFirstDescendantTextByTagName((Element)data, (String)"script");
        if (script != null) {
            this.autoedits.put("%%HDP-HIVE_SCRIPT_NAME", script);
        }
        ArrayList paramList = GlobalFunctions.getAllDescendantsTextByTagName((Element)data, (String)"param");
        for (int i = 0; i < paramList.size(); ++i) {
            String[] keyValue = ((String)paramList.get(i)).split("=");
            this.autoedits.put(String.format("%%%%HDP-HIVE_SCRIPT_PARAM-N%03d-NAME", i + 1), keyValue[0]);
            if (keyValue.length != 2) continue;
            this.autoedits.put(String.format("%%%%HDP-HIVE_SCRIPT_PARAM-N%03d-VAL", i + 1), keyValue[1]);
        }
    }

    private void setSqoopAutoedits() {
        Element data = this.entityData.getEntitiyData();
        StringBuilder sqoopCommand = new StringBuilder();
        String command = GlobalFunctions.getFirstDescendantTextByTagName((Element)data, (String)"command");
        if (command != null) {
            sqoopCommand.append(command).append(" ");
        }
        ArrayList argList = GlobalFunctions.getAllDescendantsTextByTagName((Element)data, (String)"arg");
        for (String arg : argList) {
            sqoopCommand.append(arg).append(" ");
        }
        this.autoedits.put("%%HDP-SQOOP_COMMAND", sqoopCommand.toString());
    }

    private void setPropertiesAutoedits() {
        Element data = this.entityData.getEntitiyData();
        NodeList nodeList = data.getElementsByTagName("property");
        if (nodeList.getLength() > 0 && this.autoedits.get("%%HDP-EXEC_TYPE").equalsIgnoreCase("MAP_REDUCE")) {
            Reporter.addMessage(this.messages, (String)"WRN12001", (String)this.getJobID(), (String[])new String[]{"property"});
            return;
        }
        int propIndex = 1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (!(childNode instanceof Element)) continue;
            String propertyName = GlobalFunctions.getFirstDescendantTextByTagName((Element)((Element)childNode), (String)"name");
            String propertyValue = GlobalFunctions.getFirstDescendantTextByTagName((Element)((Element)childNode), (String)"value");
            if (propertyName == null || propertyValue == null) continue;
            this.autoedits.put(String.format("%%%%HDP-PROP-N%03d-NAME", propIndex), propertyName);
            this.autoedits.put(String.format("%%%%HDP-PROP-N%03d-VAL", propIndex), propertyValue);
            ++propIndex;
        }
    }

    private void setPrepareAutoedits(String TagNAme, String preCommand) {
        Element data = this.entityData.getEntitiyData();
        ArrayList deleteList = GlobalFunctions.getAllDescendantsAttributeByTagName((Element)data, (String)TagNAme, (String)"path");
        for (int i = 0; i < deleteList.size(); ++i) {
            this.autoedits.put(String.format("%%%%HDP-PRE_CMD_ACTION-N%03d-CMD", i + 1), preCommand);
            String cmd = (String)deleteList.get(i);
            cmd = this.entityFullProperties.annotateString(cmd);
            this.autoedits.put(String.format("%%%%HDP-PRE_CMD_ACTION-N%03d-ARG", i + 1), cmd);
        }
    }

    private void setPigAutoedits() {
        Element data = this.entityData.getEntitiyData();
        String pigScript = GlobalFunctions.getFirstDescendantTextByTagName((Element)data, (String)"script");
        if (pigScript != null) {
            this.autoedits.put("%%HDP-PIG_PROG_NAME", pigScript);
        }
        this.addPigArguments(data);
    }

    private void addPigArguments(Element data) {
        ArrayList argList = GlobalFunctions.getAllDescendantsTextByTagName((Element)data, (String)"param");
        for (int i = 0; i < argList.size(); ++i) {
            String[] Splitedval = ((String)argList.get(i)).split("=");
            this.autoedits.put(String.format("%%%%HDP-PIG_PARAM-N%03d-NAME", i + 1), Splitedval[0]);
            if (Splitedval.length != 2) continue;
            Splitedval[1] = this.entityFullProperties.annotateString(Splitedval[1]);
            this.autoedits.put(String.format("%%%%HDP-PIG_PARAM-N%03d-VAL", i + 1), Splitedval[1]);
        }
    }

    private void setOptionalAttribute(String name, String value) {
        if (!this.optionalProperties.contains(name)) {
            this.optionalProperties.add(name);
        }
        this.properties.setProperty(name, value);
    }

    public SchedEntity.TYPE type() {
        return this.entityType;
    }

    public String originalProductID() {
        return null;
    }

    public String getJobID() {
        return (String)(this.properties.containsKey("PARENT_TABLE") ? this.properties.getProperty("PARENT_TABLE") + "_" : "") + this.getJobName();
    }

    public List<SchedEntity> getChildren() {
        block7: {
            if (this.type().equals((Object)SchedEntity.TYPE.JOB) || this.children != null) break block7;
            this.children = new ArrayList();
            HashMap<String, String> filterDetails = new HashMap<String, String>();
            if (this.entityData.getEntityApplicationType().equals("coordinator")) {
                for (OozieEntity child : OozieHierarchyMapping.instance().getEntityChildrens(this.entityData.getEntityApplicationType(), this.entityData.getEntityFile().getName())) {
                    if (child != null) {
                        filterDetails.put("Workflow name", child.getEntitiyName());
                        if (!this.rules.getFilterHandler().isFilter(filterDetails)) continue;
                        this.children.add(new OozieJob(child, this, this.sourceDefinitions));
                        continue;
                    }
                    Reporter.addMessage(this.messages, (String)"WRN12008", (String)this.getJobID(), (String[])new String[]{this.entityData.getEntityFile().getName()});
                }
            } else {
                Element data = this.entityData.getEntitiyData();
                NodeList childrenElements = data.getElementsByTagName("action");
                for (int i = 0; i < childrenElements.getLength(); ++i) {
                    Element childData = (Element)childrenElements.item(i);
                    String name = childData.getAttribute("name");
                    filterDetails.put("Action name", name);
                    if (!this.rules.getFilterHandler().isFilter(filterDetails)) continue;
                    NodeList subFlowPath = childData.getElementsByTagName("app-path");
                    if (subFlowPath != null && subFlowPath.getLength() == 1) {
                        OozieEntity child = OozieHierarchyMapping.instance().getSubWorkflowEntity(name);
                        if (child == null) {
                            Reporter.addMessage(this.messages, (String)"WRN12008", (String)this.getJobID(), (String[])new String[]{name});
                            continue;
                        }
                        this.children.add(new OozieJob(child, this, this.sourceDefinitions));
                        continue;
                    }
                    this.children.add(new OozieJob(new OozieEntity(childData, name), this, this.sourceDefinitions));
                }
            }
        }
        return this.children;
    }

    public List<AssistingJob> getAssistingJobs() {
        return null;
    }

    public String getAttr(String attrName) {
        return this.properties.getProperty(attrName);
    }

    public List<Properties> getInConds() {
        if (this.type().equals((Object)SchedEntity.TYPE.JOB) && this.entityData.getEntitiyData().getNodeName().equals("action")) {
            return this.sourceDefinitions.getJobInconds((SchedEntity)this);
        }
        return null;
    }

    public List<Properties> getOutConds() {
        List tmpList = null;
        if (this.type().equals((Object)SchedEntity.TYPE.JOB) && this.entityData.getEntitiyData().getNodeName().equals("action")) {
            tmpList = this.sourceDefinitions.getJobOutconds((SchedEntity)this);
        }
        ArrayList<Properties> toRet = new ArrayList<Properties>();
        if (tmpList != null) {
            for (Properties tmpProps : tmpList) {
                if (tmpProps.getProperty("CTM_OUT_TYPE", "").equals("ON_STMT")) continue;
                toRet.add(tmpProps);
            }
        }
        return toRet;
    }

    public List<Properties> getTags() {
        return this.getTags(false);
    }

    public List<Properties> getTags(boolean suppressMessages) {
        ArrayList<Properties> toRet = null;
        if (this.getParent() == null) {
            Properties rbc;
            if (this.entityData.getEntityApplicationType().equals("coordinator")) {
                HashSet<ArrayList<String>> messages;
                rbc = RbcGenerator.instance().getRbc(this.entityData.getEntitiyName());
                if (!suppressMessages && (messages = RbcGenerator.instance().getMessages(this.entityData.getEntitiyName())) != null) {
                    for (ArrayList<String> message : messages) {
                        String msgid = message.remove(0);
                        String[] args = new String[message.size()];
                        args = message.toArray(args);
                        Reporter.addMessage(this.messages, (String)msgid, (String)this.properties.getProperty("JOBNAME"), (String[])args);
                    }
                }
            } else {
                rbc = RbcGenerator.getEmptyRbc();
            }
            toRet = new ArrayList<Properties>();
            toRet.add(rbc);
        } else {
            toRet = (ArrayList<Properties>)this.getParent().getTags();
        }
        return toRet;
    }

    public List<Properties> getQuantResources() {
        return null;
    }

    public List<Properties> getCtrlResources() {
        return null;
    }

    public List<Properties> getOnStmt() {
        ArrayList<Properties> toRet = new ArrayList<Properties>();
        if (this.onStmts != null) {
            toRet.addAll(this.onStmts);
        }
        List tmpList = null;
        if (this.type().equals((Object)SchedEntity.TYPE.JOB) && this.entityData.getEntitiyData().getNodeName().equals("action")) {
            tmpList = this.sourceDefinitions.getJobOutconds((SchedEntity)this);
        }
        if (tmpList != null) {
            for (Properties tmpProps : tmpList) {
                if (!tmpProps.getProperty("CTM_OUT_TYPE", "").equals("ON_STMT")) continue;
                toRet.add(tmpProps);
            }
        }
        return toRet;
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return null;
    }

    public List<Properties> getShouts() {
        return null;
    }

    public String getJobName() {
        return this.properties.getProperty("JOBNAME");
    }

    public String getOriginalJobName() {
        return this.properties.getProperty("JOBNAME");
    }

    public String getParentName() {
        return this.getTablePathForSons();
    }

    public String getTablePathForSons() {
        if (this.entityParent != null) {
            if (this.entityType == SchedEntity.TYPE.JOB) {
                return this.entityParent.getParentName();
            }
            if (this.entityType == SchedEntity.TYPE.SUB_TABLE) {
                return this.entityParent.getParentName() + "/" + this.getJobName();
            }
        }
        return this.getJobName();
    }

    public boolean isValid() {
        return this.validEntity;
    }

    public boolean hasWarnings() {
        if (this.messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        for (String id : messageIds.keySet()) {
            if (!((MessageId)messageIds.get(id)).getMessageType(id).equals("W")) continue;
            for (String currMessage : this.messages) {
                if (!currMessage.startsWith(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public boolean isDSJob() {
        return true;
    }

    public String getTableName() {
        return this.getJobName();
    }

    public boolean isCyclic() {
        String cyclic = this.properties.getProperty("CYCLIC");
        if (cyclic == null) {
            return false;
        }
        return cyclic.equals("1");
    }

    public String applyFieldConversion(String field) {
        return null;
    }

    public String getApplication() {
        return this.properties.getProperty("APPLICATION");
    }

    public String getGroup() {
        return this.properties.getProperty("GROUP");
    }

    public LinkedHashMap<String, String> getAutoedits() {
        this.autoedits.keySet().forEach(key -> {
            String resolvedValue = this.entityFullProperties.resolveString(this.autoedits.get(key));
            String validatedValue = this.validateAutoedit((String)key, resolvedValue);
            this.autoedits.put((String)key, validatedValue);
        });
        for (String key2 : this.entityProperties.getPropertiesOrder()) {
            this.autoedits.put("%%" + key2.replace(".", "_"), this.entityProperties.getAnnotatedProperty(key2));
        }
        return this.autoedits;
    }

    private String validateAutoedit(String autoEditName, String value) {
        if (autoEditName.equals("%%HDP-ACCOUNT")) {
            return FieldValidation.instance().validateAndReturnFixedValue("CONNECTION_PROFILE", value);
        }
        return value;
    }

    public List<String> getOptionalAttributes() {
        return this.optionalProperties;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    public OozieJob getParent() {
        return this.entityParent;
    }
}

