/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.oozie;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.base.table.BaseExtendedTable;
import com.bmc.ctmconvert.base.table.BaseFilterableTable;
import com.bmc.ctmconvert.base.table.BaseTableModel;
import com.bmc.ctmconvert.base.table.BaseTableToolbar;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FileFunctions;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.oozie.OozieGlobals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DataImportOozie
extends DataImportVendor {
    private static DefaultTableModel manualModel;
    private static Properties filesMapping;
    private static final String oozieTmpDirectoryName;

    public DataImportOozie() {
        filesMapping = new Properties();
        File oozieTmpDirectory = new File(oozieTmpDirectoryName);
        if (oozieTmpDirectory.exists()) {
            GlobalFunctions.deleteDir((File)oozieTmpDirectory);
        }
        oozieTmpDirectory.mkdir();
        this.importPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("DATA_IMPORT_TITLE_OOZIE")), new BaseFooterPanel(""));
        this.addTableToPanel(this.importPanel);
    }

    public Component getDefaultFocusedComponent() {
        return this.importPanel.getComponent();
    }

    private BaseProgressBar initSnakeProgress() {
        BaseProgressBar snakeProgress = new BaseProgressBar(TextManager.instance().get("DATA_IMPORT_GETTING_FILE_PROGRESS_TITLE"));
        snakeProgress.setLabel(TextManager.instance().get("DATA_IMPORT_GETTING_FILE_PROGRESS_LABEL"));
        snakeProgress.setSnakeLook(true);
        snakeProgress.setDisplayDescription(true);
        return snakeProgress;
    }

    public BaseContentPanel getNextPanel() {
        return this.importPanel;
    }

    private void addTableToPanel(BaseContentPanel rootPanel) {
        manualModel = new BaseTableModel((Object[][])new String[0][], OozieGlobals.DATA_IMPORT_TABLE_HEADER);
        manualModel.addTableModelListener(e -> rootPanel.setValid(this.isModelValid(manualModel)));
        BaseFilterableTable baseFilterableTable = new BaseFilterableTable();
        baseFilterableTable.setModel(manualModel);
        baseFilterableTable.setColumnWidth(3, 0);
        baseFilterableTable.setHeight(300);
        BaseTableToolbar filesTableToolbar = new BaseTableToolbar();
        BaseButton add = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.ADD);
        add.addActionListener(e -> {
            BaseProgressBar snakeProgress = this.initSnakeProgress();
            BaseTextField tmp = new BaseTextField();
            tmp.getComponent().setName("Hadoop - Oozie Data");
            File[] files = GlobalFunctions.browseClick((JTextField)((JTextField)tmp.getComponent()), (String[])new String[]{TextManager.instance().get("FILE_CHOOSER_TITLE_DIRECTORY"), "XML"}, (boolean)true);
            Thread getDataFiles = new Thread(() -> {
                this.addFilesToModel(files, snakeProgress);
                snakeProgress.dispose();
            });
            getDataFiles.start();
            snakeProgress.setVisible(true);
        });
        add.setEnabled(true);
        filesTableToolbar.add((Component)add);
        filesTableToolbar.add(Box.createRigidArea(new Dimension(5, 0)));
        BaseButton delete = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.DELETE);
        delete.addActionListener(e -> {
            if (baseFilterableTable.getSelectedRowIndex() > -1) {
                baseFilterableTable.removeRow(baseFilterableTable.getSelectedRowIndex());
            }
        });
        filesTableToolbar.add((Component)delete);
        filesTableToolbar.add(Box.createRigidArea(new Dimension(5, 0)));
        BaseExtendedTable filesList = new BaseExtendedTable(baseFilterableTable, filesTableToolbar, null);
        BaseField filesListField = new BaseField((BaseComponent)filesList);
        filesListField.setFillAllArea(true);
        manualModel.addTableModelListener(e -> filesListField.setValid(manualModel.getRowCount() > 0));
        baseFilterableTable.addSelectionListener(e -> delete.setEnabled(baseFilterableTable.getSelectedRowIndex() > -1));
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        tablePanel.add(filesList.getComponent());
        rootPanel.setContentPanel((Component)tablePanel);
    }

    private boolean isModelValid(DefaultTableModel model) {
        boolean valid = false;
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (!model.getValueAt(row, 0).equals("coordinator") && !model.getValueAt(row, 0).equals("workflow")) continue;
            valid = true;
            break;
        }
        return valid;
    }

    private void addFilesToModel(File[] files, BaseProgressBar progress) {
        DefaultTableModel model = manualModel;
        ArrayList<String[]> filesTable = DataImportOozie.scanFiles(files, progress);
        if (progress.isCancelled()) {
            for (File file : files) {
                if (file.isFile()) {
                    file.delete();
                    continue;
                }
                GlobalFunctions.deleteDir((File)file);
            }
        } else {
            for (Object[] objectArray : filesTable) {
                for (int i = 0; i < model.getRowCount(); ++i) {
                    String tmpFilePath;
                    String modelFilePath = ((String)model.getValueAt(i, 2)).replaceFirst("(.*\\\\tmp_\\d+)", "");
                    if (!modelFilePath.equals(tmpFilePath = ((String)objectArray[2]).replaceFirst("(.*\\\\tmp_\\d+)", "")) || !model.getValueAt(i, 0).equals(objectArray[0])) continue;
                    model.removeRow(i);
                    break;
                }
                model.addRow(objectArray);
            }
        }
    }

    public static ArrayList<String[]> scanFiles(File[] files, BaseProgressBar progressBar) {
        ArrayList<String[]> filesArray = new ArrayList<String[]>();
        if (files != null) {
            ArrayList<String[]> applications = new ArrayList<String[]>();
            ArrayList<String[]> properties = new ArrayList<String[]>();
            for (File file : files) {
                if (progressBar != null) {
                    progressBar.setDescription(file.getName());
                    if (progressBar.isCancelled()) break;
                }
                if (file.isDirectory()) {
                    filesArray.addAll(DataImportOozie.scanFiles(file.listFiles(), progressBar));
                }
                if (!file.isFile()) continue;
                if (file.toString().toLowerCase().endsWith(".xml")) {
                    try {
                        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document document = parser.parse(file);
                        NodeList childs = document.getChildNodes();
                        String fileType = "";
                        for (int i = 0; i < childs.getLength(); ++i) {
                            if (childs.item(i).getNodeType() != 1) continue;
                            fileType = childs.item(i).getNodeName();
                        }
                        if (!fileType.endsWith("-app")) continue;
                        fileType = fileType.toLowerCase().substring(0, fileType.indexOf("-app"));
                        String[] row = new String[]{fileType, file.toString().substring(file.toString().lastIndexOf(Globs.DIRSEP) + 1), file.toString(), ""};
                        applications.add(row);
                        filesArray.add(row);
                    }
                    catch (IOException | ParserConfigurationException | SAXException e1) {
                        ExceptionHandler.writeToExceptionFile((Exception)e1);
                    }
                    continue;
                }
                if (!file.toString().toLowerCase().endsWith(".properties")) continue;
                properties.add(new String[]{"properties", file.toString().substring(file.toString().lastIndexOf(Globs.DIRSEP) + 1), file.toString(), ""});
            }
            if (properties.size() <= 1) {
                if (properties.size() == 1 && applications.size() > 1) {
                    String[] propertiesArr = (String[])properties.removeFirst();
                    for (String[] application : applications) {
                        String[] row = new String[]{propertiesArr[0], propertiesArr[1], propertiesArr[2], propertiesArr[3]};
                        row[0] = application[1].replace(".xml", "") + "-properties";
                        row[3] = application[2];
                        properties.add(row);
                    }
                } else if (properties.size() == 1 && applications.size() == 1) {
                    ((String[])properties.getFirst())[0] = ((String[])applications.getFirst())[1].replace(".xml", "") + "-properties";
                    ((String[])properties.getFirst())[3] = ((String[])applications.getFirst())[2];
                }
            }
            filesArray.addAll(properties);
        }
        return filesArray;
    }

    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        ArrayList<String[]> filesList = new ArrayList<String[]>();
        Vector<Vector> data = manualModel.getDataVector();
        for (Vector row : data) {
            if (!(row instanceof Vector)) continue;
            Vector rowV = row;
            String[] rowData = new String[rowV.size()];
            for (int i = 0; i < rowV.size(); ++i) {
                rowData[i] = (String)rowV.get(i);
            }
            filesList.add(rowData);
        }
        return DataImportOozie.performDataImport(destinationFolderPath, progressBar, filesList);
    }

    public static FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar, ArrayList<String[]> files) {
        FlowGlobals.COMPLETION_MODE toRet = FlowGlobals.COMPLETION_MODE.FAILURE;
        if (progressBar != null) {
            progressBar.setProgressMax(files.size());
        }
        HashMap<String, Integer> counters = new HashMap<String, Integer>();
        counters.put("bundle", 1);
        counters.put("coordinator", 1);
        counters.put("workflow", 1);
        counters.put("properties", 1);
        HashMap<String, String> fullPath2NewName = new HashMap<String, String>();
        int index = 0;
        for (String[] file : files) {
            String type = file[0];
            if (type.endsWith("properties")) {
                type = "properties";
            }
            Integer cnt = (Integer)counters.get(type);
            String newName = String.format("%s-%d%s", type, cnt, ".xml");
            counters.put(type, cnt + 1);
            if (type.endsWith("properties") && fullPath2NewName.containsKey(file[3])) {
                newName = ((String)fullPath2NewName.get(file[3])).replace(".xml", ".properties");
                type = newName.substring(0, newName.indexOf("-"));
            }
            fullPath2NewName.put(file[2], newName);
            file[3] = newName;
            filesMapping.setProperty(file[3], file[2].replaceFirst("(.*\\\\tmp_\\d+)", ""));
            File typeDirectory = new File(destinationFolderPath + type);
            if (!typeDirectory.exists() && !typeDirectory.mkdir()) continue;
            ++index;
            File sourceFile = new File(file[2]);
            if (progressBar != null) {
                progressBar.setLabel(String.format(TextManager.instance().get("DATA_IMPORT_PROGRESS_LABEL_COPY_FILE"), sourceFile.getName()));
                progressBar.setProgressValue(index);
                if (progressBar.isCancelled()) {
                    toRet = FlowGlobals.COMPLETION_MODE.ABORTED;
                    break;
                }
            }
            if (sourceFile.getName().isEmpty()) continue;
            File destinationFile = new File(typeDirectory.getAbsolutePath() + Globs.DIRSEP + file[3]);
            try {
                FileFunctions.copyFile((File)sourceFile, (File)destinationFile);
                toRet = FlowGlobals.COMPLETION_MODE.SUCCESS;
            }
            catch (IOException e) {
                ProcessAlertsManager.instance().addMessage(String.format(TextManager.instance().get("DATA_IMPORT_COPY_FILE_ERROR_FORMAT"), sourceFile.toString(), destinationFile.toString()));
            }
        }
        try {
            filesMapping.store(new FileOutputStream(destinationFolderPath + "filesMapping.properties"), "");
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            ProcessAlertsManager.instance().addMessage(e.getLocalizedMessage());
        }
        return toRet;
    }

    public String getHelpTitle() {
        return "LOAD_DATA_OOZIE_MANUAL";
    }

    public String getFieldsData() {
        return manualModel.getDataVector().toString() + "\n";
    }

    static {
        filesMapping = new Properties();
        oozieTmpDirectoryName = Globs.TEMP_DIR + Globs.DIRSEP + "OozieTemp";
    }
}

