/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.io.csv.CsvReader;
import com.bmc.ctmconvert.tng.TngGlobals;
import com.bmc.ctmconvert.tng.TngJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TNGAssessmentCSVReader {
    private String[] m_jobColumnsHeaders;
    private String[] m_jobSetColumnsHeaders;
    private String[] m_stationColumnsHeaders;
    private String[] m_UnsupportedAttributes_Job = new String[]{"USERENV", "ANYCPU", "AVGTIME", "JOBTYPE", "INTERRUPTIBLE", "AUTOSTART", "SKIP", "HISTORY", "CRITCADJ", "CRITNWACT"};
    private int[] m_UnsupportedAttributesColumnIndex_Job = new int[]{12, 14, 17, m_indexCPU, 20, 22, 23, 24, 34, 35};
    private String[] m_UnsupportedAttributes_JobParm = new String[]{"SUBDOMAIN", "SUBPASS"};
    private int[] m_UnsupportedAttributesColumnIndex_JobParm = new int[]{20, 21};
    private String[] m_UnsupportedAttributes_JobSet = new String[]{"ANYCPU", "USERENV", "AVGTIME", "SKIP", "HISTORY", "CRITCADJ", "SUBDOMAIN", "SUBPASS"};
    private int[] m_UnsupportedAttributesColumnIndex_JobSet = new int[]{10, 12, 15, 17, 18, 26, 28, 30};
    private String[] m_DateAttributes = new String[]{"EFFECTIVEDATE", "EXPIRESDATE"};
    private m_RecommendedDateFormatType m_RecommendedDateFormat = m_RecommendedDateFormatType.NO_DATES;
    private int m_rowsCount = 0;
    public static String TREV_NAME = "DSCLOSEU";
    public static String SAP_NAME = "SAPJOB";
    private static String m_CPU = "CPU";
    public static String m_sJob = "Job - ";
    public static String m_sJobSet = "Job Set - ";
    private static int m_indexCPU = 19;
    private HashMap<String, ArrayList<String>> m_JobID_Info = new HashMap();
    private HashMap<String, String> m_JobID_Command = new HashMap();
    private HashMap<String, String> m_JobID_Progname = new HashMap();
    private HashMap<String, String> m_JobID_In = new HashMap();
    private HashMap<String, ArrayList<String>> m_JobSetID_Info = new HashMap();
    private HashMap<String, ArrayList<String>> m_JobSetID_JobsIDList = new HashMap();
    private ArrayList<String> m_SAPJobsIDList = new ArrayList();
    private ArrayList<String> m_TandemJobsIDList = new ArrayList();
    private HashMap<String, ArrayList<String>> m_JobSetID_JobsIDList_NoCAL = new HashMap();
    private HashMap<String, String> m_JobSetID_CalendarID = new HashMap();
    private HashMap<String, ArrayList<String>> m_UnsupportedAttribute_JobsList = new HashMap();
    private HashMap<String, ArrayList<String>> m_UnsupportedAttribute_JobSetsList = new HashMap();
    private HashMap<String, ArrayList<String>> m_StationID_JobsIDList = new HashMap();
    private HashMap<String, ArrayList<String>> m_StationID_Info = new HashMap();
    private HashMap<String, ArrayList<String>> m_User_JobsIDList = new HashMap();
    private ArrayList<String> m_stationGroupsList = new ArrayList();
    private HashMap<String, ArrayList<String>> m_StationGroupID_StationsIDList = new HashMap();
    private HashMap<String, ArrayList<String>> m_CalendarID_JobsIDList = new HashMap();
    private HashMap<String, ArrayList<String>> m_DateFields_List = new HashMap();
    private ArrayList<String> m_declaredTriggersList = new ArrayList();
    private HashMap<String, ArrayList<String>> m_StationID_TriggersIDList = new HashMap();
    private HashMap<String, String> m_TriggerID_Info = new HashMap();

    public int getCRowsNumber() {
        return this.m_rowsCount;
    }

    public String[] getJobColumnsHeaders() {
        return this.m_jobColumnsHeaders;
    }

    public ArrayList<String> getJobInfo(String jobName) {
        return this.m_JobID_Info.get(jobName);
    }

    public ArrayList<String> getAllSAPJobsList() {
        return this.m_SAPJobsIDList;
    }

    public ArrayList<String> getAllTandemJobsList() {
        return this.m_TandemJobsIDList;
    }

    public String getJobCommand(String jobname) {
        return this.m_JobID_Command.get(jobname);
    }

    public String getJobProgname(String jobname) {
        return this.m_JobID_Progname.get(jobname);
    }

    public String getJobIn(String jobname) {
        return this.m_JobID_In.get(jobname);
    }

    public ArrayList<String> getAllJobsList() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String jobID : this.m_JobID_Info.keySet()) {
            resultList.add(jobID);
        }
        return resultList;
    }

    public String[] getJobSetColumnsHeaders() {
        return this.m_jobSetColumnsHeaders;
    }

    public ArrayList<String> getJobSetInfo(String jobSetName) {
        return this.m_JobSetID_Info.get(jobSetName);
    }

    public ArrayList<String> getJobsListOfJobSet(String jobSetID) {
        return this.m_JobSetID_JobsIDList.get(jobSetID);
    }

    public ArrayList<String> getAllJobSetsList() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String jobSetID : this.m_JobSetID_Info.keySet()) {
            resultList.add(jobSetID);
        }
        return resultList;
    }

    public String[] getStationColumnsHeaders() {
        return this.m_stationColumnsHeaders;
    }

    public ArrayList<String> getStationInfo(String stationID) {
        return this.m_StationID_Info.get(stationID);
    }

    public ArrayList<String> getJobsListOfStation(String stationID) {
        return this.m_StationID_JobsIDList.get(stationID);
    }

    public ArrayList<String> getAllStationsList() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String stationID : this.m_StationID_JobsIDList.keySet()) {
            if (this.m_stationGroupsList.contains(stationID)) continue;
            resultList.add(stationID);
        }
        return resultList;
    }

    public ArrayList<String> getAllStationGroupsList() {
        return this.m_stationGroupsList;
    }

    public ArrayList<String> getAllDefinedStatinGroups() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String stationGroupID : this.m_StationGroupID_StationsIDList.keySet()) {
            resultList.add(stationGroupID);
        }
        return resultList;
    }

    public ArrayList<String> getStationsListOfStationGroup(String stationGroupID) {
        return this.m_StationGroupID_StationsIDList.get(stationGroupID);
    }

    public ArrayList<String> getJobsListOfCalendar(String calendarID) {
        return this.m_CalendarID_JobsIDList.get(calendarID);
    }

    public ArrayList<String> getAllCalendarsList() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String calendarID : this.m_CalendarID_JobsIDList.keySet()) {
            resultList.add(calendarID);
        }
        return resultList;
    }

    public ArrayList<String> getJobsListOfUser(String userID) {
        return this.m_User_JobsIDList.get(userID);
    }

    public ArrayList<String> getAllUsersList() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String userID : this.m_User_JobsIDList.keySet()) {
            resultList.add(userID);
        }
        return resultList;
    }

    public ArrayList<String> getAllStationsWithTriggersList() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String stationID : this.m_StationID_TriggersIDList.keySet()) {
            resultList.add(stationID);
        }
        return resultList;
    }

    public ArrayList<String> getTriggersListOfStation(String stationID) {
        return this.m_StationID_TriggersIDList.get(stationID);
    }

    public String getTriggerInfo(String triggerID) {
        return this.m_TriggerID_Info.get(triggerID);
    }

    public ArrayList<String> getJobsListOfUnsupportedAttribute(String attributeID) {
        return this.m_UnsupportedAttribute_JobsList.get(attributeID);
    }

    public ArrayList<String> getAllUnsupportedAttributesJobsList() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String userID : this.m_UnsupportedAttribute_JobsList.keySet()) {
            resultList.add(userID);
        }
        return resultList;
    }

    public ArrayList<String> getJobSetsListOfUnsupportedAttribute(String attributeID) {
        return this.m_UnsupportedAttribute_JobSetsList.get(attributeID);
    }

    public ArrayList<String> getAllUnsupportedAttributesJobSetsList() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String userID : this.m_UnsupportedAttribute_JobSetsList.keySet()) {
            resultList.add(userID);
        }
        return resultList;
    }

    public TNGAssessmentCSVReader(String path) {
        this.loadJobsCSVFile(path);
        this.loadJobSetsCSVFile(path);
        this.loadJobParmCSVFile(path);
        this.loadStationGroupCSVFile(path);
        this.setStationGroups(path);
        this.setCalendars();
        this.loadJobPredCSVFile(path);
        this.loadTriggerCSVFile(path);
        this.loadStationCSVFile(path);
    }

    public void loadJobsCSVFile(String filePath) {
        String fileName = filePath + "JOB.csv";
        try {
            CsvReader reader = new CsvReader(fileName);
            reader.setHeaders(TngGlobals.JOB_ATTRIBUTES);
            Object jobIDStr = "";
            int index_JobID = 2;
            String jobSetIDStr = "";
            int index_JobSetID = 1;
            int index_JobNum = 3;
            String stationIDStr = "";
            int index_StationID = 6;
            String calendarIDStr = "";
            int index_CalendarID = 25;
            ArrayList<String> tempArray = null;
            int length = 0;
            reader.readRecord();
            this.m_jobColumnsHeaders = new String[reader.getValues().length];
            for (int i = 0; i < this.m_jobColumnsHeaders.length; ++i) {
                this.m_jobColumnsHeaders[i] = reader.getValues()[i].replaceAll("\"", "");
            }
            ArrayList<String> sonsList = null;
            while (reader.readRecord()) {
                length = reader.getValues().length;
                jobIDStr = reader.getValues()[index_JobSetID].replaceAll("\"", "") + " - " + reader.getValues()[index_JobID].replaceAll("\"", "") + " - ";
                String formatedJobNo = String.format("%04d", Integer.parseInt(reader.getValues()[index_JobNum]));
                jobIDStr = (String)jobIDStr + formatedJobNo;
                tempArray = new ArrayList<String>();
                for (int i = 0; i < length; ++i) {
                    tempArray.add(reader.getValues()[i]);
                    String sCurrentAttributeValue = reader.getValues()[i].replaceAll("\"", "");
                    if (sCurrentAttributeValue.compareToIgnoreCase("NULL") == 0) continue;
                    this.testUnsupportedAttributesJob(i, sCurrentAttributeValue, (String)jobIDStr, true);
                    this.testDateAttributes(reader.getHeader(i), sCurrentAttributeValue, (String)jobIDStr);
                }
                this.m_JobID_Info.put((String)jobIDStr, tempArray);
                jobSetIDStr = reader.getValues()[index_JobSetID].replaceAll("\"", "");
                if (!jobSetIDStr.isEmpty() && jobSetIDStr.compareToIgnoreCase("NULL") != 0) {
                    sonsList = this.m_JobSetID_JobsIDList.get(jobSetIDStr);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add((String)jobIDStr);
                    this.m_JobSetID_JobsIDList.put(jobSetIDStr, sonsList);
                }
                if (!(stationIDStr = reader.getValues()[index_StationID].replaceAll("\"", "")).isEmpty() && stationIDStr.compareToIgnoreCase("NULL") != 0) {
                    sonsList = this.m_StationID_JobsIDList.get(stationIDStr);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add((String)jobIDStr);
                    this.m_StationID_JobsIDList.put(stationIDStr, sonsList);
                }
                if (!(calendarIDStr = reader.getValues()[index_CalendarID].replaceAll("\"", "")).isEmpty() && calendarIDStr.compareToIgnoreCase("NULL") != 0) {
                    sonsList = this.m_CalendarID_JobsIDList.get(calendarIDStr);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add((String)jobIDStr);
                    this.m_CalendarID_JobsIDList.put(calendarIDStr, sonsList);
                } else {
                    sonsList = this.m_JobSetID_JobsIDList_NoCAL.get(jobSetIDStr);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add((String)jobIDStr);
                    this.m_JobSetID_JobsIDList_NoCAL.put(jobSetIDStr, sonsList);
                }
                ++this.m_rowsCount;
            }
            reader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in loadJobsCSVFiles");
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + this.m_rowsCount));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
        }
    }

    public void loadJobSetsCSVFile(String filePath) {
        int d = 0;
        String fileName = filePath + "JOBSET.csv";
        try {
            CsvReader reader = new CsvReader(fileName);
            reader.setHeaders(TngGlobals.JOBSET_ATTRIBUTES);
            ArrayList<String> tempArray = null;
            int length = 0;
            String jobSetIDStr = "";
            int index_JobSetID = 1;
            String stationIDStr = "";
            int index_StationID = 4;
            String calendarIDStr = "";
            int index_CalendarID = 19;
            reader.readRecord();
            this.m_jobSetColumnsHeaders = new String[reader.getValues().length];
            for (int i = 0; i < this.m_jobSetColumnsHeaders.length; ++i) {
                this.m_jobSetColumnsHeaders[i] = reader.getValues()[i].replaceAll("\"", "");
            }
            ArrayList<String> sonsList = null;
            while (reader.readRecord()) {
                jobSetIDStr = reader.getValues()[index_JobSetID].replaceAll("\"", "");
                length = reader.getValues().length;
                tempArray = new ArrayList<String>();
                for (int i = 0; i < length; ++i) {
                    tempArray.add(reader.getValues()[i]);
                    String sCurrentAttributeValue = reader.getValues()[i].replaceAll("\"", "");
                    if (sCurrentAttributeValue.compareToIgnoreCase("NULL") == 0) continue;
                    this.testUnsupportedAttributesJobSet(i, sCurrentAttributeValue, jobSetIDStr);
                    this.testDateAttributes(reader.getHeader(i), sCurrentAttributeValue, jobSetIDStr);
                }
                this.m_JobSetID_Info.put(jobSetIDStr, tempArray);
                stationIDStr = reader.getValues()[index_StationID].replaceAll("\"", "");
                if (!stationIDStr.isEmpty() && stationIDStr.compareToIgnoreCase("NULL") != 0) {
                    sonsList = this.m_StationID_JobsIDList.get(stationIDStr);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add(jobSetIDStr);
                    this.m_StationID_JobsIDList.put(stationIDStr, sonsList);
                }
                if (!(calendarIDStr = reader.getValues()[index_CalendarID].replaceAll("\"", "")).isEmpty() && calendarIDStr.compareToIgnoreCase("NULL") != 0) {
                    sonsList = this.m_CalendarID_JobsIDList.get(calendarIDStr);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add(jobSetIDStr);
                    this.m_CalendarID_JobsIDList.put(calendarIDStr, sonsList);
                    this.m_JobSetID_CalendarID.put(jobSetIDStr, calendarIDStr);
                }
                ++d;
            }
            reader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in loadJobSetsCSVFiles");
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + d));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
        }
    }

    public void loadJobParmCSVFile(String filePath) {
        int d = 0;
        String fileName = filePath + "JOBPARM.csv";
        try {
            CsvReader reader = new CsvReader(fileName);
            Object jobIDStr = "";
            int index_JobID = 2;
            int index_JobSetID = 1;
            int index_JobNum = 3;
            String commandIDStr = "";
            int index_commandID = 18;
            String userIDStr = "";
            int index_userID = 19;
            String prognameStr = "";
            int index_progname = 5;
            String inStr = "";
            int index_in = 10;
            reader.readRecord();
            ArrayList<String> sonsList = null;
            int length = reader.getValues().length;
            while (reader.readRecord()) {
                jobIDStr = reader.getValues()[index_JobSetID].replaceAll("\"", "") + " - " + reader.getValues()[index_JobID].replaceAll("\"", "") + " - ";
                String formatedJobNo = String.format("%04d", Integer.parseInt(reader.getValues()[index_JobNum]));
                jobIDStr = (String)jobIDStr + formatedJobNo;
                commandIDStr = reader.getValues()[index_commandID];
                this.m_JobID_Command.put((String)jobIDStr, commandIDStr);
                if (commandIDStr.toUpperCase().contains(SAP_NAME)) {
                    this.m_SAPJobsIDList.add((String)jobIDStr);
                }
                if ((prognameStr = reader.getValues()[index_progname]) != null && !prognameStr.isEmpty() && !prognameStr.equals("NULL")) {
                    this.m_TandemJobsIDList.add((String)jobIDStr);
                    this.m_JobID_Progname.put((String)jobIDStr, prognameStr);
                    inStr = reader.getValues()[index_in];
                    this.m_JobID_In.put((String)jobIDStr, inStr);
                }
                if (!(userIDStr = reader.getValues()[index_userID].replaceAll("\"", "")).isEmpty() && userIDStr.compareToIgnoreCase("NULL") != 0) {
                    sonsList = this.m_User_JobsIDList.get(userIDStr);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add((String)jobIDStr);
                    this.m_User_JobsIDList.put(userIDStr, sonsList);
                }
                for (int i = 0; i < length; ++i) {
                    String sCurrentAttributeValue = reader.getValues()[i].replaceAll("\"", "");
                    if (sCurrentAttributeValue.compareToIgnoreCase("NULL") == 0) continue;
                    this.testUnsupportedAttributesJob(i, sCurrentAttributeValue, (String)jobIDStr, false);
                }
                ++d;
            }
            reader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in loadJobParmCSVFiles");
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + d));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
        }
    }

    public void loadStationGroupCSVFile(String filePath) {
        int d = 0;
        String fileName = filePath + "STATIONGROUP.csv";
        try {
            CsvReader reader = new CsvReader(fileName);
            ArrayList<String> tempArray = null;
            String[] stationsList = null;
            String StationGroupIDStr = "";
            int index_StationGroupID = 1;
            String StationsListStr = "";
            int index_StationsList = 2;
            reader.readRecord();
            while (reader.readRecord()) {
                StationGroupIDStr = reader.getValues()[index_StationGroupID].replaceAll("\"", "");
                StationsListStr = reader.getValues()[index_StationsList];
                StationsListStr = StationsListStr.replaceAll("\\(", "");
                StationsListStr = StationsListStr.replaceAll("\\)", "");
                stationsList = StationsListStr.split(",");
                tempArray = new ArrayList<String>(Arrays.asList(stationsList));
                this.m_StationGroupID_StationsIDList.put(StationGroupIDStr, tempArray);
                ++d;
            }
            reader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in loadStationGroupCSVFile");
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + d));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
        }
    }

    public void setStationGroups(String filePath) {
        int d = 0;
        String fileName = filePath + "STATIONGROUP.csv";
        try {
            CsvReader reader = new CsvReader(fileName);
            reader.readRecord();
            String stationID = "";
            int index_stationID = 1;
            ArrayList<String> tempStationGroupsList = new ArrayList<String>();
            while (reader.readRecord()) {
                stationID = reader.getValues()[index_stationID].replaceAll("\"", "");
                if (tempStationGroupsList.contains(stationID)) continue;
                tempStationGroupsList.add(stationID);
            }
            reader.close();
            for (String stationGroup : this.m_StationID_JobsIDList.keySet()) {
                if (!tempStationGroupsList.contains(stationGroup)) continue;
                this.m_stationGroupsList.add(stationGroup);
            }
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in setStationGroups");
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + d));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
        }
    }

    public void setCalendars() {
        Set<String> jobSetList = this.m_JobSetID_JobsIDList_NoCAL.keySet();
        ArrayList<String> jobsList = null;
        String calnedarID = null;
        for (String jobSet : jobSetList) {
            calnedarID = this.m_JobSetID_CalendarID.get(jobSet);
            if (null == calnedarID || null == (jobsList = this.m_JobSetID_JobsIDList_NoCAL.get(jobSet))) continue;
            this.m_CalendarID_JobsIDList.get(calnedarID).addAll(jobsList);
        }
    }

    private void loadJobPredCSVFile(String filePath) {
        int d = 0;
        String fileName = filePath + "JOBPRED.csv";
        try {
            CsvReader reader = new CsvReader(fileName);
            String sTREV = "";
            int index_TREV = 8;
            int index_TRID = 9;
            reader.readRecord();
            while (reader.readRecord()) {
                sTREV = reader.getValues()[index_TREV].replaceAll("\"", "");
                if ((sTREV = sTREV.replaceAll("\"", "")).compareToIgnoreCase(TREV_NAME) == 0) {
                    this.m_declaredTriggersList.add(reader.getValues()[index_TRID].replaceAll("\"", ""));
                }
                ++d;
            }
            reader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in loadJobPredCSVFile");
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + d));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
        }
    }

    private void loadTriggerCSVFile(String filePath) {
        int d = 0;
        String fileName = filePath + "TRIGGER.csv";
        try {
            CsvReader reader = new CsvReader(fileName);
            String sTriggerID = "";
            int index_TriggerID = 1;
            String sEventID = "";
            int index_EventID = 2;
            String sDescription = "";
            int index_Description = 3;
            String sStation = "";
            int index_Station = 7;
            String sFileName = "";
            int index_FileName = 8;
            reader.readRecord();
            ArrayList<String> sonsList = null;
            while (reader.readRecord()) {
                sTriggerID = reader.getValues()[index_TriggerID].replaceAll("\"", "");
                if (this.m_declaredTriggersList.contains(sTriggerID)) {
                    sStation = reader.getValues()[index_Station].replaceAll("\"", "");
                    sonsList = this.m_StationID_TriggersIDList.get(sStation);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add(sTriggerID);
                    this.m_StationID_TriggersIDList.put(sStation, sonsList);
                    sDescription = reader.getValues()[index_Description].replaceAll("\"", "");
                    sFileName = reader.getValues()[index_FileName].replaceAll("\"", "");
                    sEventID = reader.getValues()[index_EventID].replaceAll("\"", "");
                    this.m_TriggerID_Info.put(sTriggerID, sDescription + ";" + sFileName + ";" + sEventID);
                }
                ++d;
            }
            reader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in loadTriggerCSVFile");
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + d));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
        }
    }

    private void loadStationCSVFile(String filePath) {
        int d = 0;
        String fileName = filePath + "STATION.csv";
        try {
            CsvReader reader = new CsvReader(fileName);
            String stationIDStr = "";
            int index_stationID = 1;
            reader.readRecord();
            this.m_stationColumnsHeaders = new String[reader.getValues().length];
            for (int i = 0; i < this.m_stationColumnsHeaders.length; ++i) {
                this.m_stationColumnsHeaders[i] = reader.getValues()[i].replaceAll("\"", "");
            }
            int length = reader.getValues().length;
            ArrayList<String> tempArray = null;
            while (reader.readRecord()) {
                stationIDStr = reader.getValues()[index_stationID].replaceAll("\"", "");
                tempArray = new ArrayList<String>();
                for (int i = 0; i < length; ++i) {
                    tempArray.add(reader.getValues()[i]);
                }
                this.m_StationID_Info.put(stationIDStr, tempArray);
                ++d;
            }
            reader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in loadStationCSVFile");
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + d));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
        }
    }

    void testUnsupportedAttributesJob(int index, String sCurrentAttributeValue, String jobIDStr, boolean bFromJobCSVFile) {
        String[] unsupportedAttributesNames;
        int[] unsupportedAttributesColumnIndex;
        if (bFromJobCSVFile && m_indexCPU == index && sCurrentAttributeValue.equalsIgnoreCase(m_CPU)) {
            return;
        }
        Object sCurrentAttributeName = m_sJob;
        ArrayList<String> jobsListOfAttribute = null;
        if (bFromJobCSVFile) {
            unsupportedAttributesColumnIndex = this.m_UnsupportedAttributesColumnIndex_Job;
            unsupportedAttributesNames = this.m_UnsupportedAttributes_Job;
        } else {
            unsupportedAttributesColumnIndex = this.m_UnsupportedAttributesColumnIndex_JobParm;
            unsupportedAttributesNames = this.m_UnsupportedAttributes_JobParm;
        }
        for (int x = 0; x < unsupportedAttributesColumnIndex.length; ++x) {
            if (unsupportedAttributesColumnIndex[x] != index) continue;
            jobsListOfAttribute = this.m_UnsupportedAttribute_JobsList.get(sCurrentAttributeName = (String)sCurrentAttributeName + unsupportedAttributesNames[x]);
            if (null == jobsListOfAttribute) {
                jobsListOfAttribute = new ArrayList();
            }
            jobsListOfAttribute.add(jobIDStr);
            this.m_UnsupportedAttribute_JobsList.put((String)sCurrentAttributeName, jobsListOfAttribute);
        }
    }

    void testUnsupportedAttributesJobSet(int index, String sCurrentAttributeValue, String jobSetIDStr) {
        Object sCurrentAttributeName = m_sJobSet;
        ArrayList<String> jobSetsListOfAttribute = null;
        for (int x = 0; x < this.m_UnsupportedAttributesColumnIndex_JobSet.length; ++x) {
            if (this.m_UnsupportedAttributesColumnIndex_JobSet[x] != index) continue;
            jobSetsListOfAttribute = this.m_UnsupportedAttribute_JobSetsList.get(sCurrentAttributeName = (String)sCurrentAttributeName + this.m_UnsupportedAttributes_JobSet[x]);
            if (null == jobSetsListOfAttribute) {
                jobSetsListOfAttribute = new ArrayList();
            }
            jobSetsListOfAttribute.add(jobSetIDStr);
            this.m_UnsupportedAttribute_JobSetsList.put((String)sCurrentAttributeName, jobSetsListOfAttribute);
        }
    }

    private String[] parseDateString(String inputData) {
        Matcher matcher;
        String[] retVal = null;
        String datePattern = "(\\d{1,2}|\\w{3})([\\W])(\\d{1,2})\\2(\\d{4})";
        Pattern pat = Pattern.compile(datePattern);
        if (inputData != null && (matcher = pat.matcher(inputData)).matches()) {
            if (GlobalFunctions.isNumber((String)matcher.group(1))) {
                retVal = this.getDayMonth(matcher.group(3), matcher.group(1), matcher.group(4));
            } else {
                String month = TngJob.getNumericMonth(matcher.group(1));
                retVal = this.getDayMonth(matcher.group(3), month, matcher.group(4));
            }
        }
        return retVal;
    }

    private String[] getDayMonth(String theDay, String theMonth, String theYear) {
        String[] retVal = new String[]{theMonth, theDay};
        return retVal;
    }

    void testDateAttributes(String sCurrentAttributeName, String sCurrentAttributeValue, String jobIDStr) {
        ArrayList<String> dateFieldsListOfAttribute = null;
        for (int x = 0; x < this.m_DateAttributes.length; ++x) {
            if (this.m_DateAttributes[x] != sCurrentAttributeName) continue;
            dateFieldsListOfAttribute = this.m_DateFields_List.get(sCurrentAttributeName);
            if (null == dateFieldsListOfAttribute) {
                dateFieldsListOfAttribute = new ArrayList();
            }
            dateFieldsListOfAttribute.add(sCurrentAttributeValue);
            this.m_DateFields_List.put(sCurrentAttributeName, dateFieldsListOfAttribute);
            String[] dateValues = this.parseDateString(sCurrentAttributeValue);
            Integer val1 = 0;
            Integer val2 = 0;
            if (GlobalFunctions.isNumber((String)dateValues[0])) {
                val1 = Integer.parseInt(dateValues[0]);
            }
            if (GlobalFunctions.isNumber((String)dateValues[1])) {
                val2 = Integer.parseInt(dateValues[1]);
            }
            if (this.m_RecommendedDateFormat == m_RecommendedDateFormatType.NO_DATES) {
                if (val1 > 12) {
                    this.m_RecommendedDateFormat = m_RecommendedDateFormatType.DDMM;
                    break;
                }
                if (val2 <= 12) break;
                this.m_RecommendedDateFormat = m_RecommendedDateFormatType.MMDD;
                break;
            }
            if (this.m_RecommendedDateFormat == m_RecommendedDateFormatType.DDMM) {
                if (val2 <= 12) break;
                this.m_RecommendedDateFormat = m_RecommendedDateFormatType.CANNOT_DETERMINE;
                break;
            }
            if (this.m_RecommendedDateFormat != m_RecommendedDateFormatType.MMDD || val1 <= 12) break;
            this.m_RecommendedDateFormat = m_RecommendedDateFormatType.CANNOT_DETERMINE;
            break;
        }
    }

    public String getRecommendedDateFormat() {
        String ret = "Can not determine";
        if (this.m_RecommendedDateFormat == m_RecommendedDateFormatType.NO_DATES) {
            ret = "No dates found";
        } else if (this.m_RecommendedDateFormat == m_RecommendedDateFormatType.DDMM) {
            ret = "European (DDMM)";
        } else if (this.m_RecommendedDateFormat == m_RecommendedDateFormatType.MMDD) {
            ret = "American (MMDD)";
        }
        return ret;
    }

    private static enum m_RecommendedDateFormatType {
        NO_DATES,
        MMDD,
        DDMM,
        CANNOT_DETERMINE;

    }
}

