/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rule;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.rule.ConversionBuilderRule;
import com.bmc.ctmconvert.rule.RulesProvider;
import com.bmc.ctmconvert.rule.SelfConversionRuleHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class XmlRulesProvider
implements RulesProvider {
    private static final String RULE_TAG = "RULE";
    private InputStream input;
    private List<ConversionBuilderRule> rules = new ArrayList<ConversionBuilderRule>();

    public XmlRulesProvider(InputStream inputXml) {
        this.input = inputXml;
        this.init();
    }

    private void init() {
        XmlLoader loader = new XmlLoader();
        try {
            loader.loadFile(this.input);
            XmlElement root = loader.getXmlElement();
            List nodesList = root.getDirectchildsElementbyName(RULE_TAG);
            if (nodesList.isEmpty()) {
                throw new RuleFilesHasNoRulesException();
            }
            nodesList.stream().forEach(this::readConversionRule);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException("Invalid input rules file - failed to parse xml file", e);
        }
    }

    private void readConversionRule(XmlElement ruleXml) {
        SelfConversionRuleHandler selfConversionRuleHandler = new SelfConversionRuleHandler();
        ConversionBuilderRule selfConversionRule = selfConversionRuleHandler.createSelfConversionRule(ruleXml);
        this.rules.add(selfConversionRule);
    }

    @Override
    public List<ConversionBuilderRule> getRules() {
        return this.rules;
    }

    public class RuleFilesHasNoRulesException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private static final String message = "Conversion rules file does not contain any rules";

        public RuleFilesHasNoRulesException() {
            super(message);
        }
    }
}

