/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rule;

import com.bmc.ctmconvert.Context;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.exception.ChildElementNotFoundException;
import com.bmc.ctmconvert.exception.FailedToCreateStringParameterException;
import com.bmc.ctmconvert.exception.RuleClassNotFoundException;
import com.bmc.ctmconvert.rule.ScriptRuleElementHandler;
import com.bmc.ctmconvert.subject.IdentitySubject;
import com.bmc.ctmconvert.workspace.Workspace;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;

public class RuleElementHandler {
    private static final String COM_BMC_CTMCONVERT_SUBJECT_SUBJECT = "com.bmc.ctmconvert.subject.Subject";
    protected static final String JAVA_UTIL_LIST = "java.util.List";
    protected static final String COM_BMC_CTMCONVERT_WORKSPACE_WORKSPACE = "com.bmc.ctmconvert.workspace.Workspace";
    protected static final String DEFAULT_PACKAGE_PREFIX = "com.bmc.ctmconvert";
    protected static final String DOT = ".";
    protected static final String CLASS_NAME_ATTRIBUTE = "ClassName";
    protected static final String JAVA_LANG_STRING = "java.lang.String";

    public Object createObjectFromXml(XmlElement ruleElement) throws Exception {
        String className = this.getClassName(ruleElement);
        if (ScriptRuleElementHandler.isBelong(className)) {
            ScriptRuleElementHandler scriptRuleElementHandler = this.getScriptHandler();
            return scriptRuleElementHandler.getObject(ruleElement);
        }
        String elementTag = ruleElement.getTagName();
        Constructor<?> constructor = this.getConstractorFromClassPath(elementTag, className);
        List<Object> parameterList = this.createParametersListForCtor(constructor, ruleElement);
        Object retObject = constructor.newInstance(parameterList.toArray());
        return retObject;
    }

    ScriptRuleElementHandler getScriptHandler() {
        return new ScriptRuleElementHandler();
    }

    protected Constructor<?> getConstractorFromClassPath(String elementTag, String className) throws RuleClassNotFoundException {
        String packagePath = "com.bmc.ctmconvert." + elementTag.toLowerCase();
        String classPath = packagePath + DOT + className;
        Constructor<?> constructor = null;
        try {
            Class<?> classData = Class.forName(classPath);
            constructor = classData.getConstructors()[0];
        }
        catch (ClassNotFoundException e) {
            throw new RuleClassNotFoundException(elementTag, className);
        }
        return constructor;
    }

    protected String getClassName(XmlElement ruleElement) {
        String className = ruleElement.getAttribute(CLASS_NAME_ATTRIBUTE);
        return className;
    }

    private List<Object> createParametersListForCtor(Constructor<?> constructor, XmlElement ruleElement) throws Exception {
        Parameter[] ctorParameters = constructor.getParameters();
        ArrayList<Object> retParameterList = new ArrayList<Object>();
        for (Parameter parameter : ctorParameters) {
            int instanceNumber = this.getExpectedXmlElementInstanceNumber(parameter, retParameterList);
            Object object = this.createParameter(parameter, ruleElement, instanceNumber);
            retParameterList.add(object);
        }
        return retParameterList;
    }

    public int getExpectedXmlElementInstanceNumber(Parameter parameter, List<Object> retParameterList) {
        int instanceNumber = 0;
        for (Object object : retParameterList) {
            if (!parameter.getType().isInstance(object)) continue;
            ++instanceNumber;
        }
        return instanceNumber;
    }

    protected Object createParameter(Parameter parameter, XmlElement ruleElement, int instanceNumber) throws Exception {
        String typeName;
        Object retObject = null;
        switch (typeName = parameter.getType().getName()) {
            case "java.lang.String": {
                retObject = this.stringHandler(parameter, ruleElement);
                break;
            }
            case "com.bmc.ctmconvert.workspace.Workspace": {
                retObject = this.workspaceHandler();
                break;
            }
            case "java.util.List": {
                retObject = this.javaListHandler(ruleElement);
                break;
            }
            case "com.bmc.ctmconvert.subject.Subject": {
                retObject = this.subjectHandler(ruleElement, typeName, instanceNumber);
                break;
            }
            default: {
                XmlElement childRuleElement = this.getChildRuleElementByTypeName(ruleElement, typeName, instanceNumber);
                retObject = this.createObjectFromXml(childRuleElement);
            }
        }
        return retObject;
    }

    public Object subjectHandler(XmlElement ruleElement, String typeName, int instanceNumber) throws Exception {
        Object retObject;
        try {
            XmlElement childRuleElement = this.getChildRuleElementByTypeName(ruleElement, typeName, instanceNumber);
            retObject = this.createObjectFromXml(childRuleElement);
        }
        catch (ChildElementNotFoundException e) {
            retObject = new IdentitySubject();
        }
        return retObject;
    }

    private Object javaListHandler(XmlElement ruleElement) throws Exception {
        List childsElement = ruleElement.getAllDirectchildsElement();
        ArrayList<Object> result = new ArrayList<Object>();
        for (XmlElement element : childsElement) {
            result.add(this.createObjectFromXml(element));
        }
        return result;
    }

    protected XmlElement getChildRuleElementByTypeName(XmlElement ruleElement, String typeName, int instanceNumber) {
        String className = this.getClassNameFromTypeName(typeName);
        String tagName = this.getTagNameFromClassName(className);
        List directchildsElement = ruleElement.getDirectchildsElementbyName(tagName);
        if (directchildsElement.isEmpty() || directchildsElement.size() <= instanceNumber) {
            throw new ChildElementNotFoundException(tagName, ruleElement.getTagName());
        }
        return (XmlElement)directchildsElement.get(instanceNumber);
    }

    protected String stringHandler(Parameter parameter, XmlElement ruleElement) {
        String attributeName = parameter.getName();
        if (!ruleElement.hasAttribute(attributeName)) {
            throw new FailedToCreateStringParameterException(parameter, ruleElement);
        }
        String attributeValue = ruleElement.getAttribute(attributeName);
        return attributeValue;
    }

    protected Workspace workspaceHandler() {
        return Context.getWorkspace().getWorkspace();
    }

    protected String getClassNameFromTypeName(String typeName) {
        return this.splitByPatternAndReturnLast(typeName, "\\.");
    }

    protected String getTagNameFromClassName(String className) {
        String tagName = this.splitByPatternAndReturnLast(className, "(?=\\p{Upper})");
        return tagName.toUpperCase();
    }

    protected String splitByPatternAndReturnLast(String className, String pattern) {
        String[] splitByUpperCase = className.split(pattern);
        int lastIndex = splitByUpperCase.length - 1;
        String tagName = splitByUpperCase[lastIndex];
        return tagName;
    }
}

