/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.DataSupplier;
import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class MultiDataSupplier
implements Consumer<Path> {
    private Path dirPath;
    private List<Supplier<InputStream>> inputSuppliers;

    public MultiDataSupplier(Path somePath) {
        this.dirPath = somePath;
        this.inputSuppliers = new ArrayList<Supplier<InputStream>>();
    }

    protected List<Supplier<InputStream>> suplyData() {
        try (Stream<Path> paths = Files.walk(this.dirPath, new FileVisitOption[0]);){
            paths.forEach(this::accept);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return this.inputSuppliers;
    }

    @Override
    public void accept(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        DataSupplier singleSupp = new DataSupplier(path);
        this.inputSuppliers.add(singleSupp.supplyData());
    }
}

