/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.io.csv.CsvReader;
import com.bmc.ctmconvert.jobtrac.JobTracCSVWriter;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class SCLsLargeCSVFilesSplitter {
    private ArrayList<String> m_largeFilesList = new ArrayList();

    public ArrayList<String> getSmallFilesList() {
        return this.m_largeFilesList;
    }

    public boolean splitLargeFile(String fileName, String fileSuffix) {
        int d = 0;
        String sWriterName = "";
        try {
            File nfilename;
            File ofilename;
            CsvReader reader = new CsvReader(fileName);
            int jobsCounter = 0;
            int filesCounter = 0;
            String sJobID = "";
            String sPreviousJobID = "";
            Object sGroupSuffix = "";
            CsvWriter writer = null;
            ArrayList<ArrayList<String>> jobsDataList = new ArrayList<ArrayList<String>>();
            ArrayList<String> jobList = new ArrayList<String>();
            int indexJobID = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "JobID");
            reader.readRecord();
            ArrayList<String> headersList = new ArrayList<String>(Arrays.asList(reader.getValues()));
            jobsDataList.add(headersList);
            while (reader.readRecord()) {
                sJobID = reader.getValues()[indexJobID];
                if (!sJobID.equals(sPreviousJobID) && ++jobsCounter >= JobTracGlobals.MAX_JOBS_IN_SCL_CSV_FILE) {
                    sGroupSuffix = ".EventsGroup." + String.format("%04d", filesCounter) + fileSuffix;
                    sWriterName = fileName.replace(fileSuffix, (CharSequence)sGroupSuffix);
                    writer = new CsvWriter(sWriterName);
                    this.m_largeFilesList.add(sWriterName);
                    JobTracCSVWriter.writeToCSV(jobsDataList, writer);
                    writer.close();
                    ++filesCounter;
                    jobsCounter = 0;
                    jobsDataList.clear();
                    jobsDataList.add(headersList);
                }
                for (String val : reader.getValues()) {
                    jobList.add(val);
                }
                jobsDataList.add(jobList);
                jobList = new ArrayList();
                sPreviousJobID = sJobID;
                ++d;
            }
            if (jobsDataList.size() > 0) {
                sGroupSuffix = ".EventsGroup." + String.format("%04d", filesCounter) + fileSuffix;
                sWriterName = fileName.replace(fileSuffix, (CharSequence)sGroupSuffix);
                writer = new CsvWriter(sWriterName);
                JobTracCSVWriter.writeToCSV(jobsDataList, writer);
                writer.close();
            }
            reader.close();
            if (filesCounter > 0 && !(ofilename = new File(fileName)).renameTo(nfilename = new File(fileName + ".unsplit"))) {
                throw new IOException("Couldn't rename unsplit large SCL file '" + fileName + "' to '" + fileName + ".unsplit'");
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return false;
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in SCLsLargeCSVFilesSplitter - splitLargeFile");
            ExceptionHandler.writeToExceptionFile((String)("Reading File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + d));
            ExceptionHandler.writeToExceptionFile((String)("Writing to File : " + sWriterName));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading/writing csv file: " + String.valueOf(e)));
            return false;
        }
        return true;
    }
}

