/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CtmPriority;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import com.bmc.ctmconvert.jobtrac.JobtracDefs;
import com.bmc.ctmconvert.rules.FieldEditor;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.lang.invoke.CallSite;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JobtracJob
implements SchedEntity {
    private JobtracDefs m_sourceDefs;
    private String m_jobName;
    private IAttrHolder m_sclAttr = null;
    private AttrHolderList m_fullSclAttributes = null;
    private JobtracJob m_parent = null;
    private SchedEntity.TYPE m_type = null;
    private HashMap<String, String> m_attributes = new HashMap();
    private HashSet<String> m_optionalAttributes = null;
    private ArrayList<String> m_messages;
    private ArrayList<Properties> m_shouts;
    private ArrayList<Properties> m_tags = new ArrayList();
    private RulesDataSet m_rules = null;
    private ArrayList<Properties> m_controlRes = null;
    private ArrayList<Properties> m_quantRes = null;
    private ArrayList<Properties> m_inConds;
    private ArrayList<Properties> m_outConds;
    private ArrayList<Properties> m_onstmt = null;
    private boolean m_isValid = true;
    private LinkedHashMap<String, String> m_autoedits;
    private static CtmPriority m_priorityCalculator = null;
    private static int iStepName = 0;
    private static int iStepProc = 2;
    private static int iStepPGM = 3;
    String sacIndicator;
    DateFormat dateFormat = new SimpleDateFormat("yyMMdd");
    Date date = new Date();
    String currDate = this.dateFormat.format(this.date);
    private boolean isCA11Active;

    public JobtracJob(String table, IAttrHolder sclAttributes, JobtracDefs jobtracDefs) {
        this.m_sourceDefs = jobtracDefs;
        this.m_sclAttr = sclAttributes;
        this.m_type = SchedEntity.TYPE.SMART_TABLE;
        this.init();
    }

    public JobtracJob(SchedEntity parent, IAttrHolder sclAttributes, JobtracDefs sourceDefs) {
        this.m_parent = (JobtracJob)parent;
        this.m_sclAttr = sclAttributes;
        this.m_sourceDefs = sourceDefs;
        this.m_type = this.m_sclAttr.isFieldExist("FAKE_TABLE_NAME") ? SchedEntity.TYPE.SUB_TABLE : SchedEntity.TYPE.JOB;
        this.init();
    }

    public JobtracJob(SchedEntity parent, AttrHolderList jobAttributes, JobtracDefs jobtracDefs) {
        this.m_parent = (JobtracJob)parent;
        this.m_fullSclAttributes = jobAttributes;
        this.m_sourceDefs = jobtracDefs;
        this.m_type = ((IAttrHolder)this.m_fullSclAttributes.get(0)).isFieldExist("FAKE_TABLE_NAME") ? SchedEntity.TYPE.SUB_TABLE : SchedEntity.TYPE.JOB;
        if ("DSTRGSET".equals(this.getParentName())) {
            this.initDummyJobForDSTrigGlobalVariable();
        } else {
            this.init();
        }
    }

    private void initDummyJobForDSTrigGlobalVariable() {
        this.m_rules = RuleManager.instance().getCurrentRules();
        this.m_messages = new ArrayList();
        this.m_autoedits = new LinkedHashMap();
        this.m_attributes.put("TASKTYPE", "Job");
        this.m_attributes.put("OWNER", "DUMMYUSR");
        this.m_attributes.put("JOBNAME", "DSTRGSET");
        this.m_attributes.put("MEMNAME", "DSTRGSET");
        this.m_attributes.put("MEMLIB", "DUMMY");
        this.m_jobName = "DSTRGSET";
        this.m_sourceDefs.getDsTrigGlobalVariables().stream().forEach(pair -> this.m_autoedits.put(String.format("\\M\\NO_APPL\\NO_GROUP\\DSNTRIG\\%s", pair.getKey()), (String)pair.getValue()));
    }

    private void init() {
        this.m_rules = RuleManager.instance().getCurrentRules();
        boolean useAltJcl = this.m_rules.getBooleanRule("Jobtrac rules", new String[]{"UseAltJCL"});
        this.isCA11Active = this.m_rules.getBooleanRule("Jobtrac rules", new String[]{"CA-11_IS_ACTIVE"});
        this.m_messages = new ArrayList();
        if (this.type() == SchedEntity.TYPE.JOB) {
            if (useAltJcl) {
                this.m_jobName = this.getSclAttrAsStr("R_AlternateName");
                this.m_jobName = !this.m_jobName.isEmpty() ? this.m_jobName.substring(1) : this.getSclAttrAsStr("EVENTNM");
            } else {
                this.m_jobName = this.getSclAttrAsStr("EVENTNM");
            }
            this.validateJob();
            if (!this.isValid()) {
                return;
            }
            if (this.getSclAttrAsStr("EVENTNM").startsWith("0")) {
                this.m_attributes.put("TASKTYPE", "Started_Task");
                this.m_attributes.put("MEMNAME", "CTMJOBPR");
                String fullMemlib = "*,LIB=" + this.m_rules.getStringRule("Mainframe", new String[]{"SCHEDTAB"}) + ",TABLE=" + this.getSclAttrAsStr("EVENTNM").substring(1);
                if (fullMemlib.length() > Globs.MEMLIB_MAX_LEN) {
                    if (this.m_autoedits == null) {
                        this.m_autoedits = new LinkedHashMap();
                    }
                    this.m_autoedits.put("%%SCHLIB", this.m_rules.getStringRule("Mainframe", new String[]{"SCHEDTAB"}));
                    fullMemlib = "*,LIB=%%SCHLIB,TABLE=" + this.getSclAttrAsStr("EVENTNM").substring(1);
                }
                this.m_attributes.put("MEMLIB", fullMemlib);
            } else {
                this.m_attributes.put("TASKTYPE", "Job");
                this.m_attributes.put("MEMNAME", this.m_jobName);
                if (this.getSclAttrAsStr("EventType").equals("D") || this.getSclAttrAsStr("EventType").equals("E")) {
                    this.m_attributes.put("MEMLIB", "DUMMY");
                } else if (!this.isDSJob()) {
                    this.m_attributes.put("MEMLIB", this.applyFieldConversion("MEMLIB"));
                }
            }
            this.setSchedDefs();
            this.readTimeFrame();
            this.readResources();
            this.readDeps();
            this.readReferback();
            String alternateJCL = this.getSclAttrAsStr("R_AlternateName");
            if (this.isDSJob()) {
                this.setJobToDS();
            } else if (!useAltJcl && !alternateJCL.isEmpty()) {
                String jclLib = this.m_rules.getStringRule("Mainframe", new String[]{"JCLLIB"});
                this.m_attributes.put("USE_INSTREAM_JCL", "Y");
                String inStream = String.format("//* %%%%INCLIB %s %%%%INCMEM %s", jclLib, alternateJCL.substring(1));
                this.setOptionalAttribute("INSTREAM_JCL", String.format("%04d%s", inStream.length(), inStream));
            } else {
                this.m_attributes.put("USE_INSTREAM_JCL", "N");
            }
            if (this.isDummyConversion()) {
                this.setJobToRunAsDummy();
            }
        } else {
            this.populateFolderAttributes();
        }
        if (null != this.m_jobName) {
            this.m_jobName = this.m_jobName.replaceAll("\\s+", "_");
        }
        this.m_attributes.put("TABLE_DSN", this.m_rules.getStringRule("Mainframe", new String[]{"SCHEDTAB"}));
        this.m_attributes.put("JOBNAME", this.m_jobName);
        Object altJclDesc = "";
        if (useAltJcl && this.m_type == SchedEntity.TYPE.JOB && !this.m_jobName.equals(this.getSclAttrAsStr("EVENTNM"))) {
            altJclDesc = " Original EVENT Name: " + this.getSclAttrAsStr("EVENTNM");
        }
        if (!this.m_attributes.containsKey("DESCRIPTION")) {
            this.m_attributes.put("DESCRIPTION", this.applyFieldConversion("DESCRIPTION") + (String)altJclDesc);
        }
        this.m_attributes.put("TIMEZONE", "");
        if (!this.m_attributes.containsKey("PRIORITY")) {
            this.m_attributes.put("PRIORITY", "");
        }
        if (this.isCyclic()) {
            this.setToCyclic();
        } else {
            this.m_attributes.put("CYCLIC", "0");
            if (this.m_type == SchedEntity.TYPE.JOB && !this.m_attributes.containsKey("MAXRERUN")) {
                this.m_attributes.put("MAXRERUN", "5");
            }
        }
        this.m_attributes.put("APPLICATION", this.applyFieldConversion("APPLICATION"));
        this.m_attributes.put("OWNER", this.applyFieldConversion("OWNER"));
        String group = this.applyFieldConversion("GROUP");
        if (group.length() > 20) {
            group = group.substring(0, 20);
        }
        this.m_attributes.put("GROUP", group);
        this.m_attributes.put("AUTHOR", this.applyFieldConversion("AUTHOR"));
    }

    private void populateFolderAttributes() {
        this.m_jobName = this.m_sclAttr.getAttr("FAKE_TABLE_NAME");
        this.createTableTags();
        HashSet<String> dups = this.m_sourceDefs.getDuplicateTables(this.m_jobName);
        if (dups != null && dups.size() > 1) {
            Reporter.addMessage(this.m_messages, (String)"WRN5009", (String)this.m_jobName, (String[])new String[]{this.m_jobName, dups.toString()});
        }
        this.m_attributes.put("TABLE_USERDAILY", "");
    }

    private boolean isDummyConversion() {
        return this.m_rules.getTaskTypeHandler().isToDummy();
    }

    private void validateJob() {
        if (this.getSclAttrAsStr("EventType").equals("E")) {
            Reporter.addMessage(this.m_messages, (String)"ERR5002", (String)this.m_jobName, (String[])new String[]{this.getSclAttrAsStr("EVENTNM"), this.getSclAttrAsStr("LibraryName")});
        }
        if (this.getSclAttrAsStr("EVENTNM").trim().isEmpty()) {
            Reporter.addMessage(this.m_messages, (String)"ERR0004", (String)this.m_jobName, (String[])new String[]{"JOBTRAC", "EVENTNM", this.getSclAttrAsStr("EVENTNM"), this.getSclAttrAsStr("SCLmember")});
            this.m_isValid = false;
        }
    }

    void readTimeFrame() {
        if (this.m_type != SchedEntity.TYPE.JOB) {
            return;
        }
        String timeFrom = "";
        String timeTo = "";
        String lateSubTime = "";
        for (IAttrHolder currSclLine : this.m_fullSclAttributes) {
            String threshold = currSclLine.getAttr("Threshold");
            String time = currSclLine.getAttr("Time");
            if (time.equalsIgnoreCase("ASAP")) continue;
            if (time.equals("*")) {
                if (threshold.equals("T")) {
                    time = "ASAP";
                    continue;
                }
                Reporter.addMessage(this.m_messages, (String)"WRN0005", (String)this.m_jobName, (String[])new String[]{this.m_jobName, this.m_jobName, "Time=*"});
                continue;
            }
            if (!this.isValidTimeHHMM(time)) {
                if (time.trim().isEmpty()) continue;
                Reporter.addMessage(this.m_messages, (String)"WRN0006", (String)this.m_jobName, (String[])new String[]{"JOBTRAC", "Time", time, "TIME"});
                continue;
            }
            if (threshold.equals("A") && (timeTo.isEmpty() || Integer.valueOf(timeTo) < Integer.valueOf(time))) {
                timeTo = time;
            }
            if ((threshold.isEmpty() || threshold.equals("S")) && (timeFrom.isEmpty() || Integer.valueOf(timeFrom) > Integer.valueOf(time))) {
                timeFrom = time;
            }
            if (!threshold.isEmpty() && !threshold.equals("T") || time.isEmpty() || !lateSubTime.isEmpty() && Integer.valueOf(lateSubTime) <= Integer.valueOf(time)) continue;
            lateSubTime = time;
        }
        if (!timeFrom.isEmpty()) {
            this.m_attributes.put("TIMEFROM", timeFrom);
            this.sacIndicator = "";
            String newday = this.m_rules.getStringRule("Jobtrac rules", new String[]{"NEWDAY"});
            if (newday.substring(0, 1).equals("+") && Integer.valueOf(timeFrom) < Integer.valueOf(newday.substring(1, 5))) {
                this.sacIndicator = "P";
            } else if (newday.substring(0, 1).equals("-") && Integer.valueOf(timeFrom) > 2400 - Integer.valueOf(newday.substring(1, 5))) {
                this.sacIndicator = "N";
            }
            if (!this.sacIndicator.isEmpty()) {
                if (!this.isDSJob()) {
                    this.m_attributes.put("PREV_DAY", this.sacIndicator);
                } else {
                    Reporter.addMessage(this.m_messages, (String)"WRN5028", (String)this.m_jobName, (String[])new String[]{this.m_jobName, timeFrom, newday});
                }
            }
        }
        if (!timeTo.isEmpty()) {
            this.m_attributes.put("TIMETO", timeTo);
        }
        if (!lateSubTime.isEmpty()) {
            Properties lateSubShout = new Properties();
            lateSubShout.put("DEST", this.isDSJob() ? "EM" : "OPER");
            lateSubShout.put("MESSAGE", String.format("Submission of job %s delayed beyond %02d:%02d", this.m_jobName, Integer.valueOf(lateSubTime) / 100, Integer.valueOf(lateSubTime) % 100));
            lateSubShout.put("TIME", lateSubTime);
            lateSubShout.put("URGENCY", "R");
            lateSubShout.put("WHEN", "LATESUB");
            if (this.m_shouts == null) {
                this.m_shouts = new ArrayList();
            }
            this.m_shouts.add(lateSubShout);
        }
    }

    public String applyFieldConversion(String field) {
        return this.m_rules.getFieldEditor().generateCTMField(field, new FieldEditor.SourceFieldGetter(){

            public String getField(String fieldName) {
                return JobtracJob.this.getSourceAttr(fieldName);
            }
        });
    }

    public String getSourceAttr(String field) {
        String value = this.getSclAttrAsStr(field).trim();
        if (value.isEmpty() && field.equals("LocationID")) {
            value = this.getSclAttrAsStr("@SETLOC").trim();
        }
        return value;
    }

    public String getApplication() {
        return this.m_attributes.get("APPLICATION");
    }

    public List<AssistingJob> getAssistingJobs() {
        return null;
    }

    public String getAttr(String attrName) {
        return this.m_attributes.get(attrName);
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.m_autoedits;
    }

    public List<SchedEntity> getChildren() {
        ArrayList<SchedEntity> toRet = new ArrayList<SchedEntity>();
        LinkedHashMap<Integer, AttrHolderList> attrMap = new LinkedHashMap<Integer, AttrHolderList>();
        if (this.m_type == SchedEntity.TYPE.JOB) {
            return null;
        }
        AttrHolderList allChildrenAttrs = this.m_sourceDefs.getAtrsListByNameValue("SCLmember", this.m_sclAttr.getAttr("FAKE_TABLE_NAME"));
        for (IAttrHolder currAttrs : allChildrenAttrs) {
            int id = currAttrs.getAttrAsInt("JobID");
            if (attrMap.get(id) == null) {
                attrMap.put(id, new AttrHolderList());
            }
            ((AttrHolderList)attrMap.get(id)).add((Object)currAttrs);
        }
        for (Integer currKey : attrMap.keySet()) {
            toRet.add(new JobtracJob((SchedEntity)this, (AttrHolderList)attrMap.get(currKey), this.m_sourceDefs));
        }
        return toRet;
    }

    public List<Properties> getCtrlResources() {
        if (this.m_controlRes == null) {
            return this.m_sourceDefs.getJobControlRes(this);
        }
        List<Properties> list = this.m_sourceDefs.getJobControlRes(this);
        if (null != list) {
            this.m_controlRes.addAll(list);
        }
        return this.m_controlRes;
    }

    public String getGroup() {
        return this.m_attributes.get("GROUP");
    }

    public List<Properties> getInConds() {
        ArrayList<Properties> condsFromDefs = (ArrayList<Properties>)this.m_sourceDefs.getJobInconds(this);
        ArrayList<Properties> tempConds = new ArrayList<Properties>();
        HashSet<CallSite> addedConds = new HashSet<CallSite>();
        for (Properties currCond : condsFromDefs) {
            String testStr = (String)currCond.get("NAME") + (String)currCond.get("ODATE");
            if (addedConds.contains(testStr)) continue;
            tempConds.add(currCond);
            addedConds.add((CallSite)((Object)testStr));
            if (!this.m_sourceDefs.isGlobCond(currCond.getProperty("NAME"))) continue;
            HashMap<String, String> action = new HashMap<String, String>();
            action.put("ACTENTTYPE", "GLOBALCOND");
            action.put("JOBID", this.m_jobName);
            action.put("ACTENTNAME", currCond.getProperty("NAME"));
            action.put("ACTENTQTY", "0");
            action.put("ACTSTATUS", "0");
            Reporter.addAction(action);
        }
        condsFromDefs = tempConds;
        if (this.m_inConds == null) {
            return this.updateConds(condsFromDefs, true);
        }
        this.m_inConds.addAll(condsFromDefs);
        return this.updateConds(this.m_inConds, true);
    }

    List<Properties> updateConds(ArrayList<Properties> origConds, boolean isInconds) {
        for (int i = 0; i < origConds.size(); ++i) {
            String condName = origConds.get(i).getProperty("NAME");
            if (condName.equals(condName.toUpperCase())) continue;
            origConds.get(i).setProperty("NAME", condName.toUpperCase());
        }
        if (!this.isDSJob() || !isInconds) {
            return origConds;
        }
        ArrayList<Properties> dsInConds = new ArrayList<Properties>();
        for (Properties cond : origConds) {
            if (cond.getProperty("ODATE").startsWith("-") || cond.getProperty("ODATE").startsWith("+")) {
                Properties newCond = new Properties();
                newCond.setProperty("NAME", cond.getProperty("NAME"));
                if (cond.getProperty("ODATE").startsWith("-")) {
                    newCond.setProperty("ODATE", "PREV");
                } else if (cond.getProperty("ODATE").startsWith("+")) {
                    newCond.setProperty("ODATE", "NEXT");
                } else {
                    newCond.setProperty("ODATE", cond.getProperty("ODATE"));
                }
                newCond.setProperty("AND_OR", cond.getProperty("AND_OR"));
                dsInConds.add(newCond);
                Reporter.addMessage(this.m_messages, (String)"INF5001", (String)this.m_jobName, (String[])new String[]{cond.toString(), newCond.toString()});
                continue;
            }
            dsInConds.add(cond);
        }
        return dsInConds;
    }

    public String getJobName() {
        return this.m_jobName;
    }

    public ArrayList<String> getMessages() {
        ArrayList<String> fromDefs = this.m_sourceDefs.getJobMessages(this.m_jobName);
        if (this.m_messages == null) {
            return fromDefs;
        }
        if (fromDefs != null) {
            this.m_messages.addAll(fromDefs);
        }
        return this.m_messages;
    }

    public List<Properties> getOnStmt() {
        List<Properties> list;
        Properties sysoutStmt = null;
        if (this.m_onstmt == null) {
            this.m_onstmt = new ArrayList();
        }
        if (this.m_type == SchedEntity.TYPE.JOB) {
            String ccdeStr;
            if (!this.isDSJob()) {
                boolean addCtrStmt = this.m_rules.getBooleanRule("Mainframe", new String[]{"CONTROLRINSTALLED"});
                if (addCtrStmt) {
                    boolean restartFromFail;
                    Properties ctrStmt = new Properties();
                    boolean stcJob = this.m_attributes.get("TASKTYPE").equals("Started_Task");
                    if (!stcJob) {
                        ctrStmt.put("DOIFRERUN", "Y");
                        ctrStmt.put("FPGMS", "$EXERR");
                        ctrStmt.put("CONFIRM", "1");
                    }
                    if ((restartFromFail = this.m_rules.getBooleanRule("Mainframe", new String[]{"AUTORESTARTFROMFAILINGSTEP"}).booleanValue()) && !this.isCyclic()) {
                        ctrStmt.put("ACTION", "RERUN");
                    }
                    if (!ctrStmt.isEmpty()) {
                        ctrStmt.put("PGMS", "ANYSTEP");
                        ctrStmt.put("CODE", "EXERR");
                        this.m_onstmt.add(ctrStmt);
                    }
                }
                String sysoutFrom = this.m_rules.getStringRule("Mainframe", new String[]{"SYSOUTFROMCLASS"});
                String sysoutTo = this.m_rules.getStringRule("Mainframe", new String[]{"SYSOUTTOCLASS"});
                String sysoutOpt = this.m_rules.getStringRule("Mainframe", new String[]{"SYSOUTOPTION"});
                sysoutStmt = new Properties();
                sysoutStmt.put("ACTION", "DOSYSOUT");
                sysoutStmt.put("PGMS", "ANYSTEP");
                sysoutStmt.put("CODE", "*****,****");
                sysoutStmt.put("PAR", sysoutTo);
                sysoutStmt.put("FROM", sysoutFrom);
                if (!sysoutOpt.equals("None")) {
                    sysoutStmt.put("OPTION", sysoutOpt);
                }
            }
            if (!(ccdeStr = this.getSclAttrAsStr("MaximumConditionCode").trim()).isEmpty() && ccdeStr.matches("^-?[0-9]+$")) {
                String opStr;
                String doStr;
                Integer ccdeInt = Integer.valueOf(ccdeStr);
                Integer maxCcInt = 0;
                String maxCcStr = this.m_rules.getStringRule("Mainframe", new String[]{"MAXCC"});
                if (!maxCcStr.isEmpty() && maxCcStr.matches("-?[0-9]+")) {
                    maxCcInt = Integer.valueOf(maxCcStr);
                }
                if (ccdeInt < maxCcInt) {
                    doStr = "NOTOK";
                    opStr = ">";
                } else {
                    doStr = "OK";
                    opStr = "<";
                    Integer n = ccdeInt;
                    ccdeInt = ccdeInt + 1;
                }
                int iMaxPossibleCC = this.isDSJob() ? 9999 : 4096;
                Properties ccdeStmt = new Properties();
                ccdeStmt.put("ACTION", doStr);
                if (this.isDSJob()) {
                    if (opStr.isEmpty()) {
                        opStr = "=";
                    }
                    ccdeStmt.put("CODE", "COMPSTAT " + opStr + " " + ccdeInt);
                    ccdeStmt.put("STMT", "*");
                } else {
                    ccdeStmt.put("PGMS", "ANYSTEP");
                    ccdeStmt.put("CODE", String.format("%sC%04d", opStr, ccdeInt > iMaxPossibleCC ? iMaxPossibleCC : ccdeInt));
                }
                this.m_onstmt.add(ccdeStmt);
            }
        }
        if (null != (list = this.m_sourceDefs.getJobOnstmts(this))) {
            this.m_onstmt.addAll(list);
        }
        Collections.sort(this.m_onstmt, new Comparator<Properties>(this){

            @Override
            public int compare(Properties on1, Properties on2) {
                boolean o1ANY = false;
                boolean o2ANY = false;
                if (on1 != null && on1.get("PGMS") != null) {
                    o1ANY = on1.get("PGMS").equals("ANYSTEP");
                }
                if (on2 != null && on2.get("PGMS") != null) {
                    o2ANY = on2.get("PGMS").equals("ANYSTEP");
                }
                int retval = o1ANY == o2ANY ? 0 : (o1ANY ? -1 : 1);
                return retval;
            }
        });
        if (sysoutStmt != null) {
            this.m_onstmt.add(sysoutStmt);
        }
        return this.m_onstmt;
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        LinkedHashMap onDoMap = null;
        List<Properties> onList = this.getOnStmt();
        if (onList != null && !onList.isEmpty()) {
            onDoMap = new LinkedHashMap();
            for (Properties on : onList) {
                String action;
                ArrayList<Properties> doList = new ArrayList<Properties>();
                Properties doStmt = new Properties();
                doList.add(doStmt);
                if (on.getProperty("DOIFRERUN") != null) {
                    action = "DOIFRERUN";
                    doStmt.setProperty("ACTION", "DOIFRERUN");
                } else {
                    action = on.getProperty("ACTION");
                    doStmt.setProperty("ACTION", action);
                }
                if (action == "DOSYSOUT") {
                    String sysoutOption;
                    doStmt.setProperty("OPTION", "ChangeClass");
                    doStmt.setProperty("PAR", on.getProperty("PAR"));
                    String sysoutFrom = on.getProperty("FROM");
                    if (sysoutFrom != null && !sysoutFrom.isEmpty()) {
                        doStmt.setProperty("FROM", sysoutFrom);
                    }
                    if ((sysoutOption = on.getProperty("OPTION")) != null && !sysoutOption.isEmpty()) {
                        Properties secondDoStmt = new Properties();
                        secondDoStmt.setProperty("ACTION", action);
                        secondDoStmt.setProperty("OPTION", sysoutOption);
                        doList.add(secondDoStmt);
                    }
                } else if (action == "DOIFRERUN") {
                    boolean doRerun;
                    doStmt.setProperty("FPGMS", on.getProperty("FPGMS"));
                    doStmt.setProperty("CONFIRM", on.getProperty("CONFIRM"));
                    boolean bl = doRerun = on.getProperty("ACTION") == "RERUN";
                    if (doRerun) {
                        Properties secondDoStmt = new Properties();
                        secondDoStmt.setProperty("ACTION", "RERUN");
                        doList.add(secondDoStmt);
                    }
                } else {
                    this.setDoProperties(on, doStmt);
                }
                onDoMap.put(on, doList);
            }
        }
        return onDoMap;
    }

    private void setDoProperties(Properties onProp, Properties doProp) {
        String[] propertiesToAdd;
        for (String key : propertiesToAdd = new String[]{"ATTACH_SYSOUT", "DEST", "CC_DEST", "MESSAGE", "SUBJECT", "URGENCY", "NAME", "ODATE", "TABLE_NAME", "VALUE", "SIGN"}) {
            if (!onProp.containsKey(key) || onProp.get(key) == null) continue;
            doProp.setProperty(key, onProp.getProperty(key));
        }
    }

    public List<String> getOptionalAttributes() {
        return this.m_optionalAttributes == null ? null : new ArrayList<String>(this.m_optionalAttributes);
    }

    public String getOriginalJobName() {
        if (this.m_type == SchedEntity.TYPE.JOB) {
            return this.getSclAttrAsStr("EVENTNM");
        }
        return this.m_sclAttr.getAttr("FAKE_TABLE_NAME");
    }

    public List<Properties> getOutConds() {
        ArrayList inConds;
        ArrayList<Properties> condsFromDefs = (ArrayList<Properties>)this.m_sourceDefs.getJobOutconds(this);
        ArrayList<Properties> tempConds = new ArrayList<Properties>();
        HashSet<CallSite> addedConds = new HashSet<CallSite>();
        boolean clearConds = this.m_rules.getBooleanRule("Jobtrac rules", new String[]{"CLEANUPCONDITIONS"});
        boolean bl = clearConds = clearConds && this.m_rules.getStringRule("Jobtrac rules", new String[]{"CONDITION_NAME"}).equals("JOBA_JOBB");
        if (clearConds && (inConds = (ArrayList)this.getInConds()) != null && !inConds.isEmpty()) {
            HashSet inCondsHash = new HashSet(inConds);
            if (this.m_outConds == null) {
                this.m_outConds = new ArrayList();
            }
            for (Properties inCond : inCondsHash) {
                Properties tmpProperties = new Properties();
                tmpProperties.put("NAME", inCond.get("NAME"));
                tmpProperties.put("ODATE", inCond.get("ODATE"));
                tmpProperties.put("SIGN", "DEL");
                if (this.m_outConds.contains(tmpProperties)) continue;
                this.m_outConds.add(tmpProperties);
            }
        }
        for (Properties currCond : condsFromDefs) {
            String testStr = ((String)currCond.get("NAME")).toUpperCase() + (String)currCond.get("ODATE");
            if (addedConds.contains(testStr)) continue;
            tempConds.add(currCond);
            addedConds.add((CallSite)((Object)testStr));
            if (!this.m_sourceDefs.isGlobCond(currCond.getProperty("NAME"))) continue;
            HashMap<String, String> action = new HashMap<String, String>();
            action.put("ACTENTTYPE", "GLOBALCOND");
            action.put("JOBID", this.m_jobName);
            action.put("ACTENTNAME", currCond.getProperty("NAME"));
            action.put("ACTENTQTY", "0");
            action.put("ACTSTATUS", "0");
            Reporter.addAction(action);
        }
        condsFromDefs = tempConds;
        if (this.m_outConds == null) {
            return this.updateConds(condsFromDefs, false);
        }
        for (Properties tmpCond : condsFromDefs) {
            if (this.m_outConds.contains(tmpCond)) continue;
            this.m_outConds.add(tmpCond);
        }
        return this.updateConds(this.m_outConds, false);
    }

    public String getParentName() {
        return this.m_parent == null ? "" : this.m_parent.getJobName();
    }

    public SchedEntity getParent() {
        return this.m_parent;
    }

    public List<Properties> getQuantResources() {
        return this.m_quantRes;
    }

    public List<Properties> getShouts() {
        return this.m_shouts;
    }

    public String getTableName() {
        if (this.m_type == SchedEntity.TYPE.SMART_TABLE) {
            return this.m_sclAttr.getAttr("FAKE_TABLE_NAME");
        }
        return this.m_parent.getJobName();
    }

    public String getTablePathForSons() {
        return null;
    }

    public List<Properties> getTags() {
        return this.m_tags;
    }

    public boolean hasMessages() {
        return this.m_sourceDefs.getJobMessages(this.m_jobName) != null && !this.m_sourceDefs.getJobMessages(this.m_jobName).isEmpty() || this.m_messages != null && this.m_messages.size() > 0;
    }

    public boolean hasWarnings() {
        if (this.m_messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        for (String id : messageIds.keySet()) {
            if (!((MessageId)messageIds.get(id)).getMessageType(id).equals("W")) continue;
            for (String currMessage : this.m_messages) {
                if (!currMessage.startsWith(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCyclic() {
        String cyclic = this.m_attributes.get("CYCLIC");
        if (cyclic == null) {
            return this.m_type == SchedEntity.TYPE.JOB && !this.getSclAttrAsStr("R_Interval").isEmpty();
        }
        return cyclic.equals("1");
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    public String originalProductID() {
        return null;
    }

    public SchedEntity.TYPE type() {
        return this.m_type;
    }

    public String getSclAttrAsStr(String attr) {
        if (this.m_type != SchedEntity.TYPE.JOB) {
            return this.m_sclAttr.isFieldExist(attr) ? this.m_sclAttr.getAttr(attr) : "";
        }
        for (IAttrHolder currAttrs : this.m_fullSclAttributes) {
            if (currAttrs.getAttr(attr).isEmpty()) continue;
            return currAttrs.getAttr(attr);
        }
        return "";
    }

    private LinkedHashSet<String> getSclAttrAsStrList(String attr) {
        LinkedHashSet<String> toRet = new LinkedHashSet<String>();
        for (IAttrHolder currAttrs : this.m_fullSclAttributes) {
            toRet.add(currAttrs.getAttr(attr));
        }
        return toRet;
    }

    public boolean isDSJob() {
        String eventType = this.getSclAttrAsStr("EventType");
        String command = this.getSclAttrAsStr("R_IP");
        String node = this.getSclAttrAsStr("R_NODE");
        return this.m_type == SchedEntity.TYPE.JOB && (eventType.equals("C") || eventType.equals("D") && !command.isEmpty() && !node.isEmpty());
    }

    private void setJobToRunAsDummy() {
        if (this.getSclAttrAsStr("EventType").equals("D")) {
            return;
        }
        if (!Params.instance().getGUIVersion().equals("7")) {
            if (this.m_autoedits == null) {
                this.m_autoedits = new LinkedHashMap();
            }
            if (this.isDSJob()) {
                if (this.m_attributes.containsKey("TASKTYPE")) {
                    this.m_autoedits.put("%%$BMCWAIORIGTYPE", this.m_attributes.get("TASKTYPE"));
                }
            } else {
                if (this.m_attributes.containsKey("OVERLIB")) {
                    this.m_autoedits.put("%%$BMCWAIORIGTYPE", this.m_attributes.get("OVERLIB"));
                }
                if (this.m_attributes.containsKey("USE_INSTREAM_JCL")) {
                    this.m_autoedits.put("%%$BMCWAIORIGUSEISJCL", this.m_attributes.get("USE_INSTREAM_JCL"));
                }
                if (this.m_attributes.get("TASKTYPE").equals("Started_Task")) {
                    this.m_autoedits.put("%%$BMCWAIORIGUSEISSTC", "Y");
                }
            }
        }
        if (this.isDSJob()) {
            this.m_attributes.put("TASKTYPE", "Dummy");
        } else {
            this.setOptionalAttribute("OVERLIB", "DUMMY");
            this.m_attributes.put("USE_INSTREAM_JCL", "N");
            if (this.m_attributes.get("TASKTYPE").equals("Started_Task")) {
                this.m_attributes.put("TASKTYPE", "Job");
            }
        }
    }

    private void setJobToDS() {
        String nodeId = this.getSclAttrAsStr("R_NODE").trim();
        if (nodeId.startsWith("NODE=")) {
            nodeId = nodeId.substring("NODE=".length());
        }
        StringBuilder cmdline = new StringBuilder();
        for (String string : this.getSclAttrAsStrList("R_IP")) {
            cmdline.append(string);
            if (cmdline.toString().startsWith("IP=")) {
                cmdline.delete(0, 3);
            }
            if (string.isEmpty() || string.length() >= (string.startsWith("IP=") ? 33 : 32)) continue;
            cmdline.append(' ');
        }
        StringBuilder extras = new StringBuilder();
        for (String partial : this.getSclAttrAsStrList("R_EnvironmentalDependenciesList")) {
            extras.append(partial.trim());
            if (!extras.toString().startsWith("DS=")) continue;
            extras.delete(0, 3);
        }
        String string = extras.toString().trim();
        if (string.matches("[^/]+/[0-9]+/[0-9]+/.+")) {
            String[] extrArr = string.split("/", 4);
            String varName = extrArr[0];
            Integer retry = 0;
            if (!extrArr[1].isEmpty()) {
                retry = Integer.valueOf(extrArr[1]);
            }
            Integer interval = 0;
            if (!extrArr[2].isEmpty()) {
                interval = this.hhmm2numOfMinutes(extrArr[2]);
            }
            String varVal = extrArr[3];
            if (retry > 0) {
                Properties tmpStmt = new Properties();
                if (interval > 0) {
                    this.m_attributes.put("CYCLIC", "1");
                    this.m_attributes.put("CYCLIC_TYPE", "Interval");
                    this.m_attributes.put("INTERVAL", interval.toString());
                    this.m_attributes.put("IND_CYCLIC", "END");
                    tmpStmt.setProperty("CODE", "OK");
                    tmpStmt.setProperty("STMT", "*");
                    tmpStmt.setProperty("ACTION", "SPCYC");
                } else {
                    tmpStmt.setProperty("CODE", "NOTOK");
                    tmpStmt.setProperty("STMT", "*");
                    tmpStmt.setProperty("ACTION", "RERUN");
                }
                this.m_attributes.put("MAXRERUN", retry.toString());
                if (this.m_onstmt == null) {
                    this.m_onstmt = new ArrayList();
                }
                this.m_onstmt.add(tmpStmt);
            }
            if (this.m_autoedits == null) {
                this.m_autoedits = new LinkedHashMap();
            }
            this.m_autoedits.put("%%" + varName, varVal);
        }
        String command = cmdline.toString().trim();
        RulesDataSet rules = RuleManager.instance().getCurrentRules();
        boolean convertToCmdline = rules.getTaskTypeHandler().isToCommandType();
        if (!convertToCmdline) {
            if (command.contains(";")) {
                StringBuilder embeddedScript = new StringBuilder();
                String[] commandsArray = command.split("\\s*;\\s*");
                for (int i = 0; i < commandsArray.length; ++i) {
                    embeddedScript.append(commandsArray[i]).append("\n");
                }
                this.m_attributes.put("TASKTYPE", "Job");
                this.m_attributes.put("MEMNAME", this.getJobName());
                this.m_attributes.put("USE_INSTREAM_JCL", "Y");
                this.setOptionalAttribute("INSTREAM_JCL", embeddedScript.toString());
            } else {
                convertToCmdline = true;
                for (String taskTypeFilter : rules.getTaskTypeHandler().getTaskTypeFilters()) {
                    convertToCmdline = convertToCmdline && !command.contains(taskTypeFilter);
                }
                if (!convertToCmdline) {
                    ArrayList cmdArgs = GlobalFunctions.cmdline2ArgArr((String)command, (boolean)true);
                    boolean bl = convertToCmdline = cmdArgs == null;
                    if (!convertToCmdline) {
                        this.m_attributes.put("TASKTYPE", "Job");
                        this.m_attributes.put("MEMLIB", (String)cmdArgs.get(0));
                        this.m_attributes.put("MEMNAME", (String)cmdArgs.get(1));
                        if (this.m_autoedits == null) {
                            this.m_autoedits = new LinkedHashMap();
                        }
                        for (int i = 2; i < cmdArgs.size(); ++i) {
                            this.m_autoedits.put(String.format("%%%%PARM%d", i - 1), (String)cmdArgs.get(i));
                        }
                    }
                }
            }
        }
        if (convertToCmdline) {
            this.m_attributes.put("TASKTYPE", "Command");
            this.m_attributes.put("CMDLINE", command);
            this.m_attributes.put("MEMNAME", this.getJobName());
        }
        if (this.getSclAttrAsStr("EventType").equals("D")) {
            if (!Params.instance().getGUIVersion().equals("7")) {
                if (this.m_autoedits == null) {
                    this.m_autoedits = new LinkedHashMap();
                }
                this.m_autoedits.put("%%$BMCWAIORIGTYPE", this.m_attributes.get("TASKTYPE"));
            }
            this.m_attributes.put("TASKTYPE", "Dummy");
        }
        this.m_attributes.put("NODEID", nodeId);
        this.setOptionalAttributeToMandatory("ACTIVE_FROM", "");
        this.setOptionalAttributeToMandatory("ACTIVE_TILL", "");
    }

    private void setOptionalAttributeToMandatory(String attribute, String defaultValue) {
        if (!this.m_optionalAttributes.remove(attribute)) {
            this.m_attributes.put(attribute, defaultValue);
        }
    }

    private void createTableTags() {
        this.m_tags.add(this.createTagFromDates(null, "ALL"));
        HashMap<String, ArrayList<String>> cals = this.m_sourceDefs.getCals(this.m_sclAttr.getAttr("FAKE_TABLE_FULL_NAME"));
        if (cals != null) {
            for (String currCal : cals.keySet()) {
                this.m_tags.add(this.createTagFromDates(cals.get(currCal), currCal));
            }
        }
    }

    private Properties createTagFromDates(ArrayList<String> dates, String name) {
        String flagVal;
        Properties toRet = new Properties();
        if (name.equals("ALL") || dates == null || dates.isEmpty()) {
            toRet.put("WEEKDAYS", "ALL");
            toRet.put("DAYS", "ALL");
            flagVal = "1";
        } else {
            Object dateStr = "";
            for (String currdate : dates) {
                dateStr = (String)dateStr + currdate;
            }
            toRet.put("DATE", dateStr);
            flagVal = "0";
        }
        toRet.put("JAN", flagVal);
        toRet.put("FEB", flagVal);
        toRet.put("MAR", flagVal);
        toRet.put("APR", flagVal);
        toRet.put("MAY", flagVal);
        toRet.put("JUN", flagVal);
        toRet.put("JUL", flagVal);
        toRet.put("AUG", flagVal);
        toRet.put("SEP", flagVal);
        toRet.put("OCT", flagVal);
        toRet.put("NOV", flagVal);
        toRet.put("DEC", flagVal);
        toRet.put("DAYS_AND_OR", "OR");
        toRet.put("LEVEL", "TABLE");
        toRet.put("MAXWAIT", "00");
        toRet.put("NAME", name);
        toRet.put("RETRO", "0");
        toRet.put("SHIFT", "IGNOREJOB");
        toRet.put("SHIFTNUM", "+00");
        return toRet;
    }

    private void setSchedDefs() {
        schedulingCriteria jobSc = new schedulingCriteria();
        this.handleHolidayAction();
        this.handleDates(jobSc);
        this.handleProcessPeriod(jobSc);
        this.addCalendarActions();
        if (this.m_attributes.containsKey("DAYS_AND_OR") && this.m_attributes.get("DAYS_AND_OR").equals("AND") && (!this.m_attributes.containsKey("WEEKDAYS") || this.m_attributes.get("WEEKDAYS").isEmpty() || !this.m_attributes.containsKey("DAYS") || this.m_attributes.get("DAYS").isEmpty())) {
            this.m_attributes.put("DAYS_AND_OR", "OR");
        }
    }

    private void addCalendarActions() {
        String[] possibleCalendars = new String[]{"DAYSCAL", "WEEKSCAL", "CONFCAL"};
        for (int i = 0; i < possibleCalendars.length; ++i) {
            if (!this.m_attributes.containsKey(possibleCalendars[i])) continue;
            HashMap<String, String> action = new HashMap<String, String>();
            action.put("ACTENTTYPE", "CAL");
            action.put("JOBID", this.m_jobName);
            action.put("ACTENTNAME", this.m_attributes.get(possibleCalendars[i]));
            action.put("ACTENTQTY", "0");
            action.put("ACTSTATUS", "0");
            Reporter.addAction(action);
        }
    }

    private void handleProcessPeriod(schedulingCriteria jobSc) {
        String prevOperator = "";
        boolean wasMonthDefined = false;
        for (int pi = 0; pi < this.m_fullSclAttributes.size(); ++pi) {
            String locId;
            schedulingCriteria sc = new schedulingCriteria();
            String operator = ((IAttrHolder)this.m_fullSclAttributes.get(pi)).getAttr("ConditionalOperator").trim();
            String origRawProcP = ((IAttrHolder)this.m_fullSclAttributes.get(pi)).getAttr("ProcessPeriod").trim();
            char[] weekDayCharArr = new char[]{'M', 'T', 'W', 'T', 'F', 'S', 'S'};
            String shortWeekDaysExpr = "(MON|TUE|WED|THU|FRI|SAT|SUN)";
            String longWeekDaysExpr = "(MON|TUES|WEDNES|THURS|FRI|SATUR|SUN)DAY";
            wasMonthDefined = false;
            Object cycCal = this.getSclAttrAsStr("@CYC").trim();
            if (((String)(cycCal = ((String)cycCal).replace("(OVR)", ""))).length() <= 5) {
                cycCal = "CYC" + (String)cycCal;
            }
            if ((locId = this.getSclAttrAsStr("LocationID")).trim().isEmpty()) {
                locId = this.getSclAttrAsStr("@SETLOC");
            }
            String workdCal = "WORKD" + locId;
            String rawProcP = origRawProcP.startsWith("=") ? origRawProcP.substring(1) : origRawProcP;
            boolean isWeekDaysField = false;
            for (int i = 0; i < (weekDayCharArr.length > rawProcP.trim().length() ? rawProcP.trim().length() : weekDayCharArr.length) && (rawProcP.trim().charAt(i) == weekDayCharArr[i] || rawProcP.trim().charAt(i) == '.'); ++i) {
                if (i != rawProcP.trim().length() - 1) continue;
                isWeekDaysField = true;
            }
            if (rawProcP.equals("DAILY")) {
                String[] monthsArr = GlobalFunctions.getMonthsArray();
                for (int i2 = 1; i2 <= monthsArr.length; ++i2) {
                    sc.set_month(i2, true);
                }
                sc.set_days("daysN", 1, 31, true);
                wasMonthDefined = true;
            } else if (isWeekDaysField) {
                Integer i = 0;
                while (i < rawProcP.trim().length()) {
                    if (rawProcP.charAt(i) != '.') {
                        sc.set_wDays("wDaysN", (i + 1) % 7, true);
                    }
                    Integer i2 = i;
                    i = i + 1;
                }
            } else if (rawProcP.matches("(MON|TUES|WEDNES|THURS|FRI|SATUR|SUN)DAY")) {
                String[] daysArr = GlobalFunctions.getWeekDaysArray((String)"SUN");
                Integer i = 0;
                while (i < daysArr.length) {
                    if (rawProcP.startsWith(daysArr[i])) {
                        sc.set_wDays("wDaysN", i, true);
                        break;
                    }
                    Integer n = i;
                    i = i + 1;
                }
            } else if (rawProcP.matches("(MON|TUE|WED|THU|FRI|SAT|SUN)#[0-5]{1,2}")) {
                String[] tmpArr = rawProcP.split("#");
                String day = tmpArr[0];
                int week = Integer.valueOf(tmpArr[1]);
                Integer dayInt = GlobalFunctions.getDayOfTheWeekIndex((String[])GlobalFunctions.getWeekDaysArray((String)"SUN"), (String)day);
                sc.set_monthWeekDays(dayInt, week);
            } else if (rawProcP.matches("(MON|TUE|WED|THU|FRI|SAT|SUN)#LAST")) {
                String[] tmpArr = rawProcP.split("#");
                String day = tmpArr[0];
                Integer dayInt = GlobalFunctions.getDayOfTheWeekIndex((String[])GlobalFunctions.getWeekDaysArray((String)"SUN"), (String)day);
                sc.set_days("daysLn", 1, 7, true);
                if (prevOperator.startsWith("X")) {
                    if (!jobSc.valWdaysVal(dayInt)) {
                        Reporter.addMessage(this.m_messages, (String)"WRN5012", (String)this.m_jobName, (String[])new String[]{rawProcP, prevOperator});
                    }
                    jobSc.wDaysSet = true;
                    sc.wDaysSet = true;
                } else {
                    sc.set_wDays("wDaysN", dayInt, true);
                }
                sc.set_relation("AND");
            } else if (rawProcP.matches("(MON|TUE|WED|THU|FRI|SAT|SUN)M[0-5]{1,2}")) {
                String day = rawProcP.substring(0, 3);
                Integer dayInt = GlobalFunctions.getDayOfTheWeekIndex((String[])GlobalFunctions.getWeekDaysArray((String)"SUN"), (String)day);
                int week = Integer.valueOf(rawProcP.substring(4).trim());
                sc.set_wDays("wDaysN", dayInt, true);
                if (week == 1) {
                    sc.set_days("daysLn", 1, 7, true);
                }
                if (week == 2) {
                    sc.set_days("daysLn", 8, 14, true);
                }
                if (week == 3) {
                    sc.set_days("daysLn", 15, 21, true);
                }
                if (week == 4) {
                    sc.set_days("daysLn", 22, 28, true);
                }
                if (week == 5) {
                    sc.set_days("daysLn", 29, 31, true);
                }
                sc.set_relation("AND");
            } else if (rawProcP.matches("X(MON|TUE|WED|THU|FRI|SAT|SUN)#LAST")) {
                String day = rawProcP.substring(1, 4);
                Integer dayInt = GlobalFunctions.getDayOfTheWeekIndex((String[])GlobalFunctions.getWeekDaysArray((String)"SUN"), (String)day);
                sc.set_wDays("wDaysN", dayInt, true);
                sc.set_days("daysxLn", 1, 7, true);
                sc.set_relation("AND");
                if (!operator.trim().isEmpty()) {
                    operator = "";
                    Reporter.addMessage(this.m_messages, (String)"WRN5022", (String)this.m_jobName, (String[])new String[]{rawProcP});
                }
            } else if (rawProcP.matches("X(MON|TUE|WED|THU|FRI|SAT|SUN)#[0-5]{1,2}")) {
                String day = rawProcP.substring(1, 4);
                Integer dayInt = GlobalFunctions.getDayOfTheWeekIndex((String[])GlobalFunctions.getWeekDaysArray((String)"SUN"), (String)day);
                int week = Integer.valueOf(rawProcP.substring(5).trim());
                for (int i = 1; i < 6; ++i) {
                    if (i == week) continue;
                    sc.set_monthWeekDays(dayInt, i);
                }
            } else if (rawProcP.equals("EOY")) {
                sc.set_dates(31, 12);
                wasMonthDefined = true;
                sc.set_confcal(workdCal);
                sc.set_shift("PREVDAY");
            } else if (rawProcP.equals("EOM")) {
                sc.set_days("daysLn", 1, 1, true);
                sc.set_dcal(workdCal);
            } else if (rawProcP.equals("XEOM")) {
                sc.set_days("daysxLn", 1, 1, true);
                sc.set_dcal(workdCal);
            } else if (rawProcP.equals("FOM")) {
                sc.set_days("daysDn", 1, 1, true);
                sc.set_dcal(workdCal);
            } else if (rawProcP.equals("LASTDAY")) {
                sc.set_days("daysLn", 1, 1, true);
            } else if (rawProcP.equals("WORKDAYS")) {
                sc.set_dcal(workdCal);
            } else if (rawProcP.matches("WORKDAYM[0-3][0-9]")) {
                sc.set_dcal(workdCal);
                String num = rawProcP.split("M")[1];
                sc.set_days("daysLn", Integer.parseInt(num), Integer.parseInt(num), true);
            } else if (rawProcP.matches("WORKDAY#[0-3][0-9]")) {
                String[] tmpArr = rawProcP.split("#");
                String days = tmpArr[1];
                sc.set_dcal(workdCal);
                sc.set_days("daysDn", Integer.parseInt(days), Integer.parseInt(days), true);
            } else if (rawProcP.matches("WORKDAYX[0-3][0-9]")) {
                String[] tmpArr = rawProcP.split("X");
                String days = tmpArr[1];
                sc.set_dcal(workdCal);
                sc.set_days("daysxDn", Integer.parseInt(days), Integer.parseInt(days), true);
            } else if (rawProcP.matches("WORKDAY>[0-3][0-9]")) {
                String[] tmpArr = rawProcP.split(">");
                String days = tmpArr[1];
                sc.set_dcal(workdCal);
                sc.set_days("daysDn", Integer.parseInt(days) + 1, 31, true);
            } else if (rawProcP.matches("WORKDAY<[0-3][0-9]")) {
                String[] tmpArr = rawProcP.split("<");
                String days = tmpArr[1];
                sc.set_dcal(workdCal);
                sc.set_days("daysDn", 1, Integer.parseInt(days) - 1, true);
            } else if (rawProcP.matches("QTR[1-4]")) {
                String qtrString = rawProcP.substring(3);
                Integer qtrInt = Integer.valueOf(qtrString);
                String[] monthsArr = GlobalFunctions.getMonthsArray();
                wasMonthDefined = true;
                sc.set_dcal(workdCal);
                sc.set_days("daysDn", 1, 1, true);
                for (int i = 0; i < monthsArr.length; ++i) {
                    sc.set_month(i + 1, i + 1 == (qtrInt - 1) * 3 + 1);
                }
            } else if (rawProcP.matches("QTR[1-4]A")) {
                Integer qtrInt = Integer.valueOf(rawProcP.substring(3, 4));
                String[] monthsArr = GlobalFunctions.getMonthsArray();
                wasMonthDefined = true;
                sc.set_dcal("ALLDAYS");
                for (int i = 0; i < monthsArr.length; ++i) {
                    sc.set_month(i + 1, i + 1 >= (qtrInt - 1) * 3 + 1 && i + 1 < qtrInt * 3 + 1);
                }
            } else if (rawProcP.matches("([0-9]{2}|\\*{2})/([0-9]{2}|\\*{2})/([0-9]{2}|\\*{2})")) {
                String[] tmpArr = rawProcP.split("/");
                String month = tmpArr[0];
                String day = tmpArr[1];
                String year = tmpArr[2];
                String dateFormat = this.getSclAttrAsStr("@DATEFORM");
                dateFormat = dateFormat.trim().isEmpty() ? this.m_rules.getStringRule("Jobtrac rules", new String[]{"DATE_FORMAT"}) : (dateFormat.equalsIgnoreCase("I") ? "ddmm" : "mmdd");
                if (dateFormat.equals("ddmm")) {
                    String tmp = day;
                    day = month;
                    month = tmp;
                }
                if (!this.isValidDate(day, month, year)) {
                    Reporter.addMessage(this.m_messages, (String)"WRN0006", (String)this.m_jobName, (String[])new String[]{"JOBTRAC", "ProcessPeriod", rawProcP, "DATE"});
                } else if (this.isRelevantDate(day, month, year)) {
                    if (!month.matches("\\*{2}") && !day.matches("\\*{2}")) {
                        sc.set_dates(Integer.parseInt(day), Integer.parseInt(month));
                        wasMonthDefined = true;
                    } else {
                        if ((day = day.replaceAll("^0", "")).matches("\\*+")) {
                            sc.set_dcal("ALLDAYS");
                        } else {
                            sc.set_days("daysN", Integer.parseInt(day), Integer.parseInt(day), true);
                        }
                        String[] monthsArr = GlobalFunctions.getMonthsArray();
                        for (int i = 0; i < monthsArr.length; ++i) {
                            if (month.matches("\\*+") || Integer.valueOf(month) == i + 1) {
                                sc.set_month(i + 1, true);
                                continue;
                            }
                            sc.set_month(i + 1, false);
                        }
                        wasMonthDefined = true;
                    }
                    if (!year.matches("\\*{2}")) {
                        this.setOptionalAttribute("ACTIVE_FROM", (Integer.valueOf(year) < 50 ? "20" : "19") + year + "0101");
                        this.setOptionalAttribute("ACTIVE_TILL", (Integer.valueOf(year) < 50 ? "20" : "19") + year + "1231");
                    }
                }
            } else if (rawProcP.matches("WEEKDAY#[1-7]")) {
                sc.set_wDays("wDaysDn", Integer.parseInt(rawProcP.substring(8).trim()) % 7, true);
                sc.set_wcal(workdCal);
            } else if (rawProcP.matches("WEEKDAYX[1-7]")) {
                sc.set_wDays("wDaysxDn", Integer.parseInt(rawProcP.substring(8).trim()) % 7, true);
                sc.set_wcal(workdCal);
            } else if (rawProcP.length() > 8 && rawProcP.substring(0, 9).equals("WEEKDAY#L")) {
                sc.set_wDays("wDaysLn", 1, true);
                sc.set_wcal(workdCal);
            } else if (rawProcP.matches("EV[1-6](MON|TUE|WED|THU|FRI|SAT|SUN)\\([1-4]\\)")) {
                String day = rawProcP.substring(3, 6);
                Integer dayInt = GlobalFunctions.getDayOfTheWeekIndex((String[])GlobalFunctions.getWeekDaysArray((String)"SUN"), (String)day);
                int week = Integer.valueOf(rawProcP.substring(7, 8));
                sc.set_monthWeekDays(dayInt, week);
                this.setToCyclicForEVndayPP();
                this.setOptionalAttribute("MAXWAIT", "99");
                String[] monthsArr = GlobalFunctions.getMonthsArray();
                sc.set_month(1, true);
                for (int i = 1; i < monthsArr.length; ++i) {
                    sc.set_month(i + 1, false);
                }
                wasMonthDefined = true;
            } else if (rawProcP.equals("CYCLAST")) {
                sc.set_periodDaysMonth("1", "*", "L", "");
                sc.set_dcal((String)cycCal);
            } else if (rawProcP.matches("CYCDAYM[0-9]{1,3}")) {
                String days = rawProcP.substring("CYCDAYM".length()).trim();
                if (Integer.valueOf(days) > 63) {
                    Reporter.addMessage(this.m_messages, (String)"WRN5031", (String)this.m_jobName, (String[])new String[]{this.m_jobName, this.m_jobName, days});
                    days = "63";
                }
                while (days.startsWith("0")) {
                    days = days.substring(1);
                }
                sc.set_periodDaysMonth(days, "*", "L", "");
                sc.set_dcal((String)cycCal);
            } else if (rawProcP.matches("CYCDAY#[0-9]{1,3}")) {
                String days = rawProcP.substring("CYCDAY#".length()).trim();
                if (Integer.valueOf(days) > 63) {
                    Reporter.addMessage(this.m_messages, (String)"WRN5031", (String)this.m_jobName, (String[])new String[]{this.m_jobName, this.m_jobName, days});
                    days = "63";
                }
                while (days.startsWith("0")) {
                    days = days.substring(1);
                }
                sc.set_periodDaysMonth(days, "*", "D", "");
                sc.set_dcal((String)cycCal);
            } else if (rawProcP.matches("CYCDAYX[0-9]{1,3}")) {
                String days = rawProcP.substring("CYCDAYX".length()).trim();
                if (Integer.valueOf(days) > 63) {
                    Reporter.addMessage(this.m_messages, (String)"WRN5031", (String)this.m_jobName, (String[])new String[]{this.m_jobName, this.m_jobName, days});
                    days = "63";
                }
                while (days.startsWith("0")) {
                    days = days.substring(1);
                }
                sc.set_periodDaysMonth(days, "*", "D", "-");
                sc.set_dcal((String)cycCal);
            } else if (rawProcP.matches("CYCLE[0-9]{1,2}")) {
                Integer cycleInt = Integer.valueOf(rawProcP.substring("CYCLE".length()).trim());
                sc.set_periodDaysMonth("*", Integer.toString(cycleInt, 16).toUpperCase(), "D", "");
                sc.set_dcal((String)cycCal);
            } else if (rawProcP.matches("UDEF[0-9A-Z#@$]{1}")) {
                sc.set_rbc(rawProcP.trim());
            } else if (!jobSc.isDateSched() || !rawProcP.isEmpty()) {
                if (jobSc.isDateSched() && !rawProcP.isEmpty() && this.m_fullSclAttributes.size() > 1) {
                    sc.setDateSched(true);
                } else {
                    sc.set_dcal(rawProcP);
                    Reporter.addMessage(this.m_messages, (String)"INF5003", (String)this.m_jobName, (String[])new String[]{this.m_jobName, rawProcP});
                }
            }
            if (jobSc.isDateSched() && !rawProcP.isEmpty()) {
                if (this.m_fullSclAttributes.size() == 1) {
                    sc.daysSet = true;
                    sc.set_relation("AND");
                } else {
                    sc.setDateSched(true);
                }
            }
            if (!wasMonthDefined) {
                int i;
                String[] monthsArr = GlobalFunctions.getMonthsArray();
                boolean hasMonth = false;
                for (i = 1; i <= monthsArr.length; ++i) {
                    if (!jobSc.getMonth(i)) continue;
                    hasMonth = true;
                }
                if (!hasMonth || prevOperator.startsWith("+")) {
                    for (i = 1; i <= monthsArr.length; ++i) {
                        sc.set_month(i, true);
                    }
                }
                wasMonthDefined = true;
            }
            if (!jobSc.merge(sc, prevOperator)) {
                Reporter.addMessage(this.m_messages, (String)"WRN5012", (String)this.m_jobName, (String[])new String[]{rawProcP, prevOperator});
            }
            prevOperator = prevOperator.startsWith("+") && operator.equals("/") ? "+/" : operator;
            if (operator.trim().isEmpty()) break;
        }
    }

    private void handleDates(schedulingCriteria jobSc) {
        ArrayList<String> rawValues = new ArrayList<String>();
        for (int i = 0; i < this.m_fullSclAttributes.size(); ++i) {
            rawValues.add(((IAttrHolder)this.m_fullSclAttributes.get(i)).getAttr("Date"));
        }
        String dateFormat = this.m_rules.getStringRule("Jobtrac rules", new String[]{"DATE_FORMAT"});
        boolean tagAllAdded = false;
        schedulingCriteria sc = new schedulingCriteria();
        for (int i = 0; i < rawValues.size(); ++i) {
            String currRawDate = (String)rawValues.get(i);
            if (currRawDate.equals("*")) continue;
            if (currRawDate.equals("ASAP")) {
                if (tagAllAdded) continue;
                tagAllAdded = true;
                this.m_tags.add(this.createTagFromDates(null, "ALL"));
                continue;
            }
            if (currRawDate.startsWith("*+")) {
                String offset = currRawDate.substring(2);
                if (!offset.matches("[0-9]{1,2}")) continue;
                this.setOptionalAttribute("FROM_DAYSOFFSET", offset);
                continue;
            }
            if (currRawDate.startsWith("*-") || currRawDate.length() != 4 || !currRawDate.matches("[0-9\\*]+")) continue;
            String day = currRawDate.substring(2, 4);
            String month = currRawDate.substring(0, 2);
            if (dateFormat.equals("ddmm")) {
                String tmp = day;
                day = month;
                month = tmp;
            }
            if (!this.isValidDate(day, month, "*")) {
                Reporter.addMessage(this.m_messages, (String)"WRN0006", (String)this.m_jobName, (String[])new String[]{"JOBTRAC", "Date", currRawDate, "DATE"});
                continue;
            }
            if (!day.equals("**") && !month.equals("**")) {
                sc.set_dates(Integer.parseInt(day), Integer.parseInt(month));
            } else {
                if (day.equals("**")) {
                    sc.set_dcal("ALLDAYS");
                } else {
                    sc.set_days("daysN", Integer.parseInt(day), Integer.parseInt(day), true);
                }
                String[] monthsArr = GlobalFunctions.getMonthsArray();
                for (int j = 0; j < monthsArr.length; ++j) {
                    if (month.equals("**") || Integer.valueOf(month) == j + 1) {
                        sc.set_month(j + 1, true);
                        continue;
                    }
                    sc.set_month(j + 1, false);
                }
            }
            sc.setDateSched(true);
            String prevOperator = " ";
            jobSc.merge(sc, prevOperator);
        }
    }

    private void setOptionalAttribute(String name, String value) {
        if (this.m_optionalAttributes == null) {
            this.m_optionalAttributes = new HashSet();
        }
        this.m_optionalAttributes.add(name);
        this.m_attributes.put(name, value);
    }

    private void removeOptionalAttribute(String name) {
        if (this.m_optionalAttributes != null) {
            this.m_optionalAttributes.remove(name);
        }
        this.m_attributes.remove(name);
    }

    private void readResources() {
        LinkedHashSet<String> usedRes;
        Properties toAdd;
        ArrayList<String> mappedRes = this.m_sourceDefs.getMappedNoJob(this.getOriginalJobName());
        if (mappedRes != null) {
            for (String currRes : mappedRes) {
                if (this.m_controlRes == null) {
                    this.m_controlRes = new ArrayList();
                }
                toAdd = new Properties();
                toAdd.put("NAME", currRes + "_" + this.getOriginalJobName());
                toAdd.put("TYPE", "E");
                toAdd.put("ONFAIL", "R");
                this.m_controlRes.add(toAdd);
            }
        }
        if ((mappedRes = this.m_sourceDefs.getMappedJobRes(this.getOriginalJobName())) != null) {
            for (String currRes : mappedRes) {
                if (this.m_outConds == null) {
                    this.m_outConds = new ArrayList();
                }
                toAdd = new Properties();
                toAdd.put("NAME", currRes + "_" + this.getOriginalJobName());
                toAdd.put("ODATE", "ODAT");
                toAdd.put("SIGN", "DEL");
                this.m_outConds.add(toAdd);
            }
        }
        if (!(usedRes = this.getSclAttrAsStrList("R_ResourceList")).isEmpty()) {
            for (String rawRes : usedRes) {
                if (rawRes.isEmpty()) continue;
                rawRes = rawRes.substring(1);
                Pattern pattern = Pattern.compile("(.)(.*)");
                Matcher matcher = pattern.matcher(rawRes);
                while (matcher.matches()) {
                    String currRes = matcher.group(1);
                    rawRes = matcher.group(2);
                    matcher = pattern.matcher(rawRes);
                    Properties resProps = this.m_sourceDefs.getResEntryByName(currRes);
                    this.processResourceEntry(resProps, currRes);
                }
            }
        }
        if (!(usedRes = this.getSclAttrAsStrList("R_ResourceList2")).isEmpty()) {
            for (String rawRes : usedRes) {
                if (rawRes.isEmpty()) continue;
                rawRes = rawRes.substring(3);
                String[] resList = rawRes.split(",");
                for (int i = 0; i < resList.length; ++i) {
                    Properties resProps = this.m_sourceDefs.getResEntryByName(resList[i]);
                    this.processResourceEntry(resProps, resList[i]);
                }
            }
        }
    }

    private void processResourceEntry(Properties resProps, String resName) {
        if (resName == null || resProps == null) {
            return;
        }
        String rule = (String)resProps.get("RES_KEY_RULE_TYPE");
        if (rule.equals("JOB")) {
            if (this.m_inConds == null) {
                this.m_inConds = new ArrayList();
            }
            Properties newCond = new Properties();
            newCond.put("NAME", resName + "_" + String.valueOf(resProps.get("RES_KEY_EVENT_NAME")));
            newCond.put("AND_OR", "AND");
            newCond.put("ODATE", "ODAT");
            this.m_inConds.add(newCond);
            return;
        }
        if (rule.equals("NOJOB") && !resProps.getProperty("RES_KEY_EVENT_NAME").equals(this.getOriginalJobName())) {
            Properties ctrlRes = new Properties();
            ctrlRes.put("NAME", resName + "_" + resProps.getProperty("RES_KEY_EVENT_NAME"));
            ctrlRes.put("TYPE", "S");
            ctrlRes.put("ONFAIL", "R");
            if (this.m_controlRes == null) {
                this.m_controlRes = new ArrayList();
            }
            this.m_controlRes.add(ctrlRes);
            return;
        }
        if (rule.startsWith("GENERIC")) {
            Properties quantRes = new Properties();
            quantRes.put("NAME", resName + "_GENERIC");
            quantRes.put("QUANT", "1");
            if (this.m_quantRes == null) {
                this.m_quantRes = new ArrayList();
            }
            this.m_quantRes.add(quantRes);
            this.addQRAction(quantRes);
            return;
        }
        Reporter.addMessage(this.m_messages, (String)"WRN0005", (String)this.m_jobName, (String[])new String[]{this.m_jobName, this.m_jobName, "RESOURCE RULE with TYPE=" + String.valueOf(resProps.get("RES_KEY_RULE_TYPE"))});
        String action = (String)resProps.get("RES_KEY_OPERATION_TYPE");
        action.trim();
        if (action.equals("PURGE") || action.equals("CANCEL")) {
            Reporter.addMessage(this.m_messages, (String)"WRN0005", (String)this.m_jobName, (String[])new String[]{this.m_jobName, this.m_jobName, "RESOURCE OPERATION=" + action});
        }
    }

    private void addQRAction(Properties quantRes) {
        String name = quantRes.getProperty("NAME");
        String quantity = quantRes.getProperty("QUANT");
        HashMap<String, String> quantAction = new HashMap<String, String>();
        quantAction.put("ACTENTTYPE", "QR");
        quantAction.put("JOBID", this.m_jobName);
        quantAction.put("ACTENTNAME", name);
        quantAction.put("ACTENTQTY", quantity);
        quantAction.put("ACTSTATUS", "0");
        Reporter.addAction(quantAction);
    }

    private void setToCyclicForEVndayPP() {
        if (this.m_attributes.containsKey("CYCLIC") && this.m_attributes.get("CYCLIC").equals("1")) {
            return;
        }
        this.m_attributes.put("CYCLIC", "1");
        this.m_attributes.put("CYCLIC_TYPE", "Interval");
        this.m_attributes.put("IND_CYCLIC", "END");
    }

    private void setToCyclic() {
        if (this.m_attributes.containsKey("CYCLIC") && this.m_attributes.get("CYCLIC").equals("1")) {
            return;
        }
        String rawIinterval = this.getSclAttrAsStr("R_Interval").trim();
        String string = rawIinterval = rawIinterval.startsWith("=") ? rawIinterval.substring(1) : rawIinterval;
        if (!rawIinterval.matches("[0-9]+(/[0-9]*(/[SAE])?)?")) {
            Reporter.addMessage(this.m_messages, (String)"WRN0005", (String)this.m_jobName, (String[])new String[]{this.m_jobName, this.m_jobName, "REFERBACK I=" + rawIinterval});
            this.m_attributes.put("CYCLIC", "0");
            return;
        }
        String[] intervalFields = rawIinterval.split("/");
        if (intervalFields.length >= 1) {
            this.m_attributes.put("CYCLIC", "1");
            this.m_attributes.put("CYCLIC_TYPE", "Interval");
            this.m_attributes.put("INTERVAL", this.hhmm2numOfMinutes(intervalFields[0]).toString());
            this.m_attributes.put("IND_CYCLIC", "END");
        }
        if (intervalFields.length >= 2 && !intervalFields[1].isEmpty()) {
            String timeTo = this.m_attributes.get("TIMETO");
            if (timeTo != null && !timeTo.isEmpty()) {
                if (this.hhmm2numOfMinutes(timeTo) > this.hhmm2numOfMinutes(intervalFields[1])) {
                    Reporter.addMessage(this.m_messages, (String)"WRN5017", (String)this.m_jobName, (String[])new String[]{intervalFields[1], timeTo});
                    timeTo = intervalFields[1];
                }
            } else {
                timeTo = intervalFields[1];
            }
            if (!timeTo.trim().isEmpty()) {
                if (!this.isValidTimeHHMM(timeTo)) {
                    Reporter.addMessage(this.m_messages, (String)"WRN0006", (String)this.m_jobName, (String[])new String[]{"JOBTRAC", "R_Interval", timeTo, "TIME"});
                } else {
                    this.m_attributes.put("TIMETO", timeTo);
                }
            }
        }
        if (intervalFields.length >= 3 && !intervalFields[2].isEmpty()) {
            if (intervalFields[2].trim().equals("S")) {
                this.m_attributes.put("IND_CYCLIC", "TARGET");
            } else if (intervalFields[2].trim().equals("A")) {
                this.m_attributes.put("IND_CYCLIC", "START");
            } else if (intervalFields[2].trim().equals("E")) {
                this.m_attributes.put("IND_CYCLIC", "END");
            }
        }
    }

    private Integer hhmm2numOfMinutes(String hhmm) {
        if (!hhmm.matches("[0-9]+")) {
            return 0;
        }
        Integer tmpRaw = Integer.valueOf(hhmm);
        return tmpRaw % 100 + tmpRaw / 100 * 60;
    }

    private void handleHolidayAction() {
        String action = this.getSclAttrAsStr("HolidayAction").trim();
        String locId = this.getSclAttrAsStr("LocationID").trim();
        if (locId.trim().isEmpty()) {
            locId = this.getSclAttrAsStr("@SETLOC").trim();
        }
        String workdCal = "WORKD" + locId;
        String holidCal = "HOLID" + locId;
        if (action.isEmpty() || action.equals(" ")) {
            this.setOptionalAttribute("CONFCAL", holidCal);
        } else if (action.equals("S")) {
            this.setOptionalAttribute("CONFCAL", holidCal);
            this.setOptionalAttribute("SHIFT", "NOCONFCAL");
        } else if (action.equals("H")) {
            this.setOptionalAttribute("CONFCAL", holidCal);
            this.setOptionalAttribute("SHIFT", "NOCONFCAL");
            Reporter.addMessage(this.m_messages, (String)"WRN0005", (String)this.m_jobName, (String[])new String[]{this.m_jobName, this.m_jobName, "HOLIDAY ACTION HOLD=" + action});
        } else if (action.equals("N")) {
            this.setOptionalAttribute("CONFCAL", holidCal);
            this.setOptionalAttribute("SHIFT", "NEXTDAY");
        } else if (action.equals("W")) {
            this.setOptionalAttribute("CONFCAL", workdCal);
            this.setOptionalAttribute("SHIFT", "NEXTDAY");
        } else if (action.equals("O")) {
            this.setOptionalAttribute("CONFCAL", holidCal);
        } else if (action.equals("P")) {
            this.setOptionalAttribute("CONFCAL", workdCal);
            this.setOptionalAttribute("SHIFT", "PREVDAY");
        }
    }

    private boolean isRelevantDate(String ppDay, String ppMonth, String ppYear) {
        if (ppYear.matches("\\*{2}")) {
            return true;
        }
        if (Integer.valueOf(ppYear) > 65) {
            return false;
        }
        String year = ppYear;
        String month = ppMonth;
        String day = ppDay;
        if (ppMonth.matches("\\*{2}")) {
            month = "12";
        }
        if (ppDay.matches("\\*{2}")) {
            day = "31";
        }
        return Integer.valueOf(year + month + day) > Integer.valueOf(this.currDate);
    }

    private boolean isValidDate(String day, String month, String year) {
        GregorianCalendar tmpCal;
        Integer dayInt = day.trim().matches("[0-9]+") ? Integer.valueOf(day) : 1;
        Integer monthInt = month.trim().matches("[0-9]+") ? Integer.valueOf(month) : 1;
        Integer yearInt = year.trim().matches("[0-9]+") ? Integer.valueOf(year) : 2004;
        if (yearInt < 100) {
            yearInt = yearInt + (yearInt > 50 ? 1900 : 2000);
        }
        return (tmpCal = new GregorianCalendar(yearInt, monthInt - 1, dayInt)).get(5) == dayInt.intValue() && tmpCal.get(2) + 1 == monthInt && tmpCal.get(1) == yearInt.intValue();
    }

    private boolean isValidTimeHHMM(String hhmm) {
        if (!hhmm.matches("^[0-9]{4}$")) {
            return false;
        }
        Integer rawTimeInt = Integer.valueOf(hhmm);
        Integer minutes = rawTimeInt % 100;
        Integer hours = rawTimeInt / 100;
        return minutes >= 0 && minutes < 60 && hours >= 0 && hours < 24;
    }

    private void readDeps() {
        LinkedHashSet<String> depsList = this.getSclAttrAsStrList("DependencyList");
        block0: for (String currDep : depsList) {
            if (currDep.isEmpty()) continue;
            String tmpDep = currDep;
            String dep = tmpDep.trim().substring(0, 1);
            tmpDep = tmpDep.substring(1);
            while (!dep.isEmpty()) {
                if (dep.equals("E")) {
                    if (this.m_inConds == null) {
                        this.m_inConds = new ArrayList();
                    }
                    newCond = new Properties();
                    newCond.put("NAME", "EDIT_JCL-" + this.getOriginalJobName());
                    newCond.put("AND_OR", "AND");
                    newCond.put("ODATE", "ODAT");
                    this.m_inConds.add(newCond);
                } else if (dep.equals("D")) {
                    if (this.m_inConds == null) {
                        this.m_inConds = new ArrayList();
                    }
                    newCond = new Properties();
                    newCond.put("NAME", "DSNTRIG_" + this.getOriginalJobName());
                    newCond.put("AND_OR", "AND");
                    newCond.put("ODATE", "ODAT");
                    this.m_inConds.add(newCond);
                } else if (dep.equals("A")) {
                    if (this.m_onstmt == null) {
                        this.m_onstmt = new ArrayList();
                    }
                    Properties stmt = new Properties();
                    stmt.put("PGMS", "ANYSTEP");
                    stmt.put("PROCS", "");
                    stmt.put("CODE", "U****,S***");
                    stmt.put("ACTION", "OK");
                    this.m_onstmt.add(stmt);
                } else if (dep.equals("J")) {
                    if (this.m_inConds == null) {
                        this.m_inConds = new ArrayList();
                    }
                    newCond = new Properties();
                    newCond.put("NAME", "JCL-" + this.getOriginalJobName());
                    newCond.put("AND_OR", "AND");
                    newCond.put("ODATE", "ODAT");
                    this.m_inConds.add(newCond);
                } else if (dep.equals("M")) {
                    this.m_attributes.put("CONFIRM", "1");
                } else if (dep.equals("O")) {
                    Reporter.addMessage(this.m_messages, (String)"WRN0005", (String)this.m_jobName, (String[])new String[]{this.m_jobName, this.m_jobName, "Output release dependency (DEPS=O)"});
                } else if (!dep.equals("P")) {
                    if (dep.equals("Q")) {
                        if (this.m_inConds == null) {
                            this.m_inConds = new ArrayList();
                        }
                        newCond = new Properties();
                        newCond.put("NAME", "Q_RELEAS-" + this.getOriginalJobName());
                        newCond.put("AND_OR", "AND");
                        newCond.put("ODATE", "ODAT");
                        this.m_inConds.add(newCond);
                    } else if (dep.equals("?")) {
                        if (this.m_inConds == null) {
                            this.m_inConds = new ArrayList();
                        }
                        newCond = new Properties();
                        newCond.put("NAME", "VIEW_DOC-" + this.getOriginalJobName());
                        newCond.put("AND_OR", "AND");
                        newCond.put("ODATE", "ODAT");
                        this.m_inConds.add(newCond);
                    }
                }
                if (tmpDep.length() == 0) continue block0;
                dep = tmpDep.trim().substring(0, 1);
                tmpDep = tmpDep.substring(1);
            }
        }
    }

    private void readReferback() {
        String[] unsupportedFileds;
        String altSchenv;
        String priorityStr;
        LinkedHashSet<String> condCodeList = this.getSclAttrAsStrList("R_MaximumConditionCodeList");
        ArrayList<ArrayList<String>> sJobSteps = this.m_sourceDefs.getM_ccpfConvertor().getM_event_steps().get(this.m_jobName);
        for (String currConds : condCodeList) {
            if (currConds.isEmpty()) continue;
            if (this.isDSJob()) {
                Reporter.addMessage(this.m_messages, (String)"WRN5027", (String)this.m_jobName, (String[])new String[]{"Coversion of CC= not supported for Distributed jobs", currConds.toString()});
                break;
            }
            if (sJobSteps == null) {
                Reporter.addMessage(this.m_messages, (String)"WRN5027", (String)this.m_jobName, (String[])new String[]{"JCL not available", currConds.toString()});
                break;
            }
            this.ccListToOnStmt(currConds, sJobSteps);
        }
        if (!(priorityStr = this.getSclAttrAsStr("R_PRIORITY").trim()).isEmpty() && priorityStr.matches("PRIORITY=[0-9]+")) {
            priorityStr = priorityStr.split("=")[1];
        }
        if (priorityStr.matches("[0-9]+")) {
            Integer priorityInt = Integer.valueOf(priorityStr);
            if (m_priorityCalculator == null) {
                m_priorityCalculator = new CtmPriority(JobTracGlobals.MIN_PRIORITY.intValue(), JobTracGlobals.MAX_PRIORITY.intValue());
            }
            priorityInt = 100 - priorityInt + 1;
            priorityStr = m_priorityCalculator.calculatePriority(priorityInt.intValue());
            this.m_attributes.put("PRIORITY", priorityStr);
        }
        if ((altSchenv = this.getSclAttrAsStr("R_SCHENV")).contains("=")) {
            altSchenv = altSchenv.split("=", 2)[1].trim();
            this.setOptionalAttribute("SCHEDULING_ENVIRONMENT", altSchenv);
        }
        for (String field : unsupportedFileds = new String[]{"R_EmailList", "R_EmailPlus", "R_FLOWEND", "R_FLOWSTART", "R_REPORT"}) {
            String value = this.getSclAttrAsStr(field);
            if (value.trim().isEmpty()) continue;
            Reporter.addMessage(this.m_messages, (String)"WRN0005", (String)this.m_jobName, (String[])new String[]{this.m_jobName, this.m_jobName, "R_Referback " + field + "=" + value});
        }
    }

    private void ccListToOnStmt(String conds, ArrayList<ArrayList<String>> sJobSteps) {
        conds = conds.substring(3);
        Pattern listPattern = Pattern.compile("([0-9]+),(EQ|NE|GT|LT|LE|GE),([0-9]+),?(.*)");
        Matcher matcher = listPattern.matcher(conds);
        while (matcher.matches()) {
            String step = matcher.group(1);
            String operator = matcher.group(2);
            String valueStr = matcher.group(3);
            conds = matcher.group(4);
            matcher = listPattern.matcher(conds);
            int stepno = Integer.parseInt(step);
            if (this.isCA11Active) {
                --stepno;
            }
            if (stepno > sJobSteps.size()) {
                Reporter.addMessage(this.m_messages, (String)"WRN5027", (String)this.m_jobName, (String[])new String[]{"The sequential step # requested, " + step + ", exceeds the total number of steps in the JCL (" + sJobSteps.size() + ")", step + "," + operator + "," + valueStr});
                continue;
            }
            ArrayList<String> thisStep = sJobSteps.get(stepno - 1);
            String sStepName = thisStep.get(iStepName);
            if (thisStep.get(iStepPGM).isEmpty()) {
                if (!thisStep.get(iStepProc).isEmpty()) {
                    Reporter.addMessage(this.m_messages, (String)"WRN5027", (String)this.m_jobName, (String[])new String[]{"Step " + sStepName + " executes a PROC", step + "," + operator + "," + valueStr});
                    continue;
                }
                Reporter.addMessage(this.m_messages, (String)"WRN5027", (String)this.m_jobName, (String[])new String[]{"An Error has been encountered - no PGM or PROC found for " + sStepName, step + "," + operator + "," + valueStr});
                continue;
            }
            if (sStepName.isEmpty()) {
                Reporter.addMessage(this.m_messages, (String)"WRN5027", (String)this.m_jobName, (String[])new String[]{"Step number " + step + " has a blank stepname for CC= entry: " + step + "," + operator + "," + valueStr});
                continue;
            }
            Properties stmt = new Properties();
            Integer valueInt = Integer.valueOf(valueStr);
            if (this.m_onstmt == null) {
                this.m_onstmt = new ArrayList();
            }
            String[] sOPandVAL = this.m_sourceDefs.getM_ccpfConvertor().convertOperatorAndValue(operator, String.valueOf(valueInt), this.isDSJob());
            stmt.put("PGMS", sStepName);
            stmt.put("CODE", String.format("%sC%s", sOPandVAL[0], sOPandVAL[1]));
            stmt.put("ACTION", sOPandVAL[2]);
            this.m_onstmt.add(stmt);
        }
    }

    public class schedulingCriteria {
        public static final String daysN = "daysN";
        public static final String daysDn = "daysDn";
        public static final String daysLn = "daysLn";
        public static final String daysxN = "daysxN";
        public static final String daysxDn = "daysxDn";
        public static final String daysxLn = "daysxLn";
        private HashMap<String, Boolean>[] days = null;
        public static final String wDaysN = "wDaysN";
        public static final String wDaysDn = "wDaysDn";
        public static final String wDaysLn = "wDaysLn";
        public static final String wDaysxN = "wDaysxN";
        public static final String wDaysxDn = "wDaysxDn";
        public static final String wDaysxLn = "wDaysxLn";
        private HashMap<String, Boolean>[] wDays = null;
        public static final String monthWeekDaysDays = "monthWeekDaysDays";
        public static final String monthWeekDaysWeeks = "monthWeekDaysWeeks";
        private HashMap<String, Integer>[] monthWeekDays = null;
        private int numMonthWeekDays = 0;
        public static final String periodDaysMonthDay = "periodDaysMonthDay";
        public static final String periodDaysMonthPeriod = "periodDaysMonthPeriod";
        public static final String periodDaysMonthDL = "periodDaysMonthDL";
        public static final String periodDaysMonthX = "periodDaysMonthX";
        public static final String periodDaysMonthDel = "periodDaysMonthDel";
        private HashMap<String, String>[] periodDaysMonth = null;
        private int numPeriodDaysMonth = 0;
        private int[] dayDates = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private int[] monthDates = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private int numDates = 0;
        private boolean[] month = new boolean[13];
        static final String monthNamesList = "JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC";
        private String dcal = "";
        private String wcal = "";
        private String confcal = "";
        private String shift = "";
        private String relation = "OR";
        private HashSet<String> rbc = null;
        private String rbcAndOr = "OR";
        private boolean daysSet = false;
        private boolean wDaysSet = false;
        private boolean dateSched = false;

        public schedulingCriteria() {
            int i;
            this.days = new HashMap[32];
            for (i = 0; i < 32; ++i) {
                this.days[i] = new HashMap();
            }
            this.wDays = new HashMap[7];
            for (i = 0; i < 7; ++i) {
                this.wDays[i] = new HashMap();
            }
            this.monthWeekDays = new HashMap[11];
            for (i = 0; i < 11; ++i) {
                this.monthWeekDays[i] = new HashMap();
            }
            this.numMonthWeekDays = 0;
            this.periodDaysMonth = new HashMap[8];
            for (i = 0; i < 8; ++i) {
                this.periodDaysMonth[i] = new HashMap();
            }
            this.numPeriodDaysMonth = 0;
            for (i = 0; i < 12; ++i) {
                this.dayDates[i] = -1;
                this.monthDates[i] = -1;
            }
            this.numDates = 0;
            for (i = 1; i < 13; ++i) {
                this.month[i] = false;
            }
            this.dcal = "";
            this.wcal = "";
            this.confcal = "";
            this.shift = "";
            this.relation = "OR";
            this.rbc = new HashSet();
            this.rbcAndOr = "OR";
        }

        public String daysToString() {
            Object objStr = "";
            for (int i = 1; i < 32; ++i) {
                if (this.days[i].keySet().isEmpty()) continue;
                for (String key : this.days[i].keySet()) {
                    if (key.equals(daysN)) {
                        objStr = (String)objStr + i + ",";
                        continue;
                    }
                    if (key.equals(daysDn)) {
                        objStr = (String)objStr + "D" + i + ",";
                        continue;
                    }
                    if (key.equals(daysLn)) {
                        objStr = (String)objStr + "L" + i + ",";
                        continue;
                    }
                    if (key.equals(daysxN)) {
                        objStr = (String)objStr + "-" + i + ",";
                        continue;
                    }
                    if (key.equals(daysxDn)) {
                        objStr = (String)objStr + "-D" + i + ",";
                        continue;
                    }
                    if (!key.equals(daysxLn)) continue;
                    objStr = (String)objStr + "-L" + i + ",";
                }
            }
            if (!((String)objStr).isEmpty() && ((String)objStr).substring(((String)objStr).length() - 1, ((String)objStr).length()).equals(",")) {
                objStr = ((String)objStr).substring(0, ((String)objStr).length() - 1);
            }
            return objStr;
        }

        public String wDaysToString() {
            Object objStr = "";
            for (int i = 0; i < 7; ++i) {
                int iSweekL;
                int iSweek;
                int n = iSweek = JobtracJob.this.m_rules.getStringRule("Jobtrac rules", new String[]{"SWEEK"}).equals("MON") ? i : i + 1;
                if (iSweek > 6) {
                    iSweek = 0;
                }
                int n2 = iSweekL = JobtracJob.this.m_rules.getStringRule("Jobtrac rules", new String[]{"SWEEK"}).equals("MON") ? i : i - 1;
                if (iSweekL < 0) {
                    iSweekL = 6;
                }
                if (this.wDays[i].keySet().isEmpty()) continue;
                for (String key : this.wDays[i].keySet()) {
                    if (key.equals(wDaysN)) {
                        objStr = (String)objStr + iSweek + ",";
                        continue;
                    }
                    if (key.equals(wDaysDn)) {
                        objStr = (String)objStr + "D" + iSweek + ",";
                        continue;
                    }
                    if (key.equals(wDaysLn)) {
                        objStr = (String)objStr + "L" + iSweekL + ",";
                        continue;
                    }
                    if (key.equals(wDaysxN)) {
                        objStr = (String)objStr + "-" + iSweek + ",";
                        continue;
                    }
                    if (key.equals(wDaysxDn)) {
                        objStr = (String)objStr + "-D" + iSweek + ",";
                        continue;
                    }
                    if (!key.equals(wDaysxLn)) continue;
                    objStr = (String)objStr + "-L" + iSweekL + ",";
                }
            }
            if (!((String)objStr).isEmpty() && ((String)objStr).substring(((String)objStr).length() - 1, ((String)objStr).length()).equals(",")) {
                objStr = ((String)objStr).substring(0, ((String)objStr).length() - 1);
            }
            return objStr;
        }

        public String monthWeekDaysToString() {
            Object objStr = "";
            for (int i = 0; i < this.numMonthWeekDays; ++i) {
                int iSweek;
                if (this.monthWeekDays[i].keySet().isEmpty()) continue;
                int n = iSweek = JobtracJob.this.m_rules.getStringRule("Jobtrac rules", new String[]{"SWEEK"}).equals("MON") ? this.monthWeekDays[i].get(monthWeekDaysDays) : this.monthWeekDays[i].get(monthWeekDaysDays) + 1;
                if (iSweek > 6) {
                    iSweek = 0;
                }
                objStr = (String)objStr + "D" + iSweek + "W" + String.valueOf(this.monthWeekDays[i].get(monthWeekDaysWeeks)) + ",";
            }
            if (!((String)objStr).isEmpty() && ((String)objStr).substring(((String)objStr).length() - 1, ((String)objStr).length()).equals(",")) {
                objStr = ((String)objStr).substring(0, ((String)objStr).length() - 1);
            }
            return objStr;
        }

        public String periodDaysMonthToString() {
            Object objStr = "";
            for (int i = 0; i < this.numPeriodDaysMonth; ++i) {
                if (this.periodDaysMonth[i].keySet().isEmpty() || !this.periodDaysMonth[i].get(periodDaysMonthDel).equals("N")) continue;
                objStr = (String)objStr + this.periodDaysMonth[i].get(periodDaysMonthX) + this.periodDaysMonth[i].get(periodDaysMonthDL) + this.periodDaysMonth[i].get(periodDaysMonthDay) + "P" + this.periodDaysMonth[i].get(periodDaysMonthPeriod) + ",";
            }
            if (!((String)objStr).isEmpty() && ((String)objStr).substring(((String)objStr).length() - 1, ((String)objStr).length()).equals(",")) {
                objStr = ((String)objStr).substring(0, ((String)objStr).length() - 1);
            }
            return objStr;
        }

        public String datesToString() {
            Object objStr = "";
            for (int i = 0; i < this.numDates; ++i) {
                objStr = (String)objStr + String.format("%02d", this.monthDates[i]);
                objStr = (String)objStr + String.format("%02d", this.dayDates[i]);
            }
            return objStr;
        }

        public String monthToString() {
            Object objStr = "";
            for (int i = 1; i < 13; ++i) {
                if (!this.month[i]) continue;
                objStr = (String)objStr + monthNamesList.substring((i - 1) * 3, i * 3) + "=Y,";
            }
            if (!((String)objStr).isEmpty() && ((String)objStr).substring(((String)objStr).length() - 1, ((String)objStr).length()).equals(",")) {
                objStr = ((String)objStr).substring(0, ((String)objStr).length() - 1);
            }
            return objStr;
        }

        public String dcalToString() {
            return this.dcal;
        }

        public String wcalToString() {
            return this.wcal;
        }

        public String confcalToString() {
            return this.confcal;
        }

        public String shiftToString() {
            return this.shift;
        }

        public String relationToString() {
            return this.relation;
        }

        public String toString() {
            Object objStr = "";
            objStr = (String)objStr + "\ndays=";
            if (!((String)(objStr = (String)objStr + this.daysToString())).substring(((String)objStr).length() - 1, ((String)objStr).length()).equals("=")) {
                objStr = (String)objStr + ",";
            }
            if (((String)(objStr = (String)objStr + this.periodDaysMonthToString())).substring(((String)objStr).length() - 1, ((String)objStr).length()).equals(",")) {
                objStr = ((String)objStr).substring(0, ((String)objStr).length() - 1);
            }
            objStr = (String)objStr + "\nwDays=";
            if (!((String)(objStr = (String)objStr + this.wDaysToString())).substring(((String)objStr).length() - 1, ((String)objStr).length()).equals("=")) {
                objStr = (String)objStr + ",";
            }
            if (((String)(objStr = (String)objStr + this.monthWeekDaysToString())).substring(((String)objStr).length() - 1, ((String)objStr).length()).equals(",")) {
                objStr = ((String)objStr).substring(0, ((String)objStr).length() - 1);
            }
            objStr = (String)objStr + "\nDates=";
            objStr = (String)objStr + this.datesToString();
            objStr = (String)objStr + "\nMonth=";
            objStr = (String)objStr + this.monthToString();
            objStr = (String)objStr + "\nDCAL=";
            objStr = (String)objStr + this.dcalToString();
            objStr = (String)objStr + "\nWCAL=";
            objStr = (String)objStr + this.wcalToString();
            objStr = (String)objStr + "\nCONFCAL=";
            objStr = (String)objStr + this.confcalToString();
            objStr = (String)objStr + "\nSHIFT=";
            objStr = (String)objStr + this.shiftToString();
            objStr = (String)objStr + "\nRELATION=";
            objStr = (String)objStr + this.relationToString();
            return objStr;
        }

        public void toJob() {
            Properties tagProperties = null;
            Object objStr = "";
            if (!this.datesToString().isEmpty()) {
                JobtracJob.this.setOptionalAttribute("DATE", this.datesToString());
            } else {
                objStr = this.daysToString();
                if (!((String)objStr).isEmpty()) {
                    objStr = (String)objStr + ",";
                }
                if (!((String)(objStr = (String)objStr + this.periodDaysMonthToString())).isEmpty() && ((String)objStr).substring(((String)objStr).length() - 1, ((String)objStr).length()).equals(",")) {
                    objStr = ((String)objStr).substring(0, ((String)objStr).length() - 1);
                }
                if (((String)objStr).equals("1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31")) {
                    objStr = "ALL";
                }
                JobtracJob.this.setOptionalAttribute("DAYS", (String)objStr);
                if (!this.dcalToString().isEmpty()) {
                    JobtracJob.this.setOptionalAttribute("DAYSCAL", this.dcalToString());
                } else {
                    JobtracJob.this.removeOptionalAttribute("DAYSCAL");
                }
            }
            objStr = "";
            objStr = this.wDaysToString();
            if (!((String)objStr).isEmpty()) {
                objStr = (String)objStr + ",";
            }
            if (!((String)(objStr = (String)objStr + this.monthWeekDaysToString())).isEmpty() && ((String)objStr).substring(((String)objStr).length() - 1, ((String)objStr).length()).equals(",")) {
                objStr = ((String)objStr).substring(0, ((String)objStr).length() - 1);
            }
            if (((String)objStr).equals("0,1,2,3,4,5,6")) {
                objStr = "ALL";
            }
            if (((String)objStr).equals("1,2,3,4,5,6,0")) {
                objStr = "ALL";
            }
            JobtracJob.this.setOptionalAttribute("WEEKDAYS", (String)objStr);
            String[] monthsArr = GlobalFunctions.getMonthsArray();
            for (int im = 0; im < monthsArr.length; ++im) {
                JobtracJob.this.setOptionalAttribute(monthsArr[im], this.getMonth(im + 1) ? "1" : "0");
            }
            if (!this.wcalToString().isEmpty()) {
                JobtracJob.this.setOptionalAttribute("WEEKSCAL", this.wcalToString());
            }
            if (!this.confcalToString().isEmpty()) {
                JobtracJob.this.setOptionalAttribute("CONFCAL", this.confcalToString());
            }
            if (!this.shiftToString().isEmpty()) {
                JobtracJob.this.setOptionalAttribute("SHIFT", this.shiftToString());
            }
            JobtracJob.this.setOptionalAttribute("DAYS_AND_OR", this.relationToString());
            JobtracJob.this.m_tags.clear();
            for (Properties currTag : JobtracJob.this.m_parent.getTags()) {
                String tagName = currTag.getProperty("NAME");
                String nTagName = "!" + tagName;
                for (String anRbc : this.rbc) {
                    if (tagName.equals(anRbc) || tagName.startsWith(anRbc + "_")) {
                        JobtracJob.this.m_tags.add(currTag);
                    }
                    if (!nTagName.equals(anRbc) && !nTagName.startsWith(anRbc + "_")) continue;
                    tagProperties = new Properties();
                    tagProperties.put("NAME", nTagName);
                    JobtracJob.this.m_tags.add(tagProperties);
                }
            }
            if (JobtracJob.this.m_tags.isEmpty()) {
                JobtracJob.this.m_attributes.put("TAG_RELATIONSHIP", "OR");
            } else {
                JobtracJob.this.m_attributes.put("TAG_RELATIONSHIP", this.rbcAndOr);
            }
        }

        public void set_days(String type, int dayRangeStart, int dayRangeEnd, Boolean val) {
            String locId = JobtracJob.this.getSclAttrAsStr("LocationID");
            if (locId.trim().isEmpty()) {
                locId = JobtracJob.this.getSclAttrAsStr("@SETLOC");
            }
            String workdCal = "WORKD" + locId;
            for (int day = dayRangeStart; day <= dayRangeEnd; ++day) {
                this.days[day].put(type, val);
                this.daysSet = true;
            }
            if (type.startsWith("daysx")) {
                this.set_dcal(workdCal);
            }
        }

        public void set_wDays(String type, int day, Boolean val) {
            String locId = JobtracJob.this.getSclAttrAsStr("LocationID");
            if (locId.trim().isEmpty()) {
                locId = JobtracJob.this.getSclAttrAsStr("@SETLOC");
            }
            String workdCal = "WORKD" + locId;
            this.wDays[day].put(type, val);
            this.wDaysSet = true;
            if (type.startsWith("wDaysx")) {
                this.set_wcal(workdCal);
            }
        }

        public boolean set_monthWeekDays(Integer valDays, Integer valWeeks) {
            if (this.numMonthWeekDays < this.monthWeekDays.length) {
                this.monthWeekDays[this.numMonthWeekDays].put(monthWeekDaysDays, valDays);
                this.monthWeekDays[this.numMonthWeekDays].put(monthWeekDaysWeeks, valWeeks);
                ++this.numMonthWeekDays;
                this.wDaysSet = true;
                return true;
            }
            return false;
        }

        public boolean set_periodDaysMonth(String valDay, String valPeriod, String valDL, String valX) {
            if (this.numPeriodDaysMonth < this.periodDaysMonth.length) {
                this.periodDaysMonth[this.numPeriodDaysMonth].put(periodDaysMonthDay, valDay);
                this.periodDaysMonth[this.numPeriodDaysMonth].put(periodDaysMonthPeriod, valPeriod);
                this.periodDaysMonth[this.numPeriodDaysMonth].put(periodDaysMonthDL, valDL);
                this.periodDaysMonth[this.numPeriodDaysMonth].put(periodDaysMonthX, valX);
                this.periodDaysMonth[this.numPeriodDaysMonth].put(periodDaysMonthDel, "N");
                this.daysSet = true;
                ++this.numPeriodDaysMonth;
                return true;
            }
            return false;
        }

        public boolean set_dates(int day, int month) {
            for (int i = 0; i < this.dayDates.length; ++i) {
                if (this.dayDates[i] != day || this.monthDates[i] != month) continue;
                return true;
            }
            if (this.numDates < this.dayDates.length) {
                this.dayDates[this.numDates] = day;
                this.monthDates[this.numDates] = month;
                ++this.numDates;
                return true;
            }
            return false;
        }

        public void set_month(int a_month, boolean val) {
            this.month[a_month] = val;
        }

        public boolean getMonth(int a_month) {
            return this.month[a_month];
        }

        public void set_dcal(String cal) {
            this.dcal = cal;
        }

        public void set_wcal(String cal) {
            this.wcal = cal;
        }

        public void set_confcal(String cal) {
            this.confcal = cal;
        }

        public void set_shift(String shift) {
            this.shift = shift;
        }

        public void set_relation(String rel) {
            this.relation = rel;
            if (rel.equals("AND")) {
                if (!this.daysSet) {
                    this.set_days(daysN, 1, 31, true);
                }
                if (!this.wDaysSet) {
                    this.set_wDays(wDaysN, 1, true);
                    this.set_wDays(wDaysN, 2, true);
                    this.set_wDays(wDaysN, 3, true);
                    this.set_wDays(wDaysN, 4, true);
                    this.set_wDays(wDaysN, 5, true);
                    this.set_wDays(wDaysN, 6, true);
                    this.set_wDays(wDaysN, 0, true);
                }
            }
        }

        public void set_rbc(String anRbc) {
            this.rbc.add(anRbc);
        }

        public void set_rbcAndOr(String andOr) {
            this.rbcAndOr = andOr;
        }

        public boolean isDateSched() {
            return this.dateSched;
        }

        public void setDateSched(boolean dateSched) {
            this.dateSched = dateSched;
        }

        public boolean mergeDays(schedulingCriteria nsc, String operation) {
            for (int i = 1; i < 32; ++i) {
                if (nsc.days[i].keySet().isEmpty()) continue;
                if (this.numDates > 0) {
                    return false;
                }
                for (String key : nsc.days[i].keySet()) {
                    if (operation.equals("X")) {
                        if (key.equals(daysN)) {
                            this.set_days(daysxN, i, i, true);
                            continue;
                        }
                        if (key.equals(daysxN)) {
                            this.set_days(daysN, i, i, true);
                            continue;
                        }
                        if (key.equals(daysDn)) {
                            this.set_days(daysxDn, i, i, true);
                            continue;
                        }
                        if (key.equals(daysxDn)) {
                            this.set_days(daysDn, i, i, true);
                            continue;
                        }
                        if (key.equals(daysxLn)) {
                            this.set_days(daysLn, i, i, true);
                            continue;
                        }
                        if (!key.equals(daysLn)) continue;
                        this.set_days(daysxLn, i, i, true);
                        continue;
                    }
                    this.set_days(key, i, i, true);
                }
            }
            return true;
        }

        public boolean mergeWDays(schedulingCriteria nsc, String operation) {
            for (int i = 0; i < 7; ++i) {
                if (nsc.wDays[i].keySet().isEmpty()) continue;
                for (String key : nsc.wDays[i].keySet()) {
                    if (operation.equals("X")) {
                        if (key.equals(wDaysN)) {
                            for (String thisKey : this.wDays[i].keySet()) {
                                if (!thisKey.equals(wDaysN)) continue;
                                return false;
                            }
                            this.set_wDays(wDaysxN, i, true);
                            continue;
                        }
                        if (key.equals(wDaysxN)) {
                            this.set_wDays(wDaysN, i, true);
                            continue;
                        }
                        if (key.equals(wDaysDn)) {
                            this.set_wDays(wDaysxDn, i, true);
                            continue;
                        }
                        if (key.equals(wDaysxDn)) {
                            this.set_wDays(wDaysDn, i, true);
                            continue;
                        }
                        if (key.equals(wDaysLn)) {
                            this.set_wDays(wDaysxLn, i, true);
                            continue;
                        }
                        if (!key.equals(wDaysxLn)) continue;
                        this.set_wDays(wDaysLn, i, true);
                        continue;
                    }
                    this.set_wDays(key, i, true);
                    if (!operation.equals("+")) continue;
                    this.set_relation("AND");
                }
            }
            return true;
        }

        public boolean valWdaysVal(Integer dayInt) {
            for (int i = 0; i < 7; ++i) {
                if (!(i == dayInt ? this.wDays[i].keySet().isEmpty() : !this.wDays[i].keySet().isEmpty())) continue;
                return false;
            }
            return true;
        }

        public boolean mergeMonthWeekDays(schedulingCriteria nsc) {
            for (int i = 0; i < 11; ++i) {
                if (nsc.monthWeekDays[i].keySet().isEmpty() || this.set_monthWeekDays(nsc.monthWeekDays[i].get(monthWeekDaysDays), nsc.monthWeekDays[i].get(monthWeekDaysWeeks))) continue;
                return false;
            }
            return true;
        }

        public boolean mergePeriodDaysMonth(schedulingCriteria nsc, String operator) {
            boolean itemFound = false;
            for (int i = 0; i < 8; ++i) {
                if (nsc.periodDaysMonth[i].keySet().isEmpty()) continue;
                if (this.numDates > 0) {
                    return false;
                }
                if (operator.startsWith("+") || operator.startsWith("X")) {
                    if (nsc.periodDaysMonth[i].get(periodDaysMonthDL).equals("D") && nsc.periodDaysMonth[i].get(periodDaysMonthDay).equals("*") && nsc.periodDaysMonth[i].get(periodDaysMonthX).isEmpty() && !nsc.periodDaysMonth[i].get(periodDaysMonthPeriod).equals("*")) {
                        for (int j = 0; j < 8; ++j) {
                            if (this.periodDaysMonth[j].keySet().isEmpty() || !this.periodDaysMonth[j].get(periodDaysMonthDL).equals("D") || this.periodDaysMonth[j].get(periodDaysMonthDay).equals("*") || !this.periodDaysMonth[j].get(periodDaysMonthX).isEmpty() || !this.periodDaysMonth[j].get(periodDaysMonthPeriod).equals("*")) continue;
                            this.periodDaysMonth[j].put(periodDaysMonthDel, "Y");
                            itemFound = true;
                            if (operator.startsWith("+") && !this.set_periodDaysMonth(this.periodDaysMonth[j].get(periodDaysMonthDay), nsc.periodDaysMonth[i].get(periodDaysMonthPeriod), nsc.periodDaysMonth[i].get(periodDaysMonthDL), nsc.periodDaysMonth[i].get(periodDaysMonthX))) {
                                return false;
                            }
                            if (!operator.startsWith("X") || this.set_periodDaysMonth(this.periodDaysMonth[j].get(periodDaysMonthDay), nsc.periodDaysMonth[i].get(periodDaysMonthPeriod), nsc.periodDaysMonth[i].get(periodDaysMonthDL), "-")) continue;
                            return false;
                        }
                        return true;
                    }
                    if (nsc.periodDaysMonth[i].get(periodDaysMonthDL).equals("D") && !nsc.periodDaysMonth[i].get(periodDaysMonthDay).equals("*") && nsc.periodDaysMonth[i].get(periodDaysMonthX).isEmpty() && nsc.periodDaysMonth[i].get(periodDaysMonthPeriod).equals("*")) {
                        for (int j = 0; j < 8; ++j) {
                            if (this.periodDaysMonth[j].keySet().isEmpty() || !this.periodDaysMonth[j].get(periodDaysMonthDL).equals("D") || !this.periodDaysMonth[j].get(periodDaysMonthDay).equals("*") || !this.periodDaysMonth[j].get(periodDaysMonthX).isEmpty() || this.periodDaysMonth[j].get(periodDaysMonthPeriod).equals("*")) continue;
                            this.periodDaysMonth[j].put(periodDaysMonthDel, "Y");
                            itemFound = true;
                            if (operator.startsWith("+") && !this.set_periodDaysMonth(nsc.periodDaysMonth[i].get(periodDaysMonthDay), this.periodDaysMonth[j].get(periodDaysMonthPeriod), nsc.periodDaysMonth[i].get(periodDaysMonthDL), nsc.periodDaysMonth[i].get(periodDaysMonthX))) {
                                return false;
                            }
                            if (!operator.startsWith("X") || this.set_periodDaysMonth(nsc.periodDaysMonth[i].get(periodDaysMonthDay), this.periodDaysMonth[j].get(periodDaysMonthPeriod), nsc.periodDaysMonth[i].get(periodDaysMonthDL), "-")) continue;
                            return false;
                        }
                        return !operator.startsWith("X") || itemFound || this.set_periodDaysMonth(nsc.periodDaysMonth[i].get(periodDaysMonthDay), nsc.periodDaysMonth[i].get(periodDaysMonthPeriod), nsc.periodDaysMonth[i].get(periodDaysMonthDL), "-");
                    }
                }
                if (this.set_periodDaysMonth(nsc.periodDaysMonth[i].get(periodDaysMonthDay), nsc.periodDaysMonth[i].get(periodDaysMonthPeriod), nsc.periodDaysMonth[i].get(periodDaysMonthDL), nsc.periodDaysMonth[i].get(periodDaysMonthX))) continue;
                return false;
            }
            return true;
        }

        public boolean mergeDates(schedulingCriteria nsc) {
            for (int i = 0; i < nsc.numDates; ++i) {
                for (int d = 1; d < 32; ++d) {
                    if (this.days[d].keySet().isEmpty()) continue;
                    return false;
                }
                String[] monthsArr = GlobalFunctions.getMonthsArray();
                for (int m = 1; m <= monthsArr.length; ++m) {
                    if (!this.getMonth(m)) continue;
                    return false;
                }
                if (!this.dcal.isEmpty()) {
                    return false;
                }
                if (!this.wcal.isEmpty()) {
                    return false;
                }
                if (!this.confcal.isEmpty()) {
                    return false;
                }
                if (this.set_dates(nsc.dayDates[i], nsc.monthDates[i])) continue;
                return false;
            }
            return true;
        }

        public boolean mergeMonth(schedulingCriteria nsc, String operator) {
            for (int i = 1; i < 13; ++i) {
                if (nsc.month[i]) {
                    if (this.numDates > 0) {
                        return false;
                    }
                    this.set_month(i, true);
                }
                if (!operator.equals("+") || nsc.month[i]) continue;
                this.set_month(i, false);
            }
            return true;
        }

        public boolean mergeDcal(schedulingCriteria nsc) {
            if (this.dcal.equals(nsc.dcal)) {
                return true;
            }
            if (this.dcal.equals("ALLDAYS") && nsc.dcal.isEmpty() && (this.daysSet || this.wDaysSet)) {
                this.set_dcal("");
                return true;
            }
            if (nsc.dcal.isEmpty()) {
                return true;
            }
            if (this.numDates > 0) {
                return false;
            }
            if (this.dcal.isEmpty() || this.dcal.equals("ALLDAYS")) {
                this.set_dcal(nsc.dcal);
                return true;
            }
            return !this.dcal.isEmpty() && nsc.dcal.equals("ALLDAYS");
        }

        public boolean mergeWcal(schedulingCriteria nsc) {
            if (nsc.wcal.isEmpty()) {
                return true;
            }
            if (this.numDates > 0) {
                return false;
            }
            if (this.wcal.isEmpty()) {
                this.set_wcal(nsc.wcal);
                return true;
            }
            return this.wcal.equals(nsc.wcal);
        }

        public boolean mergeConfcal(schedulingCriteria nsc) {
            if (nsc.confcal.isEmpty()) {
                return true;
            }
            if (this.numDates > 0) {
                return false;
            }
            if (this.confcal.isEmpty()) {
                this.set_confcal(nsc.confcal);
                return true;
            }
            return this.confcal.equals(nsc.confcal);
        }

        public boolean mergeShift(schedulingCriteria nsc) {
            if (nsc.shift.isEmpty()) {
                return true;
            }
            if (this.shift.isEmpty()) {
                this.set_shift(nsc.shift);
                return true;
            }
            return this.shift.equals(nsc.shift);
        }

        public boolean mergeRelation(schedulingCriteria nsc, String operation) {
            if (operation.startsWith("+") || operation.startsWith("X")) {
                this.relation = "AND";
                return true;
            }
            if (this.relation.equals("OR")) {
                this.relation = nsc.relation;
                return true;
            }
            return nsc.relation.equals("AND");
        }

        public boolean mergeRbcAndOr(schedulingCriteria nsc, String operation) {
            if (operation.equals("+") || operation.equals("X")) {
                this.set_rbcAndOr("AND");
                return true;
            }
            if (nsc.rbcAndOr.isEmpty()) {
                return true;
            }
            if (this.rbcAndOr.isEmpty() || nsc.rbcAndOr.equals("AND")) {
                this.set_rbcAndOr(nsc.rbcAndOr);
                return true;
            }
            return true;
        }

        public boolean mergeRbc(schedulingCriteria nsc, String operation) {
            for (String anRbc : nsc.rbc) {
                if (operation.equals("X")) {
                    return false;
                }
                this.rbc.add(anRbc);
            }
            return true;
        }

        public boolean mergeDateSched(schedulingCriteria nsc, String operation) {
            if (this.isDateSched() && nsc.isDateSched()) {
                return false;
            }
            this.setDateSched(true);
            return true;
        }

        public boolean merge(schedulingCriteria nsc, String operation) {
            boolean success = true;
            if (!this.mergeDays(nsc, operation)) {
                success = false;
            }
            if (!this.mergeWDays(nsc, operation)) {
                success = false;
            }
            if (!this.mergeMonthWeekDays(nsc)) {
                success = false;
            }
            if (!this.mergePeriodDaysMonth(nsc, operation)) {
                success = false;
            }
            if (!this.mergeDates(nsc)) {
                success = false;
            }
            if (!this.mergeMonth(nsc, operation)) {
                success = false;
            }
            if (!this.mergeDcal(nsc)) {
                success = false;
            }
            if (!this.mergeWcal(nsc)) {
                success = false;
            }
            if (!this.mergeConfcal(nsc)) {
                success = false;
            }
            if (!this.mergeShift(nsc)) {
                success = false;
            }
            if (!this.mergeRelation(nsc, operation)) {
                success = false;
            }
            if (!this.mergeRbcAndOr(nsc, operation)) {
                success = false;
            }
            if (!this.mergeRbc(nsc, operation)) {
                success = false;
            }
            if (!this.mergeDateSched(nsc, operation)) {
                success = false;
            }
            if (operation.startsWith("+")) {
                this.set_relation("AND");
            }
            this.toJob();
            return success;
        }
    }
}

