/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.draftwriter.DraftFormat;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.jobtrac.CCPFConvertor;
import com.bmc.ctmconvert.jobtrac.CCPFToJSCSFConvertor;
import com.bmc.ctmconvert.jobtrac.CSVReaderRESOURCE;
import com.bmc.ctmconvert.jobtrac.CardCreatorJCLForMF;
import com.bmc.ctmconvert.jobtrac.CardsFileConvertorAbstract;
import com.bmc.ctmconvert.jobtrac.CardsFileConvertorCMEM;
import com.bmc.ctmconvert.jobtrac.CardsFileConvertorControlO;
import com.bmc.ctmconvert.jobtrac.EXCLPARMConvertor;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import com.bmc.ctmconvert.jobtrac.JobtracADIConvertor;
import com.bmc.ctmconvert.jobtrac.JobtracJCLtoCreateCopyMembers;
import com.bmc.ctmconvert.jobtrac.JobtracJMFConvertor;
import com.bmc.ctmconvert.jobtrac.JobtracJob;
import com.bmc.ctmconvert.jobtrac.JobtracMemberModifier;
import com.bmc.ctmconvert.jobtrac.SclTable;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.Pair;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JobtracDefs
implements SourceDefinitions {
    private SclTable m_sclTable;
    private String m_loadedSclName = null;
    private AttrHolderList m_loadedScl = null;
    private HashMap<Integer, HashSet<String>> m_inCondMap = new HashMap();
    private HashMap<Integer, HashSet<String>> m_outCondMap = new HashMap();
    private HashMap<Integer, HashSet<String>> m_inOdatMap = new HashMap();
    private HashMap<Integer, HashSet<String>> m_outOdatMap = new HashMap();
    private HashMap<String, String> m_sclMemberMap = null;
    private LinkedHashMap<String, String[]> m_sclMemebers = null;
    private static HashMap<String, Integer> m_fakeTableAttrHeader = new HashMap();
    private RulesDataSet m_rules = null;
    private ArrayList<String> m_messages = null;
    private HashMap<String, HashMap<String, ArrayList<String>>> m_datesMap = new HashMap();
    private CSVReaderRESOURCE m_resTable = null;
    private HashMap<String, ArrayList<String>> m_noJobRes = null;
    private HashMap<String, ArrayList<String>> m_jobRes = null;
    private EXCLPARMConvertor m_exclConvertor = null;
    private CCPFConvertor m_ccpfConvertor = null;
    private CCPFToJSCSFConvertor m_ccpfJSCSFConvertor = null;
    private HashSet<String> m_dsEventList = new HashSet();
    private BaseProgressBar m_progressBar = null;
    private HashMap<String, HashSet<String>> m_member2LibMap = new HashMap();
    private HashMap<String, ArrayList<String>> m_jobMessages = new HashMap();
    private HashMap<String, String> allInConditions = new HashMap();
    private List<String> listOfDynamicallyOrdered = new ArrayList<String>();

    public CCPFConvertor getM_ccpfConvertor() {
        return this.m_ccpfConvertor;
    }

    public CCPFToJSCSFConvertor getM_ccpfJSCSFConvertor() {
        return this.m_ccpfJSCSFConvertor;
    }

    public JobtracDefs(RulesDataSet rules) {
        this.m_rules = rules;
    }

    public JobtracDefs() {
        this.m_rules = RuleManager.instance().getCurrentRules();
    }

    public void convertScl(Map<String, InputStream> fileNameMap) throws ConvertorCancelClickException {
        m_fakeTableAttrHeader.put("JobID", 0);
        m_fakeTableAttrHeader.put("FAKE_TABLE_NAME", 1);
        m_fakeTableAttrHeader.put("FAKE_TABLE_FULL_NAME", 2);
        m_fakeTableAttrHeader.put("LocationID", 3);
        m_fakeTableAttrHeader.put("SCHENV", 4);
        m_fakeTableAttrHeader.put("BUSGRP", 5);
        this.m_messages = new ArrayList();
        for (String fullPathFileName : fileNameMap.keySet()) {
            if (this.isTaskCancelled()) {
                throw new ConvertorCancelClickException();
            }
            this.m_loadedSclName = new File(fullPathFileName).getName();
            this.m_loadedScl = new AttrHolderList();
            this.m_sclTable = new SclTable(this);
            this.m_sclTable.load(fileNameMap.get(fullPathFileName));
            this.creatListOfDynamicallyOrdered();
            this.creatUserDailyActions();
            this.mapGlobals(this.m_loadedScl);
        }
        HashSet<String> deadKeys = null;
        for (String key : this.m_member2LibMap.keySet()) {
            if (this.m_member2LibMap.get(key).size() > 1) continue;
            if (deadKeys == null) {
                deadKeys = new HashSet<String>();
            }
            deadKeys.add(key);
        }
        for (String key : deadKeys) {
            this.m_member2LibMap.remove(key);
        }
    }

    private void creatUserDailyActions() {
        for (IAttrHolder currAttrs : this.m_loadedScl) {
            String eventName = currAttrs.getAttr("EVENTNM");
            if (!eventName.startsWith("0")) continue;
            String orderedFolder = eventName.substring(1);
            String sclName = currAttrs.getAttr("SCLmember");
            this.addUserDailyAction(sclName, orderedFolder);
        }
    }

    public boolean isDynamicallyOrdered(String folderName) {
        return this.listOfDynamicallyOrdered.contains(folderName);
    }

    private void creatListOfDynamicallyOrdered() {
        for (IAttrHolder currAttrs : this.m_loadedScl) {
            String eventName = currAttrs.getAttr("EVENTNM");
            if (!eventName.startsWith("0")) continue;
            String orderedFolder = eventName.substring(1);
            this.addFolderToListOfDynamicallyOrdered(orderedFolder);
        }
    }

    public void addFolderToListOfDynamicallyOrdered(String orderedFolder) {
        if (!this.listOfDynamicallyOrdered.contains(orderedFolder)) {
            this.listOfDynamicallyOrdered.add(orderedFolder);
        }
    }

    private void addUserDailyAction(String folderName, String orderedFolder) {
        HashMap<String, String> userDailyAction = new HashMap<String, String>();
        userDailyAction.put("ACTENTTYPE", "User Daily");
        userDailyAction.put("JOBID", orderedFolder);
        userDailyAction.put("ACTENTNAME", folderName);
        Reporter.addAction(userDailyAction);
    }

    private LinkedList<jobTableId> getTableNameOfJob(AttrHolderList scl, String jobName, String versionId, String tableName, String jobProcPer, String jobRefDate) {
        boolean IsDSJob;
        String memberName = "";
        int jobId = 0;
        int prevJobId = 0;
        String procPer = "";
        String refDate = "";
        String lineVerId = "";
        String jobVerId = "";
        String tempLineVer = "";
        LinkedList<jobTableId> llj = new LinkedList<jobTableId>();
        LinkedList<jobTableId> pllj = null;
        boolean eventfound = false;
        boolean haveSameProcPeriodDate = false;
        String eventType = "";
        String IP = "";
        String node = "";
        for (IAttrHolder currLine : scl) {
            if (!currLine.getAttr("SCLmember").trim().equals(tableName.trim()) || !currLine.getAttr("EVENTNM").trim().equals(jobName.trim())) continue;
            memberName = tableName;
            tempLineVer = currLine.getAttr("EventVersion");
            while (tempLineVer.startsWith("0")) {
                tempLineVer = tempLineVer.substring(1);
            }
            if (tempLineVer.equals("1")) {
                tempLineVer = "";
            }
            if (!tempLineVer.equals(versionId) || (jobId = currLine.getAttrAsInt("JobID").intValue()) == prevJobId) continue;
            prevJobId = jobId;
            eventfound = true;
            procPer = currLine.getAttr("ProcessPeriod");
            refDate = currLine.getAttr("Date");
            lineVerId = currLine.getAttr("R_ReferbackVersion");
            while (lineVerId.startsWith("0")) {
                lineVerId = lineVerId.substring(1);
            }
            jobVerId = currLine.getAttr("EventVersion");
            while (jobVerId.startsWith("0")) {
                jobVerId = jobVerId.substring(1);
            }
            if (lineVerId.isEmpty()) {
                lineVerId = jobVerId;
            }
            eventType = currLine.getAttr("EventType");
            if (IP.isEmpty() && !currLine.getAttr("R_IP").isEmpty()) {
                IP = currLine.getAttr("R_IP");
            }
            if (node.isEmpty() && !currLine.getAttr("R_NODE").isEmpty()) {
                node = currLine.getAttr("R_NODE");
            }
            IsDSJob = eventType.equals("C") || eventType.equals("D") && !IP.isEmpty() && !node.isEmpty();
            llj.add(new jobTableId(this, memberName, jobId, procPer, refDate, lineVerId, jobVerId, IsDSJob));
        }
        if (eventfound) {
            haveSameProcPeriodDate = false;
            for (jobTableId jti : llj) {
                if (!jti.procPer.equals(jobProcPer) || !jti.refDate.equals(jobRefDate)) continue;
                haveSameProcPeriodDate = true;
            }
            if (haveSameProcPeriodDate) {
                pllj = new LinkedList<jobTableId>();
                for (jobTableId jti : llj) {
                    if (!jti.procPer.equals(jobProcPer) || !jti.refDate.equals(jobRefDate)) continue;
                    pllj.add(jti);
                }
                return pllj;
            }
            return llj;
        }
        for (IAttrHolder currLine : scl) {
            if (!currLine.getAttr("EVENTNM").trim().equals(jobName.trim())) continue;
            tempLineVer = currLine.getAttr("EventVersion");
            while (tempLineVer.startsWith("0")) {
                tempLineVer = tempLineVer.substring(1);
            }
            if (tempLineVer.equals("1")) {
                tempLineVer = "";
            }
            if (!tempLineVer.equals(versionId) || (jobId = currLine.getAttrAsInt("JobID").intValue()) == prevJobId) continue;
            prevJobId = jobId;
            eventfound = true;
            memberName = currLine.getAttr("SCLmember").trim();
            procPer = currLine.getAttr("ProcessPeriod");
            refDate = currLine.getAttr("Date");
            lineVerId = currLine.getAttr("R_ReferbackVersion");
            while (lineVerId.startsWith("0")) {
                lineVerId = lineVerId.substring(1);
            }
            jobVerId = currLine.getAttr("EventVersion");
            while (jobVerId.startsWith("0")) {
                jobVerId = jobVerId.substring(1);
            }
            if (lineVerId.isEmpty()) {
                lineVerId = jobVerId;
            }
            eventType = currLine.getAttr("EventType");
            if (IP.isEmpty() && !currLine.getAttr("R_IP").isEmpty()) {
                IP = currLine.getAttr("R_IP");
            }
            if (node.isEmpty() && !currLine.getAttr("R_NODE").isEmpty()) {
                node = currLine.getAttr("R_NODE");
            }
            IsDSJob = eventType.equals("C") || eventType.equals("D") && !IP.isEmpty() && !node.isEmpty();
            llj.add(new jobTableId(this, memberName, jobId, procPer, refDate, lineVerId, jobVerId, IsDSJob));
        }
        if (eventfound) {
            return llj;
        }
        Reporter.addMessage(this.m_messages, (String)"WRN5023", (String)jobName, (String[])new String[]{jobName});
        llj.add(new jobTableId(this, "NoTable", -2, "", "", "", "", false));
        return llj;
    }

    private int getTableId(String tableName) {
        for (String[] vals : this.m_sclMemebers.values()) {
            if (!vals[1].equals(tableName)) continue;
            return Integer.valueOf(vals[0]);
        }
        Reporter.addMessage(this.m_messages, (String)"WRN5023", (String)tableName, (String[])new String[]{tableName});
        return -999999;
    }

    private String getEventAlternateName(AttrHolderList scl, String jobName, String tableName) {
        String alternateName = "";
        int jobId = 0;
        int prevJobId = 0;
        boolean eventFound = false;
        for (IAttrHolder currLine : scl) {
            if (eventFound) {
                jobId = currLine.getAttrAsInt("JobID");
                if (jobId == prevJobId) {
                    alternateName = currLine.getAttr("R_AlternateName");
                    if (alternateName.isEmpty()) continue;
                    return alternateName.substring(1);
                }
                eventFound = false;
                return jobName;
            }
            if (!currLine.getAttr("SCLmember").trim().equals(tableName.trim()) || !currLine.getAttr("EVENTNM").trim().equals(jobName.trim()) || (jobId = currLine.getAttrAsInt("JobID").intValue()) == prevJobId) continue;
            prevJobId = jobId;
            eventFound = true;
            alternateName = currLine.getAttr("R_AlternateName");
            if (alternateName.isEmpty()) continue;
            return alternateName.substring(1);
        }
        if (alternateName.isEmpty()) {
            for (IAttrHolder currLine : scl) {
                if (eventFound) {
                    jobId = currLine.getAttrAsInt("JobID");
                    if (jobId == prevJobId) {
                        alternateName = currLine.getAttr("R_AlternateName");
                        if (alternateName.isEmpty()) continue;
                        return alternateName.substring(1);
                    }
                    eventFound = false;
                    return jobName;
                }
                if (!currLine.getAttr("EVENTNM").trim().equals(jobName.trim()) || (jobId = currLine.getAttrAsInt("JobID").intValue()) == prevJobId) continue;
                prevJobId = jobId;
                eventFound = true;
                alternateName = currLine.getAttr("R_AlternateName");
                if (alternateName.isEmpty()) continue;
                return alternateName.substring(1);
            }
        }
        if (alternateName.isEmpty()) {
            alternateName = jobName;
        }
        return alternateName;
    }

    public String mapGlobals(AttrHolderList scl) {
        int currJobId = -1;
        String eventName = "";
        String altOrEventName = "";
        String tableName = "";
        String procPer = "";
        String refDate = "";
        String baseProcP = null;
        boolean useMaybeConds = true;
        String maybePrefix = this.m_rules.getStringRule("Mainframe", new String[]{"PREFIXFORMAYBECONDITION"});
        String GlobPrefixM2D = this.m_rules.getStringRule("Mainframe", new String[]{"PREFIXFORGLOBALMF2DS"});
        String GlobPrefixD2M = this.m_rules.getStringRule("Mainframe", new String[]{"PREFIXFORGLOBALDS2MF"});
        String GlobPrefixMandD = this.m_rules.getStringRule("Mainframe", new String[]{"PREFIXFORGLOBALMFandDS"});
        boolean clearConds = this.m_rules.getBooleanRule("Jobtrac rules", new String[]{"CLEANUPCONDITIONS"});
        boolean isShortCondName = !this.m_rules.getStringRule("Jobtrac rules", new String[]{"CONDITION_NAME"}).equals("JOBA_JOBB");
        boolean useAltJcl = this.m_rules.getBooleanRule("Jobtrac rules", new String[]{"UseAltJCL"});
        HashMap inCondLookup = new HashMap();
        HashMap outCondLookup = new HashMap();
        HashMap<Object, String> maybeForCond = new HashMap<Object, String>();
        HashMap<Object, String> globalForCond = new HashMap<Object, String>();
        String jobVer = "";
        Object formattedJobVer = "";
        boolean IsDSJob = false;
        String thisMaybe = "";
        String thisGlobal = "";
        LinkedList<jobTableId> llj = null;
        String eventType = "";
        String IP = "";
        String node = "";
        for (IAttrHolder currLine : scl) {
            String trimmedCond;
            String altOrOrigJobName;
            String versionId;
            this.mapDates(currLine);
            ArrayList<String> maybeConds = new ArrayList<String>();
            int tmpId = currLine.getAttrAsInt("JobID");
            String procP = currLine.getAttr("ProcessPeriod");
            if (tmpId != currJobId) {
                currJobId = tmpId;
                jobVer = currLine.getAttr("EventVersion");
                tableName = currLine.getAttr("SCLmember").trim();
                procPer = currLine.getAttr("ProcessPeriod");
                refDate = currLine.getAttr("Date");
                eventName = currLine.getAttr("EVENTNM").trim();
                altOrEventName = useAltJcl ? this.getEventAlternateName(scl, eventName, tableName) : eventName;
                while (jobVer.startsWith("0")) {
                    jobVer = jobVer.substring(1);
                }
                formattedJobVer = jobVer;
                if (!((String)formattedJobVer).isEmpty()) {
                    formattedJobVer = "+" + (String)formattedJobVer;
                }
                if (!this.m_outCondMap.containsKey(currJobId)) {
                    this.m_outCondMap.put(currJobId, new HashSet());
                }
                if (!this.m_inCondMap.containsKey(currJobId)) {
                    this.m_inCondMap.put(currJobId, new HashSet());
                }
                if (!this.m_inOdatMap.containsKey(currJobId)) {
                    this.m_inOdatMap.put(currJobId, new HashSet());
                }
                if (!this.m_outOdatMap.containsKey(currJobId)) {
                    this.m_outOdatMap.put(currJobId, new HashSet());
                }
                baseProcP = currLine.getAttr("ProcessPeriod");
                useMaybeConds = currLine.getAttr("ConditionalOperator").trim().isEmpty();
                eventType = currLine.getAttr("EventType");
                if (IP.isEmpty() && !currLine.getAttr("R_IP").isEmpty()) {
                    IP = currLine.getAttr("R_IP");
                }
                if (node.isEmpty() && !currLine.getAttr("R_NODE").isEmpty()) {
                    node = currLine.getAttr("R_NODE");
                }
                IsDSJob = eventType.equals("C") || eventType.equals("D") && !IP.isEmpty() && !node.isEmpty();
            }
            thisMaybe = "";
            thisGlobal = "";
            ArrayList<String> tmpConds = JobTracGlobals.breakStringByWidth(currLine.getAttr("R_PredecessorsList"), JobTracGlobals.eventNameWidth, " ");
            refDate = currLine.getAttr("Date");
            if (refDate.trim().matches("^\\*[+-].*") && !refDate.substring(2).trim().matches("\\d{1,2}")) {
                if (!this.m_jobMessages.containsKey(eventName)) {
                    this.m_jobMessages.put(eventName, new ArrayList());
                }
                Reporter.addMessage((List)this.m_jobMessages.get(eventName), (String)"WRN0006", (String)eventName, (String[])new String[]{"JOBTRAC", "Date", refDate, "DATE"});
                refDate = "*";
            }
            Object lineVer = currLine.getAttr("R_ReferbackVersion");
            while (((String)lineVer).startsWith("0")) {
                lineVer = ((String)lineVer).substring(1);
            }
            if (((String)lineVer).isEmpty()) {
                lineVer = jobVer;
            }
            if ((versionId = lineVer).equals("1")) {
                versionId = "";
            }
            if (!((String)lineVer).isEmpty()) {
                lineVer = "+" + (String)lineVer;
            }
            if (tmpConds != null) {
                for (int i = 0; i < tmpConds.size(); ++i) {
                    String cond = tmpConds.get(i);
                    if (useMaybeConds && !baseProcP.equals(procP) && !procP.isEmpty()) {
                        maybeConds.add(cond);
                        continue;
                    }
                    String trimmedCond2 = "";
                    Object fullCondName = "";
                    altOrOrigJobName = "";
                    if (cond.startsWith("0")) {
                        trimmedCond2 = cond.substring(1).trim();
                        int tableId = this.getTableId(trimmedCond2);
                        fullCondName = trimmedCond2 + "-SCL_" + tableName.trim() + "-" + altOrEventName.trim() + (String)formattedJobVer;
                        fullCondName = ((String)fullCondName).length() > 39 ? ((String)fullCondName).substring(0, 39) : fullCondName;
                        this.m_inCondMap.get(currJobId).add((String)fullCondName);
                        this.checkDuplicateInCondition((String)fullCondName, altOrEventName, eventName, trimmedCond2, trimmedCond2);
                        this.m_inOdatMap.get(currJobId).add("ODAT");
                        if (!this.m_outCondMap.containsKey(tableId)) {
                            this.m_outCondMap.put(tableId, new HashSet());
                        }
                        this.m_outCondMap.get(tableId).add((String)fullCondName);
                        if (!this.m_outOdatMap.containsKey(tableId)) {
                            this.m_outOdatMap.put(tableId, new HashSet());
                        }
                        this.m_outOdatMap.get(tableId).add("ODAT");
                        continue;
                    }
                    trimmedCond2 = cond.trim();
                    String adjustedOdat = "ODAT";
                    llj = this.getTableNameOfJob(scl, trimmedCond2, versionId, tableName, procPer, refDate);
                    for (jobTableId jti : llj) {
                        altOrOrigJobName = useAltJcl ? this.getEventAlternateName(scl, trimmedCond2, tableName) : trimmedCond2;
                        if (!jti.lineVerId.isEmpty()) {
                            jti.lineVerId = "+" + jti.lineVerId;
                        }
                        fullCondName = jti.tableName.equals(tableName) ? tableName.trim() + "-" + altOrOrigJobName + jti.lineVerId + "_" + altOrEventName.trim() + (String)formattedJobVer : jti.getTableName().trim() + "-" + altOrOrigJobName + jti.lineVerId + "_" + tableName.trim() + "-" + altOrEventName.trim() + (String)formattedJobVer;
                        if (!jti.procPer.equals(procPer)) {
                            fullCondName = maybePrefix + (String)fullCondName;
                            thisMaybe = maybePrefix;
                        }
                        Object object = fullCondName = ((String)(fullCondName = (thisGlobal = this.GlobPref(jti.IsDS(), IsDSJob, clearConds, GlobPrefixM2D, GlobPrefixD2M, GlobPrefixMandD)) + (String)fullCondName)).length() > 39 ? ((String)fullCondName).substring(0, 39) : fullCondName;
                        if (isShortCondName) {
                            fullCondName = jti.getTableName().trim() + "-" + altOrOrigJobName + jti.lineVerId + "_OK";
                            if (!outCondLookup.containsKey(fullCondName)) {
                                outCondLookup.put(fullCondName, new HashSet());
                            }
                            if (jti.getJobId() != -2) {
                                ((HashSet)outCondLookup.get(fullCondName)).add(jti.getJobId());
                            }
                            if (!inCondLookup.containsKey(fullCondName)) {
                                inCondLookup.put(fullCondName, new HashSet());
                            }
                            if (currJobId != -2) {
                                ((HashSet)inCondLookup.get(fullCondName)).add(currJobId);
                            }
                            if (!thisMaybe.isEmpty()) {
                                maybeForCond.put(fullCondName, thisMaybe);
                            }
                            if (!thisGlobal.isEmpty()) {
                                globalForCond.put(fullCondName, thisGlobal);
                            }
                        }
                        this.m_inCondMap.get(currJobId).add((String)fullCondName);
                        this.checkDuplicateInCondition((String)fullCondName, altOrEventName, eventName, altOrOrigJobName, trimmedCond2);
                        if (jti.getJobId() != -2) {
                            if (!this.m_outCondMap.containsKey(jti.getJobId())) {
                                this.m_outCondMap.put(jti.getJobId(), new HashSet());
                            }
                            this.m_outCondMap.get(jti.getJobId()).add((String)fullCondName);
                        }
                        if (jti.refDate.trim().equals("*") && refDate.startsWith("*-")) {
                            adjustedOdat = String.format("-%03d", Integer.valueOf(refDate.substring(2).trim()));
                        }
                        if (refDate.trim().equals("*") && jti.refDate.startsWith("*+")) {
                            adjustedOdat = String.format("-%03d", Integer.valueOf(jti.refDate.substring(2).trim()));
                        }
                        if (tableName.equals(jti.tableName) && trimmedCond2.equals(eventName.trim()) && refDate.equals(jti.refDate) && jobVer.equals(jti.jobVerId)) {
                            adjustedOdat = "PREV";
                        }
                        this.m_inOdatMap.get(currJobId).add(adjustedOdat);
                        if (!this.m_outOdatMap.containsKey(jti.getJobId())) {
                            this.m_outOdatMap.put(jti.getJobId(), new HashSet());
                        }
                        this.m_outOdatMap.get(jti.getJobId()).add("ODAT");
                    }
                }
            }
            thisMaybe = "";
            thisGlobal = "";
            tmpConds = JobTracGlobals.breakStringByWidth(currLine.getAttr("R_SuccessorsList"), JobTracGlobals.eventNameWidth, " ");
            if (tmpConds != null) {
                Object fullCondName = "";
                for (String cond : tmpConds) {
                    trimmedCond = "";
                    altOrOrigJobName = "";
                    if (cond.startsWith("0")) {
                        trimmedCond = cond.substring(1).trim();
                        int tableId = this.getTableId(trimmedCond);
                        fullCondName = tableName.trim() + "-" + altOrEventName.trim() + (String)formattedJobVer + "_" + trimmedCond + "-SCL";
                        fullCondName = ((String)fullCondName).length() > 39 ? ((String)fullCondName).substring(0, 39) : fullCondName;
                        this.m_outCondMap.get(currJobId).add((String)fullCondName);
                        this.m_outOdatMap.get(currJobId).add("ODAT");
                        if (!this.m_inCondMap.containsKey(tableId)) {
                            this.m_inCondMap.put(tableId, new HashSet());
                        }
                        this.m_inCondMap.get(tableId).add((String)fullCondName);
                        this.checkDuplicateInCondition((String)fullCondName, altOrEventName, eventName, trimmedCond, trimmedCond);
                        if (!this.m_inOdatMap.containsKey(tableId)) {
                            this.m_inOdatMap.put(tableId, new HashSet());
                        }
                        this.m_inOdatMap.get(tableId).add("ODAT");
                        continue;
                    }
                    trimmedCond = cond.trim();
                    String adjustedOdat = "ODAT";
                    llj = this.getTableNameOfJob(scl, trimmedCond, versionId, tableName, procPer, refDate);
                    for (jobTableId jti : llj) {
                        altOrOrigJobName = useAltJcl ? this.getEventAlternateName(scl, trimmedCond, tableName) : trimmedCond;
                        if (jti == null) {
                            fullCondName = tableName.trim() + "-" + altOrEventName.trim() + (String)formattedJobVer + "_NoTable-" + trimmedCond;
                        } else {
                            if (!jti.lineVerId.isEmpty()) {
                                jti.lineVerId = "+" + jti.lineVerId;
                            }
                            fullCondName = jti.tableName.equals(tableName) ? tableName.trim() + "-" + altOrEventName.trim() + (String)formattedJobVer + "_" + altOrOrigJobName + jti.lineVerId : tableName.trim() + "-" + altOrEventName.trim() + (String)formattedJobVer + "_" + jti.getTableName().trim() + "-" + altOrOrigJobName + jti.lineVerId;
                            if (!jti.procPer.equals(procPer)) {
                                fullCondName = maybePrefix + (String)fullCondName;
                                thisMaybe = maybePrefix;
                            }
                        }
                        thisGlobal = this.GlobPref(IsDSJob, jti.IsDS(), clearConds, GlobPrefixM2D, GlobPrefixD2M, GlobPrefixMandD);
                        fullCondName = thisGlobal + (String)fullCondName;
                        Object object = fullCondName = ((String)fullCondName).length() > 39 ? ((String)fullCondName).substring(0, 39) : fullCondName;
                        if (isShortCondName) {
                            fullCondName = tableName.trim() + "-" + altOrEventName.trim() + (String)formattedJobVer + "_OK";
                            if (!outCondLookup.containsKey(fullCondName)) {
                                outCondLookup.put(fullCondName, new HashSet());
                            }
                            if (currJobId != -2) {
                                ((HashSet)outCondLookup.get(fullCondName)).add(currJobId);
                            }
                            if (!inCondLookup.containsKey(fullCondName)) {
                                inCondLookup.put(fullCondName, new HashSet());
                            }
                            if (jti.getJobId() != -2) {
                                ((HashSet)inCondLookup.get(fullCondName)).add(jti.getJobId());
                            }
                            if (!thisMaybe.isEmpty()) {
                                maybeForCond.put(fullCondName, thisMaybe);
                            }
                            if (!thisGlobal.isEmpty()) {
                                globalForCond.put(fullCondName, thisGlobal);
                            }
                        }
                        this.m_outCondMap.get(currJobId).add((String)fullCondName);
                        if (jti.getJobId() != -2) {
                            if (!this.m_inCondMap.containsKey(jti.getJobId())) {
                                this.m_inCondMap.put(jti.getJobId(), new HashSet());
                            }
                            this.m_inCondMap.get(jti.getJobId()).add((String)fullCondName);
                            this.checkDuplicateInCondition((String)fullCondName, altOrEventName, eventName, altOrOrigJobName, trimmedCond);
                        }
                        if (refDate.trim().equals("*") && jti.refDate.startsWith("*+")) {
                            adjustedOdat = String.format("-%03d", Integer.valueOf(jti.refDate.substring(2).trim()));
                        }
                        if (jti.refDate.trim().equals("*") && refDate.startsWith("*-")) {
                            adjustedOdat = String.format("-%03d", Integer.valueOf(refDate.substring(2).trim()));
                        }
                        if (tableName.equals(jti.tableName) && trimmedCond.equals(eventName.trim()) && refDate.equals(jti.refDate) && jobVer.equals(jti.jobVerId)) {
                            adjustedOdat = "PREV";
                        }
                        this.m_outOdatMap.get(currJobId).add("ODAT");
                        if (!this.m_inOdatMap.containsKey(jti.getJobId())) {
                            this.m_inOdatMap.put(jti.getJobId(), new HashSet());
                        }
                        this.m_inOdatMap.get(jti.getJobId()).add(adjustedOdat);
                    }
                }
            }
            thisMaybe = "";
            thisGlobal = "";
            tmpConds = JobTracGlobals.breakStringByWidth(currLine.getAttr("R_ConditionalPredecessorsList"), JobTracGlobals.eventNameWidth, " ");
            if (tmpConds != null) {
                tmpConds.addAll(maybeConds);
            } else {
                tmpConds = maybeConds;
            }
            for (String cond : tmpConds) {
                Object fullCondName = "";
                trimmedCond = "";
                altOrOrigJobName = "";
                if (cond.startsWith("0")) {
                    trimmedCond = cond.substring(1).trim();
                    int tableId = this.getTableId(trimmedCond);
                    fullCondName = trimmedCond + "-SCL_" + tableName.trim() + "-" + altOrEventName.trim() + (String)formattedJobVer;
                    fullCondName = ((String)fullCondName).length() > 39 ? ((String)fullCondName).substring(0, 39) : fullCondName;
                    this.m_inCondMap.get(currJobId).add((String)fullCondName);
                    this.checkDuplicateInCondition((String)fullCondName, altOrEventName, eventName, trimmedCond, trimmedCond);
                    this.m_inOdatMap.get(currJobId).add("ODAT");
                    if (!this.m_outCondMap.containsKey(tableId)) {
                        this.m_outCondMap.put(tableId, new HashSet());
                    }
                    this.m_outCondMap.get(tableId).add((String)fullCondName);
                    if (!this.m_outOdatMap.containsKey(tableId)) {
                        this.m_outOdatMap.put(tableId, new HashSet());
                    }
                    this.m_outOdatMap.get(tableId).add("ODAT");
                    continue;
                }
                trimmedCond = cond.trim();
                String adjustedOdat = "ODAT";
                llj = this.getTableNameOfJob(scl, trimmedCond, versionId, tableName, procPer, refDate);
                for (jobTableId jti : llj) {
                    if (jti == null) {
                        fullCondName = maybePrefix + tableName.trim() + "-" + altOrEventName.trim() + (String)formattedJobVer + "_NoTable-" + trimmedCond;
                    } else {
                        altOrOrigJobName = useAltJcl ? this.getEventAlternateName(scl, trimmedCond, tableName) : trimmedCond;
                        if (!jti.lineVerId.isEmpty()) {
                            jti.lineVerId = "+" + jti.lineVerId;
                        }
                        fullCondName = jti.tableName.equals(tableName) ? maybePrefix + tableName.trim() + "-" + altOrOrigJobName + jti.lineVerId + "_" + altOrEventName.trim() + (String)formattedJobVer : maybePrefix + jti.tableName.trim() + "-" + altOrOrigJobName + jti.lineVerId + "_" + tableName.trim() + "-" + altOrEventName.trim() + (String)formattedJobVer;
                    }
                    thisMaybe = maybePrefix;
                    thisGlobal = this.GlobPref(jti.IsDS(), IsDSJob, clearConds, GlobPrefixM2D, GlobPrefixD2M, GlobPrefixMandD);
                    fullCondName = thisGlobal + (String)fullCondName;
                    Object object = fullCondName = ((String)fullCondName).length() > 39 ? ((String)fullCondName).substring(0, 39) : fullCondName;
                    if (isShortCondName) {
                        fullCondName = jti.getTableName().trim() + "-" + altOrOrigJobName + jti.lineVerId + "_OK";
                        if (!outCondLookup.containsKey(fullCondName)) {
                            outCondLookup.put(fullCondName, new HashSet());
                        }
                        if (jti.getJobId() != -2) {
                            ((HashSet)outCondLookup.get(fullCondName)).add(jti.getJobId());
                        }
                        if (!inCondLookup.containsKey(fullCondName)) {
                            inCondLookup.put(fullCondName, new HashSet());
                        }
                        if (currJobId != -2) {
                            ((HashSet)inCondLookup.get(fullCondName)).add(currJobId);
                        }
                        if (!thisMaybe.isEmpty()) {
                            maybeForCond.put(fullCondName, thisMaybe);
                        }
                        if (!thisGlobal.isEmpty()) {
                            globalForCond.put(fullCondName, thisGlobal);
                        }
                    }
                    this.m_inCondMap.get(currJobId).add((String)fullCondName);
                    this.checkDuplicateInCondition((String)fullCondName, altOrEventName, eventName, altOrOrigJobName, trimmedCond);
                    if (jti.getJobId() != -2) {
                        if (!this.m_outCondMap.containsKey(jti.getJobId())) {
                            this.m_outCondMap.put(jti.getJobId(), new HashSet());
                        }
                        this.m_outCondMap.get(jti.getJobId()).add((String)fullCondName);
                    }
                    if (jti.refDate.trim().equals("*") && refDate.startsWith("*-")) {
                        adjustedOdat = String.format("-%03d", Integer.valueOf(refDate.substring(2).trim()));
                    }
                    if (refDate.trim().equals("*") && jti.refDate.startsWith("*+")) {
                        adjustedOdat = String.format("-%03d", Integer.valueOf(jti.refDate.substring(2).trim()));
                    }
                    if (tableName.equals(jti.tableName) && trimmedCond.equals(eventName.trim()) && refDate.equals(jti.refDate) && jobVer.equals(jti.jobVerId)) {
                        adjustedOdat = "PREV";
                    }
                    this.m_inOdatMap.get(currJobId).add(adjustedOdat);
                    if (!this.m_outOdatMap.containsKey(jti.getJobId())) {
                        this.m_outOdatMap.put(jti.getJobId(), new HashSet());
                    }
                    this.m_outOdatMap.get(jti.getJobId()).add("ODAT");
                }
            }
            if (!currLine.getAttr("EventType").equals("C")) continue;
            this.m_dsEventList.add(eventName + (String)lineVer);
        }
        if (isShortCondName) {
            Object newCondName = "";
            for (String condName : outCondLookup.keySet()) {
                newCondName = condName;
                if (maybeForCond.containsKey(condName)) {
                    newCondName = (String)maybeForCond.get(condName) + (String)newCondName;
                }
                if (globalForCond.containsKey(condName)) {
                    newCondName = (String)globalForCond.get(condName) + (String)newCondName;
                }
                if (condName.equals(newCondName)) continue;
                for (Integer jobId : (HashSet)outCondLookup.get(condName)) {
                    this.m_outCondMap.get(jobId).add((String)newCondName);
                    this.m_outCondMap.get(jobId).remove(condName);
                }
                for (Integer jobId : (HashSet)inCondLookup.get(condName)) {
                    this.m_inCondMap.get(jobId).add((String)newCondName);
                    this.m_inCondMap.get(jobId).remove(condName);
                }
            }
        }
        return scl.toString();
    }

    private void checkDuplicateInCondition(String fullCondName, String altOrEventName, String origEventName, String producerAltEventName, String producerOrigEventName) {
        String otherJob = this.allInConditions.get(fullCondName);
        if (otherJob != null && !otherJob.isEmpty()) {
            if (!altOrEventName.equals(origEventName) || !producerAltEventName.equals(producerOrigEventName)) {
                Reporter.addMessage(this.m_messages, (String)"WRN5030", (String)altOrEventName, (String[])new String[]{fullCondName, otherJob});
            }
        } else {
            this.allInConditions.put(fullCondName, altOrEventName);
        }
    }

    private void mapDates(IAttrHolder attrs) {
        String rawUdefs = attrs.getAttr("UDEF").trim();
        if (rawUdefs.isEmpty()) {
            return;
        }
        String key = attrs.getAttr("SCLmember") + "---" + attrs.getAttr("LibraryName");
        if (this.m_datesMap.get(key) != null) {
            return;
        }
        Pattern pattern = Pattern.compile("((UDEF[0-9A-Z])=)?([0-9]+).*");
        String dateFormat = this.m_rules.getStringRule("Jobtrac rules", new String[]{"DATE_FORMAT"});
        String[] calsArr = rawUdefs.split(";");
        HashMap tmpCal = new HashMap();
        for (int currCalInd = 0; currCalInd < calsArr.length; ++currCalInd) {
            String[] currCalDefs = calsArr[currCalInd].trim().split(":");
            String name = "";
            for (int i = 0; i < currCalDefs.length; ++i) {
                Matcher matcher = pattern.matcher(currCalDefs[i]);
                if (!matcher.matches()) continue;
                name = matcher.group(2) == null || matcher.group(2).isEmpty() ? name : matcher.group(2);
                String date = matcher.group(3);
                if (!tmpCal.containsKey(name)) {
                    tmpCal.put(name, new ArrayList());
                }
                Integer dateInt = Integer.valueOf(date);
                Integer monthInt = dateInt / 100;
                Integer dayInt = dateInt % 100;
                if (dateFormat.equals("ddmm")) {
                    Integer tmp = dayInt;
                    dayInt = monthInt;
                    monthInt = tmp;
                }
                if (GlobalFunctions.isValidDate((String)("2004" + (date = String.format("%02d%02d", monthInt, dayInt))), (String)"yyyyMMdd")) {
                    ((ArrayList)tmpCal.get(name)).add(date);
                    continue;
                }
                if (!this.m_jobMessages.containsKey(attrs.getAttr("SCLmember"))) {
                    this.m_jobMessages.put(attrs.getAttr("SCLmember"), new ArrayList());
                }
                Reporter.addMessage((List)this.m_jobMessages.get(attrs.getAttr("SCLmember")), (String)"WRN0006", (String)attrs.getAttr("SCLmember"), (String[])new String[]{"JOBTRAC", "ProcessPeriod", date, "DATE"});
            }
        }
        HashMap targetCals = new HashMap();
        for (String currCalName : tmpCal.keySet()) {
            if (((ArrayList)tmpCal.get(currCalName)).size() < 12) {
                targetCals.put(currCalName, (ArrayList)tmpCal.get(currCalName));
                continue;
            }
            Integer splitCount = 0;
            String splitKey = currCalName + "_" + splitCount.toString();
            for (int i = 0; i < ((ArrayList)tmpCal.get(currCalName)).size(); ++i) {
                if ((i + 1) % 12 == 0) {
                    Integer n = splitCount;
                    splitCount = splitCount + 1;
                    splitKey = currCalName + "_" + splitCount.toString();
                }
                if (!targetCals.containsKey(splitKey)) {
                    targetCals.put(splitKey, new ArrayList());
                }
                ((ArrayList)targetCals.get(splitKey)).add((String)((ArrayList)tmpCal.get(currCalName)).get(i));
            }
        }
        this.m_datesMap.put(key, targetCals);
    }

    public void mapSclMemToCurrFile(IAttrHolder toMap) {
        String key = toMap.getAttr("SCLmember") + "---" + toMap.getAttr("LibraryName");
        if (!this.m_member2LibMap.containsKey(toMap.getAttr("SCLmember"))) {
            this.m_member2LibMap.put(toMap.getAttr("SCLmember"), new HashSet());
        }
        this.m_member2LibMap.get(toMap.getAttr("SCLmember")).add(toMap.getAttr("LibraryName"));
        if (this.m_sclMemberMap == null) {
            this.m_sclMemberMap = new HashMap();
        }
        if (this.m_sclMemebers == null) {
            this.m_sclMemebers = new LinkedHashMap();
        }
        if (!this.m_sclMemberMap.containsKey(key) && this.isFiltered(toMap)) {
            String locId = toMap.getAttr("LocationID");
            if (locId.trim().isEmpty()) {
                locId = toMap.getAttr("@SETLOC");
            }
            String[] fakeAttrs = new String[]{Integer.toString(toMap.getAttrAsInt("JobID") * -1), toMap.getAttr("SCLmember"), key, locId, toMap.getAttr("R_SCHENV"), toMap.getAttr("BUSGRP")};
            this.m_sclMemberMap.put(key, this.m_loadedSclName);
            this.m_sclMemebers.put(key, fakeAttrs);
        }
    }

    private boolean isFiltered(IAttrHolder job) {
        boolean rc = false;
        boolean funcRC = false;
        boolean isInclude = this.m_rules.getFilterHandler().isInclude();
        boolean isOrCondition = this.m_rules.getFilterHandler().isOr();
        ArrayList filterConds = this.m_rules.getFilterHandler().getConditions();
        if (filterConds.isEmpty() || filterConds == null) {
            return true;
        }
        for (Map.Entry entry : filterConds) {
            String field = (String)entry.getKey();
            field = this.getJobTracField(field);
            String regVal = (String)entry.getValue();
            String jobVal = job.getAttr(field);
            if (field.equalsIgnoreCase("LocationID")) {
                if (jobVal.isEmpty()) {
                    jobVal = job.getAttr("@SETLOC");
                }
                if (!(regVal.contains("?") || regVal.contains("*") || regVal.isEmpty() || regVal.length() >= 3)) {
                    regVal = GlobalFunctions.addLeadingCharacters((String)regVal, (String)"0", (int)3);
                }
            }
            if (funcRC = GlobalFunctions.matchWildcard((String)jobVal, (String)regVal)) {
                if (isOrCondition) {
                    rc = true;
                    break;
                }
                rc = true;
                continue;
            }
            if (isOrCondition) {
                rc = false;
                continue;
            }
            rc = false;
            break;
        }
        if (isInclude) {
            return rc;
        }
        return !rc;
    }

    private String getJobTracField(String field) {
        if (field.equalsIgnoreCase("LOCATION")) {
            field = "LocationID";
        }
        return field;
    }

    public String getLoadedSclName() {
        return this.m_loadedSclName;
    }

    public AttrHolderList getLoadedScl() {
        return this.m_loadedScl;
    }

    public String getParentName(IAttrHolder sclEntry) {
        return sclEntry.getAttr("SCLmember");
    }

    public void applyFilter(String root) {
    }

    public void createDependencies(String root) {
    }

    public Set<Properties> createTags(String root) {
        return null;
    }

    public void finalize_() {
    }

    public AttrHolderList getChildren(String parentEntityId) {
        return null;
    }

    public String getEntNameFieldName() {
        return "EVENTNM";
    }

    public String getIdFieldName() {
        return "FAKE_TABLE_NAME";
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        JobtracJob tmpJob = (JobtracJob)job;
        ArrayList<Properties> toRet = new ArrayList<Properties>();
        HashSet<String> usedResources = new HashSet<String>();
        if (tmpJob != null && job.type() == SchedEntity.TYPE.JOB) {
            Properties tmpProperties;
            String sEventName = job.getOriginalJobName();
            ArrayList<String> tempList = null;
            tempList = this.m_exclConvertor.getResourcesListOfEvent(sEventName, "EXCLUSIVE");
            if (null != tempList) {
                for (String sRes : tempList) {
                    if (usedResources.contains(sRes)) continue;
                    tmpProperties = new Properties();
                    tmpProperties.put("NAME", sRes);
                    tmpProperties.put("ONFAIL", "R");
                    tmpProperties.put("TYPE", "E");
                    toRet.add(tmpProperties);
                    usedResources.add(sRes);
                }
            }
            if (null != (tempList = this.m_exclConvertor.getResourcesListOfEvent(sEventName, "SHARED"))) {
                for (String sRes : tempList) {
                    if (usedResources.contains(sRes)) continue;
                    tmpProperties = new Properties();
                    tmpProperties.put("NAME", sRes);
                    tmpProperties.put("ONFAIL", "R");
                    tmpProperties.put("TYPE", "S");
                    toRet.add(tmpProperties);
                    usedResources.add(sRes);
                }
            }
            return toRet;
        }
        return null;
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        JobtracJob tmpJob = (JobtracJob)job;
        ArrayList<Properties> toRet = new ArrayList<Properties>();
        if (tmpJob != null) {
            String ver = tmpJob.getSclAttrAsStr("EventVersion");
            while (ver.startsWith("0")) {
                ver = ver.substring(1);
            }
            Integer jobId = Integer.valueOf(tmpJob.getSclAttrAsStr("JobID"));
            String tempOdat = "";
            if (this.m_inOdatMap.containsKey(jobId)) {
                Iterator<String> iterator = this.m_inOdatMap.get(jobId).iterator();
                while (iterator.hasNext()) {
                    String currOdat;
                    tempOdat = currOdat = iterator.next();
                }
            }
            if (this.m_inCondMap.containsKey(jobId)) {
                for (String currPredCond : this.m_inCondMap.get(jobId)) {
                    Properties tmpProperties = new Properties();
                    tmpProperties.put("AND_OR", "AND");
                    tmpProperties.put("NAME", currPredCond);
                    tmpProperties.put("ODATE", tempOdat);
                    toRet.add(tmpProperties);
                }
            }
        }
        return toRet;
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        JobtracJob tmpJob = (JobtracJob)job;
        ArrayList<Properties> toRet = new ArrayList<Properties>();
        if (tmpJob != null) {
            Integer jobId = Integer.valueOf(tmpJob.getSclAttrAsStr("JobID"));
            String ver = tmpJob.getSclAttrAsStr("EventVersion");
            String tempOdat = "";
            while (ver.startsWith("0")) {
                ver = ver.substring(1);
            }
            if (this.m_outOdatMap.containsKey(jobId)) {
                Iterator<String> iterator = this.m_outOdatMap.get(jobId).iterator();
                while (iterator.hasNext()) {
                    String currOdat;
                    tempOdat = currOdat = iterator.next();
                }
            }
            if (this.m_outCondMap.containsKey(jobId)) {
                for (String currSuccCond : this.m_outCondMap.get(jobId)) {
                    Properties tmpProperties = new Properties();
                    tmpProperties.put("NAME", currSuccCond.trim());
                    tmpProperties.put("ODATE", tempOdat);
                    tmpProperties.put("SIGN", "ADD");
                    toRet.add(tmpProperties);
                }
            }
        }
        return toRet;
    }

    public String getParentEntFieldName() {
        return null;
    }

    public AttrHolderList getTopLevelEntities() {
        AttrHolderList toRet = new AttrHolderList();
        List<Pair<String, String>> globalVariableList = this.getDsTrigGlobalVariables();
        for (String currSclMem : this.m_sclMemebers.keySet()) {
            String[] fakeVals = this.m_sclMemebers.get(currSclMem);
            AttrHolder fakeAttrHolder = new AttrHolder(fakeVals, m_fakeTableAttrHeader);
            toRet.add((Object)fakeAttrHolder);
        }
        if (!globalVariableList.isEmpty()) {
            toRet.add((Object)new AttrHolder(new String[]{"0", "DSTRGSET", "DSTRGSET", "", "", "DSTRGSET"}, m_fakeTableAttrHeader));
            Object[] values = new String[JobTracGlobals.SCL_HEADERS.length];
            Arrays.fill(values, "");
            Map<String, Integer> attrToIndex = Stream.of(JobTracGlobals.SCL_HEADERS).collect(Collectors.toMap(attr -> attr, attr -> JobTracGlobals.getIndexOfHeaderInCSV("SCL", attr)));
            AttrHolder attrHolder = new AttrHolder((String[])values, attrToIndex);
            attrHolder.appendAttr("SCLmember", "DSTRGSET");
            attrHolder.appendAttr("JobID", "0");
            this.m_loadedScl.add((Object)attrHolder);
        }
        return toRet;
    }

    @NotNull
    public List<Pair<String, String>> getDsTrigGlobalVariables() {
        return this.m_loadedScl.stream().map(attr -> new Pair((Object)attr.getAttr("EVENTNM").trim(), (Object)attr.getAttr("DataSetCount").trim())).filter(pair -> !((String)pair.getKey()).isEmpty() && !((String)pair.getValue()).isEmpty()).collect(Collectors.toList());
    }

    public boolean hasChildren(String entId) {
        return this.m_sclMemberMap.containsKey(entId);
    }

    public void init() throws ConvertorCancelClickException {
        this.convertNonJobEntities();
    }

    private void convertNonJobEntities() throws ConvertorCancelClickException {
        String jmf_file = Params.instance().getDatasourcePath() + "JMF.JMF";
        String adi_file = Params.instance().getDatasourcePath() + "ADI.ADI";
        String jmf_jcl = Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "JMF.JCL";
        String adi_jcl = Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "ADI.JCL";
        String inclib = this.m_rules.getStringRule("Mainframe", new String[]{"INCLIB"});
        String filePath = Params.instance().getDatasourcePath();
        String sMaxCC = this.m_rules.getStringRule("Mainframe", new String[]{"MAXCC"});
        String cTMPARM = this.m_rules.getStringRule("Mainframe", new String[]{"CTMPARM"});
        this.m_ccpfConvertor = new CCPFConvertor(filePath + "CCPF_Tables.csv", filePath + "MergedJCLs.csv", Integer.parseInt(sMaxCC));
        ArrayList<String> messagesList = null;
        if (null != this.m_ccpfConvertor) {
            this.m_ccpfConvertor.doConversion();
            messagesList = this.m_ccpfConvertor.getMessages();
        }
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream jSCSFoutputStream = new ByteArrayOutputStream();
        StringBuilder builder = new StringBuilder();
        String line = null;
        try {
            FileReader fileReader = new FileReader(filePath + "CCPF_Tables.csv");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line + "\n");
            }
            bufferedReader.close();
            fileReader.close();
            inputStream = new ByteArrayInputStream(builder.toString().getBytes());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to open file '" + filePath + "CCPF_Tables.csv'");
        }
        catch (IOException ex) {
            System.out.println("Error reading file '" + filePath + "CCPF_Tables.csv'");
        }
        this.m_ccpfJSCSFConvertor = new CCPFToJSCSFConvertor(inputStream, jSCSFoutputStream, Integer.parseInt(sMaxCC), cTMPARM);
        if (null != this.m_ccpfJSCSFConvertor) {
            CardCreatorJCLForMF cardsCreatorForJCL;
            String sJCLLib;
            try {
                this.m_ccpfJSCSFConvertor.doConversion();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.isTaskCancelled()) {
                throw new ConvertorCancelClickException();
            }
            try {
                JobtracJMFConvertor jmf = new JobtracJMFConvertor(jmf_file, jmf_jcl, inclib, jSCSFoutputStream);
                jmf.convert();
                if (this.isTaskCancelled()) {
                    throw new ConvertorCancelClickException();
                }
                ArrayList<String> jmf_messages = jmf.getMessages();
                for (String jmf_msg : jmf_messages) {
                    this.m_messages.add(jmf_msg);
                }
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
            try {
                JobtracADIConvertor adi = new JobtracADIConvertor(adi_file, adi_jcl, inclib);
                adi.convert();
                if (this.isTaskCancelled()) {
                    throw new ConvertorCancelClickException();
                }
                ArrayList<String> adi_messages = adi.getMessages();
                for (String adi_msg : adi_messages) {
                    this.m_messages.add(adi_msg);
                }
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
            if (this.isTaskCancelled()) {
                throw new ConvertorCancelClickException();
            }
            this.TranslateMembers();
            if (this.isTaskCancelled()) {
                throw new ConvertorCancelClickException();
            }
            try {
                this.concatEnvJCLFiles();
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
            String sChange = "<CHANGE-THIS>";
            String sUser = this.m_rules.getStringRule("Mainframe", new String[]{"USER"});
            if (null == sUser) {
                sUser = sChange;
            }
            if (null == (sJCLLib = this.m_rules.getStringRule("Mainframe", new String[]{"RUNJCLLIBRARY"}))) {
                sJCLLib = sChange;
            }
            String sIOAENV = this.m_rules.getStringRule("Mainframe", new String[]{"IOAENV"});
            if (this.isTaskCancelled()) {
                throw new ConvertorCancelClickException();
            }
            ArrayList<String> configParameters = new ArrayList<String>();
            if (null != sUser) {
                configParameters.add(sUser);
            }
            if (null != sJCLLib) {
                configParameters.add(sJCLLib);
            }
            if (null != sIOAENV) {
                configParameters.add(sIOAENV);
            }
            CardsFileConvertorAbstract convertorToCards = new CardsFileConvertorControlO();
            ArrayList<char[]> cardsListRESOURCE = null;
            ArrayList<char[]> cardsListADR = null;
            ArrayList<char[]> cardsListAMR = null;
            ArrayList<char[]> cardsListSCS = null;
            cardsListADR = convertorToCards.doConversion(filePath + "ADR_Tables.csv", "ADR", configParameters);
            if (null != cardsListADR) {
                convertorToCards.writeCardsToFile(filePath + "Cards_ADR_ASCII.txt", 0, cardsListADR);
                convertorToCards.writeCardsToFile(filePath + "Cards_ADR_EBCDIC.txt", 1, cardsListADR);
            }
            if (null != (messagesList = convertorToCards.getMessages()) && messagesList.size() > 0) {
                this.m_messages.addAll(messagesList);
            }
            if (this.isTaskCancelled()) {
                throw new ConvertorCancelClickException();
            }
            cardsListSCS = convertorToCards.doConversion(filePath + "SCS_Tables.csv", "SCS", configParameters);
            if (null != cardsListSCS) {
                convertorToCards.writeCardsToFile(filePath + "Cards_SCS_ASCII.txt", 0, cardsListSCS);
                convertorToCards.writeCardsToFile(filePath + "Cards_SCS_EBCDIC.txt", 1, cardsListSCS);
            }
            if (this.isTaskCancelled()) {
                throw new ConvertorCancelClickException();
            }
            messagesList = convertorToCards.getMessages();
            if (null != messagesList && messagesList.size() > 0) {
                this.m_messages.addAll(messagesList);
            }
            if (this.isTaskCancelled()) {
                throw new ConvertorCancelClickException();
            }
            cardsListAMR = convertorToCards.doConversion(filePath + "AMR_Tables.csv", "AMR", configParameters);
            if (null != cardsListAMR) {
                convertorToCards.writeCardsToFile(filePath + "Cards_AMR_ASCII.txt", 0, cardsListAMR);
                convertorToCards.writeCardsToFile(filePath + "Cards_AMR_EBCDIC.txt", 1, cardsListAMR);
            }
            if (null != (messagesList = convertorToCards.getMessages()) && messagesList.size() > 0) {
                this.m_messages.addAll(messagesList);
            }
            convertorToCards = null;
            convertorToCards = new CardsFileConvertorCMEM();
            if (null != convertorToCards) {
                cardsListRESOURCE = convertorToCards.doConversion(filePath + "RESOURCE_Table.csv", "RES", configParameters);
                if (null != cardsListRESOURCE) {
                    convertorToCards.writeCardsToFile(filePath + "Cards_RES_ASCII.txt", 0, cardsListRESOURCE);
                    convertorToCards.writeCardsToFile(filePath + "Cards_RES_EBCDIC.txt", 1, cardsListRESOURCE);
                }
                if (null != (messagesList = convertorToCards.getMessages()) && messagesList.size() > 0) {
                    this.m_messages.addAll(messagesList);
                }
            }
            if (null != (cardsCreatorForJCL = new CardCreatorJCLForMF())) {
                String sCO;
                String sCMEM = this.m_rules.getStringRule("Mainframe", new String[]{"CMEM"});
                if (null == sCMEM) {
                    sCMEM = sChange;
                }
                if (null == (sCO = this.m_rules.getStringRule("Mainframe", new String[]{"CTODSN"}))) {
                    sCO = sChange;
                }
                String sJobCard = this.m_rules.getStringRule("Mainframe", new String[]{"JOBCARD"});
                cardsCreatorForJCL.insertCards(sJobCard, sCO, sCMEM, cardsListADR, cardsListAMR, cardsListSCS, cardsListRESOURCE);
                cardsCreatorForJCL.writeDataToFile(Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "Cards_All_ASCII.txt", 0);
                cardsCreatorForJCL.writeDataToFile(Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "Cards_All_EBCDIC.Rules", 1);
            }
            if (null != cardsListADR) {
                cardsListADR.clear();
                cardsListADR = null;
            }
            if (null != cardsListAMR) {
                cardsListAMR.clear();
                cardsListAMR = null;
            }
            if (null != cardsListSCS) {
                cardsListSCS.clear();
                cardsListSCS = null;
            }
            if (null != cardsListRESOURCE) {
                cardsListRESOURCE.clear();
                cardsListRESOURCE = null;
            }
            if (this.isTaskCancelled()) {
                throw new ConvertorCancelClickException();
            }
            this.m_exclConvertor = new EXCLPARMConvertor(filePath + "EXC.EXC");
            if (null != this.m_exclConvertor) {
                this.m_exclConvertor.doConversion();
                messagesList = this.m_exclConvertor.getMessages();
                if (null != messagesList && messagesList.size() > 0) {
                    this.m_messages.addAll(messagesList);
                }
            }
            this.m_resTable = new CSVReaderRESOURCE();
            if (null != this.m_resTable) {
                String resFile = Params.instance().getDatasourcePath() + "RESOURCE_Table.csv";
                if (this.m_resTable.loadTableFile(resFile)) {
                    this.mapResTable();
                } else {
                    this.m_resTable = null;
                }
            }
            if (null != messagesList && messagesList.size() > 0) {
                this.m_messages.addAll(messagesList);
            }
        }
    }

    private void TranslateMembers() throws ConvertorCancelClickException {
        String fileNamePrefix = "";
        String datasourcePath = Params.instance().getDatasourcePath();
        File dataSourceFolder = new File(datasourcePath);
        File dataDestnationFolder = new File(Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "JCLlibs");
        dataDestnationFolder.mkdir();
        File[] files = dataSourceFolder.listFiles();
        String inclib = this.m_rules.getStringRule("Mainframe", new String[]{"INCLIB"});
        JobtracJCLtoCreateCopyMembers JCLCreator = null;
        String jclCreatorFileName = Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "JCLPROC.JCL";
        if (this.m_rules.getBooleanRule("Mainframe", new String[]{"ALTERNATE_LIBRARIES"}).booleanValue()) {
            fileNamePrefix = this.m_rules.getStringRule("Mainframe", new String[]{"PREFIX"}).concat(".");
        }
        try {
            JCLCreator = new JobtracJCLtoCreateCopyMembers(jclCreatorFileName, this.m_rules);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        for (File currFile : files) {
            if (this.isTaskCancelled()) {
                throw new ConvertorCancelClickException();
            }
            if (!currFile.getName().startsWith("JCL_")) continue;
            StringBuilder sb = new StringBuilder();
            int index = currFile.getName().indexOf("_") + 1;
            sb.append(String.valueOf(dataDestnationFolder) + Globs.DIRSEP);
            sb.append(fileNamePrefix);
            sb.append(currFile.getName().substring(index, currFile.getName().length()));
            sb.append(".OUT");
            String membersFileNameOutput = sb.toString();
            File outputFile = new File(membersFileNameOutput);
            try {
                outputFile.createNewFile();
            }
            catch (IOException e1) {
                ExceptionHandler.writeToExceptionFile((Exception)e1);
            }
            String membersFileNameInput = currFile.getAbsolutePath();
            JobtracMemberModifier MemberModifier = null;
            try {
                MemberModifier = new JobtracMemberModifier(membersFileNameInput, new FileInputStream(membersFileNameInput), new PrintStream(membersFileNameOutput, DraftFormat.getDraftCharSet()), inclib, JobtracMemberModifier.MemberAction.ALL, this.m_rules, this);
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
            MemberModifier.modifyMembers();
            HashMap<String, ArrayList<String>> tempMessages = MemberModifier.getM_jobMessages();
            if (tempMessages != null) {
                for (String tempJobname : tempMessages.keySet()) {
                    if (!this.m_jobMessages.containsKey(tempJobname)) {
                        this.m_jobMessages.put(tempJobname, tempMessages.get(tempJobname));
                    } else {
                        this.m_jobMessages.get(tempJobname).addAll((Collection<String>)tempMessages.get(tempJobname));
                    }
                    this.m_messages.addAll((Collection<String>)tempMessages.get(tempJobname));
                }
            }
            String targetJclLib = fileNamePrefix + currFile.getName().substring(index, currFile.getName().length());
            String sourceJclLib = targetJclLib + ".OUT";
            JCLCreator.appendJCLStep(sourceJclLib, targetJclLib);
        }
    }

    private void concatEnvJCLFiles() throws IOException, ConvertorCancelClickException {
        File dir = new File(Globs.TEMP_EVALUATION_DIR);
        String envJclName = Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + Params.instance().getDatasourceName() + ".JCL";
        String jobcard = this.m_rules.getStringRule("Mainframe", new String[]{"JOBCARD"});
        if (GlobalFunctions.isFileExist((String)envJclName)) {
            File tmpFile = new File(envJclName);
            tmpFile.delete();
        }
        File[] fileList = dir.listFiles();
        PrintStream envJclFile = new PrintStream(envJclName, DraftFormat.getDraftCharSet());
        envJclFile.println(jobcard);
        for (int i = 0; i < fileList.length; ++i) {
            if (this.isTaskCancelled()) {
                envJclFile.close();
                throw new ConvertorCancelClickException();
            }
            String currFileName = fileList[i].getName();
            if (!fileList[i].isFile() || !currFileName.endsWith(".JCL")) continue;
            FileInputStream currFile = new FileInputStream(fileList[i].getAbsolutePath());
            Scanner sc = new Scanner((InputStream)currFile, DraftFormat.getDraftCharSet());
            while (sc.hasNext()) {
                envJclFile.println(sc.nextLine());
            }
            sc.close();
            currFile.close();
            fileList[i].delete();
        }
        envJclFile.close();
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return entAttr.isFieldExist("FAKE_TABLE_NAME");
    }

    public boolean isStandAloneGrouped() {
        return false;
    }

    public SchedEntity spawnJob(String table, IAttrHolder sclAttributes) {
        String fakeTableName;
        if (table.isEmpty() || table == null) {
            table = sclAttributes.isFieldExist("FAKE_TABLE_NAME") ? sclAttributes.getAttr("FAKE_TABLE_NAME") : this.getParentName(sclAttributes);
        }
        if (!this.m_loadedSclName.equals(this.m_sclMemberMap.get(fakeTableName = sclAttributes.getAttr("FAKE_TABLE_FULL_NAME"))) && !fakeTableName.equals("DSTRGSET")) {
            this.m_loadedScl = new AttrHolderList();
            this.m_sclTable.load(Params.instance().getDatasourcePath() + this.m_sclMemberMap.get(fakeTableName));
            this.m_loadedSclName = this.m_sclMemberMap.get(fakeTableName);
        }
        return new JobtracJob(table, sclAttributes, this);
    }

    public SchedEntity spawnJob(SchedEntity parent, IAttrHolder sclAttributes) {
        return new JobtracJob(parent, this.getAtrsListById(sclAttributes.getAttrAsInt("JobID")), this);
    }

    private AttrHolderList getAtrsListById(int id) {
        AttrHolderList toRet = null;
        for (IAttrHolder currAttrs : this.m_loadedScl) {
            if (currAttrs.getAttrAsInt("JobID") != id) continue;
            if (toRet == null) {
                toRet = new AttrHolderList();
            }
            toRet.add((Object)currAttrs);
        }
        return toRet;
    }

    public AttrHolderList getAtrsListByNameValue(String attribute, String value) {
        AttrHolderList toRet = null;
        for (IAttrHolder currAttrs : this.m_loadedScl) {
            if (!currAttrs.getAttr(attribute).equals(value)) continue;
            if (toRet == null) {
                toRet = new AttrHolderList();
            }
            toRet.add((Object)currAttrs);
        }
        return toRet;
    }

    public ArrayList<String> getGeneralMessages() {
        return this.m_messages;
    }

    public HashMap<String, ArrayList<String>> getCals(String key) {
        return this.m_datesMap.get(key);
    }

    public Properties getResEntryByName(String resName) {
        Properties toRet = null;
        if (this.m_resTable != null) {
            String event = this.m_resTable.getEventNameByResource(resName);
            String rule = this.m_resTable.getRuleTypeByResource(resName);
            String operation = this.m_resTable.getOperationTypeByResource(resName);
            if (rule != null && !rule.isEmpty()) {
                toRet = new Properties();
                toRet.put("RES_KEY_EVENT_NAME", event == null ? "" : event);
                toRet.put("RES_KEY_OPERATION_TYPE", operation == null ? "" : operation);
                toRet.put("RES_KEY_RULE_TYPE", rule);
            }
        }
        return toRet;
    }

    private void mapResTable() throws ConvertorCancelClickException {
        ArrayList<ArrayList<String>> fullTab = this.m_resTable.getAllData();
        if (fullTab == null) {
            return;
        }
        for (ArrayList<String> line : fullTab) {
            ArrayList<String> tmpList;
            if (this.isTaskCancelled()) {
                throw new ConvertorCancelClickException();
            }
            if (line.size() < 3) continue;
            if (line.get(1).equals("NOJOB")) {
                if (this.m_noJobRes == null) {
                    this.m_noJobRes = new HashMap();
                }
                if ((tmpList = this.m_noJobRes.get(line.get(2).trim())) == null) {
                    tmpList = new ArrayList();
                }
                tmpList.add(line.get(0).trim());
                this.m_noJobRes.put(line.get(2).trim(), tmpList);
            }
            if (!line.get(1).equals("JOB")) continue;
            if (this.m_jobRes == null) {
                this.m_jobRes = new HashMap();
            }
            if ((tmpList = this.m_jobRes.get(line.get(2).trim())) == null) {
                tmpList = new ArrayList();
            }
            tmpList.add(line.get(0).trim());
            this.m_jobRes.put(line.get(2).trim(), tmpList);
        }
    }

    public ArrayList<String> getMappedNoJob(String name) {
        if (this.m_noJobRes != null) {
            return this.m_noJobRes.get(name);
        }
        return null;
    }

    public ArrayList<String> getMappedJobRes(String name) {
        if (this.m_jobRes != null) {
            return this.m_jobRes.get(name);
        }
        return null;
    }

    public boolean isGlobCond(String condName) {
        String[] condFragmants = condName.split("_");
        if (condFragmants.length != 2) {
            return false;
        }
        return this.m_dsEventList.contains(condFragmants[0]) ^ this.m_dsEventList.contains(condFragmants[1]);
    }

    private boolean isTaskCancelled() {
        return this.m_progressBar != null && this.m_progressBar.getTask().isCancelled();
    }

    public HashSet<String> getDuplicateTables(String table) {
        return this.m_member2LibMap.remove(table);
    }

    public ArrayList<String> getJobMessages(String jobname) {
        return this.m_jobMessages.get(jobname);
    }

    public String GlobPref(boolean IsDSJob1, boolean IsDSJob2, boolean clearConds, String GlobPrefixM2D, String GlobPrefixD2M, String GlobPrefixMandD) {
        String RetVal = "";
        if (IsDSJob1 & !IsDSJob2) {
            RetVal = clearConds ? GlobPrefixMandD : GlobPrefixD2M;
        } else if (!IsDSJob1 & IsDSJob2) {
            RetVal = clearConds ? GlobPrefixMandD : GlobPrefixM2D;
        }
        return RetVal;
    }

    private class jobTableId {
        private String tableName;
        private int jobId;
        private String procPer;
        private String refDate;
        private String lineVerId;
        private String jobVerId;
        private boolean IsDSJob;

        public jobTableId(JobtracDefs jobtracDefs, String tableName, int jobId, String procPer, String refDate, String lineVerId, String jobVerId, boolean IsDSJob) {
            this.tableName = tableName;
            this.jobId = jobId;
            this.procPer = procPer;
            this.refDate = refDate;
            this.lineVerId = lineVerId;
            this.jobVerId = jobVerId;
            this.IsDSJob = IsDSJob;
        }

        public String getTableName() {
            return this.tableName;
        }

        public int getJobId() {
            return this.jobId;
        }

        public boolean IsDS() {
            return this.IsDSJob;
        }
    }
}

