/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.draftwriter.DraftFormat;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;

public class JobTracInputFileParser {
    private final ArrayList<String> m_listOfOutPutFiles = new ArrayList();
    private String m_sInFileName = "";
    private String m_sOutPathName = "";
    private BaseProgressBar m_progressBar = null;

    public JobTracInputFileParser(String inFileName, String outPathName) {
        this.initFields(inFileName, outPathName);
    }

    public JobTracInputFileParser(String inFileName, String outPathName, BaseProgressBar progressBar) {
        this.initFields(inFileName, outPathName);
        this.m_progressBar = progressBar;
    }

    private void initFields(String inFileName, String outPathName) {
        this.m_sInFileName = inFileName;
        this.m_sOutPathName = outPathName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SplitJobTracFile() throws ConvertorCancelClickException {
        File dir = new File(this.m_sOutPathName);
        if (!dir.exists() && !dir.mkdir()) {
            ExceptionHandler.writeToExceptionFile((String)"Error in JobTracInputFileParser Constructor");
            ExceptionHandler.writeToExceptionFile((String)("Output directory does not exist or couldn't be created: " + this.m_sOutPathName));
            return false;
        }
        int iLinesCount = 0;
        int iLineNumberInFile = 0;
        int iMaxLines = JobTracGlobals.MaxBufferLines;
        StringBuilder contents = new StringBuilder();
        File file = new File(this.m_sInFileName);
        BufferedWriter writer = null;
        String text = null;
        Object tempFileName = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(file, DraftFormat.getDraftCharSet()));){
            while ((text = reader.readLine()) != null) {
                if (this.m_progressBar != null && this.m_progressBar.isCancelled()) {
                    throw new ConvertorCancelClickException();
                }
                if ((text = text.replaceAll("\u0000", "")).startsWith("CTMCNV ")) {
                    String prefixType;
                    iLineNumberInFile = 0;
                    if (null != writer) {
                        if (!contents.isEmpty()) {
                            writer.write(contents.toString());
                            contents.setLength(0);
                            iLinesCount = 0;
                        }
                        writer.close();
                    }
                    tempFileName = (prefixType = this.getPrefixType(text)).startsWith("EXC") ? "EXC.EXC" : (prefixType.startsWith("RES") ? "RES.RES" : (prefixType.equals("JMF") ? "JMF.JMF" : (prefixType.equals("PRODDATE") ? "ADI.ADI" : prefixType + "_" + text.split("=")[1].trim())));
                    writer = new BufferedWriter(new FileWriter(this.m_sOutPathName + Globs.DIRSEP + (String)tempFileName, DraftFormat.getDraftCharSet()));
                    this.m_listOfOutPutFiles.add((String)tempFileName);
                    continue;
                }
                ++iLineNumberInFile;
                ++iLinesCount;
                if (!text.isEmpty()) {
                    contents.append(text);
                    contents.append(JobTracGlobals.NewLine);
                }
                if (iLinesCount < iMaxLines || null == writer) continue;
                writer.write(contents.toString());
                contents.setLength(0);
                iLinesCount = 0;
            }
            if (!contents.isEmpty() && null != writer) {
                writer.write(contents.toString());
                writer.close();
                contents.setLength(0);
            }
            if (null != writer) {
                writer.close();
            }
        }
        catch (ConvertorCancelClickException e) {
            throw e;
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in JobTracInputFileParser Constructor");
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading or writing a file : " + String.valueOf(e)));
            ExceptionHandler.writeToExceptionFile((String)("In file : " + tempFileName));
            ExceptionHandler.writeToExceptionFile((String)("In Line : " + iLineNumberInFile));
            ExceptionHandler.writeToExceptionFile((String)("Line contents: " + text));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((String)"Error in JobTracInputFileParser Constructor");
                ExceptionHandler.writeToExceptionFile((String)("Exception while closing a file : " + String.valueOf(e)));
                return false;
            }
        }
        return true;
    }

    public ArrayList<String> getListOfOutputFileNames() {
        return this.m_listOfOutPutFiles;
    }

    private String getPrefixType(String line) {
        String sTemp = line.split(" LIB=")[0];
        return sTemp.split(" ")[1];
    }
}

