/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Reporter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;

public class EXCLPARMConvertor {
    public static final String EXCLUSIVE = "EXCLUSIVE";
    public static final String SHARED = "SHARED";
    private ArrayList<String> m_declaredEventsList = new ArrayList();
    private ArrayList<String> m_declaredEventsPrefixList = new ArrayList();
    private HashMap<String, HashMap<String, ArrayList<String>>> m_eventID_mapEventsID = new HashMap();
    private ArrayList<String> m_errorMessagesList = new ArrayList();
    private ArrayList<String> m_alreadyFoundLinesList = new ArrayList();
    private HashMap<Integer, String> m_EntryID_EXCLPARM = new HashMap();
    private int m_iEntryID = 0;

    public EXCLPARMConvertor(String sourceFile) {
        this.readEntries(sourceFile);
    }

    public ArrayList<String> getMessages() {
        return this.m_errorMessagesList;
    }

    private ArrayList<String> listOfEventAppearances(String sEventName) {
        ArrayList<String> resList = new ArrayList<String>();
        if (this.m_declaredEventsList.contains(sEventName)) {
            resList.add(sEventName);
        }
        for (String sEventPrefix : this.m_declaredEventsPrefixList) {
            String sEventWithoutPrefix = sEventPrefix.substring(0, sEventPrefix.length() - 1);
            if (!sEventName.startsWith(sEventWithoutPrefix)) continue;
            resList.add(sEventPrefix);
        }
        return resList.size() == 0 ? null : resList;
    }

    public ArrayList<String> getResourcesListOfEvent(String sEventName, String sType) {
        ArrayList<String> eventApperanceList = this.listOfEventAppearances(sEventName);
        if (null == eventApperanceList) {
            return null;
        }
        ArrayList<String> sResultList = new ArrayList<String>();
        ArrayList<String> resourcesList = null;
        for (String sEventWithPrefix : eventApperanceList) {
            HashMap<String, ArrayList<String>> mapOfEvent = this.m_eventID_mapEventsID.get(sEventWithPrefix);
            if (null == mapOfEvent || null == (resourcesList = mapOfEvent.get(sType))) continue;
            for (String sRes : resourcesList) {
                if (sRes.equals("*") || sResultList.contains(sRes)) continue;
                sResultList.add(sRes);
            }
        }
        return sResultList;
    }

    private void readEntries(String sourceFile) {
        try {
            FileInputStream sourceStream = new FileInputStream(sourceFile);
            Scanner sourceScanner = new Scanner(sourceStream);
            StringBuilder currVal = new StringBuilder();
            String line = null;
            String sFirstEventName = "";
            String[] listOfEvents = null;
            while (sourceScanner.hasNext()) {
                line = sourceScanner.nextLine().trim();
                if (line.startsWith("*")) continue;
                if (line.startsWith("(")) {
                    ++this.m_iEntryID;
                    listOfEvents = line.split(",");
                    if (listOfEvents.length > 1) {
                        sFirstEventName = listOfEvents[0].replaceAll("\\(", "");
                    } else {
                        sFirstEventName = listOfEvents[0].replaceAll("\\(", "");
                        sFirstEventName = sFirstEventName.replaceAll("\\)", "");
                    }
                }
                currVal.append(line);
                if (!line.endsWith(")")) continue;
                if (!this.m_alreadyFoundLinesList.contains(currVal.toString())) {
                    this.m_EntryID_EXCLPARM.put(this.m_iEntryID, currVal.toString());
                    this.m_alreadyFoundLinesList.add(currVal.toString());
                } else {
                    Reporter.addMessage(this.m_errorMessagesList, (String)"WRN5007", (String)"$$$_EXC", (String[])new String[]{"EXC", currVal.toString()});
                }
                sFirstEventName = "";
                currVal.setLength(0);
            }
            sourceStream.close();
            sourceScanner.close();
        }
        catch (IOException ioe) {
            ExceptionHandler.writeToExceptionFile((String)("Error - EXCLPARMConvertor - readEntries " + String.valueOf(ioe)));
        }
    }

    public void doConversion() {
        String sLine = null;
        String tempLine = null;
        String sEventAT = null;
        String sEventAS = null;
        String[] listOfEvents = null;
        int iPrefixCounterAT = 0;
        int iPrefixCounterAS = 0;
        HashMap<String, ArrayList<String>> mapResourcesOfEvent = null;
        ArrayList<String> sharedResourcesOfEvent = null;
        ArrayList<String> exclusiveResourcesOfEvent = null;
        for (Integer entryID : this.m_EntryID_EXCLPARM.keySet()) {
            sLine = this.m_EntryID_EXCLPARM.get(entryID);
            if (null != sLine) {
                tempLine = sLine.replaceAll("\\(", "");
                tempLine = tempLine.replaceAll("\\)", "");
                listOfEvents = tempLine.split(",");
            }
            if (listOfEvents.length == 1) {
                if (!listOfEvents[0].endsWith("*")) continue;
                if (!this.m_declaredEventsPrefixList.contains(listOfEvents[0])) {
                    this.m_declaredEventsPrefixList.add(listOfEvents[0]);
                }
                if (null == (mapResourcesOfEvent = this.m_eventID_mapEventsID.get(listOfEvents[0]))) {
                    mapResourcesOfEvent = new HashMap();
                }
                if (null == (exclusiveResourcesOfEvent = mapResourcesOfEvent.get(EXCLUSIVE))) {
                    exclusiveResourcesOfEvent = new ArrayList();
                }
                if (!exclusiveResourcesOfEvent.contains(listOfEvents[0])) {
                    exclusiveResourcesOfEvent.add(listOfEvents[0]);
                }
                mapResourcesOfEvent.put(EXCLUSIVE, exclusiveResourcesOfEvent);
                this.m_eventID_mapEventsID.put(listOfEvents[0], mapResourcesOfEvent);
                mapResourcesOfEvent = new HashMap();
                continue;
            }
            for (int i = 0; i <= listOfEvents.length - 2; ++i) {
                for (int j = i + 1; j <= listOfEvents.length - 1; ++j) {
                    String[] pairOfEvents = new String[]{listOfEvents[i], listOfEvents[j]};
                    iPrefixCounterAT = 0;
                    iPrefixCounterAS = 0;
                    for (String sEvent : pairOfEvents) {
                        if (sEvent.endsWith("@")) {
                            ++iPrefixCounterAT;
                            sEventAT = sEvent;
                            if (this.m_declaredEventsPrefixList.contains(sEvent)) continue;
                            this.m_declaredEventsPrefixList.add(sEvent);
                            continue;
                        }
                        if (sEvent.endsWith("*")) {
                            ++iPrefixCounterAS;
                            sEventAS = sEvent;
                            if (this.m_declaredEventsPrefixList.contains(sEvent)) continue;
                            this.m_declaredEventsPrefixList.add(sEvent);
                            continue;
                        }
                        if (this.m_declaredEventsList.contains(sEvent)) continue;
                        this.m_declaredEventsList.add(sEvent);
                    }
                    if (iPrefixCounterAT == 0) {
                        for (String sEvent : pairOfEvents) {
                            mapResourcesOfEvent = this.m_eventID_mapEventsID.get(sEvent);
                            if (null == mapResourcesOfEvent) {
                                mapResourcesOfEvent = new HashMap();
                            }
                            if (null == (exclusiveResourcesOfEvent = mapResourcesOfEvent.get(EXCLUSIVE))) {
                                exclusiveResourcesOfEvent = new ArrayList();
                            }
                            if (!exclusiveResourcesOfEvent.contains(sEvent)) {
                                exclusiveResourcesOfEvent.add(sEvent);
                            }
                            mapResourcesOfEvent.put(EXCLUSIVE, exclusiveResourcesOfEvent);
                            this.m_eventID_mapEventsID.put(sEvent, mapResourcesOfEvent);
                            for (String sOtherEvent : pairOfEvents) {
                                if (sOtherEvent.equals(sEvent)) continue;
                                mapResourcesOfEvent = this.m_eventID_mapEventsID.get(sOtherEvent);
                                if (null == mapResourcesOfEvent) {
                                    mapResourcesOfEvent = new HashMap();
                                }
                                if (null == (sharedResourcesOfEvent = mapResourcesOfEvent.get(SHARED))) {
                                    sharedResourcesOfEvent = new ArrayList();
                                }
                                if (!sharedResourcesOfEvent.contains(sEvent)) {
                                    sharedResourcesOfEvent.add(sEvent);
                                }
                                mapResourcesOfEvent.put(SHARED, sharedResourcesOfEvent);
                                this.m_eventID_mapEventsID.put(sOtherEvent, mapResourcesOfEvent);
                                mapResourcesOfEvent = new HashMap();
                            }
                            mapResourcesOfEvent = new HashMap();
                        }
                        continue;
                    }
                    if (iPrefixCounterAT == 1) {
                        for (String sEvent : pairOfEvents) {
                            mapResourcesOfEvent = this.m_eventID_mapEventsID.get(sEvent);
                            if (null == mapResourcesOfEvent) {
                                mapResourcesOfEvent = new HashMap();
                            }
                            if (!sEvent.endsWith("@")) {
                                exclusiveResourcesOfEvent = mapResourcesOfEvent.get(EXCLUSIVE);
                                if (null == exclusiveResourcesOfEvent) {
                                    exclusiveResourcesOfEvent = new ArrayList();
                                }
                                if (iPrefixCounterAS == 0) {
                                    if (!exclusiveResourcesOfEvent.contains(sEventAT)) {
                                        exclusiveResourcesOfEvent.add(sEventAT);
                                    }
                                } else if (!exclusiveResourcesOfEvent.contains(sEvent)) {
                                    exclusiveResourcesOfEvent.add(sEvent);
                                }
                                mapResourcesOfEvent.put(EXCLUSIVE, exclusiveResourcesOfEvent);
                            } else {
                                sharedResourcesOfEvent = mapResourcesOfEvent.get(SHARED);
                                if (null == sharedResourcesOfEvent) {
                                    sharedResourcesOfEvent = new ArrayList();
                                }
                                if (iPrefixCounterAS == 0) {
                                    if (!sharedResourcesOfEvent.contains(sEventAT)) {
                                        sharedResourcesOfEvent.add(sEventAT);
                                    }
                                } else if (!sharedResourcesOfEvent.contains(sEventAS)) {
                                    sharedResourcesOfEvent.add(sEventAS);
                                }
                                mapResourcesOfEvent.put(SHARED, sharedResourcesOfEvent);
                            }
                            this.m_eventID_mapEventsID.put(sEvent, mapResourcesOfEvent);
                            mapResourcesOfEvent = new HashMap();
                        }
                        continue;
                    }
                    Reporter.addMessage(this.m_errorMessagesList, (String)"WRN5006", (String)"$$$_EXC", (String[])new String[]{"EXC", sLine});
                }
            }
        }
    }
}

