/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.jobtrac.CSVReaderJCL;
import java.util.ArrayList;
import java.util.HashMap;

public class CCPFConvertor {
    private ArrayList<String> m_eventsCCPFAllEvents = null;
    private ArrayList<String> m_eventsCCPFPrefixList = new ArrayList();
    private ArrayList<String> m_eventsCCPFFullNameList = new ArrayList();
    private HashMap<String, ArrayList<ArrayList<String>>> m_event_steps = null;
    private int m_iMaxCC = 0;
    private int m_iMaxEMCCPF;
    private int m_iMinEMCCPF = 0;
    private ArrayList<String> m_errorMessagesList = new ArrayList();

    public int getM_iMaxCC() {
        return this.m_iMaxCC;
    }

    private void setM_iMaxEMCCPF(boolean IsDS) {
        this.m_iMaxEMCCPF = IsDS ? 9999 : 4096;
    }

    public HashMap<String, ArrayList<ArrayList<String>>> getM_event_steps() {
        return this.m_event_steps;
    }

    public ArrayList<String> getMessages() {
        return this.m_errorMessagesList;
    }

    public void initMessages() {
        this.m_errorMessagesList = new ArrayList();
    }

    public CCPFConvertor(String ccpfFile, String jclsFile, int maxCC) {
        this.m_iMaxCC = maxCC;
        this.readJCLEntries(jclsFile);
    }

    private void readJCLEntries(String jclFile) {
        CSVReaderJCL jclReader = new CSVReaderJCL(jclFile);
        boolean bRead = jclReader.loadTableFile();
        if (bRead) {
            this.m_event_steps = jclReader.getDataMapOfSteps();
        }
    }

    public void doConversion() {
        if (null != this.m_eventsCCPFAllEvents) {
            for (String sEvent : this.m_eventsCCPFAllEvents) {
                if (null == sEvent || sEvent.isEmpty()) continue;
                if (sEvent.endsWith("*") || sEvent.equals("*")) {
                    if (this.m_eventsCCPFPrefixList.contains(sEvent)) continue;
                    this.m_eventsCCPFPrefixList.add(sEvent);
                    continue;
                }
                if (this.m_eventsCCPFFullNameList.contains(sEvent)) continue;
                this.m_eventsCCPFFullNameList.add(sEvent);
            }
            this.m_eventsCCPFAllEvents.clear();
        }
        this.m_eventsCCPFAllEvents = null;
    }

    public String[] convertOperatorAndValue(String sOPER, String sVAL, boolean bIsDSJob) {
        int iVal = Integer.parseInt(sVAL);
        this.setM_iMaxEMCCPF(bIsDSJob);
        int iOriginalVal = iVal;
        if (iVal > this.m_iMaxEMCCPF) {
            iVal = this.m_iMaxEMCCPF;
        }
        String sAction = "OK";
        boolean bOpLT = false;
        String[] sResArr = new String[3];
        if (sOPER.equals("EQ")) {
            sOPER = "";
        } else if (sOPER.equals("LT")) {
            sOPER = "<";
            bOpLT = true;
        } else if (sOPER.equals("GT")) {
            sOPER = ">";
        } else if (sOPER.equals("LE")) {
            sOPER = "<";
            if (iVal < this.m_iMaxEMCCPF) {
                ++iVal;
            }
        } else if (sOPER.equals("GE")) {
            sOPER = ">";
            if (iVal > this.m_iMinEMCCPF) {
                --iVal;
            }
        }
        if (sOPER.equals("<")) {
            if (this.m_iMaxCC > iOriginalVal) {
                int n = iVal = bOpLT ? iOriginalVal - 1 : iOriginalVal;
                if (iVal < this.m_iMinEMCCPF || iVal > this.m_iMaxEMCCPF) {
                    iVal = iOriginalVal;
                }
                sOPER = ">";
                sAction = "NOTOK";
            }
        } else if (iVal > this.m_iMaxEMCCPF) {
            iVal = this.m_iMaxEMCCPF;
        }
        if (sOPER.equals("NE")) {
            if (bIsDSJob) {
                sOPER = "!";
                sVAL = String.format("%04d", iVal);
            } else {
                sOPER = ">";
                sVAL = String.format("%04d,NC%04d", this.m_iMaxCC, iVal);
            }
        } else {
            sVAL = String.format("%04d", iVal);
        }
        sResArr[0] = sOPER;
        sResArr[1] = sVAL;
        sResArr[2] = sAction;
        return sResArr;
    }
}

