/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.redwoodbpa.convertor.steps.jobtypes.sapr3;

import com.bmc.ctmconvert.api.SapBWParametersAPI;
import com.bmc.ctmconvert.api.SapR3ParametersAPI;
import com.bmc.ctmconvert.api.SapR3StepAPI;
import com.bmc.ctmconvert.redwoodbpa.convertor.steps.jobtypes.sapr3.step.AbapStepConvertor;
import com.bmc.ctmconvert.redwoodbpa.convertor.steps.jobtypes.sapr3.step.ExternalCommandStepConvertor;
import com.bmc.ctmconvert.redwoodbpa.entities.JobDefinition;
import com.bmc.ctmconvert.redwoodbpa.extensions.CommonKt;
import com.bmc.ctmconvert.redwoodbpa.extensions.CtmJobKt;
import com.bmc.ctmconvert.redwoodbpa.extensions.JobDefinitionParameterKt;
import com.bmc.ctmconvert.redwoodbpa.messages.InfosKt;
import com.bmc.ctmconvert.redwoodbpa.messages.WarningsKt;
import com.bmc.ctmconvert.scriptelement.CtmJob;
import com.bmc.ctmconvert.scriptelement.SapR3Action;
import com.bmc.ctmconvert.scriptelement.SapR3JobClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ&\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u001a\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u001e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0002J\u001e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u001e\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010$\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010%\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006&"}, d2={"Lcom/bmc/ctmconvert/redwoodbpa/convertor/steps/jobtypes/sapr3/SapR3JobsConvertor;", "", "<init>", "()V", "toSapR3", "", "jobDefinition", "Lcom/bmc/ctmconvert/redwoodbpa/entities/JobDefinition;", "ctmJob", "Lcom/bmc/ctmconvert/scriptelement/CtmJob;", "setSapBW", "cachedJobsParamsElements", "", "Lcom/bmc/ctmconvert/redwoodbpa/entities/JobDefinition$JobDefinitionParameter;", "jobDefinitionAPI", "notSupportedSapJobType", "sapR3Job", "sapType", "", "setAsCopyExistingJob", "setAsCreateANewJob", "sapR3CtmJob", "setLocalVariablesForJob", "removePercentageFromNameIfExists", "parameter", "notSupportedJobClassValue", "Lcom/bmc/ctmconvert/scriptelement/SapR3JobClass;", "variable", "setUser", "newStep", "Lcom/bmc/ctmconvert/api/SapR3StepAPI;", "jobsParamsElements", "setSapConnectionProfile", "setSapJobName", "job", "params", "setSapBWJobId", "setJobClass", "Scheduler-Redwood-BPA"})
@SourceDebugExtension(value={"SMAP\nSapR3JobsConvertor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SapR3JobsConvertor.kt\ncom/bmc/ctmconvert/redwoodbpa/convertor/steps/jobtypes/sapr3/SapR3JobsConvertor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n827#2:142\n855#2,2:143\n1863#2,2:145\n*S KotlinDebug\n*F\n+ 1 SapR3JobsConvertor.kt\ncom/bmc/ctmconvert/redwoodbpa/convertor/steps/jobtypes/sapr3/SapR3JobsConvertor\n*L\n82#1:142\n82#1:143,2\n82#1:145,2\n*E\n"})
public final class SapR3JobsConvertor {
    public final void toSapR3(@NotNull JobDefinition jobDefinition, @NotNull CtmJob ctmJob) {
        Intrinsics.checkNotNullParameter((Object)jobDefinition, (String)"jobDefinition");
        Intrinsics.checkNotNullParameter((Object)ctmJob, (String)"ctmJob");
        switch (jobDefinition.getSapAction()) {
            case "ABAP_RUN_PRINT": {
                this.setAsCreateANewJob(ctmJob);
                break;
            }
            case "ABAP_RUN": {
                this.setAsCreateANewJob(ctmJob);
                break;
            }
            case "VARIANT_STORE": {
                this.setAsCreateANewJob(ctmJob);
                break;
            }
            case "EXTERNAL_COMMAND_RUN": {
                this.setAsCreateANewJob(ctmJob);
                break;
            }
            case "TEMPLATE_JOB_RUN": {
                this.setAsCopyExistingJob(ctmJob, jobDefinition.getBPAParams());
                break;
            }
            case "BW_CHAIN_RUN": {
                this.setSapBW(ctmJob, jobDefinition.getBPAParams(), jobDefinition);
                break;
            }
            default: {
                this.notSupportedSapJobType(ctmJob, jobDefinition.getSapAction());
            }
        }
    }

    private final void setSapBW(CtmJob ctmJob, List<? extends JobDefinition.JobDefinitionParameter> cachedJobsParamsElements, JobDefinition jobDefinitionAPI) {
        ctmJob.setSapBWType();
        ctmJob.setDescription(jobDefinitionAPI.getBPADescription());
        this.setSapBWJobId(ctmJob, cachedJobsParamsElements);
    }

    private final void notSupportedSapJobType(CtmJob sapR3Job, String sapType) {
        sapR3Job.setDummyType();
        sapR3Job.general().sapR3Parameters().deleteAll();
        sapR3Job.addMessage(WarningsKt.unsupportedSapType(sapR3Job, sapType));
    }

    private final void setAsCopyExistingJob(CtmJob sapR3Job, List<? extends JobDefinition.JobDefinitionParameter> cachedJobsParamsElements) {
        sapR3Job.general().sapR3Parameters().setAction(SapR3Action.CopyAnExistingJob);
        this.setSapJobName(sapR3Job, cachedJobsParamsElements);
        this.setSapConnectionProfile(sapR3Job);
    }

    private final void setAsCreateANewJob(CtmJob sapR3CtmJob) {
        SapR3StepAPI sapR3StepAPI;
        SapR3ParametersAPI sapR3Parameters = sapR3CtmJob.general().sapR3Parameters();
        List<JobDefinition.JobDefinitionParameter> bpaParams = CtmJobKt.getJobDefinition(sapR3CtmJob).getBPAParams();
        if (Intrinsics.areEqual((Object)CtmJobKt.getJobDefinition(sapR3CtmJob).getSapAction(), (Object)"EXTERNAL_COMMAND_RUN")) {
            ExternalCommandStepConvertor externalCommandStepConvertor = new ExternalCommandStepConvertor();
            Intrinsics.checkNotNull((Object)sapR3Parameters);
            sapR3StepAPI = (SapR3StepAPI)externalCommandStepConvertor.convertExternalCommand(sapR3Parameters, bpaParams);
        } else {
            sapR3StepAPI = (SapR3StepAPI)new AbapStepConvertor().convertAbapStep(bpaParams, sapR3CtmJob);
        }
        SapR3StepAPI newStep = sapR3StepAPI;
        this.setSapJobName(sapR3CtmJob, bpaParams);
        this.setJobClass(sapR3CtmJob, bpaParams);
        this.setSapConnectionProfile(sapR3CtmJob);
        this.setLocalVariablesForJob(sapR3CtmJob, bpaParams);
        this.setUser(newStep, bpaParams);
    }

    /*
     * WARNING - void declaration
     */
    private final void setLocalVariablesForJob(CtmJob sapR3Job, List<? extends JobDefinition.JobDefinitionParameter> cachedJobsParamsElements) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = cachedJobsParamsElements;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            JobDefinition.JobDefinitionParameter it = (JobDefinition.JobDefinitionParameter)element$iv$iv;
            boolean bl = false;
            if (it.isBuiltInSapR3PParameter()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JobDefinition.JobDefinitionParameter parameter = (JobDefinition.JobDefinitionParameter)element$iv;
            boolean bl = false;
            String name = this.removePercentageFromNameIfExists(parameter);
            String value = parameter.getValue();
            sapR3Job.general().addLocalVariable(name, value);
        }
    }

    private final String removePercentageFromNameIfExists(JobDefinition.JobDefinitionParameter parameter) {
        String paramName = parameter.getName();
        return StringsKt.startsWith$default((String)paramName, (String)"%%", (boolean)false, (int)2, null) ? StringsKt.replaceFirst$default((String)paramName, (String)"%%", (String)"", (boolean)false, (int)4, null) : paramName;
    }

    private final SapR3JobClass notSupportedJobClassValue(CtmJob sapR3Job, JobDefinition.JobDefinitionParameter variable) {
        sapR3Job.addMessage(InfosKt.invalidValueJobClassParam(sapR3Job, variable));
        return SapR3JobClass.MediumPriority;
    }

    private final void setUser(SapR3StepAPI newStep, List<? extends JobDefinition.JobDefinitionParameter> jobsParamsElements) {
        Object object = JobDefinitionParameterKt.getVariable(jobsParamsElements, "SAP_USER_NAME");
        if (object == null || (object = ((JobDefinition.JobDefinitionParameter)object).getValue()) == null) {
            object = "";
        }
        newStep.setUser((String)object);
    }

    private final void setSapConnectionProfile(CtmJob sapR3Job) {
        Object object = sapR3Job.getJobInputXmlData().getFirstChildElementByName("DefaultQueue");
        String defaultQueue = object != null ? object.getAttribute("path") : null;
        object = defaultQueue;
        if (object == null || object.length() == 0) {
            sapR3Job.general().sapR3Parameters().setConnectionProfile("DEFAULT_SAP_CONNECTION_PROFILE");
        } else {
            sapR3Job.general().sapR3Parameters().setConnectionProfile(CommonKt.getItemNameFromBusinessKey(defaultQueue));
        }
    }

    private final void setSapJobName(CtmJob job, List<? extends JobDefinition.JobDefinitionParameter> params) {
        SapR3ParametersAPI sapR3ParametersAPI = job.general().sapR3Parameters();
        Object object = JobDefinitionParameterKt.getVariable(params, "JOBNAME");
        if (object == null || (object = ((JobDefinition.JobDefinitionParameter)object).getValue()) == null) {
            object = "";
        }
        sapR3ParametersAPI.setSAPJobName((String)object);
    }

    private final void setSapBWJobId(CtmJob job, List<? extends JobDefinition.JobDefinitionParameter> params) {
        SapBWParametersAPI sapBWParametersAPI = job.general().sapBWParameters();
        Object object = JobDefinitionParameterKt.getVariable(params, "NAME");
        if (object == null || (object = ((JobDefinition.JobDefinitionParameter)object).getValue()) == null) {
            object = "";
        }
        sapBWParametersAPI.setID((String)object);
    }

    private final void setJobClass(CtmJob job, List<? extends JobDefinition.JobDefinitionParameter> params) {
        JobDefinition.JobDefinitionParameter variable = JobDefinitionParameterKt.getVariable(params, "JOBCLASS");
        if (variable == null) {
            job.general().sapR3Parameters().setJobClass(SapR3JobClass.MediumPriority);
            return;
        }
        SapR3JobClass it = variable.asSapR3JobClass();
        boolean bl = false;
        SapR3ParametersAPI sapR3ParametersAPI = job.general().sapR3Parameters();
        SapR3JobClass sapR3JobClass = it;
        if (sapR3JobClass == null) {
            sapR3JobClass = this.notSupportedJobClassValue(job, variable);
        }
        sapR3ParametersAPI.setJobClass(sapR3JobClass);
    }
}

