/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JobRunStatus {
    @SerializedName(value="jobId")
    private String jobId = null;
    @SerializedName(value="folderId")
    private String folderId = null;
    @SerializedName(value="numberOfRuns")
    private Long numberOfRuns = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="folder")
    private String folder = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="held")
    private Boolean held = null;
    @SerializedName(value="deleted")
    private Boolean deleted = null;
    @SerializedName(value="cyclic")
    private Boolean cyclic = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="endTime")
    private String endTime = null;
    @SerializedName(value="estimatedStartTime")
    private List<String> estimatedStartTime = null;
    @SerializedName(value="estimatedEndTime")
    private List<String> estimatedEndTime = null;
    @SerializedName(value="orderDate")
    private String orderDate = null;
    @SerializedName(value="ctm")
    private String ctm = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="host")
    private String host = null;
    @SerializedName(value="library")
    private String library = null;
    @SerializedName(value="application")
    private String application = null;
    @SerializedName(value="subApplication")
    private String subApplication = null;
    @SerializedName(value="jobJSON")
    private String jobJSON = null;
    @SerializedName(value="outputURI")
    private String outputURI = null;
    @SerializedName(value="logURI")
    private String logURI = null;

    public JobRunStatus jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @ApiModelProperty(required=true, value="Order ID of the job.")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public JobRunStatus folderId(String folderId) {
        this.folderId = folderId;
        return this;
    }

    @ApiModelProperty(value="Order ID of the folder containing this job.")
    public String getFolderId() {
        return this.folderId;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public JobRunStatus numberOfRuns(Long numberOfRuns) {
        this.numberOfRuns = numberOfRuns;
        return this;
    }

    @ApiModelProperty(value="The run number (in case of cyclic jobs or reruns)")
    public Long getNumberOfRuns() {
        return this.numberOfRuns;
    }

    public void setNumberOfRuns(Long numberOfRuns) {
        this.numberOfRuns = numberOfRuns;
    }

    public JobRunStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the run job.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobRunStatus folder(String folder) {
        this.folder = folder;
        return this;
    }

    @ApiModelProperty(value="The name of the run job.")
    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public JobRunStatus type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the run job.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public JobRunStatus status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the run job.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public JobRunStatus held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(value="Is job held.")
    public Boolean isHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public JobRunStatus deleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @ApiModelProperty(value="Is job held.")
    public Boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public JobRunStatus cyclic(Boolean cyclic) {
        this.cyclic = cyclic;
        return this;
    }

    @ApiModelProperty(value="Is it a cyclic job.")
    public Boolean isCyclic() {
        return this.cyclic;
    }

    public void setCyclic(Boolean cyclic) {
        this.cyclic = cyclic;
    }

    public JobRunStatus startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="The start time of the job run.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public JobRunStatus endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The end time of the job run.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public JobRunStatus estimatedStartTime(List<String> estimatedStartTime) {
        this.estimatedStartTime = estimatedStartTime;
        return this;
    }

    public JobRunStatus addEstimatedStartTimeItem(String estimatedStartTimeItem) {
        if (this.estimatedStartTime == null) {
            this.estimatedStartTime = new ArrayList<String>();
        }
        this.estimatedStartTime.add(estimatedStartTimeItem);
        return this;
    }

    @ApiModelProperty(value="The estimated start time of the jobs.")
    public List<String> getEstimatedStartTime() {
        return this.estimatedStartTime;
    }

    public void setEstimatedStartTime(List<String> estimatedStartTime) {
        this.estimatedStartTime = estimatedStartTime;
    }

    public JobRunStatus estimatedEndTime(List<String> estimatedEndTime) {
        this.estimatedEndTime = estimatedEndTime;
        return this;
    }

    public JobRunStatus addEstimatedEndTimeItem(String estimatedEndTimeItem) {
        if (this.estimatedEndTime == null) {
            this.estimatedEndTime = new ArrayList<String>();
        }
        this.estimatedEndTime.add(estimatedEndTimeItem);
        return this;
    }

    @ApiModelProperty(value="The estimated end time of the jobs.")
    public List<String> getEstimatedEndTime() {
        return this.estimatedEndTime;
    }

    public void setEstimatedEndTime(List<String> estimatedEndTime) {
        this.estimatedEndTime = estimatedEndTime;
    }

    public JobRunStatus orderDate(String orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @ApiModelProperty(value="The order date.")
    public String getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(String orderDate) {
        this.orderDate = orderDate;
    }

    public JobRunStatus ctm(String ctm) {
        this.ctm = ctm;
        return this;
    }

    @ApiModelProperty(value="The controlm server.")
    public String getCtm() {
        return this.ctm;
    }

    public void setCtm(String ctm) {
        this.ctm = ctm;
    }

    public JobRunStatus description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The job description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JobRunStatus host(String host) {
        this.host = host;
        return this;
    }

    @ApiModelProperty(value="host machine where the job runs.")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public JobRunStatus library(String library) {
        this.library = library;
        return this;
    }

    @ApiModelProperty(value="The folder library.")
    public String getLibrary() {
        return this.library;
    }

    public void setLibrary(String library) {
        this.library = library;
    }

    public JobRunStatus application(String application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(value="job application.")
    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public JobRunStatus subApplication(String subApplication) {
        this.subApplication = subApplication;
        return this;
    }

    @ApiModelProperty(value="job subApplication.")
    public String getSubApplication() {
        return this.subApplication;
    }

    public void setSubApplication(String subApplication) {
        this.subApplication = subApplication;
    }

    public JobRunStatus jobJSON(String jobJSON) {
        this.jobJSON = jobJSON;
        return this;
    }

    @ApiModelProperty(value="The JSON string that describes the job.")
    public String getJobJSON() {
        return this.jobJSON;
    }

    public void setJobJSON(String jobJSON) {
        this.jobJSON = jobJSON;
    }

    public JobRunStatus outputURI(String outputURI) {
        this.outputURI = outputURI;
        return this;
    }

    @ApiModelProperty(value="A URI that can be used to get the output of the run job")
    public String getOutputURI() {
        return this.outputURI;
    }

    public void setOutputURI(String outputURI) {
        this.outputURI = outputURI;
    }

    public JobRunStatus logURI(String logURI) {
        this.logURI = logURI;
        return this;
    }

    @ApiModelProperty(value="A URI that can be used to get the log of the run job")
    public String getLogURI() {
        return this.logURI;
    }

    public void setLogURI(String logURI) {
        this.logURI = logURI;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobRunStatus jobRunStatus = (JobRunStatus)o;
        return Objects.equals(this.jobId, jobRunStatus.jobId) && Objects.equals(this.folderId, jobRunStatus.folderId) && Objects.equals(this.numberOfRuns, jobRunStatus.numberOfRuns) && Objects.equals(this.name, jobRunStatus.name) && Objects.equals(this.folder, jobRunStatus.folder) && Objects.equals(this.type, jobRunStatus.type) && Objects.equals(this.status, jobRunStatus.status) && Objects.equals(this.held, jobRunStatus.held) && Objects.equals(this.deleted, jobRunStatus.deleted) && Objects.equals(this.cyclic, jobRunStatus.cyclic) && Objects.equals(this.startTime, jobRunStatus.startTime) && Objects.equals(this.endTime, jobRunStatus.endTime) && Objects.equals(this.estimatedStartTime, jobRunStatus.estimatedStartTime) && Objects.equals(this.estimatedEndTime, jobRunStatus.estimatedEndTime) && Objects.equals(this.orderDate, jobRunStatus.orderDate) && Objects.equals(this.ctm, jobRunStatus.ctm) && Objects.equals(this.description, jobRunStatus.description) && Objects.equals(this.host, jobRunStatus.host) && Objects.equals(this.library, jobRunStatus.library) && Objects.equals(this.application, jobRunStatus.application) && Objects.equals(this.subApplication, jobRunStatus.subApplication) && Objects.equals(this.jobJSON, jobRunStatus.jobJSON) && Objects.equals(this.outputURI, jobRunStatus.outputURI) && Objects.equals(this.logURI, jobRunStatus.logURI);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.folderId, this.numberOfRuns, this.name, this.folder, this.type, this.status, this.held, this.deleted, this.cyclic, this.startTime, this.endTime, this.estimatedStartTime, this.estimatedEndTime, this.orderDate, this.ctm, this.description, this.host, this.library, this.application, this.subApplication, this.jobJSON, this.outputURI, this.logURI);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobRunStatus {\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    folderId: ").append(this.toIndentedString(this.folderId)).append("\n");
        sb.append("    numberOfRuns: ").append(this.toIndentedString(this.numberOfRuns)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    folder: ").append(this.toIndentedString(this.folder)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    cyclic: ").append(this.toIndentedString(this.cyclic)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    estimatedStartTime: ").append(this.toIndentedString(this.estimatedStartTime)).append("\n");
        sb.append("    estimatedEndTime: ").append(this.toIndentedString(this.estimatedEndTime)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    ctm: ").append(this.toIndentedString(this.ctm)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    library: ").append(this.toIndentedString(this.library)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    subApplication: ").append(this.toIndentedString(this.subApplication)).append("\n");
        sb.append("    jobJSON: ").append(this.toIndentedString(this.jobJSON)).append("\n");
        sb.append("    outputURI: ").append(this.toIndentedString(this.outputURI)).append("\n");
        sb.append("    logURI: ").append(this.toIndentedString(this.logURI)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

