/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.FtsUserHomeDirectoryData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="SFTP server parameters")
public class FtsSftpSettings {
    @SerializedName(value="serverEnabled")
    private Boolean serverEnabled = null;
    @SerializedName(value="port")
    private Integer port = null;
    @SerializedName(value="authenticationMethod")
    private String authenticationMethod = null;
    @SerializedName(value="keystoreFilePath")
    private String keystoreFilePath = null;
    @SerializedName(value="keystoreFilePassword")
    private String keystoreFilePassword = null;
    @SerializedName(value="ciphers")
    private String ciphers = null;
    @SerializedName(value="knownUsersFilePath")
    private String knownUsersFilePath = null;
    @SerializedName(value="overriddenUsersHomeDirectories")
    private List<FtsUserHomeDirectoryData> overriddenUsersHomeDirectories = null;

    public FtsSftpSettings serverEnabled(Boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
        return this;
    }

    @ApiModelProperty(value="Enable/Disable listening for SFTP connection")
    public Boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public void setServerEnabled(Boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
    }

    public FtsSftpSettings port(Integer port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(value="SFTP server port")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public FtsSftpSettings authenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    @ApiModelProperty(value="Authentication method being used to connect FTP server")
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public FtsSftpSettings keystoreFilePath(String keystoreFilePath) {
        this.keystoreFilePath = keystoreFilePath;
        return this;
    }

    @ApiModelProperty(value="SFTP keystore file location")
    public String getKeystoreFilePath() {
        return this.keystoreFilePath;
    }

    public void setKeystoreFilePath(String keystoreFilePath) {
        this.keystoreFilePath = keystoreFilePath;
    }

    public FtsSftpSettings keystoreFilePassword(String keystoreFilePassword) {
        this.keystoreFilePassword = keystoreFilePassword;
        return this;
    }

    @ApiModelProperty(value="Password being used to access the SFTP keystore")
    public String getKeystoreFilePassword() {
        return this.keystoreFilePassword;
    }

    public void setKeystoreFilePassword(String keystoreFilePassword) {
        this.keystoreFilePassword = keystoreFilePassword;
    }

    public FtsSftpSettings ciphers(String ciphers) {
        this.ciphers = ciphers;
        return this;
    }

    @ApiModelProperty(value="Ftps server allowed cipher suites (comma-separated). Leave empty to allow all supported cipher suites.")
    public String getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public FtsSftpSettings knownUsersFilePath(String knownUsersFilePath) {
        this.knownUsersFilePath = knownUsersFilePath;
        return this;
    }

    @ApiModelProperty(value="Known users file location")
    public String getKnownUsersFilePath() {
        return this.knownUsersFilePath;
    }

    public void setKnownUsersFilePath(String knownUsersFilePath) {
        this.knownUsersFilePath = knownUsersFilePath;
    }

    public FtsSftpSettings overriddenUsersHomeDirectories(List<FtsUserHomeDirectoryData> overriddenUsersHomeDirectories) {
        this.overriddenUsersHomeDirectories = overriddenUsersHomeDirectories;
        return this;
    }

    public FtsSftpSettings addOverriddenUsersHomeDirectoriesItem(FtsUserHomeDirectoryData overriddenUsersHomeDirectoriesItem) {
        if (this.overriddenUsersHomeDirectories == null) {
            this.overriddenUsersHomeDirectories = new ArrayList<FtsUserHomeDirectoryData>();
        }
        this.overriddenUsersHomeDirectories.add(overriddenUsersHomeDirectoriesItem);
        return this;
    }

    @ApiModelProperty(value="Overridden home directories for specific internal users")
    public List<FtsUserHomeDirectoryData> getOverriddenUsersHomeDirectories() {
        return this.overriddenUsersHomeDirectories;
    }

    public void setOverriddenUsersHomeDirectories(List<FtsUserHomeDirectoryData> overriddenUsersHomeDirectories) {
        this.overriddenUsersHomeDirectories = overriddenUsersHomeDirectories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FtsSftpSettings ftsSftpSettings = (FtsSftpSettings)o;
        return Objects.equals(this.serverEnabled, ftsSftpSettings.serverEnabled) && Objects.equals(this.port, ftsSftpSettings.port) && Objects.equals(this.authenticationMethod, ftsSftpSettings.authenticationMethod) && Objects.equals(this.keystoreFilePath, ftsSftpSettings.keystoreFilePath) && Objects.equals(this.keystoreFilePassword, ftsSftpSettings.keystoreFilePassword) && Objects.equals(this.ciphers, ftsSftpSettings.ciphers) && Objects.equals(this.knownUsersFilePath, ftsSftpSettings.knownUsersFilePath) && Objects.equals(this.overriddenUsersHomeDirectories, ftsSftpSettings.overriddenUsersHomeDirectories);
    }

    public int hashCode() {
        return Objects.hash(this.serverEnabled, this.port, this.authenticationMethod, this.keystoreFilePath, this.keystoreFilePassword, this.ciphers, this.knownUsersFilePath, this.overriddenUsersHomeDirectories);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FtsSftpSettings {\n");
        sb.append("    serverEnabled: ").append(this.toIndentedString(this.serverEnabled)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    authenticationMethod: ").append(this.toIndentedString(this.authenticationMethod)).append("\n");
        sb.append("    keystoreFilePath: ").append(this.toIndentedString(this.keystoreFilePath)).append("\n");
        sb.append("    keystoreFilePassword: ").append(this.toIndentedString(this.keystoreFilePassword)).append("\n");
        sb.append("    ciphers: ").append(this.toIndentedString(this.ciphers)).append("\n");
        sb.append("    knownUsersFilePath: ").append(this.toIndentedString(this.knownUsersFilePath)).append("\n");
        sb.append("    overriddenUsersHomeDirectories: ").append(this.toIndentedString(this.overriddenUsersHomeDirectories)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

