/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="File Transfer Server LDAP authentication parameters")
public class FtsLdapAuthenticationDetails {
    @SerializedName(value="searchUserName")
    private String searchUserName = null;
    @SerializedName(value="searchUserPassword")
    private String searchUserPassword = null;
    @SerializedName(value="serverUrl")
    private String serverUrl = null;
    @SerializedName(value="baseDn")
    private String baseDn = null;
    @SerializedName(value="usernameAttributeName")
    private String usernameAttributeName = null;
    @SerializedName(value="dnAttributeName")
    private String dnAttributeName = null;
    @SerializedName(value="connectionTimeout")
    private Integer connectionTimeout = null;

    public FtsLdapAuthenticationDetails searchUserName(String searchUserName) {
        this.searchUserName = searchUserName;
        return this;
    }

    @ApiModelProperty(value="Name of the user that runs the search action for users that log on")
    public String getSearchUserName() {
        return this.searchUserName;
    }

    public void setSearchUserName(String searchUserName) {
        this.searchUserName = searchUserName;
    }

    public FtsLdapAuthenticationDetails searchUserPassword(String searchUserPassword) {
        this.searchUserPassword = searchUserPassword;
        return this;
    }

    @ApiModelProperty(value="Password of the user that runs the search action for users that log on")
    public String getSearchUserPassword() {
        return this.searchUserPassword;
    }

    public void setSearchUserPassword(String searchUserPassword) {
        this.searchUserPassword = searchUserPassword;
    }

    public FtsLdapAuthenticationDetails serverUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    @ApiModelProperty(value="URL of the LDAP Directory server")
    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public FtsLdapAuthenticationDetails baseDn(String baseDn) {
        this.baseDn = baseDn;
        return this;
    }

    @ApiModelProperty(value="Base DN (the point from where the server will search for users)")
    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public FtsLdapAuthenticationDetails usernameAttributeName(String usernameAttributeName) {
        this.usernameAttributeName = usernameAttributeName;
        return this;
    }

    @ApiModelProperty(value="Name of the LDAP attribute containing the username")
    public String getUsernameAttributeName() {
        return this.usernameAttributeName;
    }

    public void setUsernameAttributeName(String usernameAttributeName) {
        this.usernameAttributeName = usernameAttributeName;
    }

    public FtsLdapAuthenticationDetails dnAttributeName(String dnAttributeName) {
        this.dnAttributeName = dnAttributeName;
        return this;
    }

    @ApiModelProperty(value="Name of the LDAP attribute containing the distinguished name")
    public String getDnAttributeName() {
        return this.dnAttributeName;
    }

    public void setDnAttributeName(String dnAttributeName) {
        this.dnAttributeName = dnAttributeName;
    }

    public FtsLdapAuthenticationDetails connectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @ApiModelProperty(value="LDAP server connection timeout in milliseconds")
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FtsLdapAuthenticationDetails ftsLdapAuthenticationDetails = (FtsLdapAuthenticationDetails)o;
        return Objects.equals(this.searchUserName, ftsLdapAuthenticationDetails.searchUserName) && Objects.equals(this.searchUserPassword, ftsLdapAuthenticationDetails.searchUserPassword) && Objects.equals(this.serverUrl, ftsLdapAuthenticationDetails.serverUrl) && Objects.equals(this.baseDn, ftsLdapAuthenticationDetails.baseDn) && Objects.equals(this.usernameAttributeName, ftsLdapAuthenticationDetails.usernameAttributeName) && Objects.equals(this.dnAttributeName, ftsLdapAuthenticationDetails.dnAttributeName) && Objects.equals(this.connectionTimeout, ftsLdapAuthenticationDetails.connectionTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.searchUserName, this.searchUserPassword, this.serverUrl, this.baseDn, this.usernameAttributeName, this.dnAttributeName, this.connectionTimeout);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FtsLdapAuthenticationDetails {\n");
        sb.append("    searchUserName: ").append(this.toIndentedString(this.searchUserName)).append("\n");
        sb.append("    searchUserPassword: ").append(this.toIndentedString(this.searchUserPassword)).append("\n");
        sb.append("    serverUrl: ").append(this.toIndentedString(this.serverUrl)).append("\n");
        sb.append("    baseDn: ").append(this.toIndentedString(this.baseDn)).append("\n");
        sb.append("    usernameAttributeName: ").append(this.toIndentedString(this.usernameAttributeName)).append("\n");
        sb.append("    dnAttributeName: ").append(this.toIndentedString(this.dnAttributeName)).append("\n");
        sb.append("    connectionTimeout: ").append(this.toIndentedString(this.connectionTimeout)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

