/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="FTP/FTPS server parameters")
public class FtsFtpSettings {
    @SerializedName(value="serverEnabled")
    private Boolean serverEnabled = null;
    @SerializedName(value="port")
    private Integer port = null;
    @SerializedName(value="authenticationMethod")
    private String authenticationMethod = null;
    @SerializedName(value="secured")
    private Boolean secured = null;
    @SerializedName(value="keystoreFilePath")
    private String keystoreFilePath = null;
    @SerializedName(value="keystoreFilePassword")
    private String keystoreFilePassword = null;
    @SerializedName(value="ciphers")
    private String ciphers = null;
    @SerializedName(value="listenForImplicitConnection")
    private Boolean listenForImplicitConnection = null;
    @SerializedName(value="passivePorts")
    private String passivePorts = null;

    public FtsFtpSettings serverEnabled(Boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
        return this;
    }

    @ApiModelProperty(value="Enable/Disable listening for FTP/S connection")
    public Boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public void setServerEnabled(Boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
    }

    public FtsFtpSettings port(Integer port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(value="FTP server port")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public FtsFtpSettings authenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    @ApiModelProperty(value="Authentication method being used to connect FTP server")
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public FtsFtpSettings secured(Boolean secured) {
        this.secured = secured;
        return this;
    }

    @ApiModelProperty(value="Use FTP secure connection (SSL/TLS)")
    public Boolean isSecured() {
        return this.secured;
    }

    public void setSecured(Boolean secured) {
        this.secured = secured;
    }

    public FtsFtpSettings keystoreFilePath(String keystoreFilePath) {
        this.keystoreFilePath = keystoreFilePath;
        return this;
    }

    @ApiModelProperty(value="FTPS keystore file location")
    public String getKeystoreFilePath() {
        return this.keystoreFilePath;
    }

    public void setKeystoreFilePath(String keystoreFilePath) {
        this.keystoreFilePath = keystoreFilePath;
    }

    public FtsFtpSettings keystoreFilePassword(String keystoreFilePassword) {
        this.keystoreFilePassword = keystoreFilePassword;
        return this;
    }

    @ApiModelProperty(value="Password being used to access the FTPS keystore")
    public String getKeystoreFilePassword() {
        return this.keystoreFilePassword;
    }

    public void setKeystoreFilePassword(String keystoreFilePassword) {
        this.keystoreFilePassword = keystoreFilePassword;
    }

    public FtsFtpSettings ciphers(String ciphers) {
        this.ciphers = ciphers;
        return this;
    }

    @ApiModelProperty(value="Ftps server allowed cipher suites (comma-separated). Leave empty to allow all supported cipher suites.")
    public String getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public FtsFtpSettings listenForImplicitConnection(Boolean listenForImplicitConnection) {
        this.listenForImplicitConnection = listenForImplicitConnection;
        return this;
    }

    @ApiModelProperty(value="Implicit negotiation mode - requires that the entire FTP session must be encrypted")
    public Boolean isListenForImplicitConnection() {
        return this.listenForImplicitConnection;
    }

    public void setListenForImplicitConnection(Boolean listenForImplicitConnection) {
        this.listenForImplicitConnection = listenForImplicitConnection;
    }

    public FtsFtpSettings passivePorts(String passivePorts) {
        this.passivePorts = passivePorts;
        return this;
    }

    @ApiModelProperty(value="Passive FTP ports range - for PASV connections, the server will open a random port in this range for client to connect to")
    public String getPassivePorts() {
        return this.passivePorts;
    }

    public void setPassivePorts(String passivePorts) {
        this.passivePorts = passivePorts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FtsFtpSettings ftsFtpSettings = (FtsFtpSettings)o;
        return Objects.equals(this.serverEnabled, ftsFtpSettings.serverEnabled) && Objects.equals(this.port, ftsFtpSettings.port) && Objects.equals(this.authenticationMethod, ftsFtpSettings.authenticationMethod) && Objects.equals(this.secured, ftsFtpSettings.secured) && Objects.equals(this.keystoreFilePath, ftsFtpSettings.keystoreFilePath) && Objects.equals(this.keystoreFilePassword, ftsFtpSettings.keystoreFilePassword) && Objects.equals(this.ciphers, ftsFtpSettings.ciphers) && Objects.equals(this.listenForImplicitConnection, ftsFtpSettings.listenForImplicitConnection) && Objects.equals(this.passivePorts, ftsFtpSettings.passivePorts);
    }

    public int hashCode() {
        return Objects.hash(this.serverEnabled, this.port, this.authenticationMethod, this.secured, this.keystoreFilePath, this.keystoreFilePassword, this.ciphers, this.listenForImplicitConnection, this.passivePorts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FtsFtpSettings {\n");
        sb.append("    serverEnabled: ").append(this.toIndentedString(this.serverEnabled)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    authenticationMethod: ").append(this.toIndentedString(this.authenticationMethod)).append("\n");
        sb.append("    secured: ").append(this.toIndentedString(this.secured)).append("\n");
        sb.append("    keystoreFilePath: ").append(this.toIndentedString(this.keystoreFilePath)).append("\n");
        sb.append("    keystoreFilePassword: ").append(this.toIndentedString(this.keystoreFilePassword)).append("\n");
        sb.append("    ciphers: ").append(this.toIndentedString(this.ciphers)).append("\n");
        sb.append("    listenForImplicitConnection: ").append(this.toIndentedString(this.listenForImplicitConnection)).append("\n");
        sb.append("    passivePorts: ").append(this.toIndentedString(this.passivePorts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

