/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Exception alert data")
public class ExceptionAlertData {
    @SerializedName(value="alertID")
    private Integer alertID = null;
    @SerializedName(value="severity")
    private String severity = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="componentType")
    private String componentType = null;
    @SerializedName(value="componentName")
    private String componentName = null;
    @SerializedName(value="dateTime")
    private String dateTime = null;
    @SerializedName(value="messageCode")
    private String messageCode = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="comment")
    private String comment = null;
    @SerializedName(value="repeatCounter")
    private Integer repeatCounter = null;

    public ExceptionAlertData alertID(Integer alertID) {
        this.alertID = alertID;
        return this;
    }

    @ApiModelProperty(value="Exception alert ID.")
    public Integer getAlertID() {
        return this.alertID;
    }

    public void setAlertID(Integer alertID) {
        this.alertID = alertID;
    }

    public ExceptionAlertData severity(String severity) {
        this.severity = severity;
        return this;
    }

    @ApiModelProperty(value="Exception alert severity (Warning/Error/Severe).")
    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public ExceptionAlertData status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Exception alert status (Handled/Not Handled). EDITABLE.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ExceptionAlertData componentType(String componentType) {
        this.componentType = componentType;
        return this;
    }

    @ApiModelProperty(value="Component type of the exception alert (CMS,Agent,Load Balancer,Control-M/Server,Control-M/EM etc.).")
    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public ExceptionAlertData componentName(String componentName) {
        this.componentName = componentName;
        return this;
    }

    @ApiModelProperty(value="Component name of the exception alert.")
    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public ExceptionAlertData dateTime(String dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    @ApiModelProperty(value="The date and time when the exception alert occur. Date-Time format ( MM/DD/YYYY HH:MM AM/PM ).")
    public String getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public ExceptionAlertData messageCode(String messageCode) {
        this.messageCode = messageCode;
        return this;
    }

    @ApiModelProperty(value="Message code of the reported exception alert.")
    public String getMessageCode() {
        return this.messageCode;
    }

    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }

    public ExceptionAlertData message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="Information about the reported exception alert.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ExceptionAlertData comment(String comment) {
        this.comment = comment;
        return this;
    }

    @ApiModelProperty(value="Customer note about the exception alert. EDITABLE.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ExceptionAlertData repeatCounter(Integer repeatCounter) {
        this.repeatCounter = repeatCounter;
        return this;
    }

    @ApiModelProperty(value="Number of times this exception alert reported.")
    public Integer getRepeatCounter() {
        return this.repeatCounter;
    }

    public void setRepeatCounter(Integer repeatCounter) {
        this.repeatCounter = repeatCounter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionAlertData exceptionAlertData = (ExceptionAlertData)o;
        return Objects.equals(this.alertID, exceptionAlertData.alertID) && Objects.equals(this.severity, exceptionAlertData.severity) && Objects.equals(this.status, exceptionAlertData.status) && Objects.equals(this.componentType, exceptionAlertData.componentType) && Objects.equals(this.componentName, exceptionAlertData.componentName) && Objects.equals(this.dateTime, exceptionAlertData.dateTime) && Objects.equals(this.messageCode, exceptionAlertData.messageCode) && Objects.equals(this.message, exceptionAlertData.message) && Objects.equals(this.comment, exceptionAlertData.comment) && Objects.equals(this.repeatCounter, exceptionAlertData.repeatCounter);
    }

    public int hashCode() {
        return Objects.hash(this.alertID, this.severity, this.status, this.componentType, this.componentName, this.dateTime, this.messageCode, this.message, this.comment, this.repeatCounter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExceptionAlertData {\n");
        sb.append("    alertID: ").append(this.toIndentedString(this.alertID)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString(this.severity)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    componentType: ").append(this.toIndentedString(this.componentType)).append("\n");
        sb.append("    componentName: ").append(this.toIndentedString(this.componentName)).append("\n");
        sb.append("    dateTime: ").append(this.toIndentedString(this.dateTime)).append("\n");
        sb.append("    messageCode: ").append(this.toIndentedString(this.messageCode)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    repeatCounter: ").append(this.toIndentedString(this.repeatCounter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

