/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines the activation status of the data export functionality.")
public class DataExportActivation {
    @SerializedName(value="enabled")
    private Boolean enabled = null;
    @SerializedName(value="password")
    private String password = null;

    public DataExportActivation enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the data export feature is enabled. - `true` = export is enabled and can be triggered. - `false` = export is disabled. ")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public DataExportActivation password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="This password secures the exported data file. When set, the file requires this password to be opened. Applicable only if `enabled` is set to `true`. ")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataExportActivation dataExportActivation = (DataExportActivation)o;
        return Objects.equals(this.enabled, dataExportActivation.enabled) && Objects.equals(this.password, dataExportActivation.password);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.password);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataExportActivation {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

