/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="the properties of the new Control-M Agent installed thing to be connected to SaaS Control-M")
public class AgentThingProperties {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="physicalName")
    private String physicalName = null;
    @SerializedName(value="tag")
    private String tag = null;
    @SerializedName(value="server")
    private String server = null;
    @SerializedName(value="recreateSqs")
    private String recreateSqs = null;

    public AgentThingProperties name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="the logical name to be used for new agent (equivilant to NodeId)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AgentThingProperties physicalName(String physicalName) {
        this.physicalName = physicalName;
        return this;
    }

    @ApiModelProperty(value="the physical name of the thing the agent is installed on")
    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String physicalName) {
        this.physicalName = physicalName;
    }

    public AgentThingProperties tag(String tag) {
        this.tag = tag;
        return this;
    }

    @ApiModelProperty(value="the agent tag to be associated with the new agent (CMS RBA permissions tag that is)")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public AgentThingProperties server(String server) {
        this.server = server;
        return this;
    }

    @ApiModelProperty(value="the server name to be used for new agent")
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public AgentThingProperties recreateSqs(String recreateSqs) {
        this.recreateSqs = recreateSqs;
        return this;
    }

    @ApiModelProperty(value="This parameter would signal CTMS to recreate the SQS as needed.")
    public String getRecreateSqs() {
        return this.recreateSqs;
    }

    public void setRecreateSqs(String recreateSqs) {
        this.recreateSqs = recreateSqs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentThingProperties agentThingProperties = (AgentThingProperties)o;
        return Objects.equals(this.name, agentThingProperties.name) && Objects.equals(this.physicalName, agentThingProperties.physicalName) && Objects.equals(this.tag, agentThingProperties.tag) && Objects.equals(this.server, agentThingProperties.server) && Objects.equals(this.recreateSqs, agentThingProperties.recreateSqs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.physicalName, this.tag, this.server, this.recreateSqs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentThingProperties {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    physicalName: ").append(this.toIndentedString(this.physicalName)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    server: ").append(this.toIndentedString(this.server)).append("\n");
        sb.append("    recreateSqs: ").append(this.toIndentedString(this.recreateSqs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

