/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.ActiveServices;
import io.swagger.client.model.AlertEventId;
import io.swagger.client.model.AlertParam;
import io.swagger.client.model.AlertStatusParam;
import io.swagger.client.model.AlertsStreamStatus;
import io.swagger.client.model.AlertsStreamTemplate;
import io.swagger.client.model.BypassOptionAttributes;
import io.swagger.client.model.CtmudchkJobsResults;
import io.swagger.client.model.CtmudchkResults;
import io.swagger.client.model.EventParam;
import io.swagger.client.model.EventSet;
import io.swagger.client.model.ForecastTimelineResults;
import io.swagger.client.model.GetAlertInfo;
import io.swagger.client.model.JobRelatedServicesData;
import io.swagger.client.model.JobRunStatus;
import io.swagger.client.model.JobStatusResult;
import io.swagger.client.model.OrderFolderParameters;
import io.swagger.client.model.PollForecastTimelineResults;
import io.swagger.client.model.RerunParameters;
import io.swagger.client.model.ResourceMax;
import io.swagger.client.model.ResourceParam;
import io.swagger.client.model.ResourceSet;
import io.swagger.client.model.RunResult;
import io.swagger.client.model.Statistics;
import io.swagger.client.model.StringListResult;
import io.swagger.client.model.SuccessData;
import io.swagger.client.model.VariableNames;
import io.swagger.client.model.Variables;
import io.swagger.client.model.WorkloadPoliciesFileResults;
import io.swagger.client.model.WorkloadPolicyList;
import io.swagger.client.model.WorkloadPolicyStateList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class RunApi {
    private ApiClient apiClient;

    public RunApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RunApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call acknowledgeAlertCall(AlertEventId eventId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AlertEventId localVarPostBody = eventId;
        String localVarPath = "/run/alerts/internal/stream/acknowledge";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call acknowledgeAlertValidateBeforeCall(AlertEventId eventId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (eventId == null) {
            throw new ApiException("Missing the required parameter 'eventId' when calling acknowledgeAlert(Async)");
        }
        Call call = this.acknowledgeAlertCall(eventId, progressListener, progressRequestListener);
        return call;
    }

    public String acknowledgeAlert(AlertEventId eventId) throws ApiException {
        ApiResponse<String> resp = this.acknowledgeAlertWithHttpInfo(eventId);
        return resp.getData();
    }

    public ApiResponse<String> acknowledgeAlertWithHttpInfo(AlertEventId eventId) throws ApiException {
        Call call = this.acknowledgeAlertValidateBeforeCall(eventId, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call acknowledgeAlertAsync(AlertEventId eventId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.acknowledgeAlertValidateBeforeCall(eventId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call activateWorkloadPolicyCall(String policy, String ctm, String server, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/workloadpolicy/{policy}/activate".replaceAll("\\{policy\\}", this.apiClient.escapeString(policy.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call activateWorkloadPolicyValidateBeforeCall(String policy, String ctm, String server, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (policy == null) {
            throw new ApiException("Missing the required parameter 'policy' when calling activateWorkloadPolicy(Async)");
        }
        Call call = this.activateWorkloadPolicyCall(policy, ctm, server, progressListener, progressRequestListener);
        return call;
    }

    public WorkloadPolicyStateList activateWorkloadPolicy(String policy, String ctm, String server) throws ApiException {
        ApiResponse<WorkloadPolicyStateList> resp = this.activateWorkloadPolicyWithHttpInfo(policy, ctm, server);
        return resp.getData();
    }

    public ApiResponse<WorkloadPolicyStateList> activateWorkloadPolicyWithHttpInfo(String policy, String ctm, String server) throws ApiException {
        Call call = this.activateWorkloadPolicyValidateBeforeCall(policy, ctm, server, null, null);
        Type localVarReturnType = new TypeToken<WorkloadPolicyStateList>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call activateWorkloadPolicyAsync(String policy, String ctm, String server, final ApiCallback<WorkloadPolicyStateList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.activateWorkloadPolicyValidateBeforeCall(policy, ctm, server, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkloadPolicyStateList>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call addEventCall(String server, EventParam event, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EventParam localVarPostBody = event;
        String localVarPath = "/run/event/{server}".replaceAll("\\{server\\}", this.apiClient.escapeString(server.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addEventValidateBeforeCall(String server, EventParam event, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (server == null) {
            throw new ApiException("Missing the required parameter 'server' when calling addEvent(Async)");
        }
        if (event == null) {
            throw new ApiException("Missing the required parameter 'event' when calling addEvent(Async)");
        }
        Call call = this.addEventCall(server, event, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData addEvent(String server, EventParam event) throws ApiException {
        ApiResponse<SuccessData> resp = this.addEventWithHttpInfo(server, event);
        return resp.getData();
    }

    public ApiResponse<SuccessData> addEventWithHttpInfo(String server, EventParam event) throws ApiException {
        Call call = this.addEventValidateBeforeCall(server, event, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addEventAsync(String server, EventParam event, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addEventValidateBeforeCall(server, event, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call addResourceCall(String server, ResourceParam resource, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ResourceParam localVarPostBody = resource;
        String localVarPath = "/run/resource/{server}".replaceAll("\\{server\\}", this.apiClient.escapeString(server.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addResourceValidateBeforeCall(String server, ResourceParam resource, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (server == null) {
            throw new ApiException("Missing the required parameter 'server' when calling addResource(Async)");
        }
        if (resource == null) {
            throw new ApiException("Missing the required parameter 'resource' when calling addResource(Async)");
        }
        Call call = this.addResourceCall(server, resource, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData addResource(String server, ResourceParam resource) throws ApiException {
        ApiResponse<SuccessData> resp = this.addResourceWithHttpInfo(server, resource);
        return resp.getData();
    }

    public ApiResponse<SuccessData> addResourceWithHttpInfo(String server, ResourceParam resource) throws ApiException {
        Call call = this.addResourceValidateBeforeCall(server, resource, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addResourceAsync(String server, ResourceParam resource, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addResourceValidateBeforeCall(server, resource, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call addWorkloadPoliciesCall(File workloadpoliciesfile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/run/workloadpolicies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (workloadpoliciesfile != null) {
            localVarFormParams.put("workloadpoliciesfile", workloadpoliciesfile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addWorkloadPoliciesValidateBeforeCall(File workloadpoliciesfile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (workloadpoliciesfile == null) {
            throw new ApiException("Missing the required parameter 'workloadpoliciesfile' when calling addWorkloadPolicies(Async)");
        }
        Call call = this.addWorkloadPoliciesCall(workloadpoliciesfile, progressListener, progressRequestListener);
        return call;
    }

    public WorkloadPoliciesFileResults addWorkloadPolicies(File workloadpoliciesfile) throws ApiException {
        ApiResponse<WorkloadPoliciesFileResults> resp = this.addWorkloadPoliciesWithHttpInfo(workloadpoliciesfile);
        return resp.getData();
    }

    public ApiResponse<WorkloadPoliciesFileResults> addWorkloadPoliciesWithHttpInfo(File workloadpoliciesfile) throws ApiException {
        Call call = this.addWorkloadPoliciesValidateBeforeCall(workloadpoliciesfile, null, null);
        Type localVarReturnType = new TypeToken<WorkloadPoliciesFileResults>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addWorkloadPoliciesAsync(File workloadpoliciesfile, final ApiCallback<WorkloadPoliciesFileResults> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addWorkloadPoliciesValidateBeforeCall(workloadpoliciesfile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkloadPoliciesFileResults>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call bypassCall(String jobId, BypassOptionAttributes bypassOption, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        BypassOptionAttributes localVarPostBody = bypassOption;
        String localVarPath = "/run/job/{jobId}/bypass".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call bypassValidateBeforeCall(String jobId, BypassOptionAttributes bypassOption, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling bypass(Async)");
        }
        if (bypassOption == null) {
            throw new ApiException("Missing the required parameter 'bypassOption' when calling bypass(Async)");
        }
        Call call = this.bypassCall(jobId, bypassOption, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData bypass(String jobId, BypassOptionAttributes bypassOption) throws ApiException {
        ApiResponse<SuccessData> resp = this.bypassWithHttpInfo(jobId, bypassOption);
        return resp.getData();
    }

    public ApiResponse<SuccessData> bypassWithHttpInfo(String jobId, BypassOptionAttributes bypassOption) throws ApiException {
        Call call = this.bypassValidateBeforeCall(jobId, bypassOption, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call bypassAsync(String jobId, BypassOptionAttributes bypassOption, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.bypassValidateBeforeCall(jobId, bypassOption, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call closeAlertsStreamCall(Boolean force, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/alerts/stream/close";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (force != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call closeAlertsStreamValidateBeforeCall(Boolean force, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.closeAlertsStreamCall(force, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData closeAlertsStream(Boolean force) throws ApiException {
        ApiResponse<SuccessData> resp = this.closeAlertsStreamWithHttpInfo(force);
        return resp.getData();
    }

    public ApiResponse<SuccessData> closeAlertsStreamWithHttpInfo(Boolean force) throws ApiException {
        Call call = this.closeAlertsStreamValidateBeforeCall(force, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call closeAlertsStreamAsync(Boolean force, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.closeAlertsStreamValidateBeforeCall(force, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call confirmJobCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/confirm".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call confirmJobValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling confirmJob(Async)");
        }
        Call call = this.confirmJobCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData confirmJob(String jobId) throws ApiException {
        ApiResponse<SuccessData> resp = this.confirmJobWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<SuccessData> confirmJobWithHttpInfo(String jobId) throws ApiException {
        Call call = this.confirmJobValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call confirmJobAsync(String jobId, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.confirmJobValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call connectToAlertsStreamCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/alerts/internal/stream/connect";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call connectToAlertsStreamValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.connectToAlertsStreamCall(progressListener, progressRequestListener);
        return call;
    }

    public String connectToAlertsStream() throws ApiException {
        ApiResponse<String> resp = this.connectToAlertsStreamWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<String> connectToAlertsStreamWithHttpInfo() throws ApiException {
        Call call = this.connectToAlertsStreamValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call connectToAlertsStreamAsync(final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.connectToAlertsStreamValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deactivateWorkloadPolicyCall(String policy, String ctm, String server, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/workloadpolicy/{policy}/deactivate".replaceAll("\\{policy\\}", this.apiClient.escapeString(policy.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deactivateWorkloadPolicyValidateBeforeCall(String policy, String ctm, String server, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (policy == null) {
            throw new ApiException("Missing the required parameter 'policy' when calling deactivateWorkloadPolicy(Async)");
        }
        Call call = this.deactivateWorkloadPolicyCall(policy, ctm, server, progressListener, progressRequestListener);
        return call;
    }

    public WorkloadPolicyStateList deactivateWorkloadPolicy(String policy, String ctm, String server) throws ApiException {
        ApiResponse<WorkloadPolicyStateList> resp = this.deactivateWorkloadPolicyWithHttpInfo(policy, ctm, server);
        return resp.getData();
    }

    public ApiResponse<WorkloadPolicyStateList> deactivateWorkloadPolicyWithHttpInfo(String policy, String ctm, String server) throws ApiException {
        Call call = this.deactivateWorkloadPolicyValidateBeforeCall(policy, ctm, server, null, null);
        Type localVarReturnType = new TypeToken<WorkloadPolicyStateList>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deactivateWorkloadPolicyAsync(String policy, String ctm, String server, final ApiCallback<WorkloadPolicyStateList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deactivateWorkloadPolicyValidateBeforeCall(policy, ctm, server, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkloadPolicyStateList>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteEventCall(String server, String name, String date, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/event/{server}/{name}/{date}".replaceAll("\\{server\\}", this.apiClient.escapeString(server.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{date\\}", this.apiClient.escapeString(date.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteEventValidateBeforeCall(String server, String name, String date, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (server == null) {
            throw new ApiException("Missing the required parameter 'server' when calling deleteEvent(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteEvent(Async)");
        }
        if (date == null) {
            throw new ApiException("Missing the required parameter 'date' when calling deleteEvent(Async)");
        }
        Call call = this.deleteEventCall(server, name, date, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteEvent(String server, String name, String date) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteEventWithHttpInfo(server, name, date);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteEventWithHttpInfo(String server, String name, String date) throws ApiException {
        Call call = this.deleteEventValidateBeforeCall(server, name, date, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteEventAsync(String server, String name, String date, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteEventValidateBeforeCall(server, name, date, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteJobCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/delete".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteJobValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling deleteJob(Async)");
        }
        Call call = this.deleteJobCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteJob(String jobId) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteJobWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteJobWithHttpInfo(String jobId) throws ApiException {
        Call call = this.deleteJobValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteJobAsync(String jobId, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteJobValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteResourceCall(String server, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/resource/{server}/{name}".replaceAll("\\{server\\}", this.apiClient.escapeString(server.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteResourceValidateBeforeCall(String server, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (server == null) {
            throw new ApiException("Missing the required parameter 'server' when calling deleteResource(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteResource(Async)");
        }
        Call call = this.deleteResourceCall(server, name, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteResource(String server, String name) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteResourceWithHttpInfo(server, name);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteResourceWithHttpInfo(String server, String name) throws ApiException {
        Call call = this.deleteResourceValidateBeforeCall(server, name, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteResourceAsync(String server, String name, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteResourceValidateBeforeCall(server, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteVariablesCall(String server, VariableNames variableNames, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        VariableNames localVarPostBody = variableNames;
        String localVarPath = "/run/variables/{server}".replaceAll("\\{server\\}", this.apiClient.escapeString(server.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteVariablesValidateBeforeCall(String server, VariableNames variableNames, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (server == null) {
            throw new ApiException("Missing the required parameter 'server' when calling deleteVariables(Async)");
        }
        if (variableNames == null) {
            throw new ApiException("Missing the required parameter 'variableNames' when calling deleteVariables(Async)");
        }
        Call call = this.deleteVariablesCall(server, variableNames, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteVariables(String server, VariableNames variableNames) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteVariablesWithHttpInfo(server, variableNames);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteVariablesWithHttpInfo(String server, VariableNames variableNames) throws ApiException {
        Call call = this.deleteVariablesValidateBeforeCall(server, variableNames, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteVariablesAsync(String server, VariableNames variableNames, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteVariablesValidateBeforeCall(server, variableNames, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteWorkloadPolicyCall(String workloadpolicyName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/workloadpolicy/{workloadpolicyName}".replaceAll("\\{workloadpolicyName\\}", this.apiClient.escapeString(workloadpolicyName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteWorkloadPolicyValidateBeforeCall(String workloadpolicyName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (workloadpolicyName == null) {
            throw new ApiException("Missing the required parameter 'workloadpolicyName' when calling deleteWorkloadPolicy(Async)");
        }
        Call call = this.deleteWorkloadPolicyCall(workloadpolicyName, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteWorkloadPolicy(String workloadpolicyName) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteWorkloadPolicyWithHttpInfo(workloadpolicyName);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteWorkloadPolicyWithHttpInfo(String workloadpolicyName) throws ApiException {
        Call call = this.deleteWorkloadPolicyValidateBeforeCall(workloadpolicyName, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteWorkloadPolicyAsync(String workloadpolicyName, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteWorkloadPolicyValidateBeforeCall(workloadpolicyName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call disconnectFromAlertsStreamCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/alerts/internal/stream/disconnect";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call disconnectFromAlertsStreamValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.disconnectFromAlertsStreamCall(progressListener, progressRequestListener);
        return call;
    }

    public String disconnectFromAlertsStream() throws ApiException {
        ApiResponse<String> resp = this.disconnectFromAlertsStreamWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<String> disconnectFromAlertsStreamWithHttpInfo() throws ApiException {
        Call call = this.disconnectFromAlertsStreamValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call disconnectFromAlertsStreamAsync(final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.disconnectFromAlertsStreamValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call freeJobCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/free".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call freeJobValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling freeJob(Async)");
        }
        Call call = this.freeJobCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData freeJob(String jobId) throws ApiException {
        ApiResponse<SuccessData> resp = this.freeJobWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<SuccessData> freeJobWithHttpInfo(String jobId) throws ApiException {
        Call call = this.freeJobValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call freeJobAsync(String jobId, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.freeJobValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getActiveJobCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/get".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getActiveJobValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getActiveJob(Async)");
        }
        Call call = this.getActiveJobCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public String getActiveJob(String jobId) throws ApiException {
        ApiResponse<String> resp = this.getActiveJobWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<String> getActiveJobWithHttpInfo(String jobId) throws ApiException {
        Call call = this.getActiveJobValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getActiveJobAsync(String jobId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getActiveJobValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getActiveServicesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/services/sla";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getActiveServicesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getActiveServicesCall(progressListener, progressRequestListener);
        return call;
    }

    public ActiveServices getActiveServices() throws ApiException {
        ApiResponse<ActiveServices> resp = this.getActiveServicesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ActiveServices> getActiveServicesWithHttpInfo() throws ApiException {
        Call call = this.getActiveServicesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<ActiveServices>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getActiveServicesAsync(final ApiCallback<ActiveServices> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getActiveServicesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ActiveServices>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAlertCall(Integer alertId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/alert/{alertId}".replaceAll("\\{alertId\\}", this.apiClient.escapeString(alertId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAlertValidateBeforeCall(Integer alertId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (alertId == null) {
            throw new ApiException("Missing the required parameter 'alertId' when calling getAlert(Async)");
        }
        Call call = this.getAlertCall(alertId, progressListener, progressRequestListener);
        return call;
    }

    public GetAlertInfo getAlert(Integer alertId) throws ApiException {
        ApiResponse<GetAlertInfo> resp = this.getAlertWithHttpInfo(alertId);
        return resp.getData();
    }

    public ApiResponse<GetAlertInfo> getAlertWithHttpInfo(Integer alertId) throws ApiException {
        Call call = this.getAlertValidateBeforeCall(alertId, null, null);
        Type localVarReturnType = new TypeToken<GetAlertInfo>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAlertAsync(Integer alertId, final ApiCallback<GetAlertInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAlertValidateBeforeCall(alertId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetAlertInfo>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAlertsStreamStatusCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/alerts/stream/status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAlertsStreamStatusValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAlertsStreamStatusCall(progressListener, progressRequestListener);
        return call;
    }

    public AlertsStreamStatus getAlertsStreamStatus() throws ApiException {
        ApiResponse<AlertsStreamStatus> resp = this.getAlertsStreamStatusWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<AlertsStreamStatus> getAlertsStreamStatusWithHttpInfo() throws ApiException {
        Call call = this.getAlertsStreamStatusValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<AlertsStreamStatus>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAlertsStreamStatusAsync(final ApiCallback<AlertsStreamStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAlertsStreamStatusValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AlertsStreamStatus>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDetailedWorkloadPoliciesCall(String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/workloadpolicies/detailed";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDetailedWorkloadPoliciesValidateBeforeCall(String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getDetailedWorkloadPoliciesCall(name, progressListener, progressRequestListener);
        return call;
    }

    public String getDetailedWorkloadPolicies(String name) throws ApiException {
        ApiResponse<String> resp = this.getDetailedWorkloadPoliciesWithHttpInfo(name);
        return resp.getData();
    }

    public ApiResponse<String> getDetailedWorkloadPoliciesWithHttpInfo(String name) throws ApiException {
        Call call = this.getDetailedWorkloadPoliciesValidateBeforeCall(name, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDetailedWorkloadPoliciesAsync(String name, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDetailedWorkloadPoliciesValidateBeforeCall(name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getEventsCall(String ctm, String server, String name, String date, Long limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        if (date != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("date", date));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getEventsValidateBeforeCall(String ctm, String server, String name, String date, Long limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getEventsCall(ctm, server, name, date, limit, progressListener, progressRequestListener);
        return call;
    }

    public EventSet getEvents(String ctm, String server, String name, String date, Long limit) throws ApiException {
        ApiResponse<EventSet> resp = this.getEventsWithHttpInfo(ctm, server, name, date, limit);
        return resp.getData();
    }

    public ApiResponse<EventSet> getEventsWithHttpInfo(String ctm, String server, String name, String date, Long limit) throws ApiException {
        Call call = this.getEventsValidateBeforeCall(ctm, server, name, date, limit, null, null);
        Type localVarReturnType = new TypeToken<EventSet>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getEventsAsync(String ctm, String server, String name, String date, Long limit, final ApiCallback<EventSet> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getEventsValidateBeforeCall(ctm, server, name, date, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EventSet>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getForecastTimelineCall(String ctm, String folder, String rbc, String jobs, String library, String filterType, Integer year, Integer from, Integer to, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/forecast/timeline";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (folder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folder", folder));
        }
        if (rbc != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("rbc", rbc));
        }
        if (jobs != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("jobs", jobs));
        }
        if (library != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("library", library));
        }
        if (filterType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filterType", filterType));
        }
        if (year != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("year", year));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getForecastTimelineValidateBeforeCall(String ctm, String folder, String rbc, String jobs, String library, String filterType, Integer year, Integer from, Integer to, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getForecastTimelineCall(ctm, folder, rbc, jobs, library, filterType, year, from, to, progressListener, progressRequestListener);
        return call;
    }

    public ForecastTimelineResults getForecastTimeline(String ctm, String folder, String rbc, String jobs, String library, String filterType, Integer year, Integer from, Integer to) throws ApiException {
        ApiResponse<ForecastTimelineResults> resp = this.getForecastTimelineWithHttpInfo(ctm, folder, rbc, jobs, library, filterType, year, from, to);
        return resp.getData();
    }

    public ApiResponse<ForecastTimelineResults> getForecastTimelineWithHttpInfo(String ctm, String folder, String rbc, String jobs, String library, String filterType, Integer year, Integer from, Integer to) throws ApiException {
        Call call = this.getForecastTimelineValidateBeforeCall(ctm, folder, rbc, jobs, library, filterType, year, from, to, null, null);
        Type localVarReturnType = new TypeToken<ForecastTimelineResults>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getForecastTimelineAsync(String ctm, String folder, String rbc, String jobs, String library, String filterType, Integer year, Integer from, Integer to, final ApiCallback<ForecastTimelineResults> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getForecastTimelineValidateBeforeCall(ctm, folder, rbc, jobs, library, filterType, year, from, to, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ForecastTimelineResults>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getJobLogCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/log".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getJobLogValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getJobLog(Async)");
        }
        Call call = this.getJobLogCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public String getJobLog(String jobId) throws ApiException {
        ApiResponse<String> resp = this.getJobLogWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<String> getJobLogWithHttpInfo(String jobId) throws ApiException {
        Call call = this.getJobLogValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getJobLogAsync(String jobId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getJobLogValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getJobOutputCall(String jobId, Long runNo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/output".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (runNo != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("runNo", runNo));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getJobOutputValidateBeforeCall(String jobId, Long runNo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getJobOutput(Async)");
        }
        Call call = this.getJobOutputCall(jobId, runNo, progressListener, progressRequestListener);
        return call;
    }

    public String getJobOutput(String jobId, Long runNo) throws ApiException {
        ApiResponse<String> resp = this.getJobOutputWithHttpInfo(jobId, runNo);
        return resp.getData();
    }

    public ApiResponse<String> getJobOutputWithHttpInfo(String jobId, Long runNo) throws ApiException {
        Call call = this.getJobOutputValidateBeforeCall(jobId, runNo, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getJobOutputAsync(String jobId, Long runNo, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getJobOutputValidateBeforeCall(jobId, runNo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getJobStatisticsCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/statistics".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getJobStatisticsValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getJobStatistics(Async)");
        }
        Call call = this.getJobStatisticsCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public Statistics getJobStatistics(String jobId) throws ApiException {
        ApiResponse<Statistics> resp = this.getJobStatisticsWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<Statistics> getJobStatisticsWithHttpInfo(String jobId) throws ApiException {
        Call call = this.getJobStatisticsValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<Statistics>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getJobStatisticsAsync(String jobId, final ApiCallback<Statistics> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getJobStatisticsValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Statistics>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getJobStatusCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/status".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getJobStatusValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getJobStatus(Async)");
        }
        Call call = this.getJobStatusCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public JobRunStatus getJobStatus(String jobId) throws ApiException {
        ApiResponse<JobRunStatus> resp = this.getJobStatusWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<JobRunStatus> getJobStatusWithHttpInfo(String jobId) throws ApiException {
        Call call = this.getJobStatusValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<JobRunStatus>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getJobStatusAsync(String jobId, final ApiCallback<JobRunStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getJobStatusValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<JobRunStatus>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getJobsStatusCall(String runId, Long startIndex, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/status/{runId}".replaceAll("\\{runId\\}", this.apiClient.escapeString(runId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startIndex != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startIndex", startIndex));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getJobsStatusValidateBeforeCall(String runId, Long startIndex, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getJobsStatus(Async)");
        }
        Call call = this.getJobsStatusCall(runId, startIndex, progressListener, progressRequestListener);
        return call;
    }

    public JobStatusResult getJobsStatus(String runId, Long startIndex) throws ApiException {
        ApiResponse<JobStatusResult> resp = this.getJobsStatusWithHttpInfo(runId, startIndex);
        return resp.getData();
    }

    public ApiResponse<JobStatusResult> getJobsStatusWithHttpInfo(String runId, Long startIndex) throws ApiException {
        Call call = this.getJobsStatusValidateBeforeCall(runId, startIndex, null, null);
        Type localVarReturnType = new TypeToken<JobStatusResult>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getJobsStatusAsync(String runId, Long startIndex, final ApiCallback<JobStatusResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getJobsStatusValidateBeforeCall(runId, startIndex, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<JobStatusResult>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getJobsStatusByFilterCall(Long limit, String jobname, String ctm, String server, String application, String subApplication, String host, String status, String folder, String description, String jobid, String neighborhood, Integer depth, String direction, String orderDateFrom, String orderDateTo, String historyRunDate, String fromTime, String toTime, String folderLibrary, String hostGroup, String runAs, String command, String filePath, String fileName, String workloadPolicy, String ruleBasedCalendar, String resourceMutex, String resourceSemaphore, String resourceLock, String resourcePool, Boolean held, Boolean folderHeld, Boolean cyclic, Boolean deleted, String eventDate, String eventName, String waitForEventDate, String waitForEventName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/jobs/status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (jobname != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("jobname", jobname));
        }
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (application != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("application", application));
        }
        if (subApplication != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("subApplication", subApplication));
        }
        if (host != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("host", host));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (folder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folder", folder));
        }
        if (description != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("description", description));
        }
        if (jobid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("jobid", jobid));
        }
        if (neighborhood != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("neighborhood", neighborhood));
        }
        if (depth != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("depth", depth));
        }
        if (direction != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("direction", direction));
        }
        if (orderDateFrom != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orderDateFrom", orderDateFrom));
        }
        if (orderDateTo != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orderDateTo", orderDateTo));
        }
        if (historyRunDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("historyRunDate", historyRunDate));
        }
        if (fromTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fromTime", fromTime));
        }
        if (toTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("toTime", toTime));
        }
        if (folderLibrary != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folderLibrary", folderLibrary));
        }
        if (hostGroup != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("hostGroup", hostGroup));
        }
        if (runAs != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("runAs", runAs));
        }
        if (command != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("command", command));
        }
        if (filePath != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filePath", filePath));
        }
        if (fileName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fileName", fileName));
        }
        if (workloadPolicy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("workloadPolicy", workloadPolicy));
        }
        if (ruleBasedCalendar != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ruleBasedCalendar", ruleBasedCalendar));
        }
        if (resourceMutex != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceMutex", resourceMutex));
        }
        if (resourceSemaphore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceSemaphore", resourceSemaphore));
        }
        if (resourceLock != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceLock", resourceLock));
        }
        if (resourcePool != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourcePool", resourcePool));
        }
        if (held != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("held", held));
        }
        if (folderHeld != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folderHeld", folderHeld));
        }
        if (cyclic != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cyclic", cyclic));
        }
        if (deleted != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("deleted", deleted));
        }
        if (eventDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("eventDate", eventDate));
        }
        if (eventName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("eventName", eventName));
        }
        if (waitForEventDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("waitForEventDate", waitForEventDate));
        }
        if (waitForEventName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("waitForEventName", waitForEventName));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getJobsStatusByFilterValidateBeforeCall(Long limit, String jobname, String ctm, String server, String application, String subApplication, String host, String status, String folder, String description, String jobid, String neighborhood, Integer depth, String direction, String orderDateFrom, String orderDateTo, String historyRunDate, String fromTime, String toTime, String folderLibrary, String hostGroup, String runAs, String command, String filePath, String fileName, String workloadPolicy, String ruleBasedCalendar, String resourceMutex, String resourceSemaphore, String resourceLock, String resourcePool, Boolean held, Boolean folderHeld, Boolean cyclic, Boolean deleted, String eventDate, String eventName, String waitForEventDate, String waitForEventName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getJobsStatusByFilterCall(limit, jobname, ctm, server, application, subApplication, host, status, folder, description, jobid, neighborhood, depth, direction, orderDateFrom, orderDateTo, historyRunDate, fromTime, toTime, folderLibrary, hostGroup, runAs, command, filePath, fileName, workloadPolicy, ruleBasedCalendar, resourceMutex, resourceSemaphore, resourceLock, resourcePool, held, folderHeld, cyclic, deleted, eventDate, eventName, waitForEventDate, waitForEventName, progressListener, progressRequestListener);
        return call;
    }

    public JobStatusResult getJobsStatusByFilter(Long limit, String jobname, String ctm, String server, String application, String subApplication, String host, String status, String folder, String description, String jobid, String neighborhood, Integer depth, String direction, String orderDateFrom, String orderDateTo, String historyRunDate, String fromTime, String toTime, String folderLibrary, String hostGroup, String runAs, String command, String filePath, String fileName, String workloadPolicy, String ruleBasedCalendar, String resourceMutex, String resourceSemaphore, String resourceLock, String resourcePool, Boolean held, Boolean folderHeld, Boolean cyclic, Boolean deleted, String eventDate, String eventName, String waitForEventDate, String waitForEventName) throws ApiException {
        ApiResponse<JobStatusResult> resp = this.getJobsStatusByFilterWithHttpInfo(limit, jobname, ctm, server, application, subApplication, host, status, folder, description, jobid, neighborhood, depth, direction, orderDateFrom, orderDateTo, historyRunDate, fromTime, toTime, folderLibrary, hostGroup, runAs, command, filePath, fileName, workloadPolicy, ruleBasedCalendar, resourceMutex, resourceSemaphore, resourceLock, resourcePool, held, folderHeld, cyclic, deleted, eventDate, eventName, waitForEventDate, waitForEventName);
        return resp.getData();
    }

    public ApiResponse<JobStatusResult> getJobsStatusByFilterWithHttpInfo(Long limit, String jobname, String ctm, String server, String application, String subApplication, String host, String status, String folder, String description, String jobid, String neighborhood, Integer depth, String direction, String orderDateFrom, String orderDateTo, String historyRunDate, String fromTime, String toTime, String folderLibrary, String hostGroup, String runAs, String command, String filePath, String fileName, String workloadPolicy, String ruleBasedCalendar, String resourceMutex, String resourceSemaphore, String resourceLock, String resourcePool, Boolean held, Boolean folderHeld, Boolean cyclic, Boolean deleted, String eventDate, String eventName, String waitForEventDate, String waitForEventName) throws ApiException {
        Call call = this.getJobsStatusByFilterValidateBeforeCall(limit, jobname, ctm, server, application, subApplication, host, status, folder, description, jobid, neighborhood, depth, direction, orderDateFrom, orderDateTo, historyRunDate, fromTime, toTime, folderLibrary, hostGroup, runAs, command, filePath, fileName, workloadPolicy, ruleBasedCalendar, resourceMutex, resourceSemaphore, resourceLock, resourcePool, held, folderHeld, cyclic, deleted, eventDate, eventName, waitForEventDate, waitForEventName, null, null);
        Type localVarReturnType = new TypeToken<JobStatusResult>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getJobsStatusByFilterAsync(Long limit, String jobname, String ctm, String server, String application, String subApplication, String host, String status, String folder, String description, String jobid, String neighborhood, Integer depth, String direction, String orderDateFrom, String orderDateTo, String historyRunDate, String fromTime, String toTime, String folderLibrary, String hostGroup, String runAs, String command, String filePath, String fileName, String workloadPolicy, String ruleBasedCalendar, String resourceMutex, String resourceSemaphore, String resourceLock, String resourcePool, Boolean held, Boolean folderHeld, Boolean cyclic, Boolean deleted, String eventDate, String eventName, String waitForEventDate, String waitForEventName, final ApiCallback<JobStatusResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getJobsStatusByFilterValidateBeforeCall(limit, jobname, ctm, server, application, subApplication, host, status, folder, description, jobid, neighborhood, depth, direction, orderDateFrom, orderDateTo, historyRunDate, fromTime, toTime, folderLibrary, hostGroup, runAs, command, filePath, fileName, workloadPolicy, ruleBasedCalendar, resourceMutex, resourceSemaphore, resourceLock, resourcePool, held, folderHeld, cyclic, deleted, eventDate, eventName, waitForEventDate, waitForEventName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<JobStatusResult>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getListOfUnOrderedJobsForSpecifiedUserDailyCall(String poll, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/userDaily/missing/poll/{poll}".replaceAll("\\{poll\\}", this.apiClient.escapeString(poll.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getListOfUnOrderedJobsForSpecifiedUserDailyValidateBeforeCall(String poll, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (poll == null) {
            throw new ApiException("Missing the required parameter 'poll' when calling getListOfUnOrderedJobsForSpecifiedUserDaily(Async)");
        }
        Call call = this.getListOfUnOrderedJobsForSpecifiedUserDailyCall(poll, progressListener, progressRequestListener);
        return call;
    }

    public CtmudchkJobsResults getListOfUnOrderedJobsForSpecifiedUserDaily(String poll) throws ApiException {
        ApiResponse<CtmudchkJobsResults> resp = this.getListOfUnOrderedJobsForSpecifiedUserDailyWithHttpInfo(poll);
        return resp.getData();
    }

    public ApiResponse<CtmudchkJobsResults> getListOfUnOrderedJobsForSpecifiedUserDailyWithHttpInfo(String poll) throws ApiException {
        Call call = this.getListOfUnOrderedJobsForSpecifiedUserDailyValidateBeforeCall(poll, null, null);
        Type localVarReturnType = new TypeToken<CtmudchkJobsResults>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getListOfUnOrderedJobsForSpecifiedUserDailyAsync(String poll, final ApiCallback<CtmudchkJobsResults> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getListOfUnOrderedJobsForSpecifiedUserDailyValidateBeforeCall(poll, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CtmudchkJobsResults>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getRelatedJobServicesCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/related".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getRelatedJobServicesValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getRelatedJobServices(Async)");
        }
        Call call = this.getRelatedJobServicesCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public JobRelatedServicesData getRelatedJobServices(String jobId) throws ApiException {
        ApiResponse<JobRelatedServicesData> resp = this.getRelatedJobServicesWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<JobRelatedServicesData> getRelatedJobServicesWithHttpInfo(String jobId) throws ApiException {
        Call call = this.getRelatedJobServicesValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<JobRelatedServicesData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getRelatedJobServicesAsync(String jobId, final ApiCallback<JobRelatedServicesData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getRelatedJobServicesValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<JobRelatedServicesData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getResourcesCall(String ctm, String server, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/resources";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getResourcesValidateBeforeCall(String ctm, String server, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getResourcesCall(ctm, server, name, progressListener, progressRequestListener);
        return call;
    }

    public ResourceSet getResources(String ctm, String server, String name) throws ApiException {
        ApiResponse<ResourceSet> resp = this.getResourcesWithHttpInfo(ctm, server, name);
        return resp.getData();
    }

    public ApiResponse<ResourceSet> getResourcesWithHttpInfo(String ctm, String server, String name) throws ApiException {
        Call call = this.getResourcesValidateBeforeCall(ctm, server, name, null, null);
        Type localVarReturnType = new TypeToken<ResourceSet>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getResourcesAsync(String ctm, String server, String name, final ApiCallback<ResourceSet> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getResourcesValidateBeforeCall(ctm, server, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResourceSet>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUnOrderedJobsForSpecifiedUserDailyCall(String userDaily, String server, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/userDaily/{userDaily}/missing/list".replaceAll("\\{userDaily\\}", this.apiClient.escapeString(userDaily.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUnOrderedJobsForSpecifiedUserDailyValidateBeforeCall(String userDaily, String server, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (userDaily == null) {
            throw new ApiException("Missing the required parameter 'userDaily' when calling getUnOrderedJobsForSpecifiedUserDaily(Async)");
        }
        Call call = this.getUnOrderedJobsForSpecifiedUserDailyCall(userDaily, server, progressListener, progressRequestListener);
        return call;
    }

    public CtmudchkResults getUnOrderedJobsForSpecifiedUserDaily(String userDaily, String server) throws ApiException {
        ApiResponse<CtmudchkResults> resp = this.getUnOrderedJobsForSpecifiedUserDailyWithHttpInfo(userDaily, server);
        return resp.getData();
    }

    public ApiResponse<CtmudchkResults> getUnOrderedJobsForSpecifiedUserDailyWithHttpInfo(String userDaily, String server) throws ApiException {
        Call call = this.getUnOrderedJobsForSpecifiedUserDailyValidateBeforeCall(userDaily, server, null, null);
        Type localVarReturnType = new TypeToken<CtmudchkResults>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUnOrderedJobsForSpecifiedUserDailyAsync(String userDaily, String server, final ApiCallback<CtmudchkResults> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUnOrderedJobsForSpecifiedUserDailyValidateBeforeCall(userDaily, server, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CtmudchkResults>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getVariablesCall(String pool, String variable, String server, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/variables";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pool != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pool", pool));
        }
        if (variable != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("variable", variable));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getVariablesValidateBeforeCall(String pool, String variable, String server, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getVariablesCall(pool, variable, server, progressListener, progressRequestListener);
        return call;
    }

    public Variables getVariables(String pool, String variable, String server) throws ApiException {
        ApiResponse<Variables> resp = this.getVariablesWithHttpInfo(pool, variable, server);
        return resp.getData();
    }

    public ApiResponse<Variables> getVariablesWithHttpInfo(String pool, String variable, String server) throws ApiException {
        Call call = this.getVariablesValidateBeforeCall(pool, variable, server, null, null);
        Type localVarReturnType = new TypeToken<Variables>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getVariablesAsync(String pool, String variable, String server, final ApiCallback<Variables> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getVariablesValidateBeforeCall(pool, variable, server, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Variables>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getWaitingInfoCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/waitingInfo".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWaitingInfoValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getWaitingInfo(Async)");
        }
        Call call = this.getWaitingInfoCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public StringListResult getWaitingInfo(String jobId) throws ApiException {
        ApiResponse<StringListResult> resp = this.getWaitingInfoWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<StringListResult> getWaitingInfoWithHttpInfo(String jobId) throws ApiException {
        Call call = this.getWaitingInfoValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<StringListResult>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWaitingInfoAsync(String jobId, final ApiCallback<StringListResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWaitingInfoValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<StringListResult>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getWorkloadPoliciesCall(String state, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/workloadpolicies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (state != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("state", state));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWorkloadPoliciesValidateBeforeCall(String state, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getWorkloadPoliciesCall(state, progressListener, progressRequestListener);
        return call;
    }

    public WorkloadPolicyList getWorkloadPolicies(String state) throws ApiException {
        ApiResponse<WorkloadPolicyList> resp = this.getWorkloadPoliciesWithHttpInfo(state);
        return resp.getData();
    }

    public ApiResponse<WorkloadPolicyList> getWorkloadPoliciesWithHttpInfo(String state) throws ApiException {
        Call call = this.getWorkloadPoliciesValidateBeforeCall(state, null, null);
        Type localVarReturnType = new TypeToken<WorkloadPolicyList>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWorkloadPoliciesAsync(String state, final ApiCallback<WorkloadPolicyList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWorkloadPoliciesValidateBeforeCall(state, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkloadPolicyList>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call holdJobCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/hold".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call holdJobValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling holdJob(Async)");
        }
        Call call = this.holdJobCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData holdJob(String jobId) throws ApiException {
        ApiResponse<SuccessData> resp = this.holdJobWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<SuccessData> holdJobWithHttpInfo(String jobId) throws ApiException {
        Call call = this.holdJobValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call holdJobAsync(String jobId, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.holdJobValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call killJobCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/kill".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call killJobValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling killJob(Async)");
        }
        Call call = this.killJobCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData killJob(String jobId) throws ApiException {
        ApiResponse<SuccessData> resp = this.killJobWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<SuccessData> killJobWithHttpInfo(String jobId) throws ApiException {
        Call call = this.killJobValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call killJobAsync(String jobId, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.killJobValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call modifyJobCall(File jobDefinitionsFile, String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/modify".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (jobDefinitionsFile != null) {
            localVarFormParams.put("jobDefinitionsFile", jobDefinitionsFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call modifyJobValidateBeforeCall(File jobDefinitionsFile, String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobDefinitionsFile == null) {
            throw new ApiException("Missing the required parameter 'jobDefinitionsFile' when calling modifyJob(Async)");
        }
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling modifyJob(Async)");
        }
        Call call = this.modifyJobCall(jobDefinitionsFile, jobId, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData modifyJob(File jobDefinitionsFile, String jobId) throws ApiException {
        ApiResponse<SuccessData> resp = this.modifyJobWithHttpInfo(jobDefinitionsFile, jobId);
        return resp.getData();
    }

    public ApiResponse<SuccessData> modifyJobWithHttpInfo(File jobDefinitionsFile, String jobId) throws ApiException {
        Call call = this.modifyJobValidateBeforeCall(jobDefinitionsFile, jobId, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call modifyJobAsync(File jobDefinitionsFile, String jobId, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.modifyJobValidateBeforeCall(jobDefinitionsFile, jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call openAlertsStreamCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/alerts/stream/open";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call openAlertsStreamValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.openAlertsStreamCall(progressListener, progressRequestListener);
        return call;
    }

    public String openAlertsStream() throws ApiException {
        ApiResponse<String> resp = this.openAlertsStreamWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<String> openAlertsStreamWithHttpInfo() throws ApiException {
        Call call = this.openAlertsStreamValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call openAlertsStreamAsync(final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.openAlertsStreamValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call orderJobsInFolderCall(OrderFolderParameters data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OrderFolderParameters localVarPostBody = data;
        String localVarPath = "/run/order";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orderJobsInFolderValidateBeforeCall(OrderFolderParameters data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.orderJobsInFolderCall(data, progressListener, progressRequestListener);
        return call;
    }

    public RunResult orderJobsInFolder(OrderFolderParameters data) throws ApiException {
        ApiResponse<RunResult> resp = this.orderJobsInFolderWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<RunResult> orderJobsInFolderWithHttpInfo(OrderFolderParameters data) throws ApiException {
        Call call = this.orderJobsInFolderValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<RunResult>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orderJobsInFolderAsync(OrderFolderParameters data, final ApiCallback<RunResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orderJobsInFolderValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RunResult>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call pollForecastTimelineRequestCall(String poll, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/forecast/timeline/poll/{poll}".replaceAll("\\{poll\\}", this.apiClient.escapeString(poll.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call pollForecastTimelineRequestValidateBeforeCall(String poll, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (poll == null) {
            throw new ApiException("Missing the required parameter 'poll' when calling pollForecastTimelineRequest(Async)");
        }
        Call call = this.pollForecastTimelineRequestCall(poll, progressListener, progressRequestListener);
        return call;
    }

    public PollForecastTimelineResults pollForecastTimelineRequest(String poll) throws ApiException {
        ApiResponse<PollForecastTimelineResults> resp = this.pollForecastTimelineRequestWithHttpInfo(poll);
        return resp.getData();
    }

    public ApiResponse<PollForecastTimelineResults> pollForecastTimelineRequestWithHttpInfo(String poll) throws ApiException {
        Call call = this.pollForecastTimelineRequestValidateBeforeCall(poll, null, null);
        Type localVarReturnType = new TypeToken<PollForecastTimelineResults>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call pollForecastTimelineRequestAsync(String poll, final ApiCallback<PollForecastTimelineResults> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.pollForecastTimelineRequestValidateBeforeCall(poll, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PollForecastTimelineResults>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call rerunJobCall(String jobId, RerunParameters zosJobConfig, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RerunParameters localVarPostBody = zosJobConfig;
        String localVarPath = "/run/job/{jobId}/rerun".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call rerunJobValidateBeforeCall(String jobId, RerunParameters zosJobConfig, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling rerunJob(Async)");
        }
        Call call = this.rerunJobCall(jobId, zosJobConfig, progressListener, progressRequestListener);
        return call;
    }

    public JobRunStatus rerunJob(String jobId, RerunParameters zosJobConfig) throws ApiException {
        ApiResponse<JobRunStatus> resp = this.rerunJobWithHttpInfo(jobId, zosJobConfig);
        return resp.getData();
    }

    public ApiResponse<JobRunStatus> rerunJobWithHttpInfo(String jobId, RerunParameters zosJobConfig) throws ApiException {
        Call call = this.rerunJobValidateBeforeCall(jobId, zosJobConfig, null, null);
        Type localVarReturnType = new TypeToken<JobRunStatus>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call rerunJobAsync(String jobId, RerunParameters zosJobConfig, final ApiCallback<JobRunStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.rerunJobValidateBeforeCall(jobId, zosJobConfig, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<JobRunStatus>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call runJobsCall(File jobDefinitionsFile, File deployDescriptorFile, File additionalConfiguration, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/run";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (jobDefinitionsFile != null) {
            localVarFormParams.put("jobDefinitionsFile", jobDefinitionsFile);
        }
        if (deployDescriptorFile != null) {
            localVarFormParams.put("deployDescriptorFile", deployDescriptorFile);
        }
        if (additionalConfiguration != null) {
            localVarFormParams.put("additionalConfiguration", additionalConfiguration);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runJobsValidateBeforeCall(File jobDefinitionsFile, File deployDescriptorFile, File additionalConfiguration, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobDefinitionsFile == null) {
            throw new ApiException("Missing the required parameter 'jobDefinitionsFile' when calling runJobs(Async)");
        }
        Call call = this.runJobsCall(jobDefinitionsFile, deployDescriptorFile, additionalConfiguration, progressListener, progressRequestListener);
        return call;
    }

    public RunResult runJobs(File jobDefinitionsFile, File deployDescriptorFile, File additionalConfiguration) throws ApiException {
        ApiResponse<RunResult> resp = this.runJobsWithHttpInfo(jobDefinitionsFile, deployDescriptorFile, additionalConfiguration);
        return resp.getData();
    }

    public ApiResponse<RunResult> runJobsWithHttpInfo(File jobDefinitionsFile, File deployDescriptorFile, File additionalConfiguration) throws ApiException {
        Call call = this.runJobsValidateBeforeCall(jobDefinitionsFile, deployDescriptorFile, additionalConfiguration, null, null);
        Type localVarReturnType = new TypeToken<RunResult>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call runJobsAsync(File jobDefinitionsFile, File deployDescriptorFile, File additionalConfiguration, final ApiCallback<RunResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runJobsValidateBeforeCall(jobDefinitionsFile, deployDescriptorFile, additionalConfiguration, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RunResult>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call runNowCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/runNow".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runNowValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling runNow(Async)");
        }
        Call call = this.runNowCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData runNow(String jobId) throws ApiException {
        ApiResponse<SuccessData> resp = this.runNowWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<SuccessData> runNowWithHttpInfo(String jobId) throws ApiException {
        Call call = this.runNowValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call runNowAsync(String jobId, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runNowValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call runOnDemandCall(File definitionsFile, File deployDescriptorFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/run/ondemand";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (definitionsFile != null) {
            localVarFormParams.put("definitionsFile", definitionsFile);
        }
        if (deployDescriptorFile != null) {
            localVarFormParams.put("deployDescriptorFile", deployDescriptorFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runOnDemandValidateBeforeCall(File definitionsFile, File deployDescriptorFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (definitionsFile == null) {
            throw new ApiException("Missing the required parameter 'definitionsFile' when calling runOnDemand(Async)");
        }
        Call call = this.runOnDemandCall(definitionsFile, deployDescriptorFile, progressListener, progressRequestListener);
        return call;
    }

    public RunResult runOnDemand(File definitionsFile, File deployDescriptorFile) throws ApiException {
        ApiResponse<RunResult> resp = this.runOnDemandWithHttpInfo(definitionsFile, deployDescriptorFile);
        return resp.getData();
    }

    public ApiResponse<RunResult> runOnDemandWithHttpInfo(File definitionsFile, File deployDescriptorFile) throws ApiException {
        Call call = this.runOnDemandValidateBeforeCall(definitionsFile, deployDescriptorFile, null, null);
        Type localVarReturnType = new TypeToken<RunResult>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call runOnDemandAsync(File definitionsFile, File deployDescriptorFile, final ApiCallback<RunResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runOnDemandValidateBeforeCall(definitionsFile, deployDescriptorFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RunResult>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call runUnOrderedJobsForSpecifiedUserDailyCall(String userDaily, String server, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/userDaily/{userDaily}/missing/run".replaceAll("\\{userDaily\\}", this.apiClient.escapeString(userDaily.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runUnOrderedJobsForSpecifiedUserDailyValidateBeforeCall(String userDaily, String server, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (userDaily == null) {
            throw new ApiException("Missing the required parameter 'userDaily' when calling runUnOrderedJobsForSpecifiedUserDaily(Async)");
        }
        Call call = this.runUnOrderedJobsForSpecifiedUserDailyCall(userDaily, server, progressListener, progressRequestListener);
        return call;
    }

    public RunResult runUnOrderedJobsForSpecifiedUserDaily(String userDaily, String server) throws ApiException {
        ApiResponse<RunResult> resp = this.runUnOrderedJobsForSpecifiedUserDailyWithHttpInfo(userDaily, server);
        return resp.getData();
    }

    public ApiResponse<RunResult> runUnOrderedJobsForSpecifiedUserDailyWithHttpInfo(String userDaily, String server) throws ApiException {
        Call call = this.runUnOrderedJobsForSpecifiedUserDailyValidateBeforeCall(userDaily, server, null, null);
        Type localVarReturnType = new TypeToken<RunResult>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call runUnOrderedJobsForSpecifiedUserDailyAsync(String userDaily, String server, final ApiCallback<RunResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runUnOrderedJobsForSpecifiedUserDailyValidateBeforeCall(userDaily, server, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RunResult>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call setAlertsStreamTemplateCall(AlertsStreamTemplate templateFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AlertsStreamTemplate localVarPostBody = templateFile;
        String localVarPath = "/run/alerts/stream/template";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call setAlertsStreamTemplateValidateBeforeCall(AlertsStreamTemplate templateFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (templateFile == null) {
            throw new ApiException("Missing the required parameter 'templateFile' when calling setAlertsStreamTemplate(Async)");
        }
        Call call = this.setAlertsStreamTemplateCall(templateFile, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData setAlertsStreamTemplate(AlertsStreamTemplate templateFile) throws ApiException {
        ApiResponse<SuccessData> resp = this.setAlertsStreamTemplateWithHttpInfo(templateFile);
        return resp.getData();
    }

    public ApiResponse<SuccessData> setAlertsStreamTemplateWithHttpInfo(AlertsStreamTemplate templateFile) throws ApiException {
        Call call = this.setAlertsStreamTemplateValidateBeforeCall(templateFile, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call setAlertsStreamTemplateAsync(AlertsStreamTemplate templateFile, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.setAlertsStreamTemplateValidateBeforeCall(templateFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call setToOKCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/setToOk".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call setToOKValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling setToOK(Async)");
        }
        Call call = this.setToOKCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData setToOK(String jobId) throws ApiException {
        ApiResponse<SuccessData> resp = this.setToOKWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<SuccessData> setToOKWithHttpInfo(String jobId) throws ApiException {
        Call call = this.setToOKValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call setToOKAsync(String jobId, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.setToOKValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call setVariablesCall(String server, Variables variablesFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Variables localVarPostBody = variablesFile;
        String localVarPath = "/run/variables/{server}".replaceAll("\\{server\\}", this.apiClient.escapeString(server.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call setVariablesValidateBeforeCall(String server, Variables variablesFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (server == null) {
            throw new ApiException("Missing the required parameter 'server' when calling setVariables(Async)");
        }
        if (variablesFile == null) {
            throw new ApiException("Missing the required parameter 'variablesFile' when calling setVariables(Async)");
        }
        Call call = this.setVariablesCall(server, variablesFile, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData setVariables(String server, Variables variablesFile) throws ApiException {
        ApiResponse<SuccessData> resp = this.setVariablesWithHttpInfo(server, variablesFile);
        return resp.getData();
    }

    public ApiResponse<SuccessData> setVariablesWithHttpInfo(String server, Variables variablesFile) throws ApiException {
        Call call = this.setVariablesValidateBeforeCall(server, variablesFile, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call setVariablesAsync(String server, Variables variablesFile, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.setVariablesValidateBeforeCall(server, variablesFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call undeleteJobCall(String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run/job/{jobId}/undelete".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call undeleteJobValidateBeforeCall(String jobId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling undeleteJob(Async)");
        }
        Call call = this.undeleteJobCall(jobId, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData undeleteJob(String jobId) throws ApiException {
        ApiResponse<SuccessData> resp = this.undeleteJobWithHttpInfo(jobId);
        return resp.getData();
    }

    public ApiResponse<SuccessData> undeleteJobWithHttpInfo(String jobId) throws ApiException {
        Call call = this.undeleteJobValidateBeforeCall(jobId, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call undeleteJobAsync(String jobId, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.undeleteJobValidateBeforeCall(jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateAlertCall(AlertParam alertModifyValue, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AlertParam localVarPostBody = alertModifyValue;
        String localVarPath = "/run/alerts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateAlertValidateBeforeCall(AlertParam alertModifyValue, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (alertModifyValue == null) {
            throw new ApiException("Missing the required parameter 'alertModifyValue' when calling updateAlert(Async)");
        }
        Call call = this.updateAlertCall(alertModifyValue, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData updateAlert(AlertParam alertModifyValue) throws ApiException {
        ApiResponse<SuccessData> resp = this.updateAlertWithHttpInfo(alertModifyValue);
        return resp.getData();
    }

    public ApiResponse<SuccessData> updateAlertWithHttpInfo(AlertParam alertModifyValue) throws ApiException {
        Call call = this.updateAlertValidateBeforeCall(alertModifyValue, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAlertAsync(AlertParam alertModifyValue, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateAlertValidateBeforeCall(alertModifyValue, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateAlertStatusCall(AlertStatusParam alertModifyStatusValue, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AlertStatusParam localVarPostBody = alertModifyStatusValue;
        String localVarPath = "/run/alerts/status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateAlertStatusValidateBeforeCall(AlertStatusParam alertModifyStatusValue, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (alertModifyStatusValue == null) {
            throw new ApiException("Missing the required parameter 'alertModifyStatusValue' when calling updateAlertStatus(Async)");
        }
        Call call = this.updateAlertStatusCall(alertModifyStatusValue, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData updateAlertStatus(AlertStatusParam alertModifyStatusValue) throws ApiException {
        ApiResponse<SuccessData> resp = this.updateAlertStatusWithHttpInfo(alertModifyStatusValue);
        return resp.getData();
    }

    public ApiResponse<SuccessData> updateAlertStatusWithHttpInfo(AlertStatusParam alertModifyStatusValue) throws ApiException {
        Call call = this.updateAlertStatusValidateBeforeCall(alertModifyStatusValue, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAlertStatusAsync(AlertStatusParam alertModifyStatusValue, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateAlertStatusValidateBeforeCall(alertModifyStatusValue, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateResourceCall(String server, String name, ResourceMax max, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ResourceMax localVarPostBody = max;
        String localVarPath = "/run/resource/{server}/{name}".replaceAll("\\{server\\}", this.apiClient.escapeString(server.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateResourceValidateBeforeCall(String server, String name, ResourceMax max, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (server == null) {
            throw new ApiException("Missing the required parameter 'server' when calling updateResource(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateResource(Async)");
        }
        if (max == null) {
            throw new ApiException("Missing the required parameter 'max' when calling updateResource(Async)");
        }
        Call call = this.updateResourceCall(server, name, max, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData updateResource(String server, String name, ResourceMax max) throws ApiException {
        ApiResponse<SuccessData> resp = this.updateResourceWithHttpInfo(server, name, max);
        return resp.getData();
    }

    public ApiResponse<SuccessData> updateResourceWithHttpInfo(String server, String name, ResourceMax max) throws ApiException {
        Call call = this.updateResourceValidateBeforeCall(server, name, max, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateResourceAsync(String server, String name, ResourceMax max, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateResourceValidateBeforeCall(server, name, max, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

