/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms.bmcdiscovery;

import com.bmc.ctmconvert.bmcdiscovery.OSDiscoveryFilesWriter;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public class MsDiscoveryFilesWriter
extends OSDiscoveryFilesWriter {
    public MsDiscoveryFilesWriter(FileSystem fileSystem, String destDirectory) {
        super(fileSystem, destDirectory);
    }

    public MsDiscoveryFilesWriter(String destDirectory) {
        super(FileSystems.getDefault(), destDirectory);
    }

    public void writeOSfiles(Map definitions) throws IOException {
        Map msMap = definitions;
        for (Map.Entry hostEntry : msMap.entrySet()) {
            String hostName = ((String)hostEntry.getKey()).trim();
            String msDef = (String)hostEntry.getValue();
            if (msDef.trim().equals("")) continue;
            String fileSuffix = hostName.trim().toLowerCase().endsWith(".csv") ? ".csv" : ".xml";
            String fileName = hostName + fileSuffix;
            String fileFullPathAsString = String.format("%s/%s", this.destDirectory, fileName);
            Path fileFullPath = this.fileSystem.getPath(fileFullPathAsString, new String[0]);
            Files.createFile(fileFullPath, new FileAttribute[0]);
            Files.write(fileFullPath, msDef.getBytes(), new OpenOption[0]);
        }
    }
}

