/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.ms.MSDefs;
import com.bmc.ctmconvert.ms.MSGlobals;
import com.bmc.ctmconvert.ms.MSJob;
import com.bmc.ctmconvert.ms.RBCUtil;
import com.bmc.ctmconvert.ms.Task;
import com.bmc.ctmconvert.ms.TasksDirectories;
import com.bmc.ctmconvert.ms.XMLToTask;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class MSDirectory
implements SchedEntity {
    private static RulesDataSet mRules = RuleManager.instance().getCurrentRules();
    private boolean bIgnoreDisabledTasks = mRules.getBooleanRule("MS rules", new String[]{"IGNORE_DISABLED_TASKS"});
    private boolean bIgnoreDisabledTriggers = mRules.getBooleanRule("MS rules", new String[]{"IGNORE_DISABLED_TRIGGERS"});
    private List<AssistingJob> mAssistingJobsList = new ArrayList<AssistingJob>();
    private String mPath;
    private String mStartPath;
    private SchedEntity.TYPE mType;
    private List<SchedEntity> childrenListSchedEnt;
    private List<Task.Trigger> mTriggersList;
    private boolean mbDirectoryOfMS;
    private ArrayList<String> mMessagesList;
    private List<String> mRBCsList;
    private String mTableNamePrefix;
    private String mJobName;
    private String mNodeId;
    private String mNodeIdOriginal;
    private boolean bHasWarnings;
    private Properties mShoutProperties;
    public static HashMap<String, List<AssistingJob>> mapMachine_AssistingJobsList;

    public MSDirectory(String path, String startPath, SchedEntity.TYPE dirType, List<String> childrenList, List<Task.Trigger> inTriggersList, String parentName) {
        this.mPath = path;
        this.mStartPath = startPath;
        this.mType = dirType;
        this.mbDirectoryOfMS = true;
        this.mTriggersList = null != inTriggersList ? new ArrayList<Task.Trigger>(inTriggersList) : null;
        this.mRBCsList = null;
        this.mMessagesList = new ArrayList();
        this.mNodeIdOriginal = this.getMachineId();
        this.mNodeId = FieldValidation.instance().validateAndReturnFixedValue("NODEID", this.mNodeIdOriginal);
        this.mJobName = FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", mRules.getNameManipulator().manipulateName(TasksDirectories.getDirectoryLastName(this.mPath + MSGlobals.FILESEPARATOR + MSGlobals.FILESEPARATOR), this.mType));
        if (!this.mNodeId.equalsIgnoreCase(this.mNodeIdOriginal)) {
            String msgID = null;
            msgID = this.mNodeIdOriginal.length() != this.mNodeId.length() ? "WRN10005" : "WRN10004";
            Reporter.addMessage(this.mMessagesList, (String)msgID, (String)this.mJobName, (String[])new String[]{this.getOriginalJobName(), this.mNodeIdOriginal, this.mNodeId});
        }
        this.mTableNamePrefix = this.mType.equals((Object)SchedEntity.TYPE.SMART_TABLE) ? this.mNodeId : parentName + "/" + this.mJobName;
        this.bHasWarnings = false;
        this.mShoutProperties = null;
        if (null == childrenList) {
            this.mbDirectoryOfMS = false;
            return;
        }
        this.childrenListSchedEnt = new ArrayList<SchedEntity>();
        HashMap<String, String> filterDetails = new HashMap<String, String>();
        block0: for (String child : TasksDirectories.getFirstLevelChildrenOfParent(childrenList, this.mPath)) {
            if (TasksDirectories.isTask(child)) {
                Task jobTask = XMLToTask.getTaskFromXML(child, "");
                if (null == jobTask) {
                    ExceptionHandler.writeToExceptionFile((String)("The XML file: " + child + " was not parsed OK and will be ignored"));
                    Reporter.addMessage(this.mMessagesList, (String)"ERR10001", (String)this.mJobName, (String[])new String[]{child});
                    continue;
                }
                if (jobTask.getSettings() != null && this.bIgnoreDisabledTasks && !jobTask.getSettings().getEnabled()) {
                    this.bHasWarnings = true;
                    Reporter.addMessage(this.mMessagesList, (String)"INF10003", (String)this.mJobName, (String[])new String[]{TasksDirectories.getTaskFullName(child, this.mStartPath)});
                    continue;
                }
                List<Task.Action> actionsList = jobTask.getActions().getActionsList();
                List<Task.Trigger> triggersList = jobTask.getTriggers();
                int iConvertibleActions = 0;
                int iConvertibleTriggers = 0;
                String sAuthor = "emuser";
                if (null != jobTask.getRegistrationInfo().getAuthor()) {
                    sAuthor = FieldValidation.instance().validateAndReturnFixedValue("AUTHOR", jobTask.getRegistrationInfo().getAuthor());
                }
                String sOwner = "emuser";
                if (null != jobTask.getPrincipals().get(0).getUserId()) {
                    sOwner = FieldValidation.instance().validateAndReturnFixedValue("OWNER", jobTask.getPrincipals().get(0).getUserId());
                }
                String sDescription = "";
                if (null != jobTask.getRegistrationInfo().getDescription()) {
                    sDescription = FieldValidation.instance().validateAndReturnFixedValue("DESCRIPTION", jobTask.getRegistrationInfo().getDescription());
                }
                int iPriority = 7;
                if (jobTask.getSettings() != null) {
                    iPriority = jobTask.getSettings().getPriority();
                }
                if (iPriority < 0 || iPriority > 10) {
                    iPriority = 7;
                }
                for (Task.Action currentAction : actionsList) {
                    if (currentAction.getActionType().equals("ComHandler")) continue;
                    ++iConvertibleActions;
                }
                if (null != triggersList) {
                    for (Task.Trigger currentTrigger : triggersList) {
                        if (!currentTrigger.getTriggerType().equals("TimeTrigger") && !currentTrigger.getTriggerType().equals("CalendarTrigger")) continue;
                        ++iConvertibleTriggers;
                    }
                }
                if (iConvertibleActions == 0 && iConvertibleTriggers == 0) {
                    Reporter.addMessage(this.mMessagesList, (String)"INF10004", (String)this.mJobName, (String[])new String[]{TasksDirectories.getTaskFullName(child, this.mStartPath)});
                    this.bHasWarnings = true;
                    continue;
                }
                filterDetails.put("User Name", sOwner);
                filterDetails.put("Task Name", TasksDirectories.getTaskFileName(child));
                filterDetails.put("Location", child);
                if (iConvertibleActions == 0) {
                    if (!mRules.getFilterHandler().isFilter(filterDetails)) continue;
                    MSJob dummyJob = new MSJob(child, this.mStartPath, null, triggersList, sAuthor, sOwner, sDescription, iPriority, this.mTableNamePrefix);
                    this.childrenListSchedEnt.add(dummyJob);
                    this.addAssistingJob(dummyJob, null);
                    continue;
                }
                if (iConvertibleActions == 1) {
                    for (Task.Action currentAction : actionsList) {
                        if (currentAction.getActionType().equals("ComHandler")) continue;
                        if (!mRules.getFilterHandler().isFilter(filterDetails)) continue block0;
                        MSJob msJob = new MSJob(child, this.mStartPath, currentAction, triggersList, sAuthor, sOwner, sDescription, iPriority, this.mTableNamePrefix);
                        this.childrenListSchedEnt.add(msJob);
                        this.addAssistingJob(msJob, null);
                        continue block0;
                    }
                    continue;
                }
                if (!mRules.getFilterHandler().isFilter(filterDetails)) continue;
                MSDirectory subTable = new MSDirectory(child, this.mStartPath, SchedEntity.TYPE.SUB_TABLE, null, triggersList, this.mTableNamePrefix);
                ArrayList<SchedEntity> jobsList = new ArrayList<SchedEntity>(iConvertibleActions);
                int index = 0;
                String sCondName = "COND" + child.hashCode() + "_";
                boolean bAssistingAdded = false;
                for (Task.Action currentAction : actionsList) {
                    if (currentAction.getActionType().equals("ComHandler")) continue;
                    MSJob currentJob = new MSJob(child, this.mStartPath, currentAction, null, sAuthor, sOwner, sDescription, iPriority, this.mTableNamePrefix);
                    currentJob.setParentAdditionalName(subTable.mJobName);
                    if (index > 0) {
                        currentJob.setInCond(FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", sCondName + (index - 1)), "ODAT");
                    }
                    if (index < iConvertibleActions - 1) {
                        currentJob.setOutCond(FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", sCondName + index), "ODAT");
                    }
                    jobsList.add(currentJob);
                    ++index;
                    if (bAssistingAdded) continue;
                    this.addAssistingJob(currentJob, subTable.getJobName());
                    bAssistingAdded = true;
                }
                subTable.setChildren(jobsList);
                this.childrenListSchedEnt.add(subTable);
                continue;
            }
            List<String> childrenOfMachine = MSDefs.getFilesList(this.mNodeIdOriginal);
            List<String> childrenOfCurrentDirectory = null;
            if (null != childrenOfMachine) {
                childrenOfCurrentDirectory = TasksDirectories.getFirstLevelChildrenOfParent(childrenOfMachine, child);
            }
            filterDetails.put("User Name", null);
            filterDetails.remove("Task Name");
            filterDetails.put("Location", child);
            if (!mRules.getFilterHandler().isFilter(filterDetails)) continue;
            this.childrenListSchedEnt.add(new MSDirectory(child, this.mStartPath, SchedEntity.TYPE.SUB_TABLE, childrenOfCurrentDirectory, null, this.mTableNamePrefix));
        }
    }

    public SchedEntity.TYPE type() {
        return this.mType;
    }

    public String originalProductID() {
        return TasksDirectories.getFullDirectoryName(this.mPath, this.mStartPath);
    }

    public List<SchedEntity> getChildren() {
        return this.childrenListSchedEnt;
    }

    private void setChildren(List<SchedEntity> childrenList) {
        this.childrenListSchedEnt = childrenList;
    }

    public List<AssistingJob> getAssistingJobs() {
        if (SchedEntity.TYPE.SMART_TABLE.equals((Object)this.mType)) {
            return mapMachine_AssistingJobsList.get(this.mNodeId);
        }
        return null;
    }

    public String getAttr(String attrName) {
        if (this.mbDirectoryOfMS && attrName.equals("TABLE_USERDAILY")) {
            return null;
        }
        if (attrName.equals("AUTHOR")) {
            return null;
        }
        if (attrName.equals("CONFIRM")) {
            return null;
        }
        if (attrName.equals("CRITICAL")) {
            return null;
        }
        if (attrName.equals("JOBNAME")) {
            return this.mJobName;
        }
        if (attrName.equals("DESCRIPTION")) {
            return null;
        }
        if (attrName.equals("TIMEFROM")) {
            if (null != this.mTriggersList) {
                return this.calculateTimeFrom();
            }
            return null;
        }
        if (attrName.equals("TIMETO")) {
            return null;
        }
        if (attrName.equals("TIMEZONE")) {
            return null;
        }
        if (attrName.equals("PRIORITY")) {
            return null;
        }
        if (attrName.equals("TABLE_USERDAILY")) {
            return null;
        }
        return null;
    }

    public List<Properties> getInConds() {
        return null;
    }

    public List<Properties> getOutConds() {
        return null;
    }

    public List<Properties> getTags() {
        if (null != this.mRBCsList && this.mType.equals((Object)SchedEntity.TYPE.SUB_TABLE)) {
            ArrayList<Properties> resList = new ArrayList<Properties>(this.mRBCsList.size());
            Properties pro = null;
            for (String string : this.mRBCsList) {
                pro = new Properties();
                pro.put("NAME", string);
                resList.add(pro);
            }
            return resList;
        }
        ArrayList<Properties> resultList = new ArrayList<Properties>();
        resultList.addAll(this.addAllTheTagsOfTheChildren());
        if (null != this.mTriggersList && this.mTriggersList.size() > 0) {
            List<Object> dirProp = null;
            if (null != this.mRBCsList) {
                dirProp = new ArrayList(this.mRBCsList.size());
                Iterator<SchedEntity> pro = null;
                for (String rbcName : this.mRBCsList) {
                    pro = new Properties();
                    ((Properties)((Object)pro)).put("NAME", rbcName);
                    dirProp.add(pro);
                }
            } else {
                this.mRBCsList = new ArrayList<String>();
                dirProp = RBCUtil.addRBC(this.mNodeId, this.mTriggersList, this.mJobName, TasksDirectories.getFullDirectoryName(this.mPath, this.mStartPath), this.bIgnoreDisabledTriggers, this.mMessagesList);
                if (null != dirProp) {
                    for (Properties properties : dirProp) {
                        this.mRBCsList.add(new String(properties.getProperty("NAME")));
                    }
                }
                if (null != this.childrenListSchedEnt && this.mType.equals((Object)SchedEntity.TYPE.SUB_TABLE)) {
                    for (SchedEntity schedEntity : this.childrenListSchedEnt) {
                        ((MSJob)schedEntity).setRBCsNames(this.mRBCsList);
                    }
                }
            }
            if (null != dirProp) {
                resultList.addAll(new ArrayList(dirProp));
            }
        }
        if (null != resultList && resultList.size() > 0) {
            if (((Properties)resultList.get(0)).keySet().size() > 1) {
                return resultList;
            }
            HashSet<Properties> hSet = new HashSet<Properties>(resultList);
            resultList.clear();
            resultList.addAll(hSet);
            return resultList;
        }
        if (this.mType.equals((Object)SchedEntity.TYPE.SMART_TABLE) && (null == resultList || resultList.size() < 1)) {
            ArrayList<Properties> toRetResultList = new ArrayList<Properties>(1);
            Properties toRet = new Properties();
            String[] stringArray = GlobalFunctions.getMonthsArray();
            for (int i = 0; i < stringArray.length; ++i) {
                toRet.setProperty(stringArray[i], "0");
            }
            toRet.setProperty("NAME", "Unscheduled");
            toRetResultList.add(toRet);
            return toRetResultList;
        }
        return null;
    }

    private List<Properties> addAllTheTagsOfTheChildren() {
        ArrayList<Properties> resultList = new ArrayList<Properties>();
        if (null != this.childrenListSchedEnt) {
            for (SchedEntity child : this.childrenListSchedEnt) {
                List childProp = child.getTags();
                if (null == childProp) continue;
                resultList.addAll(new ArrayList(childProp));
            }
        }
        return resultList;
    }

    public List<Properties> getQuantResources() {
        return null;
    }

    public List<Properties> getCtrlResources() {
        return null;
    }

    public List<Properties> getOnStmt() {
        return null;
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return null;
    }

    public List<Properties> getShouts() {
        if (null == this.mShoutProperties) {
            return null;
        }
        ArrayList<Properties> retList = new ArrayList<Properties>(1);
        retList.add(this.mShoutProperties);
        return retList;
    }

    public String getJobName() {
        return this.mJobName;
    }

    public String getOriginalJobName() {
        return TasksDirectories.getFullDirectoryName(this.mPath, this.mStartPath);
    }

    public String getParentName() {
        return null;
    }

    public SchedEntity getParent() {
        return null;
    }

    public String getTablePathForSons() {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public boolean hasWarnings() {
        return this.bHasWarnings;
    }

    public boolean hasMessages() {
        if (null == this.mMessagesList) {
            return false;
        }
        return !this.mMessagesList.isEmpty();
    }

    public boolean isDSJob() {
        return true;
    }

    public String getTableName() {
        return this.mNodeId;
    }

    public boolean isCyclic() {
        return false;
    }

    public String applyFieldConversion(String field) {
        return null;
    }

    public String getApplication() {
        return this.mNodeId;
    }

    public String getGroup() {
        return this.mNodeId;
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return null;
    }

    public List<String> getOptionalAttributes() {
        return null;
    }

    public ArrayList<String> getMessages() {
        if (null == this.mMessagesList || this.mMessagesList.size() < 1) {
            return null;
        }
        return this.mMessagesList;
    }

    private String calculateTimeFrom() {
        String timeFrom = "";
        Date currentDate = new Date();
        Date firstAvailableDateStartBoundary = new Date(Long.MAX_VALUE);
        Date firstAvailableDateEndBoundary = null;
        int iAvailableDates = 0;
        String executionLimit = null;
        String sInterval = null;
        String sDuration = null;
        boolean bStopAtDurationEnd = false;
        for (Task.Trigger trigger : this.mTriggersList) {
            if (!trigger.getTriggerType().equals("TimeTrigger") && !trigger.getTriggerType().equals("CalendarTrigger")) continue;
            if (this.bIgnoreDisabledTriggers && !trigger.getEnabled()) {
                Reporter.addMessage(this.mMessagesList, (String)"INF10002", (String)this.mJobName, (String[])new String[]{TasksDirectories.getTaskFullName(this.mPath, this.mStartPath), trigger.getTriggerType()});
                this.bHasWarnings = true;
                continue;
            }
            Task.Trigger iterTrigger = trigger.getTriggerType().equals("TimeTrigger") ? (Task.TimeTrigger)trigger : (Task.CalendarTrigger)trigger;
            Date iterDate = iterTrigger.getStartBoundary();
            if (null == iterDate) continue;
            ++iAvailableDates;
            if (!firstAvailableDateStartBoundary.after(iterDate)) continue;
            firstAvailableDateStartBoundary = iterDate;
            firstAvailableDateEndBoundary = iterTrigger.getEndBoundary();
            executionLimit = iterTrigger.getExecutionTimeLimit();
            if (null == iterTrigger.getRepetition()) continue;
            sInterval = iterTrigger.getRepetition().getInterval();
            sDuration = iterTrigger.getRepetition().getDuration();
            bStopAtDurationEnd = iterTrigger.getRepetition().getStopAtDurationEnd();
        }
        if (iAvailableDates > 1) {
            Reporter.addMessage(this.mMessagesList, (String)"INF10001", (String)this.mJobName, (String[])new String[]{TasksDirectories.getTaskFullName(this.mPath, this.mStartPath)});
            this.bHasWarnings = true;
        }
        Calendar cal = Calendar.getInstance();
        if (null != firstAvailableDateStartBoundary && !firstAvailableDateStartBoundary.equals(new Date(Long.MAX_VALUE))) {
            cal.setTime(firstAvailableDateStartBoundary);
            timeFrom = String.format("%02d%02d", cal.get(11), cal.get(12));
        }
        if (null != firstAvailableDateEndBoundary && firstAvailableDateEndBoundary.after(currentDate)) {
            Reporter.addMessage(this.mMessagesList, (String)"INF10005", (String)this.mJobName, (String[])new String[]{TasksDirectories.getTaskFullName(this.mPath, this.mStartPath)});
            this.bHasWarnings = true;
        }
        if (null != executionLimit) {
            this.createShoutOnRunTime(executionLimit);
        }
        if (null != sInterval) {
            this.createCyclic(sInterval, sDuration, bStopAtDurationEnd);
        }
        return timeFrom;
    }

    private String getMachineId() {
        String[] res = this.mPath.substring(this.mStartPath.length()).split("[\\\\]");
        return res[0];
    }

    private void createShoutOnRunTime(String sExecutionLimit) {
        DatatypeFactory df = null;
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Exception in MSDirectory - createShoutOnRunTime");
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return;
        }
        Duration duration = df.newDuration(sExecutionLimit);
        long iMinutes = duration.getTimeInMillis(new Date()) / 60000L;
        if (iMinutes > (long)Globs.MAXEXECTIME_int.intValue()) {
            String sMinutes = sExecutionLimit + " (" + iMinutes + " minutes)";
            Reporter.addMessage(this.mMessagesList, (String)"WRN10007", (String)this.getOriginalJobName(), (String[])new String[]{this.getJobName(), this.getJobName(), sMinutes});
            this.bHasWarnings = true;
            iMinutes = Globs.MAXEXECTIME_int.intValue();
        }
        this.mShoutProperties = new Properties();
        this.mShoutProperties.setProperty("DEST", "EM");
        this.mShoutProperties.setProperty("WHEN", "EXECTIME");
        this.mShoutProperties.setProperty("TIME", ">" + iMinutes);
        this.mShoutProperties.setProperty("URGENCY", "R");
        this.mShoutProperties.setProperty("MESSAGE", "Job name %%JOBNAME run time exceeded maximum");
    }

    private void createCyclic(String sInterval, String sDuration, boolean bStopAtDurationEnd) {
        Duration dDuration;
        DatatypeFactory df = null;
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Exception in MSDirectory - createCyclic");
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return;
        }
        long lMaxRerun = 0L;
        long lInterval = 1L;
        Duration dInterval = df.newDuration(sInterval);
        if (null != dInterval) {
            lInterval = dInterval.getTimeInMillis(new Date()) / 60000L;
        }
        if (null != sDuration && null != (dDuration = df.newDuration(sDuration))) {
            long lDuration = dDuration.getTimeInMillis(new Date()) / 60000L;
            lMaxRerun = lDuration / lInterval;
        }
        if (lMaxRerun > 99L) {
            Reporter.addMessage(this.mMessagesList, (String)"WRN0001", (String)this.getOriginalJobName(), (String[])new String[]{String.valueOf(lMaxRerun), String.valueOf(99)});
            this.bHasWarnings = true;
            lMaxRerun = 99L;
        }
        if (bStopAtDurationEnd) {
            this.bHasWarnings = true;
            Reporter.addMessage(this.mMessagesList, (String)"WRN0019", (String)this.getOriginalJobName(), (String[])new String[]{"MS", "StopAtDurationEnd"});
        }
        if (null != this.childrenListSchedEnt && this.mType.equals((Object)SchedEntity.TYPE.SUB_TABLE)) {
            for (SchedEntity child : this.childrenListSchedEnt) {
                ((MSJob)child).setCyclic(lInterval, lMaxRerun);
            }
        }
    }

    private void addAssistingJob(MSJob msJob, String sJobName) {
        String nodeId;
        AssistingJob assistJob = new AssistingJob(SchedEntity.TYPE.JOB);
        boolean bConvertToDummy = mRules.getTaskTypeHandler().isToDummy();
        if (bConvertToDummy) {
            if (!Params.instance().getGUIVersion().equals("7")) {
                assistJob.setAutoedit("%%$BMCWAIORIGTYPE", "Command");
            }
            assistJob.setAttribute("TASKTYPE", "Dummy");
        } else {
            assistJob.setAttribute("TASKTYPE", "Command");
        }
        String sOrigJobName = TasksDirectories.getTaskFullName(msJob.getOriginalJobName(), MSGlobals.FILESEPARATOR + msJob.getAttr("NODEID").toLowerCase() + MSGlobals.FILESEPARATOR);
        assistJob.setAttribute("CMDLINE", "schtasks /change /disable /TN \"" + sOrigJobName + "\"");
        if (null == sJobName) {
            sJobName = msJob.getJobName();
        }
        if (null == (nodeId = msJob.getAttr("NODEID"))) {
            nodeId = "UNKNOWN";
        }
        Object newJobName = "disable_" + sJobName + "_at_" + nodeId;
        newJobName = FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", (String)newJobName);
        assistJob.setAttribute("JOBNAME", (String)newJobName);
        assistJob.setAttribute("OWNER", msJob.getAttr("OWNER"));
        assistJob.setAttribute("AUTHOR", msJob.getAttr("AUTHOR"));
        assistJob.setAttribute("NODEID", msJob.getAttr("NODEID"));
        assistJob.setAttribute("PRIORITY", msJob.getAttr("PRIORITY"));
        assistJob.setAttribute("TAG_RELATIONSHIP", "OR");
        String application = SettingsTable.instance().getProperty(SettingsStringKeys.MS_DISCOVERY_JOBS_APPLICATION);
        String group = SettingsTable.instance().getProperty(SettingsStringKeys.MS_DISCOVERY_JOBS_SUB_APPLICATION);
        String table = SettingsTable.instance().getProperty(SettingsStringKeys.MS_DISCOVERY_JOBS_FOLDER_NAME);
        assistJob.setAttribute("APPLICATION", FieldValidation.instance().validateAndReturnFixedValue("APPLICATION", application));
        assistJob.setAttribute("GROUP", FieldValidation.instance().validateAndReturnFixedValue("GROUP", group));
        assistJob.setAttribute("PARENT_TABLE", FieldValidation.instance().validateAndReturnFixedValue("PARENT_TABLE", table));
        assistJob.setAttribute("TABLE_NAME", FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", table));
        assistJob.setAttribute("DESCRIPTION", String.format("Force this job in order to disable the MS Task that was converted to the job %s in the table %s. \r\n The task %s will be set to disable by this job", sJobName, msJob.getParentName(), sOrigJobName));
        if (!msJob.getAttr("NODEID").equalsIgnoreCase(msJob.getAttr("NodeIdOriginal"))) {
            String msgID = null;
            msgID = this.mNodeIdOriginal.length() != this.mNodeId.length() ? "WRN10005" : "WRN10004";
            Reporter.addMessage(this.mMessagesList, (String)msgID, (String)sJobName, (String[])new String[]{msJob.getOriginalJobName(), this.mNodeIdOriginal, this.mNodeId});
        }
        this.mAssistingJobsList.add(assistJob);
        ArrayList<Object> jobsList = null;
        if (null != mapMachine_AssistingJobsList.get(this.mNodeId)) {
            jobsList = new ArrayList(mapMachine_AssistingJobsList.get(this.mNodeId));
            jobsList.addAll(this.mAssistingJobsList);
        } else {
            jobsList = new ArrayList<AssistingJob>(this.mAssistingJobsList);
        }
        HashSet<AssistingJob> hSet = new HashSet<AssistingJob>(jobsList);
        jobsList.clear();
        jobsList.addAll(hSet);
        mapMachine_AssistingJobsList.put(this.mNodeId, jobsList);
    }
}

