/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.ms.Task;
import com.bmc.ctmconvert.ms.XMLToTask;
import com.bmc.ctmconvert.os.OsDataImportMethodGetter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class MSAssessmentReport
extends AbstractAssessmentReport {
    private static final String GENERAL = "General";
    private static final String ACTIONS = "Actions";
    private static final String TRIGGERS = "Triggers";
    private static final String SETTINGS = "Settings";
    private static final String ACTION = "Action";
    private static final String TRIGGER = "Trigger";
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private ArrayList<String> descriptionTypeLookNodes;
    private LinkedHashMap<String, String> descriptionMap_NodeName_NodeDesc;
    private String currentPath;
    private HashMap<String, ArrayList<String>> descriptionMap_Machine_users;
    private HashMap<String, Integer> descriptionMap_Machine_EnabledNUmber;

    public MSAssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.descriptionTypeLookNodes = new ArrayList();
        this.descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        this.currentPath = Params.instance().getDatasourcePath() + "Data";
        this.descriptionMap_Machine_users = new HashMap();
        this.descriptionMap_Machine_EnabledNUmber = new HashMap();
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        DefaultMutableTreeNode mainTreeNodes = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        File dirRoot = new File(Params.instance().getDatasourcePath() + "Data");
        if (dirRoot.exists()) {
            return this.buildTree(dirRoot, mainTreeNodes);
        }
        return null;
    }

    protected String getJobInfo(String messageID) {
        if (messageID == null || messageID.isEmpty()) {
            return "";
        }
        String[] messageIDArr = messageID.split(";");
        String ret = "";
        if (messageIDArr.length > 2) {
            messageID = messageID.substring(0, messageID.length() - 1);
            String DescritionType = messageID.substring(messageID.lastIndexOf(59) + 1);
            messageID = messageID.substring(0, messageID.lastIndexOf(59));
            String path = messageID.replaceAll("\\(\\d+\\);", ";");
            path = path.replaceAll(";", "\\\\");
            path = path.substring(path.indexOf(92));
            path = path.replaceAll("\\(\\d+\\)$", "");
            if (DescritionType.equals(GENERAL) || DescritionType.equals(SETTINGS)) {
                String XmlFilePath = this.currentPath + path + ".xml";
                Task task = XMLToTask.getTaskFromXML(XmlFilePath, "");
                if (DescritionType.equals(GENERAL)) {
                    ret = this.getGeneralDescrition(task);
                }
                if (DescritionType.equals(SETTINGS)) {
                    ret = this.getSettingsDescrition(task);
                }
            } else if (DescritionType.endsWith(")")) {
                DescritionType = DescritionType.replaceAll("\\(\\d+\\)$", "");
                String XmlFilePath = this.currentPath + path + "\\" + DescritionType + ".xml";
                int TasksNumber = this.getNumberofFiles(new File(XmlFilePath));
                ret = this.getDirDescriptionFromXml(DescritionType, TasksNumber);
            } else {
                DescritionType = DescritionType.replaceAll("\\(\\d+\\)$", "");
                String XmlFilePath = this.currentPath + path + "\\" + DescritionType + ".xml";
                Task task = XMLToTask.getTaskFromXML(XmlFilePath, "");
                int actionsNumber = task.getActions().getActionsList().size();
                int triggersNumber = task.getTriggers().size();
                boolean enabled = true;
                if (task.getSettings() != null) {
                    enabled = task.getSettings().getEnabled();
                }
                ret = this.GetTaskDescriptionFromXml(DescritionType, actionsNumber, triggersNumber, enabled);
            }
        } else {
            ret = this.descriptionMap_NodeName_NodeDesc.get(messageIDArr[1].replaceAll("\\(\\d+\\)$", ""));
        }
        return ret;
    }

    private String getMachinDescriptionFromXml(String NodeName, int numberOfTasks) {
        String sDescription = this.descriptionMap_NodeName_NodeDesc.get("Machine");
        if (NodeName != null) {
            sDescription = sDescription.replaceAll("#Name#", NodeName);
        }
        if (numberOfTasks != -1) {
            sDescription = sDescription.replaceAll("#numberOfTasks#", "" + numberOfTasks);
        }
        Object numberOfEnabledTasks = "0";
        if (this.descriptionMap_Machine_EnabledNUmber != null && this.descriptionMap_Machine_EnabledNUmber.get(NodeName) != null) {
            numberOfEnabledTasks = String.valueOf(this.descriptionMap_Machine_EnabledNUmber.get(NodeName));
        }
        sDescription = sDescription.replaceAll("#numberOfEnabledTasks#", (String)numberOfEnabledTasks);
        String users = "";
        if (this.descriptionMap_Machine_users != null && !this.descriptionMap_Machine_users.isEmpty() && this.descriptionMap_Machine_users.containsKey(NodeName)) {
            users = this.descriptionMap_Machine_users.get(NodeName).toString();
            users = users.replaceFirst("\\[", "");
            users = users.substring(0, users.lastIndexOf(93));
            users = users.replaceAll(", ", ",");
            users = users.replaceAll(",", "\n\t\t  ");
        }
        sDescription = sDescription.replace("#usersList#", users);
        return sDescription;
    }

    private String getDirDescriptionFromXml(String NodeName, int numberOfTasks) {
        String sDescription = this.descriptionMap_NodeName_NodeDesc.get("Dir");
        if (!sDescription.contains("#")) {
            return sDescription;
        }
        if (NodeName != null) {
            sDescription = sDescription.replaceAll("#Name#", NodeName);
        }
        if (numberOfTasks != -1) {
            sDescription = sDescription.replaceAll("#numberOfTasks#", "" + numberOfTasks);
        }
        return sDescription;
    }

    private String GetTaskDescriptionFromXml(String NodeName, int numberOfActions, int numberOfTriggers, Boolean isEnabled) {
        String sDescription = this.descriptionMap_NodeName_NodeDesc.get("Task");
        if (NodeName != null) {
            sDescription = sDescription.replaceAll("#Name#", NodeName);
        }
        if (numberOfActions != -1) {
            sDescription = sDescription.replaceAll("#numberOfActions#", "" + numberOfActions);
        }
        if (numberOfTriggers != -1) {
            sDescription = sDescription.replaceAll("#numberOfTriggers#", "" + numberOfTriggers);
        }
        if (isEnabled != null) {
            sDescription = sDescription.replaceAll("#isEnabled#", isEnabled != false ? "True" : "False");
        }
        return sDescription;
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        return this.descriptionTypeLookNodes;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.add(ACTIONS);
        toRet.add(TRIGGERS);
        return toRet;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        int i;
        ArrayList<String> retList = new ArrayList<String>();
        parentNodeID = parentNodeID.substring(0, parentNodeID.length() - 1);
        String listType = parentNodeID.substring(parentNodeID.lastIndexOf(59) + 1);
        parentNodeID = parentNodeID.substring(0, parentNodeID.lastIndexOf(59));
        String path = parentNodeID.replaceAll("\\(\\d+\\);", ";");
        path = path.replaceAll(";", "\\\\");
        path = path.substring(path.indexOf(92));
        String XmlFilePath = this.currentPath + path + ".xml";
        Task task = XMLToTask.getTaskFromXML(XmlFilePath, "");
        if (listType.equalsIgnoreCase(ACTIONS)) {
            List<Task.Action> actionsList = task.getActions().getActionsList();
            if (actionsList.size() == 0) {
                return retList;
            }
            for (i = 0; i < actionsList.size(); ++i) {
                retList.add("Action_" + (i + 1));
            }
        }
        if (listType.equalsIgnoreCase(TRIGGERS)) {
            List<Task.Trigger> triggersList = task.getTriggers();
            if (triggersList.size() == 0) {
                return retList;
            }
            for (i = 0; i < triggersList.size(); ++i) {
                retList.add("Trigger_" + (i + 1));
            }
        }
        this.setSelectionListPath(path);
        return retList;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        StringBuilder mainSummary = new StringBuilder();
        OsDataImportMethodGetter dataImportMethodGetter = new OsDataImportMethodGetter();
        mainSummary.append(dataImportMethodGetter.getDataImportMethodTitle("MS Scheduling Tasks data"));
        mainSummary.append("MS task scheduler input data analysis:\n");
        File dirRoot = new File(Params.instance().getDatasourcePath() + "Data");
        if (dirRoot.isDirectory()) {
            File[] children;
            for (File child : children = dirRoot.listFiles()) {
                int TasksNumber = this.getNumberofFiles(child);
                this.descriptionMap_NodeName_NodeDesc.put(child.getName(), this.getMachinDescriptionFromXml(child.getName(), TasksNumber));
                mainSummary.append(this.descriptionMap_NodeName_NodeDesc.get(child.getName()));
            }
        }
        this.descriptionMap_NodeName_NodeDesc.put(Params.instance().getDatasourceName(), mainSummary.toString());
        return this.descriptionMap_NodeName_NodeDesc;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        String path = "";
        if (messageID != null && !messageID.isEmpty() && !messageID.endsWith(";")) {
            path = this.getSelectionListPath();
        }
        if (path.equals("")) {
            return "";
        }
        String messageType = messageID.split("_\\d")[0];
        int index = Integer.parseInt(messageID.replaceFirst(messageType + "_", "")) - 1;
        String XmlFilePath = this.currentPath + path + ".xml";
        Task task = XMLToTask.getTaskFromXML(XmlFilePath, "");
        String ret = "";
        if (messageType.equals(ACTION)) {
            ret = this.getActionDescrioptionFromTask(task, index);
        }
        if (messageType.equals(TRIGGER)) {
            ret = this.getTriggerDescrioptionFromTask(task, index);
        }
        return ret;
    }

    private String getGeneralDescrition(Task task) {
        Object ret = "";
        ret = (String)ret + "Author\t: " + task.getRegistrationInfo().getAuthor() + "\n";
        ret = (String)ret + "Date\t: " + String.valueOf(task.getRegistrationInfo().getDate()) + "\n";
        ret = (String)ret + "Triggers size\t: " + task.getTriggers().size() + "\n";
        ret = (String)ret + "Version\t: " + task.getVersion() + "\n";
        ret = ((String)ret).replaceAll(":\\s*null\\s*\\n", ":\n");
        return ret;
    }

    private String getActionDescrioptionFromTask(Task task, int actionIndex) {
        Object ret = "";
        List<Task.Action> actionsList = task.getActions().getActionsList();
        Task.Action action = actionsList.get(actionIndex);
        if (action.getActionType().equals("Exec")) {
            ret = (String)ret + "Command\t\t: " + ((Task.Exec)action).getCommand() + "\n";
            ret = (String)ret + "Arguments\t\t: " + ((Task.Exec)action).getArguments() + "\n";
            ret = (String)ret + "WorkingDirectory\t: " + ((Task.Exec)action).getWorkingDirectory() + "\n";
        } else if (action.getActionType().equals("ComHandler")) {
            ret = (String)ret + "ClassId\t\t: " + ((Task.ComHandler)action).getClassId() + "\n";
            ret = (String)ret + "Data\t\t: " + ((Task.ComHandler)action).getData() + "\n";
        } else if (action.getActionType().equals("ShowMessage")) {
            ret = (String)ret + "Title\t: " + ((Task.ShowMessage)action).getTitle() + "\n";
            ret = (String)ret + "Body\t: " + ((Task.ShowMessage)action).getBody() + "\n";
        } else if (action.getActionType().equals("SendEmail")) {
            ret = (String)ret + "Server\t: " + ((Task.SendEmail)action).getServer() + "\n";
            ret = (String)ret + "Subject\t: " + ((Task.SendEmail)action).getSubject() + "\n";
            ret = (String)ret + "To\t: " + ((Task.SendEmail)action).getTo() + "\n";
            ret = (String)ret + "Cc\t: " + ((Task.SendEmail)action).getCc() + "\n";
            ret = (String)ret + "Bcc\t: " + ((Task.SendEmail)action).getBcc() + "\n";
            ret = (String)ret + "ReplyTo\t: " + ((Task.SendEmail)action).getReplyTo() + "\n";
            ret = (String)ret + "From\t: " + ((Task.SendEmail)action).getFrom() + "\n";
            ret = (String)ret + "Body\t: " + ((Task.SendEmail)action).getBody() + "\n";
            if (null != ((Task.SendEmail)action).getAttachments()) {
                ret = (String)ret + "----Attachments----\n";
                for (String att : ((Task.SendEmail)action).getAttachments()) {
                    ret = (String)ret + att + "\n";
                }
            }
            if (null != ((Task.SendEmail)action).getHeaderFields()) {
                ret = (String)ret + "----HeaderFields----\n";
                for (Task.SendEmail.HeaderField hf : ((Task.SendEmail)action).getHeaderFields()) {
                    ret = (String)ret + "Name\t: " + hf.getName() + "\n";
                    ret = (String)ret + "Value\t: " + hf.getValue() + "\n";
                }
            }
        }
        ret = ((String)ret).replaceAll(":\\s*null\\s*\\n", ":\n");
        return ret;
    }

    private String getTriggerDescrioptionFromTask(Task task, int triggerIndex) {
        List<Task.Trigger> triggersList = task.getTriggers();
        Task.Trigger trigger = triggersList.get(triggerIndex);
        Object ret = "";
        ret = (String)ret + "Trigger type\t\t: " + trigger.getTriggerType() + "\n";
        if (trigger.getTriggerType().equals("CalendarTrigger")) {
            Task.CalendarTrigger.ScheduleByMonthDayOfWeek scheduleMonthDayOfWeek;
            Task.CalendarTrigger.ScheduleByWeek WeekSchedule;
            ret = (String)ret + "RandomDelay\t\t: " + ((Task.CalendarTrigger)trigger).getRandomDelay() + "\n";
            Task.CalendarTrigger.ScheduleByMonth Schedule = ((Task.CalendarTrigger)trigger).getScheduleByMonth();
            if (Schedule != null) {
                Object months;
                List<String> dayInMonth = Schedule.getDaysOfMonth();
                if (dayInMonth != null) {
                    ret = (String)ret + "Day in month\t\t : ";
                    for (String string : dayInMonth) {
                        ret = (String)ret + string + ", ";
                    }
                    ret = (String)ret + "\n";
                }
                if ((months = Schedule.getMonthsAsStrings()) != null) {
                    ret = (String)ret + "Month\t\t: ";
                    for (String month : Schedule.getMonthsAsStrings()) {
                        ret = (String)ret + month + ", ";
                    }
                    ret = (String)ret + "\n";
                }
            }
            if (null != ((Task.CalendarTrigger)trigger).getScheduleByDay()) {
                ret = (String)ret + "Interval\t\t: " + ((Task.CalendarTrigger)trigger).getScheduleByDay().getDaysInterval() + "\n";
            }
            if (null != (WeekSchedule = ((Task.CalendarTrigger)trigger).getScheduleByWeek())) {
                ret = (String)ret + "Days interval\t\t: " + WeekSchedule.getWeeksInterval() + "\n";
                for (String string : WeekSchedule.getDaysOfWeekAsStrings()) {
                    ret = (String)ret + "day\t\t: " + string + "\n";
                }
            }
            if (null != (scheduleMonthDayOfWeek = ((Task.CalendarTrigger)trigger).getScheduleByMonthDayOfWeek())) {
                for (String day : scheduleMonthDayOfWeek.getDaysOfWeekAsStrings()) {
                    ret = (String)ret + "Weekly\t\t: " + day + "\n";
                }
                for (String week : scheduleMonthDayOfWeek.getWeeks()) {
                    ret = (String)ret + "Monthly\t\t: " + week + "\n";
                }
                for (String m : scheduleMonthDayOfWeek.getMonthsAsStrings()) {
                    ret = (String)ret + "Month\t\t: " + m + "\n";
                }
                ret = (String)ret + "----------------------\n";
            }
        } else if (trigger.getTriggerType().equals("TimeTrigger")) {
            ret = (String)ret + "TimeTrigger.RandomDelay\t: " + ((Task.TimeTrigger)trigger).getRandomDelay() + "\n";
        } else if (trigger.getTriggerType().equals("BootTrigger")) {
            ret = (String)ret + "BootTrigger.Delay\t: " + ((Task.BootTrigger)trigger).getDelay() + "\n";
        } else if (trigger.getTriggerType().equals("RegistrationTrigger")) {
            ret = (String)ret + "RegistrationTrigger.Delay\t: " + ((Task.RegistrationTrigger)trigger).getDelay() + "\n";
        } else if (trigger.getTriggerType().equals("LogonTrigger")) {
            ret = (String)ret + "LogonTrigger.UserId\t: " + ((Task.LogonTrigger)trigger).getUserId() + "\n";
            ret = (String)ret + "LogonTrigger.Delay\t: " + ((Task.LogonTrigger)trigger).getDelay() + "\n";
        } else if (trigger.getTriggerType().equals("SessionStateChangeTrigger")) {
            ret = (String)ret + "SessionStateChangeTrigger.UserId\t: " + ((Task.SessionStateChangeTrigger)trigger).getUserId() + "\n";
            ret = (String)ret + "SessionStateChangeTrigger.Delay\t: " + ((Task.SessionStateChangeTrigger)trigger).getDelay() + "\n";
            ret = (String)ret + "SessionStateChangeTrigger.StateChange\t: " + ((Task.SessionStateChangeTrigger)trigger).getStateChange() + "\n";
        } else if (trigger.getTriggerType().equals("EventTrigger")) {
            ret = (String)ret + "Subscription\t\t: " + ((Task.EventTrigger)trigger).getSubscription() + "\n";
            ret = (String)ret + "Delay\t\t: " + ((Task.EventTrigger)trigger).getDelay() + "\n";
            ret = (String)ret + "PeriodOfOccurrence\t: " + ((Task.EventTrigger)trigger).getPeriodOfOccurrence() + "\n";
            ret = (String)ret + "NumberOfOccurrences\t: " + ((Task.EventTrigger)trigger).getNumberOfOccurrences() + "\n";
            ret = (String)ret + "MatchingElement\t: " + ((Task.EventTrigger)trigger).getMatchingElement() + "\n";
            if (null != ((Task.EventTrigger)trigger).getValueQueries()) {
                for (Task.EventTrigger.Value v : ((Task.EventTrigger)trigger).getValueQueries()) {
                    ret = (String)ret + "Name\t\t: " + v.getName() + "\n";
                    ret = (String)ret + "Content\t\t: " + v.getContent() + "\n";
                }
            }
            ret = (String)ret + "*************************\n";
        }
        if (trigger.getRepetition() != null) {
            ret = (String)ret + "Repetition Interval\t: " + trigger.getRepetition().getInterval() + "\n";
            ret = (String)ret + "Repetition Duration\t: " + trigger.getRepetition().getDuration() + "\n";
        }
        ret = (String)ret + "ExecutionTimeLimit\t: " + trigger.getExecutionTimeLimit() + "\n";
        if (null != trigger.getId()) {
            ret = (String)ret + "Id\t\t: " + trigger.getId() + "\n";
        }
        ret = ((String)ret).replaceAll(":\\s*null\\s*\\n", ":\n");
        return ret;
    }

    private String getSettingsDescrition(Task task) {
        Object ret = "";
        if (null == task.getSettings()) {
            return ret;
        }
        ret = (String)ret + "AllowHardTerminate\t\t: " + task.getSettings().getAllowHardTerminate() + "\n";
        ret = (String)ret + "AllowStartOnDemand\t\t: " + task.getSettings().getAllowStartOnDemand() + "\n";
        ret = (String)ret + "DeleteExpiredTaskAfter\t\t: " + task.getSettings().getDeleteExpiredTaskAfter() + "\n";
        ret = (String)ret + "DisallowStartIfOnBatteries\t\t: " + task.getSettings().getDisallowStartIfOnBatteries() + "\n";
        ret = (String)ret + "DisallowStartOnRemoteAppSession\t: " + task.getSettings().getDisallowStartOnRemoteAppSession() + "\n";
        ret = (String)ret + "Enabled\t\t\t: " + task.getSettings().getEnabled() + "\n";
        ret = (String)ret + "ExecutionTimeLimit\t\t: " + task.getSettings().getExecutionTimeLimit() + "\n";
        ret = (String)ret + "Hidden\t\t\t: " + task.getSettings().getHidden() + "\n";
        ret = (String)ret + "MultipleInstancesPolicy\t\t: " + task.getSettings().getMultipleInstancesPolicy() + "\n";
        ret = (String)ret + "NetworkProfileName\t\t: " + task.getSettings().getNetworkProfileName() + "\n";
        ret = (String)ret + "Priority\t\t\t: " + task.getSettings().getPriority() + "\n";
        ret = (String)ret + "StartWhenAvailable\t\t: " + task.getSettings().getStartWhenAvailable() + "\n";
        ret = (String)ret + "StopIfGoingOnBatteries\t\t: " + task.getSettings().getStopIfGoingOnBatteries() + "\n";
        ret = (String)ret + "UseUnifiedSchedulingEngine\t\t: " + task.getSettings().getUseUnifiedSchedulingEngine() + "\n";
        ret = (String)ret + "WakeToRun\t\t\t: " + task.getSettings().getWakeToRun() + "\n";
        ret = (String)ret + "RunOnlyIfIdle\t\t\t: " + task.getSettings().getRunOnlyIfIdle() + "\n";
        if (null != task.getSettings().getIdleSettings()) {
            ret = (String)ret + "Duration\t\t\t: " + task.getSettings().getIdleSettings().getDuration() + "\n";
            ret = (String)ret + "RestartOnIdle\t\t\t: " + task.getSettings().getIdleSettings().getRestartOnIdle() + "\n";
            ret = (String)ret + "StopOnIdleEnd\t\t: " + task.getSettings().getIdleSettings().getStopOnIdleEnd() + "\n";
            ret = (String)ret + "WaitTimeout\t\t\t: " + task.getSettings().getIdleSettings().getWaitTimeout() + "\n";
        }
        ret = (String)ret + "RunOnlyIfNetworkAvailable\t\t: " + task.getSettings().getRunOnlyIfNetworkAvailable() + "\n";
        if (null != task.getSettings().getNetworkSettings()) {
            ret = (String)ret + "NetworkSettings\t\t: \n";
            ret = (String)ret + "NetworkSettings Id\t\t: " + task.getSettings().getNetworkSettings().getId() + "\n";
            ret = (String)ret + "NetworkSettings Name\t\t: " + task.getSettings().getNetworkSettings().getName() + "\n";
            Task.RestartOnFailure restartOnFailuretask = task.getSettings().getRestartOnFailure();
            if (restartOnFailuretask != null) {
                ret = (String)ret + "RestartOnFailure Count\t\t: " + restartOnFailuretask.getCount() + "\n";
                ret = (String)ret + "RestartOnFailure tInterval\t\t: " + restartOnFailuretask.getInterval() + "\n";
            }
        }
        ret = ((String)ret).replaceAll(":\\s*null\\s*\\n", ":\n");
        return ret;
    }

    private DefaultMutableTreeNode buildTree(File dirRoot, DefaultMutableTreeNode root) {
        File[] children;
        if (!dirRoot.isDirectory()) {
            root = this.appendActionsAndTriggersToTask(dirRoot.getAbsolutePath(), root);
            return root;
        }
        for (File child : children = dirRoot.listFiles()) {
            Object childNodeName = " ";
            if (child.isDirectory()) {
                int TaskNumber = this.getNumberofFiles(child);
                childNodeName = child.getName() + "(" + TaskNumber + ")";
            } else {
                childNodeName = child.getName().substring(0, child.getName().lastIndexOf(".xml"));
            }
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(childNodeName);
            root.add(this.buildTree(child, newNode));
            this.descriptionTypeLookNodes.add(child.getName());
        }
        return root;
    }

    private DefaultMutableTreeNode appendActionsAndTriggersToTask(String taskPath, DefaultMutableTreeNode taskNode) {
        Task jobTask = XMLToTask.getTaskFromXML(taskPath, "");
        if (jobTask == null) {
            return taskNode;
        }
        String machineName = this.getMachineName(taskPath);
        jobTask.getRegistrationInfo().getAuthor();
        this.addAuthorToUsersHashMap(machineName, jobTask.getRegistrationInfo().getAuthor());
        boolean enabled = true;
        if (jobTask.getSettings() != null) {
            enabled = jobTask.getSettings().getEnabled();
        }
        if (enabled) {
            this.addToEnabledHashMap(machineName);
        }
        DefaultMutableTreeNode generalNode = new DefaultMutableTreeNode(GENERAL);
        DefaultMutableTreeNode actionNode = new DefaultMutableTreeNode(ACTIONS);
        DefaultMutableTreeNode triggersNode = new DefaultMutableTreeNode(TRIGGERS);
        DefaultMutableTreeNode settingssNode = new DefaultMutableTreeNode(SETTINGS);
        taskNode.add(generalNode);
        taskNode.add(actionNode);
        taskNode.add(triggersNode);
        taskNode.add(settingssNode);
        return taskNode;
    }

    private void addToEnabledHashMap(String machineName) {
        if (this.descriptionMap_Machine_EnabledNUmber.containsKey(machineName)) {
            this.descriptionMap_Machine_EnabledNUmber.put(machineName, this.descriptionMap_Machine_EnabledNUmber.get(machineName) + 1);
        } else {
            this.descriptionMap_Machine_EnabledNUmber.put(machineName, 1);
        }
    }

    private void addAuthorToUsersHashMap(String machineName, String userName) {
        if (!this.descriptionMap_Machine_users.containsKey(machineName)) {
            ArrayList<String> users = new ArrayList<String>();
            users.add(userName);
            this.descriptionMap_Machine_users.put(machineName, users);
        } else {
            ArrayList<String> users = this.descriptionMap_Machine_users.get(machineName);
            if (!users.contains(userName)) {
                this.descriptionMap_Machine_users.get(machineName).add(userName);
            }
        }
    }

    private String getMachineName(String path) {
        path = path.replaceFirst(".*Data\\\\", "");
        String machineName = path.replaceFirst("\\\\.*", "");
        return machineName;
    }

    private int getNumberofFiles(File file) {
        File[] children;
        if (file == null) {
            return 0;
        }
        if (!file.isDirectory()) {
            return 1;
        }
        int childrenCounter = 0;
        for (File child : children = file.listFiles()) {
            childrenCounter += this.getNumberofFiles(child);
        }
        return childrenCounter;
    }
}

