/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.common.GlobalFunctions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionRange {
    private Integer version = null;
    private boolean isAndUp;
    private boolean isOnly;
    private boolean isAllVersions;

    public VersionRange(String version) {
        if (version == null || version.isEmpty()) {
            this.isAllVersions = true;
            return;
        }
        String patternString = "\\s*(\\d+)\\s*([+|-]?)\\s*";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(version);
        if (matcher.matches()) {
            String ver = matcher.group(1);
            String sign = matcher.group(2);
            this.version = Integer.parseInt(ver);
            this.isOnly = sign.equals("");
            this.isAndUp = matcher.group(2).equals("+");
        }
    }

    public boolean isInRange(String version) {
        if (version == null || version.isEmpty() || this.isAllVersions) {
            return true;
        }
        if (this.version == null) {
            return true;
        }
        if (!GlobalFunctions.isNumber(version)) {
            return false;
        }
        int newVersion = Integer.parseInt(version);
        if (this.isOnly) {
            return newVersion == this.version;
        }
        if (this.isAndUp) {
            return newVersion >= this.version;
        }
        return newVersion <= this.version;
    }

    public static Boolean isInRange(String range, String ctmVersion) {
        VersionRange versionRange = new VersionRange(range);
        return versionRange.isInRange(ctmVersion);
    }
}

