/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Table;
import com.bmc.ctmconvert.common.xml.XmlElement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rule {
    static final String XML_TAG_RULE = "RULE";
    protected static final String XML_ATTR_RULE_TYPE = "TYPE";
    protected static final String XML_ATTR_NAME = "NAME";
    private static final String XML_ATTR_VALUE = "VALUE";
    private static final String XML_TAG_TABLE_ROW = "TABLE_ROW";
    private static final String XML_TAG_TABLE_COLUMN = "COLUMN";
    private static final String XML_TAG_ITEM = "ITEM";
    private static final String BOOLEAN_VALUE_YES = "Yes";
    private static final String BOOLEAN_VALUE_NO = "No";
    private static final String XML_TAG_ENTRY = "entry";
    private static final String XML_ATTR_KEY = "key";
    String name;
    RuleData data;

    public Rule(String name, Table table) {
        this.data = new TableData(table);
        this.init(name);
    }

    public Rule(String ruleName, ArrayList<Map.Entry<String, String>> entrisList, Class<Map.Entry> class1) {
        this.data = new PairsListDataRule(entrisList);
        this.init(ruleName);
    }

    public Rule(String name, ArrayList<String> ruleValue) {
        this.data = new ListData(ruleValue);
        this.init(name);
    }

    public Rule(String ruleName, Boolean boolValue) {
        this.data = new BoolData(boolValue);
        this.init(ruleName);
    }

    public Rule(String ruleName, Integer ruleValue) {
        this.data = new IntegerData(ruleValue);
        this.init(ruleName);
    }

    public Rule(String ruleName, String ruleValue) {
        this.data = new StringDataRule(ruleValue);
        this.init(ruleName);
    }

    public Rule(ArrayList<String> data) {
        this.data = new ListData(data);
    }

    public Rule(String name) {
        this.init(name);
    }

    public static String getRuleName(XmlElement ruleElement) {
        return ruleElement.getAttribute(XML_ATTR_NAME);
    }

    public Rule(Rule metaDataRule, XmlElement ruleElement) {
        String ruleName = ruleElement.getAttribute(XML_ATTR_NAME);
        RuleDataType ruleType = metaDataRule.getDataType();
        if (ruleName.isEmpty()) {
            this.initToEmpty();
        }
        switch (ruleType.ordinal()) {
            case 0: {
                String boolValue = ruleElement.getAttribute(XML_ATTR_VALUE);
                Boolean boolval = null;
                if (boolValue.equalsIgnoreCase("Y") || boolValue.equalsIgnoreCase("YES")) {
                    boolval = true;
                } else if (boolValue.equalsIgnoreCase("N") || boolValue.equalsIgnoreCase("NO")) {
                    boolval = false;
                }
                if (boolval == null) {
                    boolval = (Boolean)metaDataRule.getData();
                }
                this.data = new BoolData(boolval);
                this.init(ruleName);
                break;
            }
            case 6: {
                String intgerValue = ruleElement.getAttribute(XML_ATTR_VALUE);
                Integer intgerval = null;
                if (GlobalFunctions.isNumber(intgerValue)) {
                    intgerval = Integer.parseInt(intgerValue);
                }
                if (intgerval == null) {
                    intgerval = (Integer)metaDataRule.getData();
                }
                this.data = new IntegerData(intgerval);
                this.init(ruleName);
                break;
            }
            case 1: {
                String stringValue = ruleElement.getAttribute(XML_ATTR_VALUE);
                this.data = new StringDataRule(stringValue);
                this.init(ruleName);
                break;
            }
            case 2: {
                ArrayList<String> listValue = ruleElement.getDirectChildsElementAttrByName(XML_TAG_ITEM, XML_ATTR_VALUE);
                this.data = new ListData(listValue);
                this.init(ruleName);
                break;
            }
            case 3: {
                Table table = new Table();
                List<XmlElement> rowList = ruleElement.getDirectchildsElementbyName(XML_TAG_TABLE_ROW);
                for (XmlElement rowElement : rowList) {
                    ArrayList<String> colomnList = rowElement.getDirectChildsElementAttrByName(XML_TAG_TABLE_COLUMN, XML_ATTR_VALUE);
                    table.addRow(colomnList);
                }
                this.data = new TableData(table);
                this.init(ruleName);
                break;
            }
            case 4: {
                ArrayList<Map.Entry<String, String>> entriesList = new ArrayList<Map.Entry<String, String>>();
                List<XmlElement> entrysElementList = ruleElement.getDirectchildsElementbyName(XML_TAG_ENTRY);
                for (XmlElement entry : entrysElementList) {
                    String key = entry.getAttribute(XML_ATTR_KEY);
                    String value = entry.getAttribute(XML_ATTR_VALUE);
                    entriesList.add(new AbstractMap.SimpleEntry<String, String>(key, value));
                }
                this.data = new PairsListDataRule(entriesList);
                this.init(ruleName);
                break;
            }
            default: {
                this.initToEmpty();
            }
        }
    }

    public Rule() {
        this.initToEmpty();
    }

    private Rule(String name, RuleData data) {
        this.name = name;
        this.data = data;
    }

    private void initToEmpty() {
        this.name = null;
        this.data = null;
    }

    public Rule copy() {
        return new Rule(this.name, this.data.copy());
    }

    private void init(String name) {
        this.name = name;
    }

    RuleDataType getDataType() {
        return this.data.getType();
    }

    public String getName() {
        return this.name;
    }

    public Object getData() {
        if (this.data != null) {
            return this.data.getData();
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("name : ").append(this.name).append("\t");
        builder.append("type : ").append((Object)this.data.getType()).append("\t");
        builder.append("Data : ").append(this.data).append("\t");
        return builder.toString();
    }

    public void setData(Object newData) {
        this.data.setData(newData);
    }

    public Element toXmlElement(Document doc) {
        Element ruleElement;
        block7: {
            block10: {
                block9: {
                    block8: {
                        block6: {
                            ruleElement = doc.createElement(XML_TAG_RULE);
                            ruleElement.setAttribute(XML_ATTR_NAME, this.getName());
                            if (this.getData() == null) {
                                return ruleElement;
                            }
                            if (this.data instanceof BoolData) {
                                ruleElement.setAttribute(XML_ATTR_VALUE, ((BoolData)this.data).getData() != false ? BOOLEAN_VALUE_YES : BOOLEAN_VALUE_NO);
                            }
                            if (!(this.data instanceof IntegerData)) break block6;
                            ruleElement.setAttribute(XML_ATTR_VALUE, ((IntegerData)this.data).getData().toString());
                            break block7;
                        }
                        if (!(this.data instanceof StringDataRule)) break block8;
                        ruleElement.setAttribute(XML_ATTR_VALUE, ((StringDataRule)this.data).getData());
                        break block7;
                    }
                    if (!(this.data instanceof ListData)) break block9;
                    Object listString = ((ListData)this.data).getData();
                    Iterator iterator = ((ArrayList)listString).iterator();
                    while (iterator.hasNext()) {
                        String value = (String)iterator.next();
                        Element itemElement = doc.createElement(XML_TAG_ITEM);
                        itemElement.setAttribute(XML_ATTR_VALUE, value);
                        ruleElement.appendChild(itemElement);
                    }
                    break block7;
                }
                if (!(this.data instanceof TableData)) break block10;
                Table table = ((TableData)this.data).getData();
                for (Vector<String> row : table.getRows()) {
                    Element rowElement = doc.createElement(XML_TAG_TABLE_ROW);
                    for (String columnvalue : row) {
                        Element columnElement = doc.createElement(XML_TAG_TABLE_COLUMN);
                        columnElement.setAttribute(XML_ATTR_VALUE, columnvalue);
                        rowElement.appendChild(columnElement);
                    }
                    ruleElement.appendChild(rowElement);
                }
                break block7;
            }
            if (!(this.data instanceof PairsListDataRule)) break block7;
            Object entryList = ((PairsListDataRule)this.data).getData();
            Iterator iterator = ((ArrayList)entryList).iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Element entryElement = doc.createElement(XML_TAG_ENTRY);
                entryElement.setAttribute(XML_ATTR_KEY, (String)entry.getKey());
                entryElement.setAttribute(XML_ATTR_VALUE, (String)entry.getValue());
                ruleElement.appendChild(entryElement);
            }
        }
        return ruleElement;
    }

    public boolean isEmpty() {
        return this.name == null;
    }

    private class TableData
    extends RuleData {
        private Table data;

        public TableData(Table table) {
            super(Rule.this);
            this.data = table;
        }

        @Override
        RuleData copy() {
            return new TableData(this.data.copy());
        }

        @Override
        Table getData() {
            return this.data;
        }

        @Override
        void setData(Object newData) {
            if (!(newData instanceof Table)) {
                return;
            }
            this.data = (Table)newData;
        }

        @Override
        RuleDataType getType() {
            return RuleDataType.TABLE;
        }

        public String toString() {
            return "TableData [data=" + String.valueOf(this.data) + "]";
        }
    }

    private abstract class RuleData {
        private RuleData(Rule rule) {
        }

        abstract RuleData copy();

        abstract Object getData();

        abstract void setData(Object var1);

        abstract RuleDataType getType();
    }

    private class PairsListDataRule
    extends RuleData {
        private ArrayList<Map.Entry<String, String>> data;

        public PairsListDataRule(ArrayList<Map.Entry<String, String>> enriesList) {
            super(Rule.this);
            this.data = enriesList;
        }

        @Override
        RuleData copy() {
            ArrayList<Map.Entry<String, String>> copyData = new ArrayList<Map.Entry<String, String>>();
            for (Map.Entry<String, String> entry : this.data) {
                copyData.add(new AbstractMap.SimpleEntry<String, String>(entry.getKey(), entry.getValue()));
            }
            return new PairsListDataRule(copyData);
        }

        @Override
        ArrayList<Map.Entry<String, String>> getData() {
            return this.data;
        }

        @Override
        void setData(Object newData) {
            if (!(newData instanceof ArrayList) && !(newData instanceof Table)) {
                return;
            }
            this.data.clear();
            if (newData instanceof ArrayList) {
                ArrayList list = (ArrayList)newData;
                for (int i = 0; i < list.size(); ++i) {
                    Map.Entry entry;
                    Object obj = list.get(i);
                    if (!(obj instanceof Map.Entry) || !((entry = (Map.Entry)obj).getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    this.data.add(new AbstractMap.SimpleEntry<String, String>(key, value));
                }
            } else {
                Table table = (Table)newData;
                for (int i = 0; i < table.getRowCount(); ++i) {
                    if (!table.hasValueAt(i, 0)) continue;
                    String key = table.getValueAt(i, 0);
                    String value = "";
                    if (table.hasValueAt(i, 1)) {
                        value = table.getValueAt(i, 1);
                    }
                    this.data.add(new AbstractMap.SimpleEntry<String, String>(key, value));
                }
            }
        }

        public String toString() {
            return "HashDataRule [data=" + String.valueOf(this.data) + "]";
        }

        @Override
        RuleDataType getType() {
            return RuleDataType.PAIRS_LIST;
        }
    }

    public class ListData
    extends RuleData {
        private ArrayList<String> data;

        public ListData(ArrayList<String> data) {
            super(Rule.this);
            this.data = data;
        }

        public ListData(Table table) {
            super(Rule.this);
        }

        public ListData(XmlElement ruleElement) {
            super(Rule.this);
            ArrayList<String> ruleValue = ruleElement.getDirectChildsElementAttrByName(Rule.XML_TAG_ITEM, Rule.XML_ATTR_VALUE);
            this.data = ruleValue;
        }

        @Override
        public RuleData copy() {
            ArrayList<String> newData = new ArrayList<String>(this.data);
            return new ListData(newData);
        }

        @Override
        ArrayList<String> getData() {
            return this.data;
        }

        @Override
        void setData(Object newData) {
            if (!(newData instanceof ArrayList) && !(newData instanceof Table)) {
                return;
            }
            if (newData instanceof ArrayList) {
                this.data = (ArrayList)newData;
            } else {
                ArrayList<String> newArr = new ArrayList<String>();
                Table table = (Table)newData;
                for (int i = 0; i < table.getRowCount(); ++i) {
                    if (!table.hasValueAt(i, 0)) continue;
                    newArr.add(table.getValueAt(i, 0));
                }
                this.data = newArr;
            }
        }

        @Override
        RuleDataType getType() {
            return RuleDataType.LIST;
        }

        public String toString() {
            return "ListData [data=" + String.valueOf(this.data) + "]";
        }
    }

    public class BoolData
    extends RuleData {
        boolean data;

        public BoolData(Boolean data) {
            super(Rule.this);
            this.data = data;
        }

        @Override
        RuleData copy() {
            return new BoolData(this.data);
        }

        @Override
        Boolean getData() {
            return this.data;
        }

        @Override
        void setData(Object newData) {
            if (newData instanceof Boolean) {
                this.data = (Boolean)newData;
            }
        }

        @Override
        RuleDataType getType() {
            return RuleDataType.BOOLEAN;
        }

        public String toString() {
            return "BoolData [data=" + this.data + "]";
        }
    }

    public class IntegerData
    extends RuleData {
        Integer data;

        public IntegerData(Integer data) {
            super(Rule.this);
            this.data = data;
        }

        @Override
        RuleData copy() {
            return new IntegerData(this.data);
        }

        @Override
        Integer getData() {
            return this.data;
        }

        @Override
        void setData(Object newData) {
            if (newData instanceof Integer) {
                this.data = (Integer)newData;
            }
        }

        @Override
        RuleDataType getType() {
            return RuleDataType.INTEGER;
        }

        public String toString() {
            return "IntegerData [data=" + this.data + "]";
        }
    }

    private class StringDataRule
    extends RuleData {
        private String data;

        public StringDataRule(String data) {
            super(Rule.this);
            this.data = data;
        }

        @Override
        RuleData copy() {
            return new StringDataRule(this.data);
        }

        @Override
        String getData() {
            return this.data;
        }

        @Override
        void setData(Object newData) {
            if (newData instanceof String) {
                this.data = (String)newData;
            }
        }

        @Override
        RuleDataType getType() {
            return RuleDataType.STRING;
        }

        public String toString() {
            return "StringDataRule [data=" + this.data + "]";
        }
    }

    static enum RuleDataType {
        BOOLEAN,
        STRING,
        LIST,
        TABLE,
        PAIRS_LIST,
        RULES_CONTAINER,
        INTEGER;

    }
}

