/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.rules.GuiRuleComponent;
import com.bmc.ctmconvert.rules.VersionRange;
import java.util.ArrayList;
import java.util.HashMap;

public class GuiRuleContainerComponent
extends GuiRuleComponent
implements DataRetrievable {
    private ArrayList<GuiRuleComponent> componentList;
    private String componentName;
    private String componentGroupName;

    public GuiRuleContainerComponent(String componentGroupName, String componentName, VersionRange versionRange) {
        super(null, versionRange);
        this.componentName = componentName;
        this.componentGroupName = componentGroupName;
        this.componentList = new ArrayList();
    }

    public GuiRuleContainerComponent() {
        super(null, null);
    }

    public void add(GuiRuleComponent component) {
        this.componentList.add(component);
    }

    @Override
    public String getGroupName() {
        if (this.componentGroupName != null) {
            return this.componentGroupName;
        }
        return "";
    }

    @Override
    public DataRetrievable getComponent() {
        return super.getComponent();
    }

    @Override
    public void handleVersion(String CTMversion) {
        for (GuiRuleComponent component : this.componentList) {
            component.handleVersion(CTMversion);
        }
    }

    @Override
    public void checkData() {
        super.checkData();
    }

    @Override
    public Object getData() {
        HashMap<String, String> res = new HashMap<String, String>();
        for (GuiRuleComponent element : this.componentList) {
            if (!element.isValidData()) continue;
            res.put(element.getName(), (String)element.getData());
        }
        return res;
    }

    @Override
    public String getName() {
        return this.componentName;
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return null;
    }

    public ArrayList<GuiRuleComponent> getItems() {
        return this.componentList;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("group : " + this.getGroupName()).append("\t");
        builder.append("name : " + this.getName()).append("\t");
        builder.append(" data type : components container ").append("\n");
        builder.append("************************************").append("\n");
        for (GuiRuleComponent item : this.componentList) {
            builder.append(item);
        }
        builder.append("\n");
        return builder.toString();
    }

    @Override
    public void setActive(Boolean b) {
        for (GuiRuleComponent componentItem : this.componentList) {
            componentItem.setActive(b);
        }
        super.setActive(b);
    }
}

