/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.Activable;
import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseComboBox;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTableAddRemoveWrapper;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.common.Table;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.rules.EnabledJComboBoxRenderer;
import com.bmc.ctmconvert.rules.PairsListData;
import com.bmc.ctmconvert.rules.StringData;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class FieldEditorPanel
extends BaseSection {
    private LinkedHashMap<String, StringData> map_CTMField_FormattedValue;
    private LinkedHashMap<String, StringData> map_CTMField_DefaultValue;
    private LinkedHashMap<String, PairsListData> map_CTMField_StringsReplacement;
    private LinkedHashMap<String, ArrayList<String>> map_CTMField_compitatorAllowed;
    private LinkedHashMap<String, String> map_CTMField_ResetValue;
    private LinkedHashMap<String, Boolean> map_CTMField_IsMandatory;
    private String field = null;
    private JComboBox fieldsComboBox = null;
    private JPanel jPanel_EditValue = null;
    private BaseTextField jTextFieldCurrentValuePreview = null;
    BaseField editValue;
    private BaseButton jButton_Menu = null;
    private BaseButton jButton_Default = null;
    private JTable jTableReplace = null;
    private DefaultTableModel replaceCharTableModel = null;
    private JPopupMenu popupMenu = null;
    private JMenu popupMenuField = null;
    private BaseTextField jTextField_SetToDefault;
    private BaseField jTextField_SetToDefaultBaseField;
    private BaseTableAddRemoveWrapper replaceSubstringTable;
    private BaseField replaceSubstringTableField;
    private DefaultComboBoxModel comboModel;
    private BaseField fieldsComboBoxField;
    private EnabledJComboBoxRenderer enableRenderer;

    public FieldEditorPanel() {
        super(TextManager.instance().get("FIELD_EDITOR_CTM_FIELD_EDITOR_SECTION_TITLE"));
        this.initialize();
    }

    public FieldEditorPanel(DataRetrievable component, String version) {
        this.initialize();
    }

    private void initialize() {
        this.map_CTMField_FormattedValue = new LinkedHashMap();
        this.map_CTMField_DefaultValue = new LinkedHashMap();
        this.map_CTMField_compitatorAllowed = new LinkedHashMap();
        this.map_CTMField_StringsReplacement = new LinkedHashMap();
        this.map_CTMField_ResetValue = new LinkedHashMap();
        this.map_CTMField_IsMandatory = new LinkedHashMap();
        this.comboModel = new DefaultComboBoxModel(new Vector());
        this.field = "";
        BaseComboBox baseFieldsComboBox = new BaseComboBox(this.comboModel);
        this.fieldsComboBox = (JComboBox)baseFieldsComboBox.getComponent();
        this.fieldsComboBox.setModel(this.comboModel);
        this.enableRenderer = new EnabledJComboBoxRenderer();
        this.fieldsComboBox.setRenderer(this.enableRenderer);
        this.fieldsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FieldEditorPanel.this.fieldsComboBox.getSelectedItem() == null) {
                    return;
                }
                FieldEditorPanel.this.storeExisitingData();
                FieldEditorPanel.this.loadGuiData();
            }
        });
        this.fieldsComboBoxField = new BaseField((BaseComponent)baseFieldsComboBox, "Select field to edit");
        this.addField(this.fieldsComboBoxField);
        this.addField(new BaseField(null));
        this.jTextFieldCurrentValuePreview = new BaseTextField("");
        this.jTextFieldCurrentValuePreview.addValueChangedAction(new Actionable(){

            @Override
            public void act() {
                FieldEditorPanel.this.setHashValue(FieldEditorPanel.this.map_CTMField_FormattedValue, FieldEditorPanel.this.field, FieldEditorPanel.this.jTextFieldCurrentValuePreview);
            }
        });
        this.jTextFieldCurrentValuePreview.setExtraComponent(this.getJPanel_EditValue());
        this.editValue = new BaseField((BaseComponent)this.jTextFieldCurrentValuePreview, TextManager.instance().get("AUTOSYS_CONFIGURATION_CTRLM_FIELDS_EDITOR_VALUE_FORMAT_TEXTFIELD_TEXT"));
        this.addField(this.editValue);
        this.initPopupMenu(this.field);
        this.jTextField_SetToDefault = new BaseTextField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
        this.jTextField_SetToDefault.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                FieldEditorPanel.this.setHashValue(FieldEditorPanel.this.map_CTMField_DefaultValue, FieldEditorPanel.this.field, FieldEditorPanel.this.jTextField_SetToDefault);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.jTextField_SetToDefaultBaseField = new BaseField((BaseComponent)this.jTextField_SetToDefault, TextManager.instance().get("AUTOSYS_CONFIGURATION_CTRLM_FIELDS_EDITOR_DEFAULT_VALUE_TEXTFIELD_TEXT"), true);
        this.addField(this.jTextField_SetToDefaultBaseField);
        this.jTableReplace = new JTable();
        this.jTableReplace.setToolTipText(TextManager.instance().get("AUTOSYS_CONFIGURATION_CTRLM_FIELDS_EDITOR_REPLACE_SUBSTRING_DATA_GRID_TOOLTIP"));
        this.initReplaceTable(this.field);
        this.replaceSubstringTable = new BaseTableAddRemoveWrapper(this.jTableReplace);
        this.replaceSubstringTableField = new BaseField((BaseComponent)this.replaceSubstringTable, TextManager.instance().get("FIELD_EDITOR_REPLACE_SUB_STRING_SECTION_TITLE"));
        this.addField(this.replaceSubstringTableField);
        this.replaceSubstringTableField.addValueChangedAction(new Actionable(){

            @Override
            public void act() {
                FieldEditorPanel.this.storeDataFromReplaceJTable();
            }
        });
    }

    private void storeExisitingData() {
        if (this.field == null) {
            return;
        }
        this.setHashValue(this.map_CTMField_FormattedValue, this.field, this.jTextFieldCurrentValuePreview);
        this.setHashValue(this.map_CTMField_DefaultValue, this.field, this.jTextField_SetToDefault);
        this.storeDataFromReplaceJTable();
    }

    private void storeDataFromReplaceJTable() {
        Table tableData = new Table(this.jTableReplace.getModel());
        this.map_CTMField_StringsReplacement.get(this.field).storeValue(tableData);
    }

    private void setField(Object field) {
        if (!(field instanceof FieldComboElement)) {
            return;
        }
        this.field = ((FieldComboElement)field).getName();
    }

    public void loadGuiData() {
        if (this.field == null) {
            return;
        }
        this.disconnectOldFieldStorageFromComponents();
        this.setField(this.fieldsComboBox.getSelectedItem());
        this.connectFieldStorageToComponents();
    }

    private void connectFieldStorageToComponents() {
        this.map_CTMField_FormattedValue.get(this.field).setTmpComponent(this.editValue);
        this.map_CTMField_FormattedValue.get(this.field).setErrorComponent(this.editValue);
        this.map_CTMField_FormattedValue.get(this.field).addTmpAssistingComponent(new Activable(){

            @Override
            public void setActive(Boolean b) {
                FieldEditorPanel.this.jButton_Menu.setEnabled(b);
                FieldEditorPanel.this.jButton_Default.setEnabled(b);
            }

            @Override
            public boolean isActive() {
                return false;
            }
        });
        this.jTextFieldCurrentValuePreview.setExtraComponent(this.getJPanel_EditValue());
        this.initPopupMenu(this.field);
        boolean isMandatory = this.isMandatoryField(this.field);
        this.map_CTMField_DefaultValue.get(this.field).setTmpComponent(this.jTextField_SetToDefaultBaseField);
        this.map_CTMField_DefaultValue.get(this.field).setErrorComponent(this.jTextField_SetToDefaultBaseField);
        this.jTextField_SetToDefaultBaseField.setMandatory(isMandatory);
        this.map_CTMField_StringsReplacement.get(this.field).setTmpComponent(this.replaceSubstringTableField);
        JLabel mandatory = this.jTextField_SetToDefaultBaseField.getMandatoryLabel();
        if (mandatory != null) {
            this.jTextField_SetToDefaultBaseField.getMandatoryLabel().setVisible(isMandatory);
            this.jTextField_SetToDefaultBaseField.getBaseComponent().disableValidityLook(!isMandatory);
        }
    }

    private void disconnectOldFieldStorageFromComponents() {
        this.map_CTMField_FormattedValue.get(this.field).setTmpComponent(null);
        this.map_CTMField_FormattedValue.get(this.field).clearTmpAssistingComponentList();
        this.map_CTMField_FormattedValue.get(this.field).setErrorComponent(null);
        this.jTextFieldCurrentValuePreview.setExtraComponent(null);
        this.map_CTMField_DefaultValue.get(this.field).setTmpComponent(null);
        this.map_CTMField_DefaultValue.get(this.field).setErrorComponent(null);
        this.map_CTMField_DefaultValue.get(this.field).clearTmpAssistingComponentList();
        this.map_CTMField_StringsReplacement.get(this.field).setTmpComponent(null);
    }

    private void setHashValue(LinkedHashMap<String, StringData> hash, String field, BaseTextField jTextField) {
        if (hash == null || hash.get(field) == null || field == null) {
            return;
        }
        hash.get(field).storeValue(jTextField.getText());
    }

    private boolean isMandatoryField(String currentfield) {
        if (!this.map_CTMField_IsMandatory.containsKey(currentfield)) {
            return false;
        }
        return this.map_CTMField_IsMandatory.get(currentfield);
    }

    private void initReplaceTable(String ctmField) {
        this.replaceCharTableModel = new DefaultTableModel();
        this.replaceCharTableModel.addColumn(TextManager.instance().get("FIELD_EDITOR_FROM_COLUMN"));
        this.replaceCharTableModel.addColumn(TextManager.instance().get("FIELD_EDITOR_TO_COLUMN"));
        this.jTableReplace.setModel(this.replaceCharTableModel);
        this.jTableReplace.setRowHeight(18);
        this.jTableReplace.setSelectionMode(0);
        this.jTableReplace.getTableHeader().setReorderingAllowed(false);
    }

    public void setCurrentValue(String s) {
        this.jTextFieldCurrentValuePreview.setText(this.jTextFieldCurrentValuePreview.getText() + "{" + s + "}");
    }

    private JPanel getJPanel_EditValue() {
        if (this.jPanel_EditValue == null) {
            this.jPanel_EditValue = new JPanel();
            this.jPanel_EditValue.setLayout(new BoxLayout(this.jPanel_EditValue, 0));
            this.jButton_Menu = ButtonFactory.createButton(ButtonFactory.ButtonType.FIELD_EDITOR_MENU, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FieldEditorPanel.this.openPopupMenu();
                }
            });
            this.jPanel_EditValue.add(this.jButton_Menu);
            this.jPanel_EditValue.add(Box.createRigidArea(new Dimension(5, 0)));
            this.jButton_Default = new BaseButton(TextManager.instance().get("MAIN_NAVIGATION_RESET"));
            this.jButton_Default.setToolTipText(TextManager.instance().get("MAIN_NAVIGATION_RESET_TOOLTIP"));
            this.jButton_Default = ButtonFactory.createButton(ButtonFactory.ButtonType.RESET, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FieldEditorPanel.this.resetToBaseValue();
                }
            });
            this.jPanel_EditValue.add(this.jButton_Default);
        }
        return this.jPanel_EditValue;
    }

    private void openPopupMenu() {
        this.popupMenu.show(this.jPanel_EditValue, this.jButton_Menu.getX() + (int)this.jButton_Menu.getSize().getWidth(), this.jButton_Menu.getY());
    }

    private void resetToBaseValue() {
        this.jTextFieldCurrentValuePreview.setText(this.getBaseValue());
        this.setHashValue(this.map_CTMField_FormattedValue, this.field, this.jTextFieldCurrentValuePreview);
    }

    private String getBaseValue() {
        return this.map_CTMField_ResetValue.get(this.field);
    }

    private void initPopupMenu(String ctmField) {
        this.popupMenu = new JPopupMenu();
        this.popupMenuField = new JMenu(TextManager.instance().get("FIELD_EDITOR_POPUP_MENU_FIELD"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String item = e.getActionCommand();
                FieldEditorPanel.this.setCurrentValue(item);
            }
        };
        ArrayList<String> compeitorFields = this.map_CTMField_compitatorAllowed.get(ctmField);
        if (compeitorFields == null) {
            return;
        }
        for (String field : compeitorFields) {
            JMenuItem item = new JMenuItem(field);
            item.addActionListener(actionListener);
            this.popupMenuField.add(item);
        }
        if (compeitorFields.isEmpty()) {
            this.popupMenuField.setEnabled(false);
        }
        this.popupMenu.add(this.popupMenuField);
    }

    public void putCompetitorFields(String cTMfieldName, ArrayList<String> allowedValues) {
        this.map_CTMField_compitatorAllowed.put(cTMfieldName, allowedValues);
    }

    public void setResetfieldsValue(HashMap<String, String> resetValues) {
        for (String key : resetValues.keySet()) {
            this.map_CTMField_ResetValue.put(key, resetValues.get(key));
        }
    }

    public void setMandatoryFields(HashMap<String, Boolean> mandatoryValues) {
        this.map_CTMField_IsMandatory = new LinkedHashMap<String, Boolean>(mandatoryValues);
        this.loadGuiData();
    }

    public void addCTMField(String ctmFieldName, String ctmFieldTitle, StringData fieldFormatComponent, StringData fieldDefaultComponent, PairsListData stringReplaceMap) {
        if (fieldFormatComponent == null || fieldDefaultComponent == null) {
            ConversionLogger.getLogger().info("FieldEditorPanel : fieldFormatComponent or fieldDefaultComponent are null , the field will not be displayed in the conboox.");
            return;
        }
        if (this.field == null || this.field.isEmpty()) {
            this.field = ctmFieldName;
        }
        this.map_CTMField_FormattedValue.put(ctmFieldName, fieldFormatComponent);
        this.map_CTMField_DefaultValue.put(ctmFieldName, fieldDefaultComponent);
        this.map_CTMField_StringsReplacement.put(ctmFieldName, stringReplaceMap);
        final StringData a = fieldFormatComponent;
        final StringData b = fieldDefaultComponent;
        String name = ctmFieldName;
        if (ctmFieldTitle == null || ctmFieldTitle.isEmpty()) {
            ctmFieldTitle = ctmFieldName;
        }
        this.comboModel.addElement(new FieldComboElement(this, ctmFieldTitle, ctmFieldName));
        this.enableRenderer.addActiveToElement(name, new Activable(){

            @Override
            public boolean isActive() {
                return a.isActive() && b.isActive();
            }

            @Override
            public void setActive(Boolean b2) {
            }
        });
    }

    private class FieldComboElement {
        private String title;
        private String name;

        public FieldComboElement(FieldEditorPanel fieldEditorPanel, String title, String name) {
            this.title = title;
            this.name = name;
        }

        public String toString() {
            return this.title;
        }

        public String getName() {
            return this.name;
        }
    }
}

