/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.dataimport.autofiledetect.DataForImportDetector;
import com.bmc.ctmconvert.dataimport.autofiledetect.DefaultDataForImportDetector;
import com.bmc.ctmconvert.dataimport.autofiledetect.DetectFileForEntry;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.redwood.RedwoodAssessmentReport;
import com.bmc.ctmconvert.redwood.RedwoodDefs;
import com.bmc.ctmconvert.redwood.RedwoodImporter;
import com.bmc.ctmconvert.redwood.RedwoodTableEntryDetector;
import com.bmc.ctmconvert.rules.FirstDayOfTheWeekRule;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.awt.Dimension;
import java.io.InputStream;

public class AppData
implements VendorData {
    public String getName() {
        return "Redwood";
    }

    public String getDisplayName() {
        return "Redwood CPS";
    }

    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Schedulers;
    }

    public DataImportVendor getDataImport() {
        return null;
    }

    public DataForImportDetector getDataForImportDetector() {
        return new DefaultDataForImportDetector((DetectFileForEntry)new RedwoodTableEntryDetector());
    }

    public BasePanel getAssessmentReport(String path) {
        return new RedwoodAssessmentReport(path, Globs.ASSESSMENT_REPORT_DESCRIPTION_XML, null);
    }

    public CliImporter getCLIImporter() {
        return null;
    }

    public ImportEntryList getImportEntries() {
        ImportEntryList importEntries = super.getImportEntries();
        importEntries.sort();
        return importEntries;
    }

    public InputStream getRulesResourceFile() {
        InputStream fileStream = AppData.class.getResourceAsStream("/rules.xml");
        return fileStream;
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) throws ConvertorCancelClickException {
        return new RedwoodDefs();
    }

    public boolean isZOS() {
        return false;
    }

    public Importer getVendorImporter() {
        return new RedwoodImporter();
    }

    public String getHelpTitle(boolean isAutomatic) {
        if (isAutomatic) {
            return "LOAD_DATA_REDWOOD_AUTOMATIC";
        }
        return "LOAD_DATA_REDWOOD_MANUAL";
    }

    public Dimension getSize() {
        return new Dimension(670, 770);
    }

    public boolean shouldBeLoaded() {
        return SettingsBooleanKeys.SHOULD_LOAD_REDWOOD_CPS.isEnabled();
    }

    public RBC.WEEKDAYS getFirstDayOfTheWeek() {
        return FirstDayOfTheWeekRule.getFirstDayOfTheWeek((String)"Redwood rules", (String)"FIRST_DAY_OF_WEEK");
    }
}

