/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.research.ScriptDetails;
import com.bmc.ctmconvert.uc4.scripts.ScriptEntry;
import com.bmc.ctmconvert.utils.Counter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class UC4SummaryScriptsWriter {
    private final Sheet scripts_analysis_sheet;
    private int rowNumberForScript = 0;
    private final int SCRIPT_TYPE_INDEX = 0;
    private final int SUM_INDEX = 1;
    private final int SUM_HIGHEST_INDEX = 2;
    private final int COUNT_HIGHEST_INDEX = 3;
    private final int sumHighestScript = 10;
    private final XSSFWorkbook excelScriptsAnalysis = new XSSFWorkbook();
    public static final String[] HEADER = new String[]{"Script Type", "Sum", "Sum of highest", "Number of highest"};

    public UC4SummaryScriptsWriter() {
        this.scripts_analysis_sheet = this.excelScriptsAnalysis.createSheet("UC4_scripts_summary");
    }

    public void writeScriptAnalysis(HashMap<String, List<ScriptDetails>> scriptMap, LinkedHashMap<ScriptEntry, Counter> postScriptMap, LinkedHashMap<ScriptEntry, Counter> preScriptMap) {
        this.createHeader();
        this.setColumnWidth();
        this.analysisScriptMap(preScriptMap, UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_PRE.toString());
        this.analysisScriptMap(postScriptMap, UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_POST.toString());
        this.analysisScriptM_Map(scriptMap);
    }

    public void writeScriptsAnalysis(OutputStream excelFileOutPut) throws IOException {
        this.excelScriptsAnalysis.write(excelFileOutPut);
    }

    private void analysisScriptM_Map(HashMap<String, List<ScriptDetails>> scriptMap) {
        int sizeOfScriptMap = scriptMap.size();
        int sumOfScriptM = this.getSumOfScripts(scriptMap, sizeOfScriptMap);
        int sumOfHighestScript = this.getSumOfScripts(scriptMap, 10);
        this.setRowScript(UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_M.toString(), sumOfScriptM, sumOfHighestScript, sizeOfScriptMap);
    }

    private void analysisScriptMap(LinkedHashMap<ScriptEntry, Counter> scriptMap, String scriptType) {
        int sizeOfPreScriptMap = scriptMap.size();
        int sumOfScript = this.getSumOfScripts(scriptMap, sizeOfPreScriptMap);
        int sumOfHighestScript = this.getSumOfScripts(scriptMap, 10);
        this.setRowScript(scriptType, sumOfScript, sumOfHighestScript, sizeOfPreScriptMap);
    }

    private void setRowScript(String scriptType, int sumOfScript, int sumHighest, int sizeMap) {
        int countHighestScript = Math.min(sizeMap, 10);
        Row row = this.scripts_analysis_sheet.createRow(this.rowNumberForScript);
        Cell cell = row.createCell(0);
        cell.setCellValue(scriptType);
        cell = row.createCell(1);
        cell.setCellValue(Integer.toString(sumOfScript));
        cell = row.createCell(2);
        cell.setCellValue(Integer.toString(sumHighest));
        cell = row.createCell(3);
        cell.setCellValue(Integer.toString(countHighestScript));
        ++this.rowNumberForScript;
    }

    private int getSumOfScripts(LinkedHashMap<ScriptEntry, Counter> scriptMap, int numOfElement) {
        int count = 0;
        for (ScriptEntry script : scriptMap.keySet()) {
            count += scriptMap.get(script).getCount();
            if (--numOfElement != 0) continue;
            break;
        }
        return count;
    }

    private int getSumOfScripts(HashMap<String, List<ScriptDetails>> scriptMap, int numOfElement) {
        int count = 0;
        for (String script : scriptMap.keySet()) {
            count += scriptMap.get(script).size();
            if (--numOfElement != 0) continue;
            break;
        }
        return count;
    }

    private void createHeader() {
        Row row = this.scripts_analysis_sheet.createRow(this.rowNumberForScript);
        this.scripts_analysis_sheet.createFreezePane(0, 1);
        for (int i = 0; i < HEADER.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(HEADER[i]);
        }
        ++this.rowNumberForScript;
    }

    private void setColumnWidth() {
        this.scripts_analysis_sheet.setColumnWidth(0, 5000);
        this.scripts_analysis_sheet.setColumnWidth(1, 5000);
        this.scripts_analysis_sheet.setColumnWidth(2, 5000);
        this.scripts_analysis_sheet.setColumnWidth(3, 5000);
    }

    public Sheet getScriptAnalysisSheet() {
        return this.scripts_analysis_sheet;
    }
}

