/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.uc4.scripts.IRecord;
import com.bmc.ctmconvert.uc4.scripts.IScriptRecord;
import com.bmc.ctmconvert.uc4.scripts.RecordHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ScriptRecordCollector
implements RecordHandler {
    private List<IScriptRecord> records = new ArrayList<IScriptRecord>();
    private Function<IRecord, IScriptRecord> mapper;

    public ScriptRecordCollector(Function<IRecord, IScriptRecord> mapper) {
        this.mapper = mapper;
    }

    public List<IScriptRecord> getRecords() {
        return this.records;
    }

    @Override
    public void handleRecord(IRecord record) {
        IScriptRecord iRecord = this.mapper.apply(record);
        this.records.add(iRecord);
    }

    public void forEachRecored(Consumer<IScriptRecord> consumer, Predicate<IScriptRecord> filter) {
        List FilteredList = this.records.stream().filter(filter).collect(Collectors.toList());
        for (IScriptRecord record : FilteredList) {
            consumer.accept(record);
        }
    }
}

