/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.scripts.ActionValueRecord;
import com.bmc.ctmconvert.uc4.scripts.JobSElement;
import com.bmc.ctmconvert.uc4.scripts.ScriptEntry;
import com.bmc.ctmconvert.uc4.xmlJobs.XmlElementHandler;
import com.bmc.ctmconvert.utils.Counter;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Function;

public class ScriptCollector
implements XmlElementHandler {
    private static final Integer MAX_LENGTH = Short.MAX_VALUE;
    private final LinkedHashMap<ScriptEntry, Counter> scriptsEntryMap = new LinkedHashMap();
    private final UC4Globals.SCRIPT_TYPE script_type;
    private final Function<JobSElement, String> scriptGetter;

    public static ScriptCollector forPostScript() {
        return new ScriptCollector(UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_POST, JobSElement::getPostScriptContent);
    }

    public static ScriptCollector forPreScript() {
        return new ScriptCollector(UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_PRE, JobSElement::getPreScriptContent);
    }

    private ScriptCollector(UC4Globals.SCRIPT_TYPE script_type, Function<JobSElement, String> scriptGetter) {
        this.script_type = script_type;
        this.scriptGetter = scriptGetter;
    }

    @Override
    public void handleElement(XmlElement jobsElement) {
        JobSElement jobSElement = new JobSElement(jobsElement);
        String scriptContent = this.scriptGetter.apply(jobSElement);
        if (scriptContent.isEmpty()) {
            return;
        }
        String tagName = jobSElement.getTagName();
        UC4Globals.OS_TYPE osType = tagName.endsWith("MVS") ? UC4Globals.OS_TYPE.OS_TYPE_MF : UC4Globals.OS_TYPE.OS_TYPE_DS;
        this.increasCounter(scriptContent, osType, tagName);
    }

    public void increasCounter(String scriptContent, UC4Globals.OS_TYPE osType, String jobType) {
        ScriptEntry entryKey;
        Counter counter;
        if (scriptContent.length() > MAX_LENGTH) {
            scriptContent = scriptContent.substring(0, MAX_LENGTH - 1);
            ConversionLogger.getLogger().warning(String.format("the script length was above the Maximum size: %s, therefore it was truncated in the excel file: %s", MAX_LENGTH, "UC4_scripts_conversion_to_ctm.xlsx"));
        }
        if (this.isNotOnlyComments(scriptContent) && (counter = this.scriptsEntryMap.putIfAbsent(entryKey = new ScriptEntry(scriptContent.toUpperCase(), osType, jobType), new Counter(1))) != null) {
            counter.clack();
        }
    }

    private boolean isNotOnlyComments(String scriptContent) {
        for (String line : scriptContent.split("\n")) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty() || trimmedLine.startsWith("!")) continue;
            return true;
        }
        return false;
    }

    public List<ActionValueRecord> getScripts() {
        return this.scriptsEntryMap.entrySet().stream().map(scriptEntry -> new ActionValueRecord(this.script_type, ((ScriptEntry)scriptEntry.getKey()).getScript(), ((Counter)scriptEntry.getValue()).getCount(), ((ScriptEntry)scriptEntry.getKey()).getOSType(), ((ScriptEntry)scriptEntry.getKey()).getJobType())).sorted(new ByNumberOfJobsComparator()).toList();
    }

    private LinkedHashMap<ScriptEntry, Counter> sortedMapByEntityCount(LinkedHashMap<ScriptEntry, Counter> map) {
        TreeMap<ScriptEntry, Counter> sorted = new TreeMap<ScriptEntry, Counter>((s1, s2) -> {
            int sNum2;
            int sNum1 = ((Counter)map.get(s1)).toInt();
            if (sNum1 == (sNum2 = ((Counter)map.get(s2)).toInt())) {
                return 1;
            }
            return sNum2 - sNum1;
        });
        sorted.putAll(map);
        map.clear();
        map.putAll(sorted);
        return map;
    }

    public LinkedHashMap<ScriptEntry, Counter> getScriptsEntryMap() {
        return this.sortedMapByEntityCount(this.scriptsEntryMap);
    }

    private static final class ByNumberOfJobsComparator
    implements Comparator<ActionValueRecord> {
        private ByNumberOfJobsComparator() {
        }

        @Override
        public int compare(ActionValueRecord o1, ActionValueRecord o2) {
            return Integer.compare(o2.getNumberOfOccurences(), o1.getNumberOfOccurences());
        }
    }
}

