/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.IUC4Job;
import com.bmc.ctmconvert.uc4.scripts.ActionHandler;
import com.bmc.ctmconvert.uc4.scripts.MessageLengthRemover;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OnDoXmlHandler
implements ActionHandler {
    private String xmlWithOnDo;

    public OnDoXmlHandler(String xmlWithOnDo) {
        this.xmlWithOnDo = xmlWithOnDo;
    }

    @Override
    public void convert(IUC4Job uc4Job, String script) {
        try {
            XmlElement onDoXmlElement = OnDoXmlHandler.generateDocumentFromXmlString("<body>" + this.xmlWithOnDo + "</body>");
            boolean onProcessed = false;
            for (XmlElement onElement : onDoXmlElement.getAllDecnedElementByName("ON")) {
                Properties tmpOnStatement = this.getOnProperties(onElement);
                List<Properties> tmpDoStatementList = this.getDoList(onElement);
                uc4Job.addOnDoStmt(tmpOnStatement, tmpDoStatementList);
                onProcessed = true;
            }
            if (!onProcessed) {
                throw new OnDoXmlException();
            }
        }
        catch (OnDoXmlException | IOException | ParserConfigurationException | SAXException e) {
            ConversionLogger.getLogger().info(e.getMessage());
            uc4Job.addMessage("WRN8055", uc4Job.getOriginalJobName(), uc4Job.generateUniqueID(), this.xmlWithOnDo, "UC4_scripts_conversion_to_ctm.xlsx");
        }
    }

    private List<Properties> getDoList(XmlElement onElement) {
        ArrayList<Properties> tmpDoStatementList = new ArrayList<Properties>();
        for (XmlElement doElement : onElement.getAllDirectchildsElement()) {
            Properties tmpDoStatement = this.getDoProperties(doElement);
            tmpDoStatementList.add(tmpDoStatement);
        }
        return tmpDoStatementList;
    }

    private Properties getDoProperties(XmlElement doElement) {
        Properties tmpDoStatement = new Properties();
        String doAction = doElement.getTagName();
        Map doAttributesMap = doElement.getAttributes();
        Set doAttributesKeys = doAttributesMap.keySet();
        tmpDoStatement.setProperty("ACTION", doAction);
        for (String key : doAttributesKeys) {
            String value = (String)doAttributesMap.get(key);
            if (doAction.equals("DOMAIL") && key.equals("MESSAGE")) {
                value = new MessageLengthRemover().remove(value);
            }
            tmpDoStatement.setProperty(key, value);
        }
        return tmpDoStatement;
    }

    private Properties getOnProperties(XmlElement onElement) {
        Map onAttributesMap = onElement.getAttributes();
        Set attributesKeys = onAttributesMap.keySet();
        Properties tmpOnStatement = new Properties();
        for (String key : attributesKeys) {
            String value = (String)onAttributesMap.get(key);
            tmpOnStatement.setProperty(key, value);
        }
        return tmpOnStatement;
    }

    private static XmlElement generateDocumentFromXmlString(String xmlString) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        byte[] xmlStringBytes = xmlString.getBytes();
        Document doc = documentBuilder.parse(new ByteArrayInputStream(xmlStringBytes));
        Element element = doc.getDocumentElement();
        XmlElement result = new XmlElement(element);
        return result;
    }

    private class OnDoXmlException
    extends RuntimeException {
        private static final long serialVersionUID = 8068085649559543274L;

        OnDoXmlException() {
            super("Content of the supplied XML is not a valid Control-M On Do XML");
        }
    }
}

