/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.scripts.IRecord;
import com.bmc.ctmconvert.uc4.scripts.IScriptRecord;

public class ActionValueRecord
implements IRecord,
IScriptRecord {
    static final int SCRIPT_TYPE_INDEX = 0;
    static final int SCRIPT_INDEX = 1;
    static final int NUMBER_OF_OCCURENCES_INDEX = 2;
    static final int JOB_TYPE_INDEX = 3;
    static final int OS_TYPE_INDEX = 4;
    public static final int ACTION1_INDEX = 5;
    static final int VALUE1_INDEX = 6;
    public static final int ACTION2_INDEX = 7;
    static final int VALUE2_INDEX = 8;
    private static final int RECORD_SIZE = 9;
    private final String action1;
    private final String value1;
    private final String action2;
    private final String value2;
    private final boolean isValid;
    private UC4Globals.SCRIPT_TYPE type;
    private final String script;
    private final UC4Globals.OS_TYPE osType;
    private final int numberOfOccurences;
    private final String jobType;

    public ActionValueRecord(UC4Globals.SCRIPT_TYPE type, String script, int numberOfOccurrences, UC4Globals.OS_TYPE osType, String action1, String value1, String action2, String value2, String jobType) {
        this.script = script;
        this.type = type;
        this.numberOfOccurences = numberOfOccurrences;
        this.osType = osType;
        this.action1 = action1;
        this.value1 = value1;
        this.action2 = action2;
        this.value2 = value2;
        this.isValid = !action1.isEmpty() || !action2.isEmpty();
        this.jobType = jobType;
    }

    public ActionValueRecord(UC4Globals.SCRIPT_TYPE type, String script, int numberOfOccurences, UC4Globals.OS_TYPE osType, String jobType) {
        this(type, script, numberOfOccurences, osType, "", "", "", "", jobType);
    }

    public String getAction1() {
        return this.action1;
    }

    public String getAction2() {
        return this.action2;
    }

    public String getValue1() {
        return this.value1;
    }

    public String getValue2() {
        return this.value2;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public String[] getRecord() {
        String[] record = new String[]{this.getType().getValue(), this.getScript(), this.getNumberOfOccurences() != 0 ? Integer.toString(this.getNumberOfOccurences()) : "", this.jobType, this.getOsType().getValue(), this.getAction1(), this.getValue1(), this.getAction2(), this.getValue2()};
        return record;
    }

    public int getNumberOfOccurences() {
        return this.numberOfOccurences;
    }

    public static ActionValueRecord fromStringArray(String[] paramters) {
        String numberOfOccurences;
        if (paramters.length > 9) {
            return new ActionValueRecord(UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_PRE, "", 0, UC4Globals.OS_TYPE.OS_TYPE_DS, "", "", "", "", "");
        }
        UC4Globals.SCRIPT_TYPE scriptType = UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_UNKNOWN;
        String script = "";
        String jobType = "";
        String osTypeStr = "";
        int occurences = 0;
        String action1 = "";
        String value1 = "";
        String action2 = "";
        String value2 = "";
        if (paramters.length > 0) {
            scriptType = UC4Globals.SCRIPT_TYPE.fromString(paramters[0]);
        }
        if (paramters.length > 1) {
            script = paramters[1];
        }
        if (paramters.length > 2 && GlobalFunctions.isNumber((String)(numberOfOccurences = paramters[2]))) {
            occurences = Integer.parseInt(numberOfOccurences);
        }
        if (paramters.length > 3) {
            jobType = paramters[3];
        }
        if (paramters.length > 4) {
            osTypeStr = paramters[4];
        }
        if (paramters.length > 5) {
            action1 = paramters[5];
        }
        if (paramters.length > 6) {
            value1 = paramters[6].trim();
        }
        if (paramters.length > 7) {
            action2 = paramters[7];
        }
        if (paramters.length > 8) {
            value2 = paramters[8].trim();
        }
        UC4Globals.OS_TYPE osType = UC4Globals.OS_TYPE.fromString(osTypeStr);
        return new ActionValueRecord(scriptType, script, occurences, osType, action1, value1, action2, value2, jobType);
    }

    @Override
    public UC4Globals.SCRIPT_TYPE getType() {
        return this.type;
    }

    public void setType(UC4Globals.SCRIPT_TYPE type) {
        this.type = type;
    }

    public String toString() {
        return super.toString() + "ActionValueRecord [action1=" + this.action1 + ", value1=" + this.value1 + ", action2=" + this.action2 + ", value2=" + this.value2 + ", isValid=" + this.isValid + ", type=" + String.valueOf((Object)this.type) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.action1 == null ? 0 : this.action1.hashCode());
        result = 31 * result + (this.action2 == null ? 0 : this.action2.hashCode());
        result = 31 * result + (this.isValid ? 1231 : 1237);
        result = 31 * result + this.numberOfOccurences;
        result = 31 * result + (this.jobType == null ? 0 : this.jobType.hashCode());
        result = 31 * result + (this.osType == null ? 0 : this.osType.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value1 == null ? 0 : this.value1.hashCode());
        result = 31 * result + (this.value2 == null ? 0 : this.value2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionValueRecord other = (ActionValueRecord)obj;
        if (this.action1 == null ? other.action1 != null : !this.action1.equals(other.action1)) {
            return false;
        }
        if (this.action2 == null ? other.action2 != null : !this.action2.equals(other.action2)) {
            return false;
        }
        if (this.jobType == null ? other.jobType != null : !this.jobType.equals(other.jobType)) {
            return false;
        }
        if (this.isValid != other.isValid) {
            return false;
        }
        if (this.numberOfOccurences != other.numberOfOccurences) {
            return false;
        }
        if (this.osType != other.osType) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.value1 == null ? other.value1 != null : !this.value1.equals(other.value1)) {
            return false;
        }
        if (this.value2 == null) {
            return other.value2 == null;
        }
        return this.value2.equals(other.value2);
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public String getJobType() {
        return this.jobType;
    }

    @Override
    public UC4Globals.OS_TYPE getOsType() {
        return this.osType;
    }

    @Override
    public int getNumberofOccurences() {
        return this.numberOfOccurences;
    }
}

