/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.research.group_key_words;

import com.bmc.ctmconvert.uc4.research.KeyWordPattern;
import com.bmc.ctmconvert.uc4.research.KeyWordSGetterParser;
import com.bmc.ctmconvert.uc4.research.ScriptDetails;
import com.bmc.ctmconvert.uc4.research.ScriptreaderHandler;
import com.bmc.ctmconvert.uc4.research.group_key_words.MapSorter;
import com.bmc.ctmconvert.uc4.research.handlers.KeyWord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class PatternKeyWordFinder
implements ScriptreaderHandler {
    private final Map<KeyWordPattern, List<ScriptDetails>> patternToScriptsMap = new HashMap<KeyWordPattern, List<ScriptDetails>>();

    @Override
    public void handleScript(ScriptDetails script) {
        KeyWordSGetterParser parser = new KeyWordSGetterParser();
        List<KeyWord> keyWords = parser.getKeyWords(script.script());
        if (keyWords.isEmpty()) {
            return;
        }
        KeyWordPattern pattern = new KeyWordPattern(keyWords);
        this.patternToScriptsMap.computeIfAbsent(pattern, k -> new ArrayList()).add(script);
    }

    public void forEachScript(BiConsumer<KeyWordPattern, List<ScriptDetails>> collector) {
        MapSorter.CollectionMapSorter<KeyWordPattern, ScriptDetails> sorter = new MapSorter.CollectionMapSorter<KeyWordPattern, ScriptDetails>();
        Map<KeyWordPattern, List<ScriptDetails>> sortedMap = sorter.sortByLength(this.patternToScriptsMap);
        for (KeyWordPattern keywords : sortedMap.keySet()) {
            List<ScriptDetails> scripts = sortedMap.get(keywords);
            collector.accept(keywords, scripts);
        }
    }
}

