/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.research.group_key_words;

import com.bmc.ctmconvert.uc4.research.KeyWordPattern;
import com.bmc.ctmconvert.uc4.research.ScriptDetails;
import com.bmc.ctmconvert.uc4.research.ScriptreaderAnalyze;
import com.bmc.ctmconvert.uc4.research.analyzTools.smiliarScripts.DirectoryReader;
import com.bmc.ctmconvert.uc4.research.group_key_words.ExcelScriptsPatternsWriter;
import com.bmc.ctmconvert.uc4.research.group_key_words.PatternKeyWordFinder;
import com.bmc.toolbox.compare.condition_compare.DependencyChanghHandler;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.entitesCounter.SimpleEntitesCollector;
import com.bmc.toolbox.compare.condition_compare.entitesCounter.changeHandler;
import com.bmc.toolbox.compare.condition_compare.entitites.Dependency;
import com.bmc.toolbox.compare.condition_compare.entitites.Job;
import com.bmc.toolbox.compare.condition_compare.entitites.SmartFolder;
import com.bmc.toolbox.compare.condition_compare.entitites.SubFolder;
import com.bmc.toolbox.compare.condition_compare.gui.Logger;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GroupScriptsFrame {
    public static void main(String[] args) {
        GroupScriptsFrame frame = new GroupScriptsFrame();
        frame.show();
    }

    public void show() {
        JFrame frame = new JFrame("Group Uc4 Scripts By KeyWord");
        frame.setDefaultCloseOperation(3);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(BorderFactory.createBevelBorder(4));
        JTextArea textArea = new JTextArea(5, 20);
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setVerticalScrollBarPolicy(22);
        JPanel panel = new JPanel(new BorderLayout());
        JLabel ontop = new JLabel("Cool...");
        Label draftLableB = new Label("output");
        JPanel outputPanel = new JPanel(new GridLayout(0, 2));
        JTextField outoputTextField = new JTextField();
        outputPanel.add(draftLableB);
        outputPanel.add(outoputTextField);
        panel.add((Component)outputPanel, "Last");
        panel.add((Component)scrollPane, "Center");
        JTextField draftInputA = new JTextField();
        JPanel inputPanel = new JPanel(new GridLayout(0, 2));
        Label draftLableA = new Label("Input");
        inputPanel.add(draftLableA);
        inputPanel.add(draftInputA);
        panel.add((Component)inputPanel, "First");
        AnlayzeKeyWordActionListener action = new AnlayzeKeyWordActionListener(textArea, draftInputA, outoputTextField);
        Button compareButton = new Button("get Groups");
        compareButton.addActionListener(action);
        panel.add((Component)compareButton, "Before");
        frame.setContentPane(panel);
        frame.setSize(1000, 500);
        frame.setVisible(true);
    }

    private static final class AnlayzeKeyWordActionListener
    implements ActionListener {
        private final JTextArea textArea;
        private final JTextField output;
        private final JTextField input;

        private AnlayzeKeyWordActionListener(JTextArea textArea, JTextField input, JTextField outPut) {
            this.textArea = textArea;
            this.input = input;
            this.output = outPut;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PatternKeyWordFinder patternGrouper = new PatternKeyWordFinder();
            ScriptreaderAnalyze reader = new ScriptreaderAnalyze(patternGrouper);
            String filePath = this.input.getText();
            Path draftPath = Paths.get(filePath, new String[0]);
            Logger logger = System.out::println;
            logger.notify("read uc4 xml");
            if (Files.isDirectory(draftPath, new LinkOption[0])) {
                DirectoryReader directoryReader = new DirectoryReader();
                directoryReader.walkOnDirectory(reader, draftPath);
            } else {
                try {
                    InputStream inputStream = this.getStream(this.input);
                    reader.read(inputStream);
                }
                catch (IOException e1) {
                    this.textArea.setText("somthing went Wrong:\n " + String.valueOf(e1));
                    e1.printStackTrace();
                }
            }
            logger.notify("Done reading...");
            try {
                this.finKeywords(patternGrouper);
            }
            catch (IOException e1) {
                this.textArea.setText("somthing went Wrong:\n " + String.valueOf(e1));
                e1.printStackTrace();
            }
        }

        private void finKeywords(PatternKeyWordFinder patternGrouper) throws IOException {
            OutputStream out = this.getOutStream(this.output);
            BiConsumer<KeyWordPattern, List> collector = (pattern, scripts) -> this.textArea.append(scripts.size() + " : " + String.valueOf(pattern) + "\n");
            ExcelScriptsPatternsWriter writer = new ExcelScriptsPatternsWriter();
            BiConsumer<KeyWordPattern, List<ScriptDetails>> multiConsumer = (pattern, scripts) -> {
                collector.accept((KeyWordPattern)pattern, (List)scripts);
                writer.accept((KeyWordPattern)pattern, (List<ScriptDetails>)scripts);
            };
            patternGrouper.forEachScript(multiConsumer);
            writer.write(out);
            out.close();
        }

        private OutputStream getOutStream(JTextField output) throws IOException {
            String pathAsString = output.getText();
            if (pathAsString.isEmpty()) {
                return new ByteArrayOutputStream();
            }
            Path path = Paths.get(pathAsString, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            return Files.newOutputStream(path, new OpenOption[0]);
        }

        private InputStream getStream(JTextField textFeild) throws IOException {
            String draftPathAsString = textFeild.getText();
            Path path = Paths.get(draftPathAsString, new String[0]);
            return Files.newInputStream(path, new OpenOption[0]);
        }
    }

    public static class GuiHandler
    implements DependencyChanghHandler {
        private final JTextArea textArea;
        private int index;

        public GuiHandler(JTextArea textArea) {
            this.textArea = textArea;
            this.textArea.setText("");
            this.index = 0;
        }

        public void addExistOnlyInFirstEvent(Dependency dependency) {
            this.textArea.append(++this.index + "  Dependency only on First:    " + dependency.toString() + "\r\n");
        }

        public void addExistOnlyInSecondEvent(Dependency dependency) {
            this.textArea.append(++this.index + "  Dependency only on Second:   " + dependency.toString() + "\r\n");
        }
    }

    public static class NotifierSimpleEntitesCollector
    extends SimpleEntitesCollector {
        private final Logger logger;
        private int entites;

        public NotifierSimpleEntitesCollector(Logger logger) {
            this.logger = logger;
            this.entites = 0;
        }

        public void handleSmartFolder(SmartFolder smartFolder) {
            this.logger.notify("entites:" + this.entites++);
            super.handleSmartFolder(smartFolder);
        }

        public void handleJob(Job job) {
            this.logger.notify("entites:" + this.entites++);
            super.handleJob(job);
        }

        public void handleSubFolder(SubFolder subFolder) {
            this.logger.notify("entites:" + this.entites++);
            super.handleSubFolder(subFolder);
        }
    }

    public static class GuiChangeHanlder
    implements changeHandler {
        private int index = 0;
        private final JTextArea textArea;

        public GuiChangeHanlder(JTextArea textArea) {
            this.textArea = textArea;
        }

        public void addEvent(int size1, int size2) {
            this.textArea.append("entites1 #: " + size1 + "\n");
            this.textArea.append("entites2 #: " + size2 + "\n");
        }

        public void addExistOnlyINFirstEvent(DraftPath path) {
            this.textArea.append(++this.index + "  entity only on First:    " + path.toString() + "\r\n");
        }

        public void addExistOnlyInSecondEvent(DraftPath path) {
            this.textArea.append(++this.index + "  entity only on Second:    " + path.toString() + "\r\n");
        }
    }
}

