/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.research.analyzTools.smiliarScripts;

import com.bmc.ctmconvert.uc4.research.ScriptreaderAnalyze;
import com.bmc.ctmconvert.uc4.research.analyzTools.SingleScriptKeyFinder;
import com.bmc.ctmconvert.uc4.research.analyzTools.smiliarScripts.DirectoryReader;
import com.bmc.ctmconvert.uc4.research.analyzTools.smiliarScripts.SameScriptHandler;
import com.bmc.ctmconvert.uc4.research.analyzTools.smiliarScripts.SimilarScriptFinder;
import com.bmc.ctmconvert.uc4.scripts.IRecord;
import com.bmc.ctmconvert.uc4.scripts.ScriptExcelWriter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.BiConsumer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class SimilarScriptsFrame {
    public void show() {
        JFrame frame = new JFrame("Similar Scripts finder");
        JPanel contentPane = new JPanel(new BorderLayout());
        frame.setDefaultCloseOperation(3);
        final JTextArea textArea = new JTextArea(5, 20);
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setVerticalScrollBarPolicy(22);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel filesPanel = new JPanel(new GridLayout(2, 0));
        panel.add((Component)scrollPane, "Center");
        final JTextField inputFileField = new JTextField("Input File here");
        final JTextField outFileField = new JTextField("output File");
        filesPanel.add(inputFileField);
        filesPanel.add(outFileField);
        panel.add((Component)filesPanel, "Last");
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(3, 1, 7, 1);
        JSpinner spinner = new JSpinner(spinnerModel);
        spinner.setSize(50, 50);
        panel.add((Component)spinner, "After");
        AnlayzeKeyWordActionListener action = new AnlayzeKeyWordActionListener(this, textArea, spinner, inputFileField);
        contentPane.setBorder(BorderFactory.createBevelBorder(4));
        JLabel ontop = new JLabel("On top");
        panel.add((Component)ontop, "First");
        JPanel buttinPanel = new JPanel(new GridLayout(2, 0));
        Button analayzeButton = new Button("regular analyze");
        analayzeButton.addActionListener(action);
        buttinPanel.add(analayzeButton);
        Button incAnalayzeButton = new Button("Find Similiar Scripts");
        ActionListener incAnalyzeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SameScriptHandler sameScriptHandler = new SameScriptHandler();
                SimilarScriptFinder finder = new SimilarScriptFinder(sameScriptHandler);
                ScriptreaderAnalyze reader = new ScriptreaderAnalyze(finder);
                String[] header = new String[]{"Script", "number of Occurrences"};
                ScriptExcelWriter writer = new ScriptExcelWriter(header);
                BiConsumer<String, Integer> t = (script, counter) -> {
                    SimpleRecord record = new SimpleRecord(SimilarScriptsFrame.this, (String)script, (Integer)counter);
                    writer.accept(record);
                };
                String inputFilePath = inputFileField.getText();
                Path path = Paths.get(inputFilePath, new String[0]);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    DirectoryReader directoryReader = new DirectoryReader();
                    directoryReader.walkOnDirectory(reader, path);
                    textArea.setText(finder.getResults());
                } else {
                    try {
                        FileInputStream input = new FileInputStream(inputFilePath);
                        reader.read(input);
                        textArea.setText(finder.getResults());
                    }
                    catch (Exception e1) {
                        textArea.setText(e1.toString());
                        e1.printStackTrace();
                    }
                }
                sameScriptHandler.forEachScript(t);
                String outFilePath = outFileField.getText();
                try {
                    FileOutputStream outputStream = new FileOutputStream(outFilePath);
                    writer.write(outputStream);
                    outputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        incAnalayzeButton.addActionListener(incAnalyzeAction);
        buttinPanel.add(incAnalayzeButton);
        panel.add((Component)buttinPanel, "Before");
        frame.setContentPane(panel);
        frame.setSize(1000, 500);
        frame.setVisible(true);
    }

    private final class AnlayzeKeyWordActionListener
    implements ActionListener {
        private final JTextArea textArea;
        private final JSpinner spinner;
        private final JTextField textField;

        private AnlayzeKeyWordActionListener(SimilarScriptsFrame similarScriptsFrame, JTextArea textArea, JSpinner spinner, JTextField textField) {
            this.textArea = textArea;
            this.spinner = spinner;
            this.textField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Integer interval = Integer.valueOf(this.spinner.getValue().toString());
            SingleScriptKeyFinder finder = new SingleScriptKeyFinder(interval);
            ScriptreaderAnalyze reader = new ScriptreaderAnalyze(finder);
            String filePath = this.textField.getText();
            Path path = Paths.get(filePath, new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                DirectoryReader directoryReader = new DirectoryReader();
                directoryReader.walkOnDirectory(reader, path);
                this.textArea.setText(finder.getResults());
            } else {
                try {
                    FileInputStream input = new FileInputStream(filePath);
                    reader.read(input);
                    this.textArea.setText(finder.getResults());
                }
                catch (Exception e1) {
                    this.textArea.setText(e1.toString());
                    e1.printStackTrace();
                }
            }
        }
    }

    public class SimpleRecord
    implements IRecord {
        private final String script;
        private final Integer counter;

        public SimpleRecord(SimilarScriptsFrame this$0, String script, Integer counter) {
            this.script = script;
            this.counter = counter;
        }

        @Override
        public String[] getRecord() {
            return new String[]{this.script, this.counter.toString()};
        }
    }
}

