/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.handlers.variables;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class VariablesResolver {
    protected Map<String, String> variablesMap = new LinkedHashMap<String, String>();

    public Optional<String> getVariableValue(String varName) {
        if (!this.isVariableName(varName)) {
            return Optional.empty();
        }
        String realVarName = this.getVariableName(varName);
        if (!this.variablesMap.containsKey(realVarName)) {
            return Optional.empty();
        }
        String varValue = this.variablesMap.get(realVarName);
        return Optional.of(varValue);
    }

    @NotNull
    public String getVariableName(String varName) {
        return varName.replaceFirst("^&", "").replaceFirst("#$", "");
    }

    public boolean isVariableName(String value) {
        boolean ret = false;
        if (value.matches("^&.*#$")) {
            return true;
        }
        return ret;
    }

    public Map<String, String> getVariableDefinitions() {
        return this.variablesMap;
    }
}

