/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.handlers.variables;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.Uc4MessageHandler;
import com.bmc.ctmconvert.uc4.Uc4VariablesConsumer;
import com.bmc.ctmconvert.uc4.handlers.variables.DynValuesVariablesResolver;
import com.bmc.ctmconvert.uc4.handlers.variables.VariablesConsumer;
import java.util.List;
import java.util.Map;

public class JOBSDynValuesVariablesResolver
extends DynValuesVariablesResolver {
    private XmlElement uc4XmlElement;
    private UC4Job uc4Job;
    Uc4MessageHandler uc4MessageHandler;
    public VariablesConsumer uc4VariablesConsumer;

    private void addVariablesFromXmlElement(XmlElement uc4XmlElement) {
        if (uc4XmlElement == null) {
            return;
        }
        this.uc4XmlElement = uc4XmlElement;
        this.setVariableConsumer();
        List dynElementArray = this.uc4XmlElement.getAllDecnedElementByName("node");
        for (XmlElement dynElement : dynElementArray) {
            if (!dynElement.hasAttributeWithValue("name", "Variables")) continue;
            List dynSubElementList = dynElement.getAllDecnedElementByName("row");
            for (XmlElement xmlVarElement : dynSubElementList) {
                String varName = this.getVariableName(xmlVarElement.getAttribute("Name"));
                String varValue = xmlVarElement.getAttribute("Value");
                this.variablesMap.put(varName, varValue);
            }
        }
    }

    private void setVariableConsumer() {
        if (this.uc4Job != null) {
            this.uc4MessageHandler = new Uc4MessageHandler(this.uc4Job.getOriginalJobName(), this.uc4Job.getJobName(), this.uc4Job::addMessage);
            this.uc4VariablesConsumer = new Uc4VariablesConsumer(this.uc4Job.getFieldValidation(), this.uc4MessageHandler, this.uc4Job::addVariable);
        }
    }

    public JOBSDynValuesVariablesResolver(UC4Job uc4Job) {
        XmlElement parentJobXmlElement;
        this.uc4Job = uc4Job;
        this.addVariablesFromXmlElement(uc4Job.getJobXmlElement());
        if (this.uc4Job.getParent() != null && (parentJobXmlElement = this.uc4Job.getParent().getJobXmlElement()) != null) {
            XmlElement jobXmlElement = parentJobXmlElement.getAllDecnedElementByName("task").stream().filter(task -> task.hasAttributeWithValue("Alias", this.uc4Job.getOriginalJobName()) || task.getAttribute("Alias").trim().isEmpty() && task.hasAttributeWithValue("Object", this.uc4Job.getOriginalJobName())).findFirst().orElse(null);
            this.addVariablesFromXmlElement(jobXmlElement);
        }
    }

    @Override
    public void handleDynValuesVariables() {
        Map<String, String> variables = this.getVariableDefinitions();
        variables.forEach((key, value) -> this.uc4VariablesConsumer.accept((String)key, (String)value));
    }
}

