/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.cm.cit;

import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.cm.cit.BaseFTPCommandHandler;
import java.util.Map;
import java.util.Optional;

public class FTPCopyCommandHandler
extends BaseFTPCommandHandler {
    public FTPCopyCommandHandler(UC4Job uc4job, Map<String, String> citComponentXmlName2Value) {
        this.uc4job = uc4job;
        this.citComponentXmlName2Value = citComponentXmlName2Value;
    }

    @Override
    public void handle() {
        this.addFTPAttributes();
        this.addFTPVariables();
        String originalJobName = this.uc4job.getOriginalJobName();
        String jobName = this.uc4job.getJobName();
        this.uc4job.addMessage("WRN8063", originalJobName, jobName);
    }

    @Override
    public void addFTPAttributes() {
        this.uc4job.addAttribute("DESCRIPTION", this.getFTPParameterOrNull("description"));
        this.uc4job.addAttribute("TASKTYPE", "Job");
        this.uc4job.addAttribute("APPL_TYPE", "FILE_TRANS");
        this.uc4job.addAttribute("APPL_VER", "6.1.01");
        this.uc4job.addAttribute("APPL_FORM", "AFT");
        this.uc4job.addAttribute("CM_VER", "610");
    }

    private void addFileTransferDefaultVariables() {
        this.uc4job.addVariable("%%FTP-PATH", "Not in use for application jobs");
        this.uc4job.addVariable("%%FTP-LPASSIVE", "0");
        this.uc4job.addVariable("%%FTP-RPASSIVE", "0");
        this.uc4job.addVariable("%%FTP-UPLOAD1", "1");
        this.uc4job.addVariable("%%FTP-TIMELIMIT_UNIT1", "1");
        this.uc4job.addVariable("%%FTP-TIMELIMIT1", "0");
        this.uc4job.addVariable("%%FTP-ABSTIME1", "0");
        this.uc4job.addVariable("%%FTP-OVERRIDE_WATCH_INTERVAL1", "0");
        this.uc4job.addVariable("%%FTP-WATCH_INTERVAL1", "30");
        this.uc4job.addVariable("%%FTP-IF_EXIST1", "0");
        this.uc4job.addVariable("%%FTP-DSTOPT1", "0");
        this.uc4job.addVariable("%%FTP-UNIQUE1", "0");
        this.uc4job.addVariable("%%FTP-TRIM1", "1");
        this.uc4job.addVariable("%%FTP-FLDS1", "0");
        this.uc4job.addVariable("%%FTP-VERNUM1", "0");
        this.uc4job.addVariable("%%FTP-EXCLUDE_WILDCARD1", "0");
        this.uc4job.addVariable("%%FTP-CASEIFS1", "0");
        this.uc4job.addVariable("%%FTP-TRANSFER_NUM", "1");
        this.uc4job.addVariable("%%FTP-CONT_EXE_NOTOK", "0");
        this.uc4job.addVariable("%%FTP-RPF", "0");
        this.uc4job.addVariable("%%FTP-USE_DEF_NUMRETRIES", "0");
        this.uc4job.addVariable("%%FTP-NUM_RETRIES", "5");
        this.uc4job.addVariable("%%FTP-Is", "5");
        this.uc4job.addVariable("%%FTP-AUTOREFRESH", "False");
    }

    private void addAccountVariable() {
        String fromConnection = this.getFTPParameterOrNull("fromConnection");
        String toConnection = this.getFTPParameterOrNull("toConnection");
        this.uc4job.addVariable("%%FTP-ACCOUNT", this.replaceSpaceWithUnderscore(fromConnection) + "_TO_" + this.replaceSpaceWithUnderscore(toConnection));
    }

    private String getFTPParameterOrNull(String xmlName) {
        int commandIndex = 0;
        String prefixString = String.format("prompt_%d_", commandIndex);
        if (this.citComponentXmlName2Value.containsKey(prefixString + xmlName)) {
            return (String)this.citComponentXmlName2Value.get(prefixString + xmlName);
        }
        return (String)this.citComponentXmlName2Value.get(xmlName);
    }

    private String getFTPParameterOrDefault(String xmlName, String defaultValue) {
        return Optional.ofNullable(this.getFTPParameterOrNull(xmlName)).orElse(defaultValue);
    }

    private void addSourceAndDest() {
        String source = this.getFTPParameterOrDefault("sourceDir", "DEFAULT_SOURCE_PATH");
        String dest = this.getFTPParameterOrDefault("destDir", "DEFAULT_TARGET_PATH");
        this.uc4job.addVariable("%%FTP-LPATH1", source);
        this.uc4job.addVariable("%%FTP-RPATH1", dest);
    }

    private void addOnFailureVariables() {
        String onFail = this.getFTPParameterOrNull("onFailureOption");
        if (onFail != null && !onFail.equals("3") && !onFail.equals("4")) {
            this.uc4job.addVariable("%%FTP-CONT_EXE1", "1");
            this.uc4job.addVariable("%%FTP-CONT_EXE_NOTOK", "1");
        }
    }

    private void addIfFileExistVariables() {
        String sValue = this.getFTPParameterOrNull("ifFileExistsOption");
        try {
            Integer iValue = 5 - Integer.parseInt(sValue);
            sValue = String.valueOf(iValue);
            this.uc4job.addVariable("%%FTP-IF_EXIST1", sValue);
        }
        catch (NumberFormatException e) {
            this.uc4job.addVariable("%%FTP-IF_EXIST1", "0");
        }
    }

    private void addRecursive() {
        String recursive = this.getFTPParameterOrNull("copyAllChildrenFiles");
        if (recursive != null && recursive.equalsIgnoreCase("true")) {
            this.uc4job.addVariable("%%FTP-RECURSIVE1", "1");
        } else {
            this.uc4job.addVariable("%%FTP-RECURSIVE1", "0");
        }
    }

    private void addEraseSource() {
        String eraseSource = this.getFTPParameterOrNull("eraseSource");
        if (eraseSource != null && eraseSource.equalsIgnoreCase("true")) {
            this.uc4job.addVariable("%%FTP-SRCOPT1", "1");
        } else {
            this.uc4job.addVariable("%%FTP-SRCOPT1", "0");
        }
    }

    private void addRetriesAttempt() {
        String retries = (String)this.citComponentXmlName2Value.get("retryAttempts");
        if (retries != null) {
            this.uc4job.addVariable("%%FTP-NUM_RETRIES", retries);
            this.uc4job.addVariable("%%FTP-Is", retries);
        }
    }

    private void addFileType() {
        UC4Globals.FTP_FILE_TYPE type = UC4Globals.FTP_FILE_TYPE.getFileTypeFromText(this.getFTPParameterOrNull("fileType"));
        this.uc4job.addVariable("%%FTP-TYPE1", type.getType());
    }

    @Override
    public void addFTPVariables() {
        this.addFileTransferDefaultVariables();
        this.addAccountVariable();
        this.addFileType();
        this.addSourceAndDest();
        this.addEraseSource();
        this.addRecursive();
        this.addRetriesAttempt();
        this.addIfFileExistVariables();
        this.addOnFailureVariables();
    }
}

