/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.XML;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.uc4.XML.XMLStructureNode;
import com.csvreader.CsvWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Xml2Csv {
    private final List<Path> xmlFiles;
    private final String uc4Title;
    private final Path targetPath;
    private final Map<String, DataCollection> dataCollections = new HashMap<String, DataCollection>();
    private String rootName = null;
    private String rootEntityName = null;
    private final XMLStructureNode rootStructureNode;
    private HashMap<String, String> multiIdValues = null;

    public Xml2Csv(String title, List<Path> xmlFiles, Path targetPath, XMLStructureNode rootStructureNode) {
        this.uc4Title = title;
        this.xmlFiles = xmlFiles;
        this.targetPath = targetPath;
        this.rootStructureNode = rootStructureNode;
    }

    public void writeToCsv() {
        try {
            this.readEntries();
            this.entries2csv();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void entries2csv() throws IOException {
        for (String collection : this.dataCollections.keySet()) {
            DataCollection currCollection = this.dataCollections.get(collection);
            String fileName = currCollection.getFileName();
            Path csvTargetName = this.targetPath.resolve(fileName);
            OutputStream outputStream = Files.newOutputStream(csvTargetName, new OpenOption[0]);
            CsvWriter writer = new CsvWriter(outputStream, ',', Charset.defaultCharset());
            writer.writeRecord(currCollection.getHeaders());
            for (HashMap<String, String> entry : currCollection.getEntries()) {
                writer.writeRecord(this.map2arr(entry, currCollection.getHeaders()));
            }
            writer.close();
        }
    }

    private String[] map2arr(HashMap<String, String> entry, String[] headers) {
        String[] toRet = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            if (!entry.containsKey(headers[i])) continue;
            toRet[i] = entry.get(headers[i]);
        }
        return toRet;
    }

    private void readEntries() throws IOException {
        for (Path xmlFile : this.xmlFiles) {
            DataCollection collection = new DataCollection(this.uc4Title);
            String csvTargetName = this.uc4Title + ".csv";
            collection.setFileName(csvTargetName);
            collection.setHeasers(this.getCsvHeader(this.rootStructureNode, true));
            try {
                InputStream xmlStream = Files.newInputStream(xmlFile, new OpenOption[0]);
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder parser = factory.newDocumentBuilder();
                    Document doc = parser.parse(xmlStream);
                    doc.getDocumentElement().normalize();
                    Element rootElement = doc.getDocumentElement();
                    Node currNode = rootElement.getFirstChild();
                    do {
                        if (!currNode.getNodeName().startsWith(this.rootStructureNode.getName())) continue;
                        if (this.rootStructureNode.getRootAttribute() != null) {
                            this.rootName = currNode.getAttributes().getNamedItem(this.rootStructureNode.getRootAttribute()).getNodeValue();
                            this.rootEntityName = currNode.getNodeName();
                        }
                        HashMap<String, String> processEntry = this.processEntry(currNode, this.rootStructureNode, xmlFile.getFileName().toString());
                        collection.setEntry(processEntry);
                    } while ((currNode = currNode.getNextSibling()) != null);
                    if (this.dataCollections.containsKey(collection.getCollectionName())) {
                        this.dataCollections.get(collection.getCollectionName()).addAllEntries(collection.getEntries());
                        continue;
                    }
                    this.dataCollections.put(collection.getCollectionName(), collection);
                }
                finally {
                    if (xmlStream == null) continue;
                    xmlStream.close();
                }
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> processEntry(Node entryNode, XMLStructureNode structureNode, String fileName) {
        HashMap<String, String> toRet = new HashMap<String, String>();
        toRet.put("root", this.rootEntityName);
        if (entryNode.getNodeName().startsWith(structureNode.getName())) {
            for (String string : structureNode.getAttributes()) {
                Node tmpAttr = entryNode.getAttributes().getNamedItem(string);
                if (tmpAttr == null) continue;
                toRet.put(String.format("%s_%s", structureNode.getName(), tmpAttr.getNodeName()), tmpAttr.getNodeValue());
            }
            if (structureNode.checkForChildren()) {
                boolean hasChildren = entryNode.getChildNodes().getLength() > 0;
                toRet.put(structureNode.getCheckForChildrenAttrName(), hasChildren ? "YES" : "NO");
            }
            if (!structureNode.hasChild()) {
                if (structureNode.hasCsvName()) {
                    toRet.put(structureNode.getCsvName(), entryNode.getTextContent());
                } else {
                    toRet.put(entryNode.getNodeName(), entryNode.getTextContent());
                }
            }
        }
        NodeList tmpChildList = entryNode.getChildNodes();
        for (XMLStructureNode child : structureNode.getChilds()) {
            for (int index = 0; index < tmpChildList.getLength(); ++index) {
                Node currNode = tmpChildList.item(index);
                if (!currNode.getNodeName().startsWith(child.getName())) continue;
                if (child.isMulti()) {
                    if (child.hasMultiId()) {
                        for (String multiIdAttr : child.getMultiIdAttrList()) {
                            Node tmpAttr = currNode.getAttributes().getNamedItem(multiIdAttr);
                            if (tmpAttr == null) continue;
                            if (this.multiIdValues == null) {
                                this.multiIdValues = new HashMap();
                            }
                            this.multiIdValues.put(multiIdAttr, tmpAttr.getNodeValue());
                        }
                    }
                    toRet.put(child.getMultiName(), "YES");
                }
                HashMap<String, String> processEntry = this.processEntry(currNode, child, fileName);
                toRet.putAll(processEntry);
            }
        }
        if (structureNode.isMulti()) {
            void var6_12;
            Object var6_9 = null;
            String collectionName = String.format("%s_%s", this.uc4Title, structureNode.getMultiName());
            DataCollection dataCollection = this.dataCollections.get(collectionName);
            if (dataCollection == null) {
                DataCollection dataCollection2 = new DataCollection(collectionName);
                String fileNameformat = collectionName + ".csv";
                dataCollection2.setFileName(fileNameformat);
                dataCollection2.setHeasers(this.getCsvHeader(structureNode, false));
            }
            if (structureNode.needMultiId() && this.multiIdValues != null) {
                for (String multiIdName : this.multiIdValues.keySet()) {
                    toRet.put(structureNode.getMultiIdNames(multiIdName), this.multiIdValues.get(multiIdName));
                }
            }
            toRet.put("root", this.rootName);
            var6_12.setEntry(toRet);
            this.dataCollections.put(collectionName, (DataCollection)var6_12);
            toRet = new HashMap();
        } else {
            toRet.put("FileName", fileName);
        }
        return toRet;
    }

    private String[] getCsvHeader(XMLStructureNode structue, boolean ignoreMulti) {
        ArrayList<String> tmp = XMLStructureNode.getHeaders(structue, ignoreMulti);
        String[] toRet = new String[tmp.size()];
        for (int index = 0; index < tmp.size(); ++index) {
            toRet[index] = tmp.get(index);
        }
        return toRet;
    }

    private static class DataCollection {
        private final String collectionName;
        private String fileName;
        private String[] headers;
        private final List<HashMap<String, String>> entries = new ArrayList<HashMap<String, String>>();

        public DataCollection(String name) {
            this.collectionName = name;
        }

        public String getCollectionName() {
            return this.collectionName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setHeasers(String[] headers) {
            this.headers = headers;
        }

        public String[] getHeaders() {
            return this.headers;
        }

        public void setEntry(HashMap<String, String> entry) {
            this.entries.add(entry);
        }

        public void addAllEntries(List<HashMap<String, String>> entries) {
            if (entries != null) {
                this.entries.addAll(entries);
            }
        }

        public List<HashMap<String, String>> getEntries() {
            return this.entries;
        }

        public String toString() {
            return "DataCollection [collectionName=" + this.collectionName + ", fileName=" + this.fileName + ", headers=" + Arrays.toString(this.headers) + ", entries=" + String.valueOf(this.entries) + "]";
        }
    }
}

