/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.XML;

import java.util.ArrayList;
import java.util.List;

public abstract class UC4Entry {
    private final String title;
    private final String tagName;
    private final boolean isMandatory;
    private boolean isValid;
    private boolean multiTypes = false;
    protected final List<UC4Entry> childs = new ArrayList<UC4Entry>();
    private boolean updated;

    public UC4Entry(String title, String tagName, boolean isMandatory) {
        this.title = title;
        this.tagName = tagName;
        this.isMandatory = isMandatory;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public void addChild(UC4Entry entry) {
        if (entry != null) {
            this.childs.add(entry);
        }
        this.updated = true;
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean isExist() {
        if (!this.childs.isEmpty()) {
            for (UC4Entry child : this.childs) {
                if (!child.isExist()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isValid() {
        if (!this.childs.isEmpty()) {
            this.isValid = true;
            for (UC4Entry child : this.childs) {
                if (!child.isMandatory() || child.isValid()) continue;
                this.isValid = false;
                break;
            }
        }
        return this.isValid;
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    public boolean isMultiTypes() {
        return this.multiTypes;
    }

    public void setMultiTypes(boolean multiTypes) {
        this.multiTypes = multiTypes;
    }

    public ENTRY_STATE getEntryState() {
        if (this.updated) {
            if (!(!this.isMandatory() || this.isExist() && this.isValid())) {
                return ENTRY_STATE.Failed;
            }
            if (!this.isMandatory() && this.isExist() && !this.isValid()) {
                return ENTRY_STATE.Warning;
            }
            if (this.isExist() && this.isValid()) {
                return ENTRY_STATE.Success;
            }
        }
        return ENTRY_STATE.Default;
    }

    public String toString() {
        return this.title;
    }

    public void setUpdated(boolean b) {
        this.updated = b;
    }

    public static enum ENTRY_STATE {
        Success,
        Failed,
        Warning,
        Default;

    }
}

