/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.uc4.UC4Defs;
import java.util.ArrayList;
import java.util.List;

public class Uc4EntitesWalker {
    private UC4Defs defs;

    public Uc4EntitesWalker(UC4Defs defs) {
        this.defs = defs;
    }

    public void walk(AttrHolderList top_level_parents, Uc4Action action) {
        List<SchedEntity> smartFolders = this.getSmartFolders(top_level_parents);
        InnerWalker innerWalker = new InnerWalker(this, action);
        innerWalker.walk(smartFolders);
    }

    private List<SchedEntity> getSmartFolders(AttrHolderList top_level_parents) {
        ArrayList<SchedEntity> ret = new ArrayList<SchedEntity>();
        for (IAttrHolder toplevel : top_level_parents) {
            SchedEntity smartFolder = this.defs.spawnJob("", toplevel);
            ret.add(smartFolder);
        }
        return ret;
    }

    public class InnerWalker {
        private Uc4Action action;

        public InnerWalker(Uc4EntitesWalker this$0, Uc4Action action) {
            this.action = action;
        }

        public void walk(List<SchedEntity> smartFolders) {
            for (SchedEntity smartFolder : smartFolders) {
                this.actOnChildren(smartFolder);
            }
        }

        private void actOnChildren(SchedEntity folder) {
            List children = folder.getChildren();
            SchedEntity.TYPE type = folder.type();
            this.action.act(folder);
            if (this.isJob(type)) {
                return;
            }
            for (SchedEntity child : children) {
                this.actOnChildren(child);
            }
        }

        private boolean isJob(SchedEntity.TYPE type) {
            return type.equals((Object)SchedEntity.TYPE.JOB);
        }
    }

    @FunctionalInterface
    public static interface Uc4Action {
        public void act(SchedEntity var1);
    }
}

