/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.XML.XMLStructureNode;
import org.jetbrains.annotations.NotNull;

public class UC4XMLStructure {
    public static final String NOTIFICATION = "NOTIFICATION";

    public static XMLStructureNode getXMLStructure(UC4Globals.UC4_TYPES type) {
        return switch (type) {
            case UC4Globals.UC4_TYPES.JSCH -> UC4XMLStructure.getScheduleStructure();
            case UC4Globals.UC4_TYPES.JOBP -> UC4XMLStructure.getProcessFlowStructure();
            case UC4Globals.UC4_TYPES.JOBS -> UC4XMLStructure.getJobsStructure();
            case UC4Globals.UC4_TYPES.SCRI -> UC4XMLStructure.getScriptStructure();
            case UC4Globals.UC4_TYPES.SYNC -> UC4XMLStructure.getSyncStructure();
            case UC4Globals.UC4_TYPES.CALE -> UC4XMLStructure.getCalendarStructure();
            case UC4Globals.UC4_TYPES.JOBF -> UC4XMLStructure.getFileTransferStructure();
            case UC4Globals.UC4_TYPES.JOBI -> UC4XMLStructure.getIncludeStructure();
            case UC4Globals.UC4_TYPES.LOGIN -> UC4XMLStructure.getLoginStructure();
            case UC4Globals.UC4_TYPES.CALL -> UC4XMLStructure.getNotificationStructure();
            case UC4Globals.UC4_TYPES.TZ -> UC4XMLStructure.getTimeZoneStructure();
            case UC4Globals.UC4_TYPES.USER -> UC4XMLStructure.getUserStructure();
            case UC4Globals.UC4_TYPES.USRG -> UC4XMLStructure.getUserGroupStructure();
            case UC4Globals.UC4_TYPES.VARA -> UC4XMLStructure.getVariableStructure();
            case UC4Globals.UC4_TYPES.HOST -> UC4XMLStructure.getAgentStructure();
            case UC4Globals.UC4_TYPES.HOSTG -> UC4XMLStructure.getAgentGroupStructure();
            case UC4Globals.UC4_TYPES.JOBG -> UC4XMLStructure.getGroupStructure();
            case UC4Globals.UC4_TYPES.EVNT -> UC4XMLStructure.getEventStructure();
            case UC4Globals.UC4_TYPES.TASK_JOB -> UC4XMLStructure.getTaskJobStructure();
            case UC4Globals.UC4_TYPES.CONN_CIT -> UC4XMLStructure.getConnCitStructure();
            case UC4Globals.UC4_TYPES.CONN_SQL -> UC4XMLStructure.getConnSqlStructure();
            default -> UC4XMLStructure.StubStructure();
        };
    }

    public static XMLStructureNode getMultiXMLStructure(UC4Globals.UC4_TYPES type, String multiName) {
        XMLStructureNode retVal = UC4XMLStructure.getXMLStructure(type);
        if (retVal != null) {
            return UC4XMLStructure.getMultiXMLStructureRecursive(retVal, multiName);
        }
        return retVal;
    }

    private static XMLStructureNode getMultiXMLStructureRecursive(XMLStructureNode node, String multiName) {
        if (node == null || node.getName().equalsIgnoreCase(multiName)) {
            return node;
        }
        if (node.hasChild()) {
            for (XMLStructureNode child : node.getChilds()) {
                XMLStructureNode currNode = UC4XMLStructure.getMultiXMLStructureRecursive(child, multiName);
                if (currNode == null) continue;
                return currNode;
            }
        }
        return null;
    }

    public static String getIdFieldName(UC4Globals.UC4_TYPES type) {
        if (type.equals((Object)UC4Globals.UC4_TYPES.TASK_JOB) || type.equals((Object)UC4Globals.UC4_TYPES.UNKNOWN) || type.equals((Object)UC4Globals.UC4_TYPES.MISSING)) {
            return "task_Object";
        }
        return String.format("%s_%s", type.getTagName(), "name");
    }

    public static XMLStructureNode getScheduleStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("JSCH");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.JSCH.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addChild(new XMLStructureNode("Title"));
        header.addChild(new XMLStructureNode("ArchiveKey1"));
        header.addChild(new XMLStructureNode("ArchiveKey2"));
        header.addChild(new XMLStructureNode("ExtRepDef"));
        header.addChild(new XMLStructureNode("ExtRepAll"));
        header.addChild(new XMLStructureNode("ExtRepNone"));
        entityNodeStructure.addChild(header);
        UC4XMLStructure.addSync(entityNodeStructure);
        XMLStructureNode attributes = new XMLStructureNode("ATTR_JSCH");
        attributes.addChild(new XMLStructureNode("StartType"));
        attributes.addChild(new XMLStructureNode("IntAccount"));
        attributes.addChild(new XMLStructureNode("ActAtRun"));
        attributes.addChild(new XMLStructureNode("Period"));
        attributes.addChild(new XMLStructureNode("StartTime"));
        attributes.addChild(new XMLStructureNode("UC4Priority"));
        attributes.addChild(new XMLStructureNode("MaxParallel2"));
        attributes.addChild(new XMLStructureNode("MpElse1"));
        attributes.addChild(new XMLStructureNode("MpElse2"));
        attributes.addChild(new XMLStructureNode("TZ"));
        attributes.addChild(new XMLStructureNode("RWhen"));
        attributes.addChild(new XMLStructureNode("RExecute"));
        entityNodeStructure.addChild(attributes);
        XMLStructureNode schedule = new XMLStructureNode("JSCH");
        XMLStructureNode jschStruct = new XMLStructureNode("JschStruct");
        jschStruct.addAttribute("StartTime");
        jschStruct.addAttribute("Period");
        jschStruct.addAttribute("mode");
        jschStruct.addAttribute("MsgNr");
        XMLStructureNode task = new XMLStructureNode("task");
        task.setIsMulti(true);
        task.setHasMultiId(true);
        task.addMultiIdAttr("Idnr");
        task.addAttribute("Idnr");
        task.addAttribute("Lnr");
        task.addAttribute("Object");
        task.addAttribute("OType");
        task.addAttribute("Text1");
        task.addAttribute("Text2");
        task.addAttribute("Text3");
        task.addAttribute("Text4");
        task.addAttribute("Text5");
        task.addAttribute("Text6");
        XMLStructureNode timePeriod = new XMLStructureNode("TimePeriod");
        timePeriod.addAttribute("TimePeriodValue");
        task.addChild(timePeriod);
        XMLStructureNode after = new XMLStructureNode("after");
        after.addAttribute("ErlstStDays");
        after.addAttribute("ErlstStTime");
        after.addAttribute("ActFlg");
        task.addChild(after);
        XMLStructureNode runtime = new XMLStructureNode("runtime");
        runtime.addAttribute("MrtOn");
        runtime.addAttribute("MrtMethodNone");
        runtime.addAttribute("MrtMethodFix");
        runtime.addAttribute("MrtFix");
        runtime.addAttribute("MrtMethodErt");
        runtime.addAttribute("MrtErt");
        runtime.addAttribute("MrtMethodDate");
        runtime.addAttribute("MrtDays");
        runtime.addAttribute("MrtTime");
        runtime.addAttribute("MrtTZ");
        runtime.addAttribute("SrtMethodNone");
        runtime.addAttribute("SrtMethodFix");
        runtime.addAttribute("SrtFix");
        runtime.addAttribute("SrtMethodErt");
        runtime.addAttribute("SrtErt");
        runtime.addAttribute("MrtCancel");
        runtime.addAttribute("MrtExecute");
        runtime.addAttribute("MrtExecuteObj");
        task.addChild(runtime);
        XMLStructureNode result = new XMLStructureNode("result");
        result.addAttribute("RWhen");
        result.addAttribute("ChkRExec");
        result.addAttribute("RExecute");
        result.addAttribute("RRepOn");
        result.addAttribute("RRepMTimes");
        result.addAttribute("RRepWait");
        result.addAttribute("RElseHalt");
        result.addAttribute("RElseIgn");
        result.addAttribute("RElseJPAbend");
        result.addAttribute("RExecFlag");
        task.addChild(result);
        XMLStructureNode calendars = new XMLStructureNode("calendars");
        calendars.addAttribute("CaleOn");
        calendars.addAttribute("CCTypeAll");
        calendars.addAttribute("CCTypeOne");
        calendars.addAttribute("CCTypeNone");
        XMLStructureNode cale = new XMLStructureNode("cale");
        cale.setIsMulti(true);
        cale.setNeedMultiId(true);
        cale.addMultiIdNames("Idnr", "cale");
        cale.addAttribute("id");
        cale.addAttribute("CaleName");
        cale.addAttribute("CaleKeyName");
        calendars.addChild(cale);
        task.addChild(calendars);
        jschStruct.addChild(task);
        schedule.addChild(jschStruct);
        entityNodeStructure.addChild(schedule);
        XMLStructureNode runtimeTab = new XMLStructureNode("RUNTIME");
        runtimeTab.addChild(new XMLStructureNode("MaxRetCode"));
        runtimeTab.addChild(new XMLStructureNode("FcstStatus"));
        runtimeTab.addChild(new XMLStructureNode("Ert"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDef"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtDynMethod"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDyn"));
        runtimeTab.addChild(new XMLStructureNode("ErtCnt"));
        runtimeTab.addChild(new XMLStructureNode("ErtCorr"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgn"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgnFlg"));
        runtimeTab.addChild(new XMLStructureNode("ErtMinCnt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodDate"));
        runtimeTab.addChild(new XMLStructureNode("MrtDays"));
        runtimeTab.addChild(new XMLStructureNode("MrtTime"));
        runtimeTab.addChild(new XMLStructureNode("MrtTZ"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("SrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtCancel"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecute"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecuteObj"));
        entityNodeStructure.addChild(runtimeTab);
        XMLStructureNode valuesTab = new XMLStructureNode("VALUE");
        XMLStructureNode values = new XMLStructureNode("Values");
        XMLStructureNode valuesRow = new XMLStructureNode("row");
        valuesRow.setIsMulti(true);
        valuesRow.setMultiName("Values");
        valuesRow.addAttribute("id");
        valuesRow.addAttribute("Name");
        valuesRow.addAttribute("Value");
        values.addChild(valuesRow);
        valuesTab.addChild(values);
        entityNodeStructure.addChild(valuesTab);
        XMLStructureNode scriptTab = new XMLStructureNode("SCRIPT");
        scriptTab.addChild(new XMLStructureNode("MSCRI"));
        entityNodeStructure.addChild(scriptTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getProcessFlowStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("JOBP");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.JOBP.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("AllowExternal");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addChild(new XMLStructureNode("Title"));
        header.addChild(new XMLStructureNode("ArchiveKey1"));
        header.addChild(new XMLStructureNode("ArchiveKey2"));
        header.addChild(new XMLStructureNode("ExtRepDef"));
        header.addChild(new XMLStructureNode("ExtRepAll"));
        header.addChild(new XMLStructureNode("ExtRepNone"));
        entityNodeStructure.addChild(header);
        UC4XMLStructure.addSync(entityNodeStructure);
        XMLStructureNode attributes = new XMLStructureNode("ATTR_JOBP");
        attributes.addChild(new XMLStructureNode("StartType"));
        attributes.addChild(new XMLStructureNode("IntAccount"));
        attributes.addChild(new XMLStructureNode("AutoDeactNo"));
        attributes.addChild(new XMLStructureNode("AutoDeact1ErrorFree"));
        attributes.addChild(new XMLStructureNode("AutoDeactErrorFree"));
        attributes.addChild(new XMLStructureNode("DeactWhen"));
        attributes.addChild(new XMLStructureNode("AutoDeactAlways"));
        attributes.addChild(new XMLStructureNode("DeactDelay"));
        attributes.addChild(new XMLStructureNode("ActAtRun"));
        attributes.addChild(new XMLStructureNode("UC4Priority"));
        attributes.addChild(new XMLStructureNode("MaxParallel2"));
        attributes.addChild(new XMLStructureNode("MpElse1"));
        attributes.addChild(new XMLStructureNode("MpElse2"));
        attributes.addChild(new XMLStructureNode("TZ"));
        attributes.addChild(new XMLStructureNode("RWhen"));
        attributes.addChild(new XMLStructureNode("RExecute"));
        entityNodeStructure.addChild(attributes);
        XMLStructureNode processFlow = new XMLStructureNode("JOBP");
        XMLStructureNode jobpStruct = new XMLStructureNode("JobpStruct");
        jobpStruct.addAttribute("mode");
        XMLStructureNode task = new XMLStructureNode("task");
        task.setIsMulti(true);
        task.setHasMultiId(true);
        task.addMultiIdAttr("Idnr");
        task.addMultiIdAttr("Lnr");
        task.addAttribute("Alias");
        task.addAttribute("Idnr");
        task.addAttribute("Lnr");
        task.addAttribute("Object");
        task.addAttribute("OType");
        task.addAttribute("ParentObject");
        task.addAttribute("State");
        task.addAttribute("Text1");
        task.addAttribute("Text2");
        task.addAttribute("Text3");
        task.addAttribute("Text4");
        task.addAttribute("Text5");
        task.addAttribute("Text6");
        task.addAttribute("Row");
        task.addAttribute("Col");
        XMLStructureNode checkpoint = new XMLStructureNode("checkpoint");
        checkpoint.addAttribute("TcpOn");
        checkpoint.addAttribute("TcpADays");
        checkpoint.addAttribute("TcpATime");
        checkpoint.addAttribute("TcpATimeTZ");
        checkpoint.addAttribute("TcpExecute");
        task.addChild(checkpoint);
        XMLStructureNode after = new XMLStructureNode("after");
        after.addAttribute("AtimOn");
        after.addAttribute("ErlstStDays");
        after.addAttribute("ErlstStTime");
        after.addAttribute("ErlstStTimeTZ");
        after.addAttribute("ActFlg");
        after.addAttribute("HoldFlg");
        task.addChild(after);
        XMLStructureNode when = new XMLStructureNode("when");
        when.addAttribute("WtimOn");
        when.addAttribute("LtstSt");
        when.addAttribute("LtstStDays");
        when.addAttribute("LtstStTime");
        when.addAttribute("LtstEnd");
        when.addAttribute("LtstEndDays");
        when.addAttribute("LtstEndTime");
        when.addAttribute("LtstTimeTZ");
        when.addAttribute("WElseS");
        when.addAttribute("WElseH");
        when.addAttribute("WElseX");
        when.addAttribute("WElseA");
        when.addAttribute("ChkWhenExec");
        when.addAttribute("WhenExecute");
        when.addAttribute("WCTypeAND");
        when.addAttribute("WCTypeOR");
        task.addChild(when);
        XMLStructureNode preconditions = new XMLStructureNode("preconditions");
        XMLStructureNode PreCon = new XMLStructureNode("PreCon");
        XMLStructureNode PreConConditions = new XMLStructureNode("conditions");
        PreConConditions.setCheckForChildren(true);
        PreConConditions.setCheckForChildrenAttrName("PreCon_conditions");
        PreCon.addChild(PreConConditions);
        preconditions.addChild(PreCon);
        task.addChild(preconditions);
        UC4XMLStructure.postConditionsStructure(task);
        XMLStructureNode predecessors = new XMLStructureNode("predecessors");
        predecessors.addAttribute("CaleOn");
        predecessors.addAttribute("CCTypeOne");
        XMLStructureNode pre = new XMLStructureNode("pre");
        pre.setIsMulti(true);
        pre.setNeedMultiId(true);
        pre.setMultiName("pre");
        pre.addMultiIdNames("Idnr", "pre");
        pre.addMultiIdNames("Lnr", "parent_Lnr");
        pre.addAttribute("Lnr");
        pre.addAttribute("PreLnr");
        pre.addAttribute("When");
        predecessors.addChild(pre);
        task.addChild(predecessors);
        XMLStructureNode runtime = new XMLStructureNode("runtime");
        runtime.addAttribute("MrtOn");
        runtime.addAttribute("MrtMethodNone");
        runtime.addAttribute("MrtMethodFix");
        runtime.addAttribute("MrtFix");
        runtime.addAttribute("MrtMethodErt");
        runtime.addAttribute("MrtErt");
        runtime.addAttribute("MrtMethodDate");
        runtime.addAttribute("MrtDays");
        runtime.addAttribute("MrtTime");
        runtime.addAttribute("MrtTZ");
        runtime.addAttribute("SrtMethodNone");
        runtime.addAttribute("SrtMethodFix");
        runtime.addAttribute("SrtFix");
        runtime.addAttribute("SrtMethodErt");
        runtime.addAttribute("SrtErt");
        runtime.addAttribute("MrtCancel");
        runtime.addAttribute("MrtExecute");
        runtime.addAttribute("MrtExecuteObj");
        task.addChild(runtime);
        XMLStructureNode result = new XMLStructureNode("result");
        result.addAttribute("RWhen");
        result.addAttribute("ChkRExec");
        result.addAttribute("RExecute");
        result.addAttribute("RRepOn");
        result.addAttribute("RRepMTimes");
        result.addAttribute("RRepWait");
        result.addAttribute("RElseHalt");
        result.addAttribute("RElseIgn");
        result.addAttribute("RElseJPAbend");
        result.addAttribute("RExecFlag");
        task.addChild(result);
        XMLStructureNode calendars = new XMLStructureNode("calendars");
        calendars.addAttribute("CaleOn");
        calendars.addAttribute("CCTypeAll");
        calendars.addAttribute("CCTypeOne");
        calendars.addAttribute("CCTypeNone");
        calendars.addAttribute("CCTypeExt");
        XMLStructureNode cale = new XMLStructureNode("cale");
        cale.setIsMulti(true);
        cale.setNeedMultiId(true);
        cale.addMultiIdNames("Idnr", "cale");
        cale.addAttribute("id");
        cale.addAttribute("CaleName");
        cale.addAttribute("CaleKeyName");
        calendars.addChild(cale);
        task.addChild(calendars);
        jobpStruct.addChild(task);
        processFlow.addChild(jobpStruct);
        entityNodeStructure.addChild(processFlow);
        XMLStructureNode runtimeTab = new XMLStructureNode("RUNTIME");
        runtimeTab.addChild(new XMLStructureNode("MaxRetCode"));
        runtimeTab.addChild(new XMLStructureNode("FcstStatus"));
        runtimeTab.addChild(new XMLStructureNode("Ert"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDef"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtDynMethod"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDyn"));
        runtimeTab.addChild(new XMLStructureNode("ErtCnt"));
        runtimeTab.addChild(new XMLStructureNode("ErtCorr"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgn"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgnFlg"));
        runtimeTab.addChild(new XMLStructureNode("ErtMinCnt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodDate"));
        runtimeTab.addChild(new XMLStructureNode("MrtDays"));
        runtimeTab.addChild(new XMLStructureNode("MrtTime"));
        runtimeTab.addChild(new XMLStructureNode("MrtTZ"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("SrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtCancel"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecute"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecuteObj"));
        entityNodeStructure.addChild(runtimeTab);
        XMLStructureNode valuesTab = new XMLStructureNode("VALUE");
        XMLStructureNode values = new XMLStructureNode("Values");
        XMLStructureNode valuesRow = new XMLStructureNode("row");
        valuesRow.setIsMulti(true);
        valuesRow.setMultiName("Values");
        valuesRow.addAttribute("id");
        valuesRow.addAttribute("Name");
        valuesRow.addAttribute("Value");
        values.addChild(valuesRow);
        valuesTab.addChild(values);
        entityNodeStructure.addChild(valuesTab);
        XMLStructureNode scriptTab = new XMLStructureNode("SCRIPT");
        scriptTab.addChild(new XMLStructureNode("MSCRI"));
        entityNodeStructure.addChild(scriptTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static void postConditionsStructure(XMLStructureNode task) {
        XMLStructureNode postconditions = new XMLStructureNode("postconditions");
        XMLStructureNode PostCon = new XMLStructureNode("PostCon");
        XMLStructureNode conditions = new XMLStructureNode("conditions");
        conditions.setCheckForChildren(true);
        conditions.setCheckForChildrenAttrName("PostCon_conditions");
        XMLStructureNode condition = UC4XMLStructure.getXmlStructureForConditionNode();
        UC4XMLStructure.getXmlStructureForWhenNode("when", "whenAction_params", condition);
        UC4XMLStructure.getXmlStructureForWhenNode("else", "elseAction_params", condition);
        conditions.addChild(condition);
        PostCon.addChild(conditions);
        postconditions.addChild(PostCon);
        task.addChild(postconditions);
    }

    private static void getXmlStructureForWhenNode(String when, String whenAction_params, XMLStructureNode condition) {
        XMLStructureNode whenNode = new XMLStructureNode(when);
        XMLStructureNode actionWhen = new XMLStructureNode("action");
        actionWhen.setIsMulti(true);
        actionWhen.setHasMultiId(true);
        actionWhen.addMultiIdAttr("id");
        actionWhen.addMultiIdNames("Lnr", "parent_Lnr");
        actionWhen.addAttribute("id");
        XMLStructureNode actionParamsWhen = new XMLStructureNode("params");
        XMLStructureNode actionParamWhen = new XMLStructureNode("param");
        actionParamWhen.setIsMulti(true);
        actionParamWhen.setNeedMultiId(true);
        actionParamWhen.setMultiName(whenAction_params);
        actionParamWhen.addMultiIdNames("Lnr", "parent_Lnr");
        actionParamWhen.addMultiIdNames("id", "action_Id");
        actionParamWhen.addAttribute("altview");
        actionParamWhen.addAttribute("name");
        actionParamWhen.addAttribute("type");
        actionParamWhen.addAttribute("value");
        actionParamsWhen.addChild(actionParamWhen);
        actionWhen.addChild(actionParamsWhen);
        whenNode.addChild(actionWhen);
        condition.addChild(whenNode);
    }

    @NotNull
    private static XMLStructureNode getXmlStructureForConditionNode() {
        XMLStructureNode condition = new XMLStructureNode("condition");
        condition.addAttribute("id");
        XMLStructureNode params = new XMLStructureNode("params");
        XMLStructureNode param = new XMLStructureNode("param");
        param.setIsMulti(true);
        param.setNeedMultiId(true);
        param.setMultiName("Condition_params");
        param.addMultiIdNames("Lnr", "parent_Lnr");
        param.addAttribute("altview");
        param.addAttribute("name");
        param.addAttribute("type");
        param.addAttribute("value");
        params.addChild(param);
        condition.addChild(params);
        return condition;
    }

    private static XMLStructureNode getJobsStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("JOBS");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.JOBS.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addChild(new XMLStructureNode("Title"));
        header.addChild(new XMLStructureNode("ArchiveKey1"));
        header.addChild(new XMLStructureNode("ArchiveKey2"));
        header.addChild(new XMLStructureNode("ExtRepDef"));
        header.addChild(new XMLStructureNode("ExtRepAll"));
        header.addChild(new XMLStructureNode("ExtRepNone"));
        entityNodeStructure.addChild(header);
        UC4XMLStructure.addSync(entityNodeStructure);
        XMLStructureNode attributes = new XMLStructureNode("ATTR_JOBS");
        attributes.addChild(new XMLStructureNode("StartType"));
        attributes.addChild(new XMLStructureNode("HostDst"));
        attributes.addChild(new XMLStructureNode("HostATTR_Type"));
        attributes.addChild(new XMLStructureNode("CodeName"));
        attributes.addChild(new XMLStructureNode("Login"));
        attributes.addChild(new XMLStructureNode("IntAccount"));
        attributes.addChild(new XMLStructureNode("AutoDeactNo"));
        attributes.addChild(new XMLStructureNode("AutoDeact1ErrorFree"));
        attributes.addChild(new XMLStructureNode("AutoDeactErrorFree"));
        attributes.addChild(new XMLStructureNode("DeactWhen"));
        attributes.addChild(new XMLStructureNode("DeactDelay"));
        attributes.addChild(new XMLStructureNode("AutoDeactAlways"));
        attributes.addChild(new XMLStructureNode("AttDialog"));
        attributes.addChild(new XMLStructureNode("ActAtRun"));
        attributes.addChild(new XMLStructureNode("Consumption"));
        attributes.addChild(new XMLStructureNode("UC4Priority"));
        attributes.addChild(new XMLStructureNode("MaxParallel2"));
        attributes.addChild(new XMLStructureNode("MpElse1"));
        attributes.addChild(new XMLStructureNode("MpElse2"));
        attributes.addChild(new XMLStructureNode("TZ"));
        entityNodeStructure.addChild(attributes);
        XMLStructureNode citAttributes = new XMLStructureNode("CIT");
        XMLStructureNode citContAttributes = new XMLStructureNode("citcont");
        citContAttributes.addAttribute("agentname");
        citContAttributes.addAttribute("jobtype");
        citContAttributes.addAttribute("text");
        citAttributes.addChild(citContAttributes);
        entityNodeStructure.addChild(citAttributes);
        XMLStructureNode R3attributes = new XMLStructureNode("ATTR_R3");
        R3attributes.addAttribute("state");
        R3attributes.addChild(new XMLStructureNode("OutputDb"));
        R3attributes.addChild(new XMLStructureNode("OutputDbErr"));
        R3attributes.addChild(new XMLStructureNode("OutputFile"));
        R3attributes.addChild(new XMLStructureNode("Language"));
        R3attributes.addChild(new XMLStructureNode("JobName"));
        R3attributes.addChild(new XMLStructureNode("JobClass"));
        R3attributes.addChild(new XMLStructureNode("TargetSystem"));
        R3attributes.addChild(new XMLStructureNode("DeleteJob"));
        R3attributes.addChild(new XMLStructureNode("NoDelOnErr"));
        R3attributes.addChild(new XMLStructureNode("AsSoon"));
        R3attributes.addChild(new XMLStructureNode("Immediately"));
        R3attributes.addChild(new XMLStructureNode("SAP_Recipent"));
        R3attributes.addChild(new XMLStructureNode("SAP_AddressType"));
        R3attributes.addChild(new XMLStructureNode("SAP_Express"));
        R3attributes.addChild(new XMLStructureNode("SAP_Copy"));
        R3attributes.addChild(new XMLStructureNode("SAP_BlindCopy"));
        R3attributes.addChild(new XMLStructureNode("SAP_NoForward"));
        entityNodeStructure.addChild(R3attributes);
        XMLStructureNode PS_formAttributes = new XMLStructureNode("ATTR_PS_FORM");
        PS_formAttributes.addAttribute("state");
        XMLStructureNode PS1Attributes = new XMLStructureNode("ps1");
        PS1Attributes.addChild(new XMLStructureNode("connection"));
        PS1Attributes.addChild(new XMLStructureNode("logininfo"));
        PS1Attributes.addChild(new XMLStructureNode("password"));
        PS_formAttributes.addChild(PS1Attributes);
        entityNodeStructure.addChild(PS_formAttributes);
        XMLStructureNode windowsAttributes = new XMLStructureNode("ATTR_WINDOWS");
        windowsAttributes.addChild(new XMLStructureNode("OutputDb"));
        windowsAttributes.addChild(new XMLStructureNode("OutputDbErr"));
        windowsAttributes.addChild(new XMLStructureNode("OutputFile"));
        windowsAttributes.addChild(new XMLStructureNode("IsGenerated"));
        windowsAttributes.addChild(new XMLStructureNode("BAT"));
        windowsAttributes.addChild(new XMLStructureNode("COM"));
        windowsAttributes.addChild(new XMLStructureNode("WinBatch"));
        windowsAttributes.addChild(new XMLStructureNode("Standard"));
        windowsAttributes.addChild(new XMLStructureNode("Minimized"));
        windowsAttributes.addChild(new XMLStructureNode("Maximized"));
        windowsAttributes.addChild(new XMLStructureNode("JObjDefault"));
        windowsAttributes.addChild(new XMLStructureNode("JObjYes"));
        windowsAttributes.addChild(new XMLStructureNode("JObjNo"));
        windowsAttributes.addChild(new XMLStructureNode("WorkingDirectory"));
        windowsAttributes.addChild(new XMLStructureNode("Command"));
        windowsAttributes.addChild(new XMLStructureNode("LogOn"));
        windowsAttributes.addChild(new XMLStructureNode("ShowJob"));
        entityNodeStructure.addChild(windowsAttributes);
        XMLStructureNode unixAttributes = new XMLStructureNode("ATTR_UNIX");
        unixAttributes.addChild(new XMLStructureNode("OutputDb"));
        unixAttributes.addChild(new XMLStructureNode("OutputDbErr"));
        unixAttributes.addChild(new XMLStructureNode("OutputFile"));
        unixAttributes.addChild(new XMLStructureNode("ShellScript"));
        unixAttributes.addChild(new XMLStructureNode("Command"));
        unixAttributes.addChild(new XMLStructureNode("Shell"));
        unixAttributes.addChild(new XMLStructureNode("ShellOptions"));
        unixAttributes.addChild(new XMLStructureNode("Com"));
        entityNodeStructure.addChild(unixAttributes);
        XMLStructureNode runtimeTab = new XMLStructureNode("RUNTIME");
        runtimeTab.addChild(new XMLStructureNode("MaxRetCode"));
        runtimeTab.addChild(new XMLStructureNode("FcstStatus"));
        runtimeTab.addChild(new XMLStructureNode("Ert"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDef"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtDynMethod"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDyn"));
        runtimeTab.addChild(new XMLStructureNode("ErtCnt"));
        runtimeTab.addChild(new XMLStructureNode("ErtCorr"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgn"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgnFlg"));
        runtimeTab.addChild(new XMLStructureNode("ErtMinCnt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodDate"));
        runtimeTab.addChild(new XMLStructureNode("MrtDays"));
        runtimeTab.addChild(new XMLStructureNode("MrtTime"));
        runtimeTab.addChild(new XMLStructureNode("MrtTZ"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("SrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtCancel"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecute"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecuteObj"));
        entityNodeStructure.addChild(runtimeTab);
        XMLStructureNode valuesTab = new XMLStructureNode("VALUE");
        XMLStructureNode values = new XMLStructureNode("Values");
        XMLStructureNode valuesRow = new XMLStructureNode("row");
        valuesRow.setIsMulti(true);
        valuesRow.setMultiName("Values");
        valuesRow.addAttribute("id");
        valuesRow.addAttribute("Name");
        valuesRow.addAttribute("Value");
        values.addChild(valuesRow);
        valuesTab.addChild(values);
        entityNodeStructure.addChild(valuesTab);
        XMLStructureNode preScriptTab = new XMLStructureNode("PRE_SCRIPT");
        preScriptTab.addChild(new XMLStructureNode("PSCRI"));
        entityNodeStructure.addChild(preScriptTab);
        XMLStructureNode scriptTab = new XMLStructureNode("SCRIPT");
        scriptTab.addChild(new XMLStructureNode("MSCRI"));
        entityNodeStructure.addChild(scriptTab);
        XMLStructureNode postScriptTab = new XMLStructureNode("POST_SCRIPT");
        postScriptTab.addChild(new XMLStructureNode("OSCRI"));
        entityNodeStructure.addChild(postScriptTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        XMLStructureNode attributesSql = new XMLStructureNode("ATTR_SQL");
        attributesSql.addChild(new XMLStructureNode("SQLConnection"));
        attributesSql.addChild(new XMLStructureNode("Connection"));
        attributesSql.addChild(new XMLStructureNode("ServerPort"));
        attributesSql.addChild(new XMLStructureNode("DatabaseName"));
        entityNodeStructure.addChild(attributesSql);
        XMLStructureNode attributesSqlForm = new XMLStructureNode("ATTR_SQL_FORM");
        XMLStructureNode sql1 = new XMLStructureNode("sql1");
        sql1.addChild(new XMLStructureNode("formshost"));
        sql1.addChild(new XMLStructureNode("logininfo"));
        sql1.addChild(new XMLStructureNode("password"));
        attributesSqlForm.addChild(sql1);
        entityNodeStructure.addChild(attributesSqlForm);
        return entityNodeStructure;
    }

    private static XMLStructureNode getScriptStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("SCRI");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.SCRI.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addChild(new XMLStructureNode("Title"));
        header.addChild(new XMLStructureNode("ArchiveKey1"));
        header.addChild(new XMLStructureNode("ArchiveKey2"));
        header.addChild(new XMLStructureNode("ExtRepDef"));
        header.addChild(new XMLStructureNode("ExtRepAll"));
        header.addChild(new XMLStructureNode("ExtRepNone"));
        entityNodeStructure.addChild(header);
        UC4XMLStructure.addSync(entityNodeStructure);
        XMLStructureNode attributes = new XMLStructureNode("ATTR_SCRI");
        attributes.addChild(new XMLStructureNode("StartType"));
        attributes.addChild(new XMLStructureNode("IntAccount"));
        attributes.addChild(new XMLStructureNode("ActAtRun"));
        attributes.addChild(new XMLStructureNode("UC4Priority"));
        attributes.addChild(new XMLStructureNode("MaxParallel2"));
        attributes.addChild(new XMLStructureNode("MpElse1"));
        attributes.addChild(new XMLStructureNode("MpElse2"));
        attributes.addChild(new XMLStructureNode("TZ"));
        entityNodeStructure.addChild(attributes);
        XMLStructureNode runtimeTab = new XMLStructureNode("RUNTIME");
        runtimeTab.addChild(new XMLStructureNode("MaxRetCode"));
        runtimeTab.addChild(new XMLStructureNode("FcstStatus"));
        runtimeTab.addChild(new XMLStructureNode("Ert"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDef"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtDynMethod"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDyn"));
        runtimeTab.addChild(new XMLStructureNode("ErtCnt"));
        runtimeTab.addChild(new XMLStructureNode("ErtCorr"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgn"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgnFlg"));
        runtimeTab.addChild(new XMLStructureNode("ErtMinCnt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodDate"));
        runtimeTab.addChild(new XMLStructureNode("MrtDays"));
        runtimeTab.addChild(new XMLStructureNode("MrtTime"));
        runtimeTab.addChild(new XMLStructureNode("MrtTZ"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("SrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtCancel"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecute"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecuteObj"));
        entityNodeStructure.addChild(runtimeTab);
        XMLStructureNode valuesTab = new XMLStructureNode("VALUE");
        XMLStructureNode values = new XMLStructureNode("Values");
        XMLStructureNode valuesRow = new XMLStructureNode("row");
        valuesRow.setIsMulti(true);
        valuesRow.setMultiName("Values");
        valuesRow.addAttribute("Name");
        valuesRow.addAttribute("Value");
        values.addChild(valuesRow);
        valuesTab.addChild(values);
        entityNodeStructure.addChild(valuesTab);
        XMLStructureNode scriptTab = new XMLStructureNode("SCRIPT");
        scriptTab.addChild(new XMLStructureNode("MSCRI"));
        entityNodeStructure.addChild(scriptTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static void addSync(XMLStructureNode entityNodeStructure) {
        XMLStructureNode syncRef = new XMLStructureNode("SYNCREF");
        XMLStructureNode sync = new XMLStructureNode("Syncs");
        XMLStructureNode syncRow = new XMLStructureNode("row");
        syncRow.setIsMulti(true);
        syncRow.setMultiName("Syncs");
        syncRow.addAttribute("id");
        syncRow.addAttribute("Name");
        syncRow.addAttribute("Start");
        syncRow.addAttribute("Abend");
        syncRow.addAttribute("End");
        syncRow.addAttribute("Else");
        sync.addChild(syncRow);
        syncRef.addChild(sync);
        entityNodeStructure.addChild(syncRef);
    }

    private static XMLStructureNode getSyncStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("SYNC");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.SYNC.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addChild(new XMLStructureNode("Title"));
        header.addChild(new XMLStructureNode("ArchiveKey1"));
        header.addChild(new XMLStructureNode("ArchiveKey2"));
        header.addChild(new XMLStructureNode("ExtRepDef"));
        header.addChild(new XMLStructureNode("ExtRepAll"));
        header.addChild(new XMLStructureNode("ExtRepNone"));
        entityNodeStructure.addChild(header);
        XMLStructureNode attributes = new XMLStructureNode("ATTR_SYNC");
        attributes.addChild(new XMLStructureNode("CurrState"));
        attributes.addChild(new XMLStructureNode("Value"));
        entityNodeStructure.addChild(attributes);
        XMLStructureNode sync = new XMLStructureNode("SYNC");
        XMLStructureNode state = new XMLStructureNode("State");
        XMLStructureNode stateRow = new XMLStructureNode("row");
        stateRow.setIsMulti(true);
        stateRow.setMultiName("states");
        stateRow.addAttribute("Status");
        stateRow.addAttribute("Text");
        state.addChild(stateRow);
        XMLStructureNode rule = new XMLStructureNode("Rule");
        XMLStructureNode ruleRow = new XMLStructureNode("row");
        ruleRow.setIsMulti(true);
        ruleRow.setMultiName("rules");
        ruleRow.addAttribute("Action");
        ruleRow.addAttribute("StatusCheck");
        ruleRow.addAttribute("OperatorCheck");
        ruleRow.addAttribute("ValueCheck");
        ruleRow.addAttribute("StatusSet");
        ruleRow.addAttribute("OperatorSet");
        ruleRow.addAttribute("ValueSet");
        rule.addChild(ruleRow);
        sync.addChild(state);
        sync.addChild(rule);
        entityNodeStructure.addChild(sync);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getCalendarStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("CALE");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.CALE.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        entityNodeStructure.addChild(header);
        XMLStructureNode specificObjectTab = new XMLStructureNode("CALE");
        specificObjectTab.addAttribute("state");
        XMLStructureNode caleData = new XMLStructureNode("CaleData");
        caleData.addAttribute("DisplayFrom");
        caleData.addAttribute("DisplayTo");
        caleData.addAttribute("periods");
        XMLStructureNode keywords = new XMLStructureNode("Keywords");
        keywords.addAttribute("okb");
        XMLStructureNode keyword = new XMLStructureNode("Keyword");
        keyword.setIsMulti(true);
        keyword.setHasMultiId(true);
        keyword.addMultiIdAttr("name");
        keyword.addAttribute("CType");
        keyword.addAttribute("ErrMsgInsert");
        keyword.addAttribute("ErrMsgNr");
        keyword.addAttribute("MsgNr");
        keyword.addAttribute("SType");
        keyword.addAttribute("ValidFrom");
        keyword.addAttribute("ValidTo");
        keyword.addAttribute("name");
        keyword.addAttribute("state");
        XMLStructureNode staticKeyword = new XMLStructureNode("Static");
        XMLStructureNode month = new XMLStructureNode("Month");
        month.setIsMulti(true);
        month.setNeedMultiId(true);
        month.addMultiIdNames("name", "Keyword");
        month.addAttribute("mm");
        month.addAttribute("yyyy");
        staticKeyword.addChild(month);
        keyword.addChild(staticKeyword);
        keywords.addChild(keyword);
        caleData.addChild(keywords);
        specificObjectTab.addChild(caleData);
        entityNodeStructure.addChild(specificObjectTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getFileTransferStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("JOBF");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.JOBF.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        header.addChild(new XMLStructureNode("ArchiveKey1"));
        header.addChild(new XMLStructureNode("ArchiveKey2"));
        header.addChild(new XMLStructureNode("ExtRepDef"));
        header.addChild(new XMLStructureNode("ExtRepAll"));
        header.addChild(new XMLStructureNode("ExtRepNone"));
        entityNodeStructure.addChild(header);
        XMLStructureNode syncRef = new XMLStructureNode("SYNCREF");
        syncRef.addAttribute("state");
        XMLStructureNode sync = new XMLStructureNode("Syncs");
        XMLStructureNode syncRow = new XMLStructureNode("row");
        syncRow.setIsMulti(true);
        syncRow.addAttribute("id");
        syncRow.addAttribute("Name");
        syncRow.addAttribute("Start");
        syncRow.addAttribute("Abend");
        syncRow.addAttribute("End");
        syncRow.addAttribute("Else");
        sync.addChild(syncRow);
        syncRef.addChild(sync);
        entityNodeStructure.addChild(syncRef);
        XMLStructureNode attributes = new XMLStructureNode("ATTR_JOBF");
        attributes.addAttribute("state");
        attributes.addChild(new XMLStructureNode("StartType"));
        attributes.addChild(new XMLStructureNode("IntAccount"));
        attributes.addChild(new XMLStructureNode("AutoDeactNo"));
        attributes.addChild(new XMLStructureNode("AutoDeact1ErrorFree"));
        attributes.addChild(new XMLStructureNode("AutoDeactErrorFree"));
        attributes.addChild(new XMLStructureNode("DeactWhen"));
        attributes.addChild(new XMLStructureNode("AutoDeactAlways"));
        attributes.addChild(new XMLStructureNode("DeactDelay"));
        attributes.addChild(new XMLStructureNode("AttDialog"));
        attributes.addChild(new XMLStructureNode("ActAtRun"));
        attributes.addChild(new XMLStructureNode("UC4Priority"));
        attributes.addChild(new XMLStructureNode("MaxParallel2"));
        attributes.addChild(new XMLStructureNode("MpElse1"));
        attributes.addChild(new XMLStructureNode("MpElse2"));
        attributes.addChild(new XMLStructureNode("TZ"));
        entityNodeStructure.addChild(attributes);
        XMLStructureNode specificObjectTab = new XMLStructureNode("JOBF");
        specificObjectTab.addAttribute("state");
        specificObjectTab.addChild(new XMLStructureNode("HostSrc"));
        specificObjectTab.addChild(new XMLStructureNode("CodeNameSrc"));
        specificObjectTab.addChild(new XMLStructureNode("LoginSrc"));
        specificObjectTab.addChild(new XMLStructureNode("Compress"));
        specificObjectTab.addChild(new XMLStructureNode("FileNameSrc"));
        specificObjectTab.addChild(new XMLStructureNode("FileAttrSrc"));
        specificObjectTab.addChild(new XMLStructureNode("HostDst"));
        specificObjectTab.addChild(new XMLStructureNode("CodeNameDst"));
        specificObjectTab.addChild(new XMLStructureNode("LoginDst"));
        specificObjectTab.addChild(new XMLStructureNode("FileNameDst"));
        specificObjectTab.addChild(new XMLStructureNode("FileAttrDst"));
        specificObjectTab.addChild(new XMLStructureNode("WildCard"));
        specificObjectTab.addChild(new XMLStructureNode("MaxParallel"));
        specificObjectTab.addChild(new XMLStructureNode("RepeatType"));
        specificObjectTab.addChild(new XMLStructureNode("Erase"));
        specificObjectTab.addChild(new XMLStructureNode("TextTypeText"));
        specificObjectTab.addChild(new XMLStructureNode("TextTypeBin"));
        specificObjectTab.addChild(new XMLStructureNode("OvCancel"));
        specificObjectTab.addChild(new XMLStructureNode("OvOverwrite"));
        specificObjectTab.addChild(new XMLStructureNode("OvAppend"));
        entityNodeStructure.addChild(specificObjectTab);
        XMLStructureNode runtimeTab = new XMLStructureNode("RUNTIME");
        runtimeTab.addAttribute("state");
        runtimeTab.addChild(new XMLStructureNode("MaxRetCode"));
        runtimeTab.addChild(new XMLStructureNode("FcstStatus"));
        runtimeTab.addChild(new XMLStructureNode("Ert"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDef"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtDynMethod"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDyn"));
        runtimeTab.addChild(new XMLStructureNode("ErtCnt"));
        runtimeTab.addChild(new XMLStructureNode("ErtCorr"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgn"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgnFlg"));
        runtimeTab.addChild(new XMLStructureNode("ErtMinCnt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodDate"));
        runtimeTab.addChild(new XMLStructureNode("MrtDays"));
        runtimeTab.addChild(new XMLStructureNode("MrtTime"));
        runtimeTab.addChild(new XMLStructureNode("MrtTZ"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("SrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtCancel"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecute"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecuteObj"));
        entityNodeStructure.addChild(runtimeTab);
        XMLStructureNode valuesTab = new XMLStructureNode("VALUE");
        XMLStructureNode values = new XMLStructureNode("Values");
        XMLStructureNode valuesRow = new XMLStructureNode("row");
        valuesRow.setIsMulti(true);
        valuesRow.setMultiName("Values");
        valuesRow.addAttribute("Name");
        valuesRow.addAttribute("Value");
        values.addChild(valuesRow);
        valuesTab.addChild(values);
        entityNodeStructure.addChild(valuesTab);
        XMLStructureNode scriptTab = new XMLStructureNode("SCRIPT");
        scriptTab.addAttribute("state");
        scriptTab.addChild(new XMLStructureNode("MSCRI"));
        entityNodeStructure.addChild(scriptTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getIncludeStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("JOBI");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.JOBI.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        entityNodeStructure.addChild(header);
        XMLStructureNode scriptTab = new XMLStructureNode("SCRIPT");
        scriptTab.addAttribute("state");
        scriptTab.addChild(new XMLStructureNode("MSCRI"));
        entityNodeStructure.addChild(scriptTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getLoginStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("LOGIN");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.LOGIN.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        entityNodeStructure.addChild(header);
        XMLStructureNode specificObjectTab = new XMLStructureNode("LOGIN");
        specificObjectTab.addAttribute("state");
        XMLStructureNode Logins = new XMLStructureNode("Logins");
        XMLStructureNode loginsRow = new XMLStructureNode("row");
        loginsRow.setIsMulti(true);
        loginsRow.addAttribute("Host");
        loginsRow.addAttribute("Login");
        loginsRow.addAttribute("Mod");
        loginsRow.addAttribute("Pass");
        loginsRow.addAttribute("Type");
        Logins.addChild(loginsRow);
        specificObjectTab.addChild(Logins);
        entityNodeStructure.addChild(specificObjectTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getNotificationStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("CALL");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.CALL.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        header.addChild(new XMLStructureNode("ArchiveKey1"));
        header.addChild(new XMLStructureNode("ArchiveKey2"));
        header.addChild(new XMLStructureNode("ExtRepDef"));
        header.addChild(new XMLStructureNode("ExtRepAll"));
        header.addChild(new XMLStructureNode("ExtRepNone"));
        entityNodeStructure.addChild(header);
        XMLStructureNode syncRef = new XMLStructureNode("SYNCREF");
        XMLStructureNode sync = new XMLStructureNode("Syncs");
        XMLStructureNode syncRow = new XMLStructureNode("row");
        syncRow.setIsMulti(true);
        syncRow.setMultiName("Syncs_row");
        syncRef.addAttribute("state");
        syncRow.addAttribute("id");
        syncRow.addAttribute("Name");
        syncRow.addAttribute("Start");
        syncRow.addAttribute("Abend");
        syncRow.addAttribute("End");
        syncRow.addAttribute("Else");
        sync.addChild(syncRow);
        syncRef.addChild(sync);
        entityNodeStructure.addChild(syncRef);
        XMLStructureNode notification = new XMLStructureNode(NOTIFICATION);
        header.addAttribute("state");
        notification.addChild(new XMLStructureNode("Subject"));
        notification.addChild(new XMLStructureNode("Text"));
        notification.addChild(new XMLStructureNode("AttachReports"));
        notification.addChild(new XMLStructureNode("ReportSrcDb"));
        notification.addChild(new XMLStructureNode("ReportSrcExt"));
        notification.addChild(new XMLStructureNode("ReportSrcAll"));
        notification.addChild(new XMLStructureNode("AttachFile"));
        entityNodeStructure.addChild(notification);
        XMLStructureNode attributes = new XMLStructureNode("ATTR_CALL");
        attributes.addAttribute("state");
        attributes.addChild(new XMLStructureNode("StartType"));
        attributes.addChild(new XMLStructureNode("IntAccount"));
        attributes.addChild(new XMLStructureNode("MaxParallel2"));
        attributes.addChild(new XMLStructureNode("MpElse1"));
        attributes.addChild(new XMLStructureNode("MpElse2"));
        attributes.addChild(new XMLStructureNode("UC4Priority"));
        attributes.addChild(new XMLStructureNode("Priority"));
        attributes.addChild(new XMLStructureNode("Type"));
        attributes.addChild(new XMLStructureNode("Text"));
        attributes.addChild(new XMLStructureNode("ActAtRun"));
        attributes.addChild(new XMLStructureNode("TZ"));
        entityNodeStructure.addChild(attributes);
        XMLStructureNode specificObjectTab = new XMLStructureNode("CALL");
        specificObjectTab.addAttribute("state");
        XMLStructureNode cond = new XMLStructureNode("Cond");
        XMLStructureNode condRow = new XMLStructureNode("row");
        condRow.setIsMulti(true);
        condRow.addAttribute("CaleKeyName");
        condRow.addAttribute("CaleName");
        condRow.addAttribute("USR_Idnr");
        condRow.addAttribute("id");
        cond.addChild(condRow);
        specificObjectTab.addChild(cond);
        specificObjectTab.addChild(new XMLStructureNode("EscTime"));
        specificObjectTab.addChild(new XMLStructureNode("Object"));
        specificObjectTab.addChild(new XMLStructureNode("AutoDeact"));
        specificObjectTab.addChild(new XMLStructureNode("External1"));
        specificObjectTab.addChild(new XMLStructureNode("External2"));
        entityNodeStructure.addChild(specificObjectTab);
        XMLStructureNode runtimeTab = new XMLStructureNode("RUNTIME");
        runtimeTab.addAttribute("state");
        runtimeTab.addChild(new XMLStructureNode("MaxRetCode"));
        runtimeTab.addChild(new XMLStructureNode("FcstStatus"));
        runtimeTab.addChild(new XMLStructureNode("Ert"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDef"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtDynMethod"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDyn"));
        runtimeTab.addChild(new XMLStructureNode("ErtCnt"));
        runtimeTab.addChild(new XMLStructureNode("ErtCorr"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgn"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgnFlg"));
        runtimeTab.addChild(new XMLStructureNode("ErtMinCnt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodDate"));
        runtimeTab.addChild(new XMLStructureNode("MrtDays"));
        runtimeTab.addChild(new XMLStructureNode("MrtTime"));
        runtimeTab.addChild(new XMLStructureNode("MrtTZ"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("SrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtCancel"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecute"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecuteObj"));
        entityNodeStructure.addChild(runtimeTab);
        XMLStructureNode valuesTab = new XMLStructureNode("VALUE");
        XMLStructureNode values = new XMLStructureNode("Values");
        XMLStructureNode valuesRow = new XMLStructureNode("row");
        valuesRow.setIsMulti(true);
        valuesRow.setMultiName("Values");
        valuesRow.addAttribute("Name");
        valuesRow.addAttribute("Value");
        values.addChild(valuesRow);
        valuesTab.addChild(values);
        entityNodeStructure.addChild(valuesTab);
        XMLStructureNode scriptTab = new XMLStructureNode("SCRIPT");
        scriptTab.addAttribute("state");
        scriptTab.addChild(new XMLStructureNode("MSCRI"));
        entityNodeStructure.addChild(scriptTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getTimeZoneStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("TZ");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.TZ.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        entityNodeStructure.addChild(header);
        XMLStructureNode specificObjectTab = new XMLStructureNode("TZ");
        specificObjectTab.addAttribute("state");
        specificObjectTab.addChild(new XMLStructureNode("Year"));
        specificObjectTab.addChild(new XMLStructureNode("TzDiffhh"));
        specificObjectTab.addChild(new XMLStructureNode("TzDiffmi"));
        specificObjectTab.addChild(new XMLStructureNode("DlsDiffmi"));
        specificObjectTab.addChild(new XMLStructureNode("DlsSmo"));
        specificObjectTab.addChild(new XMLStructureNode("DlsStt"));
        specificObjectTab.addChild(new XMLStructureNode("DlsSwd"));
        specificObjectTab.addChild(new XMLStructureNode("DlsShh"));
        specificObjectTab.addChild(new XMLStructureNode("DlsSmi"));
        specificObjectTab.addChild(new XMLStructureNode("DlsEmo"));
        specificObjectTab.addChild(new XMLStructureNode("DlsEwd"));
        specificObjectTab.addChild(new XMLStructureNode("DlsEtt"));
        specificObjectTab.addChild(new XMLStructureNode("DlsEhh"));
        specificObjectTab.addChild(new XMLStructureNode("DlsEmi"));
        entityNodeStructure.addChild(specificObjectTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getUserStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("USER");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.USER.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        entityNodeStructure.addChild(header);
        XMLStructureNode specificObjectTab = new XMLStructureNode("USER");
        specificObjectTab.addAttribute("state");
        specificObjectTab.addAttribute("client");
        specificObjectTab.addChild(new XMLStructureNode("CboTimeZone"));
        specificObjectTab.addChild(new XMLStructureNode("FirstName"));
        specificObjectTab.addChild(new XMLStructureNode("LastName"));
        specificObjectTab.addChild(new XMLStructureNode("EMail1"));
        specificObjectTab.addChild(new XMLStructureNode("EMail2"));
        specificObjectTab.addChild(new XMLStructureNode("PwdNeverExpire"));
        specificObjectTab.addChild(new XMLStructureNode("PwdMustChange"));
        specificObjectTab.addChild(new XMLStructureNode("ValidTimeFrom"));
        specificObjectTab.addChild(new XMLStructureNode("ValidTimeTo"));
        specificObjectTab.addChild(new XMLStructureNode("ValidTime"));
        specificObjectTab.addChild(new XMLStructureNode("CaleName"));
        specificObjectTab.addChild(new XMLStructureNode("CaleKeyName"));
        specificObjectTab.addChild(new XMLStructureNode("MultiLogon"));
        specificObjectTab.addChild(new XMLStructureNode("EHRefresh"));
        specificObjectTab.addChild(new XMLStructureNode("Active"));
        entityNodeStructure.addChild(specificObjectTab);
        XMLStructureNode UACL = new XMLStructureNode("UACL");
        UACL.addAttribute("state");
        XMLStructureNode Rights = new XMLStructureNode("Rights");
        XMLStructureNode RightsRow = new XMLStructureNode("row");
        RightsRow.setIsMulti(true);
        RightsRow.addAttribute("AL");
        RightsRow.addAttribute("B1");
        RightsRow.addAttribute("B2");
        RightsRow.addAttribute(" B3");
        RightsRow.addAttribute("B4");
        RightsRow.addAttribute(" B5");
        RightsRow.addAttribute("B6");
        RightsRow.addAttribute(" B7");
        RightsRow.addAttribute("B8");
        RightsRow.addAttribute("F1");
        RightsRow.addAttribute("F2");
        RightsRow.addAttribute(" F3");
        RightsRow.addAttribute("F4");
        RightsRow.addAttribute(" F5");
        RightsRow.addAttribute("F6");
        RightsRow.addAttribute(" F7");
        RightsRow.addAttribute("F8");
        Rights.addChild(RightsRow);
        UACL.addChild(Rights);
        entityNodeStructure.addChild(UACL);
        XMLStructureNode PRIVILEGES = new XMLStructureNode("PRIVILEGES");
        PRIVILEGES.addAttribute("state");
        XMLStructureNode PrivList = new XMLStructureNode("PrivList");
        PrivList.setIsMulti(true);
        PrivList.addChild(new XMLStructureNode("B1"));
        PrivList.addChild(new XMLStructureNode("B2"));
        PrivList.addChild(new XMLStructureNode("B4"));
        PrivList.addChild(new XMLStructureNode("B8"));
        PrivList.addChild(new XMLStructureNode("B16"));
        PrivList.addChild(new XMLStructureNode("B32"));
        PrivList.addChild(new XMLStructureNode("B64"));
        PrivList.addChild(new XMLStructureNode("B128"));
        PrivList.addChild(new XMLStructureNode("B256"));
        PrivList.addChild(new XMLStructureNode("B512"));
        PrivList.addChild(new XMLStructureNode("B1024"));
        PrivList.addChild(new XMLStructureNode("B2048"));
        PrivList.addChild(new XMLStructureNode("B4096"));
        PrivList.addChild(new XMLStructureNode("B8192"));
        PrivList.addChild(new XMLStructureNode("B16384"));
        PrivList.addChild(new XMLStructureNode("B32768"));
        PrivList.addChild(new XMLStructureNode("B65536"));
        PrivList.addChild(new XMLStructureNode("B131072"));
        PrivList.addChild(new XMLStructureNode("B262144"));
        PrivList.addChild(new XMLStructureNode("B524288"));
        PrivList.addChild(new XMLStructureNode("B1048576"));
        PrivList.addChild(new XMLStructureNode("B2097152"));
        PrivList.addChild(new XMLStructureNode("B4194304"));
        PrivList.addChild(new XMLStructureNode("B8388608"));
        PRIVILEGES.addChild(PrivList);
        entityNodeStructure.addChild(PRIVILEGES);
        XMLStructureNode USRGU = new XMLStructureNode("USRGU");
        USRGU.addAttribute("state");
        XMLStructureNode Members = new XMLStructureNode("Members");
        XMLStructureNode MembersRow = new XMLStructureNode("row");
        MembersRow.setIsMulti(true);
        MembersRow.addAttribute("id");
        MembersRow.addAttribute("v0");
        MembersRow.addAttribute("v1");
        USRGU.addChild(Members);
        entityNodeStructure.addChild(USRGU);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getUserGroupStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("USRG");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.USRG.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        entityNodeStructure.addChild(header);
        XMLStructureNode UACL = new XMLStructureNode("UACL");
        UACL.addAttribute("state");
        XMLStructureNode Rights = new XMLStructureNode("Rights");
        XMLStructureNode RightsRow = new XMLStructureNode("row");
        RightsRow.setIsMulti(true);
        RightsRow.addAttribute("AL");
        RightsRow.addAttribute("B1");
        RightsRow.addAttribute("B2");
        RightsRow.addAttribute(" B3");
        RightsRow.addAttribute("B4");
        RightsRow.addAttribute(" B5");
        RightsRow.addAttribute("B6");
        RightsRow.addAttribute(" B7");
        RightsRow.addAttribute("B8");
        RightsRow.addAttribute("F1");
        RightsRow.addAttribute("F2");
        RightsRow.addAttribute(" F3");
        RightsRow.addAttribute("F4");
        RightsRow.addAttribute(" F5");
        RightsRow.addAttribute("F6");
        RightsRow.addAttribute(" F7");
        RightsRow.addAttribute("F8");
        Rights.addChild(RightsRow);
        UACL.addChild(Rights);
        entityNodeStructure.addChild(UACL);
        XMLStructureNode PRIVILEGES = new XMLStructureNode("PRIVILEGES");
        PRIVILEGES.addAttribute("state");
        XMLStructureNode PrivList = new XMLStructureNode("PrivList");
        PrivList.setIsMulti(true);
        PrivList.addChild(new XMLStructureNode("B1"));
        PrivList.addChild(new XMLStructureNode("B2"));
        PrivList.addChild(new XMLStructureNode("B4"));
        PrivList.addChild(new XMLStructureNode("B8"));
        PrivList.addChild(new XMLStructureNode("B16"));
        PrivList.addChild(new XMLStructureNode("B32"));
        PrivList.addChild(new XMLStructureNode("B64"));
        PrivList.addChild(new XMLStructureNode("B128"));
        PrivList.addChild(new XMLStructureNode("B256"));
        PrivList.addChild(new XMLStructureNode("B512"));
        PrivList.addChild(new XMLStructureNode("B1024"));
        PrivList.addChild(new XMLStructureNode("B2048"));
        PrivList.addChild(new XMLStructureNode("B4096"));
        PrivList.addChild(new XMLStructureNode("B8192"));
        PrivList.addChild(new XMLStructureNode("B16384"));
        PrivList.addChild(new XMLStructureNode("B32768"));
        PrivList.addChild(new XMLStructureNode("B65536"));
        PrivList.addChild(new XMLStructureNode("B131072"));
        PrivList.addChild(new XMLStructureNode("B262144"));
        PrivList.addChild(new XMLStructureNode("B524288"));
        PrivList.addChild(new XMLStructureNode("B1048576"));
        PrivList.addChild(new XMLStructureNode("B2097152"));
        PrivList.addChild(new XMLStructureNode("B4194304"));
        PrivList.addChild(new XMLStructureNode("B8388608"));
        PRIVILEGES.addChild(PrivList);
        entityNodeStructure.addChild(PRIVILEGES);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getVariableStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("VARA");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.VARA.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("HEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        entityNodeStructure.addChild(header);
        XMLStructureNode attributes = new XMLStructureNode("ATTR_VARA");
        attributes.addChild(new XMLStructureNode("Type"));
        attributes.addChild(new XMLStructureNode("VRName"));
        attributes.addChild(new XMLStructureNode("NotFoundErr"));
        attributes.addChild(new XMLStructureNode("NotFoundDef"));
        attributes.addChild(new XMLStructureNode("ShareN"));
        attributes.addChild(new XMLStructureNode("ShareL"));
        attributes.addChild(new XMLStructureNode("ShareR"));
        entityNodeStructure.addChild(attributes);
        XMLStructureNode specificObjectTab = new XMLStructureNode("VARA");
        specificObjectTab.addAttribute("state");
        XMLStructureNode variables = new XMLStructureNode("Variables");
        XMLStructureNode variablesRow = new XMLStructureNode("row");
        variablesRow.setIsMulti(true);
        variablesRow.addAttribute("Name");
        variablesRow.addAttribute("Value");
        variablesRow.addAttribute("Value1");
        variablesRow.addAttribute("Value2");
        variablesRow.addAttribute("Value3");
        variablesRow.addAttribute("Value4");
        variables.addChild(variablesRow);
        specificObjectTab.addChild(variables);
        entityNodeStructure.addChild(specificObjectTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getAgentStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("HOST");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.HOST.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        header.addChild(new XMLStructureNode("ArchiveKey1"));
        header.addChild(new XMLStructureNode("ArchiveKey2"));
        entityNodeStructure.addChild(header);
        XMLStructureNode HSTA_FILTER = new XMLStructureNode("HSTA_FILTER");
        HSTA_FILTER.addAttribute("state");
        XMLStructureNode FILTER = new XMLStructureNode("FILTER");
        XMLStructureNode FILTERRow = new XMLStructureNode("row");
        FILTERRow.setIsMulti(true);
        FILTERRow.addAttribute("hosttype");
        FILTERRow.addAttribute("hw");
        FILTERRow.addAttribute("id");
        FILTERRow.addAttribute("ip");
        FILTERRow.addAttribute("lic_cat");
        FILTERRow.addAttribute("lnr");
        FILTERRow.addAttribute("name");
        FILTERRow.addAttribute("not");
        FILTERRow.addAttribute("rolle");
        FILTERRow.addAttribute("sw");
        FILTERRow.addAttribute("sw_version");
        FILTERRow.addAttribute("version");
        FILTER.addChild(FILTERRow);
        HSTA_FILTER.addChild(FILTER);
        entityNodeStructure.addChild(HSTA_FILTER);
        XMLStructureNode HSTA_HACL = new XMLStructureNode("HSTA_HACL");
        HSTA_HACL.addAttribute("state");
        XMLStructureNode Rights = new XMLStructureNode("Rights");
        XMLStructureNode RightsRow = new XMLStructureNode("row");
        RightsRow.setIsMulti(true);
        RightsRow.addAttribute("Client");
        RightsRow.addAttribute("R");
        RightsRow.addAttribute("W");
        RightsRow.addAttribute("X");
        RightsRow.addAttribute("client");
        RightsRow.addAttribute("id");
        RightsRow.addAttribute("use");
        Rights.addChild(RightsRow);
        HSTA_HACL.addChild(Rights);
        entityNodeStructure.addChild(HSTA_HACL);
        XMLStructureNode runtimeTab = new XMLStructureNode("RUNTIME");
        runtimeTab.addAttribute("state");
        runtimeTab.addChild(new XMLStructureNode("<Child Name>"));
        entityNodeStructure.addChild(runtimeTab);
        XMLStructureNode scriptTab = new XMLStructureNode("SCRIPT");
        scriptTab.addAttribute("state");
        scriptTab.addChild(new XMLStructureNode("MSCRI"));
        entityNodeStructure.addChild(scriptTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getAgentGroupStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("HOSTG");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.HOSTG.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        header.addChild(new XMLStructureNode("ArchiveKey1"));
        header.addChild(new XMLStructureNode("ArchiveKey2"));
        entityNodeStructure.addChild(header);
        XMLStructureNode specificObjectTab = new XMLStructureNode("HOSTG");
        specificObjectTab.addAttribute("state");
        specificObjectTab.addChild(new XMLStructureNode("HostAttrType"));
        specificObjectTab.addChild(new XMLStructureNode("ModeA"));
        specificObjectTab.addChild(new XMLStructureNode("ModeF"));
        specificObjectTab.addChild(new XMLStructureNode("ModeN"));
        specificObjectTab.addChild(new XMLStructureNode("ModeL"));
        specificObjectTab.addChild(new XMLStructureNode("ModeX"));
        specificObjectTab.addChild(new XMLStructureNode("MaxParallel"));
        specificObjectTab.addChild(new XMLStructureNode("Enforced"));
        XMLStructureNode Members = new XMLStructureNode("Members");
        XMLStructureNode MembersRow = new XMLStructureNode("row");
        MembersRow.setIsMulti(true);
        MembersRow.addAttribute("Archive1");
        MembersRow.addAttribute("Archive2");
        MembersRow.addAttribute("HW");
        MembersRow.addAttribute("Icon");
        MembersRow.addAttribute("Name");
        MembersRow.addAttribute("Role");
        MembersRow.addAttribute("SW");
        MembersRow.addAttribute("SWVers");
        MembersRow.addAttribute("Type");
        MembersRow.addAttribute("Version");
        Members.addChild(MembersRow);
        specificObjectTab.addChild(Members);
        entityNodeStructure.addChild(specificObjectTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getGroupStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("JOBG");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.JOBG.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        header.addChild(new XMLStructureNode("ArchiveKey1"));
        header.addChild(new XMLStructureNode("ArchiveKey2"));
        header.addChild(new XMLStructureNode("ExtRepDef"));
        header.addChild(new XMLStructureNode("ExtRepAll"));
        header.addChild(new XMLStructureNode("ExtRepNone"));
        entityNodeStructure.addChild(header);
        XMLStructureNode syncRef = new XMLStructureNode("SYNCREF");
        syncRef.addAttribute("state");
        XMLStructureNode sync = new XMLStructureNode("Syncs");
        XMLStructureNode syncRow = new XMLStructureNode("row");
        syncRow.setIsMulti(true);
        syncRef.addAttribute("state");
        syncRow.addAttribute("id");
        syncRow.addAttribute("Name");
        syncRow.addAttribute("Start");
        syncRow.addAttribute("Abend");
        syncRow.addAttribute("End");
        syncRow.addAttribute("Else");
        sync.addChild(syncRow);
        syncRef.addChild(sync);
        entityNodeStructure.addChild(syncRef);
        XMLStructureNode attributes = new XMLStructureNode("ATTR_JOBG");
        attributes.addAttribute("state");
        attributes.addChild(new XMLStructureNode("MaxParallel"));
        attributes.addChild(new XMLStructureNode("StartModeCommand"));
        attributes.addChild(new XMLStructureNode("StartModeAuto"));
        attributes.addChild(new XMLStructureNode("AModeJP"));
        attributes.addChild(new XMLStructureNode("AModeMan"));
        attributes.addChild(new XMLStructureNode("ActAtRun"));
        attributes.addChild(new XMLStructureNode("TZ"));
        entityNodeStructure.addChild(attributes);
        XMLStructureNode runtimeTab = new XMLStructureNode("RUNTIME");
        runtimeTab.addAttribute("state");
        runtimeTab.addChild(new XMLStructureNode("MaxRetCode"));
        runtimeTab.addChild(new XMLStructureNode("FcstStatus"));
        runtimeTab.addChild(new XMLStructureNode("Ert"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDef"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtDynMethod"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDyn"));
        runtimeTab.addChild(new XMLStructureNode("ErtCnt"));
        runtimeTab.addChild(new XMLStructureNode("ErtCorr"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgn"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgnFlg"));
        runtimeTab.addChild(new XMLStructureNode("ErtMinCnt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodDate"));
        runtimeTab.addChild(new XMLStructureNode("MrtDays"));
        runtimeTab.addChild(new XMLStructureNode("MrtTime"));
        runtimeTab.addChild(new XMLStructureNode("MrtTZ"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("SrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtCancel"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecute"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecuteObj"));
        entityNodeStructure.addChild(runtimeTab);
        XMLStructureNode valuesTab = new XMLStructureNode("VALUE");
        XMLStructureNode values = new XMLStructureNode("Values");
        XMLStructureNode valuesRow = new XMLStructureNode("row");
        valuesRow.setIsMulti(true);
        valuesRow.setMultiName("Values");
        valuesRow.addAttribute("Name");
        valuesRow.addAttribute("Value");
        values.addChild(valuesRow);
        valuesTab.addChild(values);
        entityNodeStructure.addChild(valuesTab);
        XMLStructureNode scriptTab = new XMLStructureNode("SCRIPT");
        scriptTab.addAttribute("state");
        scriptTab.addChild(new XMLStructureNode("MSCRI"));
        entityNodeStructure.addChild(scriptTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getEventStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("EVNT");
        entityNodeStructure.setEntityName(UC4Globals.UC4_TYPES.EVNT.toString());
        entityNodeStructure.setRootAttribute("name");
        entityNodeStructure.addAttribute("client");
        entityNodeStructure.addAttribute("name");
        entityNodeStructure.addAttribute("system");
        XMLStructureNode header = new XMLStructureNode("XHEADER");
        header.addAttribute("state");
        header.addChild(new XMLStructureNode("Title"));
        header.addChild(new XMLStructureNode("ArchiveKey1"));
        header.addChild(new XMLStructureNode("ArchiveKey2"));
        header.addChild(new XMLStructureNode("ExtRepDef"));
        header.addChild(new XMLStructureNode("ExtRepAll"));
        header.addChild(new XMLStructureNode("ExtRepNone"));
        entityNodeStructure.addChild(header);
        XMLStructureNode syncRef = new XMLStructureNode("SYNCREF");
        XMLStructureNode sync = new XMLStructureNode("Syncs");
        XMLStructureNode syncRow = new XMLStructureNode("row");
        syncRow.setIsMulti(true);
        syncRef.addAttribute("state");
        syncRow.addAttribute("id");
        syncRow.addAttribute("Name");
        syncRow.addAttribute("Start");
        syncRow.addAttribute("Abend");
        syncRow.addAttribute("End");
        syncRow.addAttribute("Else");
        sync.addChild(syncRow);
        syncRef.addChild(sync);
        entityNodeStructure.addChild(syncRef);
        XMLStructureNode caleRef = new XMLStructureNode("CALEREF");
        caleRef.addAttribute("state");
        XMLStructureNode cond = new XMLStructureNode("Cond");
        XMLStructureNode condRow = new XMLStructureNode("row");
        condRow.setIsMulti(true);
        condRow.addAttribute("CaleKeyName");
        condRow.addAttribute("CaleName");
        condRow.addAttribute("From");
        condRow.addAttribute("To");
        condRow.addAttribute("id");
        cond.addChild(condRow);
        caleRef.addChild(cond);
        entityNodeStructure.addChild(caleRef);
        XMLStructureNode attributes = new XMLStructureNode("ATTR_EVNT");
        attributes.addAttribute("state");
        attributes.addChild(new XMLStructureNode("StartType"));
        attributes.addChild(new XMLStructureNode("IntAccount"));
        attributes.addChild(new XMLStructureNode("ActAtRun"));
        attributes.addChild(new XMLStructureNode("UC4Priority"));
        attributes.addChild(new XMLStructureNode("MaxParallel2"));
        attributes.addChild(new XMLStructureNode("MpElse1"));
        attributes.addChild(new XMLStructureNode("MpElse2"));
        attributes.addChild(new XMLStructureNode("TZ"));
        entityNodeStructure.addChild(attributes);
        XMLStructureNode specificObjectTab = new XMLStructureNode("EVNT");
        specificObjectTab.addAttribute("state");
        specificObjectTab.addChild(new XMLStructureNode("RepeatTypeR"));
        specificObjectTab.addChild(new XMLStructureNode("RepeatTypeS"));
        specificObjectTab.addChild(new XMLStructureNode("RepeatTypeF"));
        specificObjectTab.addChild(new XMLStructureNode("EventTypeTT"));
        specificObjectTab.addChild(new XMLStructureNode("EventTypeTS"));
        specificObjectTab.addChild(new XMLStructureNode("TimePeriodTT"));
        specificObjectTab.addChild(new XMLStructureNode("TimePeriodTS"));
        specificObjectTab.addChild(new XMLStructureNode("TExecTypeT"));
        specificObjectTab.addChild(new XMLStructureNode("TExecTypeS"));
        specificObjectTab.addChild(new XMLStructureNode("TExecTypeN"));
        specificObjectTab.addChild(new XMLStructureNode("TExecTypeE"));
        entityNodeStructure.addChild(specificObjectTab);
        XMLStructureNode eventDb = new XMLStructureNode("EVNT_DB");
        eventDb.addChild(new XMLStructureNode("Op1_type"));
        eventDb.addChild(new XMLStructureNode("Op1_sql"));
        eventDb.addChild(new XMLStructureNode("Op1_host"));
        eventDb.addChild(new XMLStructureNode("Op1_login"));
        eventDb.addChild(new XMLStructureNode("Op1_server"));
        eventDb.addChild(new XMLStructureNode("Op1_db"));
        eventDb.addChild(new XMLStructureNode("Operator"));
        eventDb.addChild(new XMLStructureNode("Op2_static"));
        entityNodeStructure.addChild(eventDb);
        XMLStructureNode specificObjectFileTypeTab = new XMLStructureNode("EVNT_FILE");
        specificObjectFileTypeTab.addAttribute("state");
        specificObjectFileTypeTab.addChild(new XMLStructureNode("HostDst"));
        specificObjectFileTypeTab.addChild(new XMLStructureNode("CLOSEOUTPUT"));
        specificObjectFileTypeTab.addChild(new XMLStructureNode("StartUpEvnt"));
        specificObjectFileTypeTab.addChild(new XMLStructureNode("Path"));
        specificObjectFileTypeTab.addChild(new XMLStructureNode("FileType"));
        specificObjectFileTypeTab.addChild(new XMLStructureNode("Operator"));
        specificObjectFileTypeTab.addChild(new XMLStructureNode("Value"));
        specificObjectFileTypeTab.addChild(new XMLStructureNode("Unit"));
        specificObjectFileTypeTab.addChild(new XMLStructureNode("InclSubDir"));
        entityNodeStructure.addChild(specificObjectFileTypeTab);
        XMLStructureNode runtimeTab = new XMLStructureNode("RUNTIME");
        runtimeTab.addAttribute("state");
        runtimeTab.addChild(new XMLStructureNode("MaxRetCode"));
        runtimeTab.addChild(new XMLStructureNode("FcstStatus"));
        runtimeTab.addChild(new XMLStructureNode("Ert"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDef"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtFix"));
        runtimeTab.addChild(new XMLStructureNode("ErtDynMethod"));
        runtimeTab.addChild(new XMLStructureNode("ErtMethodDyn"));
        runtimeTab.addChild(new XMLStructureNode("ErtCnt"));
        runtimeTab.addChild(new XMLStructureNode("ErtCorr"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgn"));
        runtimeTab.addChild(new XMLStructureNode("ErtIgnFlg"));
        runtimeTab.addChild(new XMLStructureNode("ErtMinCnt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtFix"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtMethodDate"));
        runtimeTab.addChild(new XMLStructureNode("MrtDays"));
        runtimeTab.addChild(new XMLStructureNode("MrtTime"));
        runtimeTab.addChild(new XMLStructureNode("MrtTZ"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodNone"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtFix"));
        runtimeTab.addChild(new XMLStructureNode("SrtMethodErt"));
        runtimeTab.addChild(new XMLStructureNode("SrtErt"));
        runtimeTab.addChild(new XMLStructureNode("MrtCancel"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecute"));
        runtimeTab.addChild(new XMLStructureNode("MrtExecuteObj"));
        entityNodeStructure.addChild(runtimeTab);
        XMLStructureNode valuesTab = new XMLStructureNode("VALUE");
        XMLStructureNode values = new XMLStructureNode("Values");
        XMLStructureNode valuesRow = new XMLStructureNode("row");
        valuesRow.setIsMulti(true);
        valuesRow.setMultiName("Values");
        valuesRow.addAttribute("Name");
        valuesRow.addAttribute("Value");
        values.addChild(valuesRow);
        valuesTab.addChild(values);
        entityNodeStructure.addChild(valuesTab);
        XMLStructureNode preScript = new XMLStructureNode("PRE_SCRIPT");
        preScript.addAttribute("state");
        preScript.addChild(new XMLStructureNode("PSCRI"));
        entityNodeStructure.addChild(preScript);
        XMLStructureNode scriptTab = new XMLStructureNode("SCRIPT");
        scriptTab.addAttribute("state");
        scriptTab.addChild(new XMLStructureNode("MSCRI"));
        entityNodeStructure.addChild(scriptTab);
        XMLStructureNode documentTab = new XMLStructureNode("DOCU_Docu");
        documentTab.addAttribute("type");
        XMLStructureNode DocuDOC = new XMLStructureNode("DOC");
        DocuDOC.setCsvName("DOCU_Docu_DOC");
        documentTab.addChild(DocuDOC);
        entityNodeStructure.addChild(documentTab);
        XMLStructureNode documentGeneral = new XMLStructureNode("DOCU_General");
        documentGeneral.addAttribute("state");
        documentGeneral.addAttribute("type");
        XMLStructureNode GeneralDOC = new XMLStructureNode("DOC");
        GeneralDOC.setCsvName("DOCU_General_DOC");
        documentGeneral.addChild(GeneralDOC);
        entityNodeStructure.addChild(documentGeneral);
        XMLStructureNode documentDetails = new XMLStructureNode("DOCU_Details");
        documentDetails.addAttribute("state");
        documentDetails.addAttribute("type");
        XMLStructureNode DetailsDOC = new XMLStructureNode("DOC");
        DetailsDOC.setCsvName("DOCU_Details_DOC");
        documentDetails.addChild(DetailsDOC);
        entityNodeStructure.addChild(documentDetails);
        return entityNodeStructure;
    }

    private static XMLStructureNode getTaskJobStructure() {
        XMLStructureNode task = new XMLStructureNode("task");
        task.setIsMulti(true);
        task.setHasMultiId(true);
        task.addMultiIdAttr("Idnr");
        task.addMultiIdAttr("Lnr");
        task.addAttribute("Idnr");
        task.addAttribute("Lnr");
        task.addAttribute("Object");
        task.addAttribute("OType");
        task.addAttribute("ParentObject");
        task.addAttribute("State");
        task.addAttribute("Text1");
        task.addAttribute("Text2");
        task.addAttribute("Text3");
        task.addAttribute("Text4");
        task.addAttribute("Text5");
        task.addAttribute("Text6");
        task.addAttribute("Row");
        task.addAttribute("Col");
        XMLStructureNode checkpoint = new XMLStructureNode("checkpoint");
        checkpoint.addAttribute("TcpOn");
        checkpoint.addAttribute("TcpADays");
        checkpoint.addAttribute("TcpATime");
        checkpoint.addAttribute("TcpATimeTZ");
        checkpoint.addAttribute("TcpExecute");
        task.addChild(checkpoint);
        XMLStructureNode after = new XMLStructureNode("after");
        after.addAttribute("AtimOn");
        after.addAttribute("ErlstStDays");
        after.addAttribute("ErlstStTime");
        after.addAttribute("ErlstStTimeTZ");
        after.addAttribute("ActFlg");
        after.addAttribute("HoldFlg");
        task.addChild(after);
        XMLStructureNode when = new XMLStructureNode("when");
        when.addAttribute("WtimOn");
        when.addAttribute("LtstSt");
        when.addAttribute("LtstStDays");
        when.addAttribute("LtstStTime");
        when.addAttribute("LtstEnd");
        when.addAttribute("LtstEndDays");
        when.addAttribute("LtstEndTime");
        when.addAttribute("LtstTimeTZ");
        when.addAttribute("WElseS");
        when.addAttribute("WElseH");
        when.addAttribute("WElseX");
        when.addAttribute("WElseA");
        when.addAttribute("ChkWhenExec");
        when.addAttribute("WhenExecute");
        when.addAttribute("WCTypeAND");
        when.addAttribute("WCTypeOR");
        task.addChild(when);
        XMLStructureNode predecessors = new XMLStructureNode("predecessors");
        predecessors.addAttribute("CaleOn");
        predecessors.addAttribute("CCTypeOne");
        XMLStructureNode pre = new XMLStructureNode("pre");
        pre.setIsMulti(true);
        pre.setNeedMultiId(true);
        pre.addMultiIdNames("Idnr", "pre");
        pre.addMultiIdNames("Lnr", "parent_Lnr");
        pre.addAttribute("Lnr");
        pre.addAttribute("PreLnr");
        pre.addAttribute("When");
        predecessors.addChild(pre);
        task.addChild(predecessors);
        XMLStructureNode runtime = new XMLStructureNode("runtime");
        runtime.addAttribute("MrtOn");
        runtime.addAttribute("MrtMethodNone");
        runtime.addAttribute("MrtMethodFix");
        runtime.addAttribute("MrtFix");
        runtime.addAttribute("MrtMethodErt");
        runtime.addAttribute("MrtErt");
        runtime.addAttribute("MrtMethodDate");
        runtime.addAttribute("MrtDays");
        runtime.addAttribute("MrtTime");
        runtime.addAttribute("MrtTZ");
        runtime.addAttribute("SrtMethodNone");
        runtime.addAttribute("SrtMethodFix");
        runtime.addAttribute("SrtFix");
        runtime.addAttribute("SrtMethodErt");
        runtime.addAttribute("SrtErt");
        runtime.addAttribute("MrtCancel");
        runtime.addAttribute("MrtExecute");
        runtime.addAttribute("MrtExecuteObj");
        task.addChild(runtime);
        XMLStructureNode result = new XMLStructureNode("result");
        result.addAttribute("RWhen");
        result.addAttribute("ChkRExec");
        result.addAttribute("RExecute");
        result.addAttribute("RRepOn");
        result.addAttribute("RRepMTimes");
        result.addAttribute("RRepWait");
        result.addAttribute("RElseHalt");
        result.addAttribute("RElseIgn");
        result.addAttribute("RElseJPAbend");
        result.addAttribute("RExecFlag");
        task.addChild(result);
        XMLStructureNode calendars = new XMLStructureNode("calendars");
        calendars.addAttribute("CaleOn");
        calendars.addAttribute("CCTypeAll");
        calendars.addAttribute("CCTypeOne");
        calendars.addAttribute("CCTypeNone");
        calendars.addAttribute("CCTypeExt");
        XMLStructureNode cale = new XMLStructureNode("cale");
        cale.setIsMulti(true);
        cale.setNeedMultiId(true);
        cale.addMultiIdNames("Idnr", "cale");
        cale.addAttribute("id");
        cale.addAttribute("CaleName");
        cale.addAttribute("CaleKeyName");
        calendars.addChild(cale);
        task.addChild(calendars);
        return task;
    }

    private static XMLStructureNode getConnCitStructure() {
        XMLStructureNode root = new XMLStructureNode("CONN_CIT");
        root.setEntityName(UC4Globals.UC4_TYPES.CONN_CIT.toString());
        root.setRootAttribute("name");
        root.addAttribute("name");
        XMLStructureNode header = new XMLStructureNode("HEADER");
        header.addChild(new XMLStructureNode("Title"));
        root.addChild(header);
        XMLStructureNode connCit = new XMLStructureNode("CONN_CIT");
        root.addChild(connCit);
        XMLStructureNode citcont = new XMLStructureNode("citcont");
        citcont.addAttribute("jobtype");
        citcont.addAttribute("text");
        connCit.addChild(citcont);
        XMLStructureNode cit = new XMLStructureNode("cit");
        cit.addAttribute("subtype");
        citcont.addChild(cit);
        XMLStructureNode component = new XMLStructureNode("component");
        component.setIsMulti(true);
        component.addAttribute("xmlName");
        component.addAttribute("value");
        cit.addChild(component);
        return root;
    }

    private static XMLStructureNode getConnSqlStructure() {
        XMLStructureNode root = new XMLStructureNode("CONN_SQL");
        root.setEntityName(UC4Globals.UC4_TYPES.CONN_SQL.toString());
        root.setRootAttribute("name");
        root.addAttribute("name");
        XMLStructureNode header = new XMLStructureNode("HEADER");
        header.addChild(new XMLStructureNode("Title"));
        root.addChild(header);
        XMLStructureNode conSql = new XMLStructureNode("CONN_SQL");
        root.addChild(conSql);
        XMLStructureNode citpanel = new XMLStructureNode("citpanel");
        citpanel.addAttribute("type");
        XMLStructureNode component = new XMLStructureNode("component");
        component.setIsMulti(true);
        component.addAttribute("xmlName");
        component.addAttribute("value");
        citpanel.addChild(component);
        conSql.addChild(citpanel);
        return root;
    }

    private static XMLStructureNode StubStructure() {
        XMLStructureNode entityNodeStructure = new XMLStructureNode("UNKNOWN");
        entityNodeStructure.setRootAttribute("name");
        return entityNodeStructure;
    }
}

