/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.UC4Objects;

import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Objects.TriggeredJobsHandler;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4EventsHandler;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectProcessFlow;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectSchedule;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMapCreator;
import com.bmc.ctmconvert.uc4.UC4XMLStructure;
import com.bmc.ctmconvert.uc4.XML.XMLStructureNode;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class UC4ObjectTablesMap {
    private static UC4ObjectTablesMap instance;
    private HashMap<UC4Globals.UC4_TYPES, HashMap<String, UC4Object>> objMap = new HashMap();
    private HashMap<UC4Globals.UC4_TYPES, HashMap<String, ArrayList<UC4Object>>> duplicateObjMap = new HashMap();
    private static UC4Object unAutomatedSchedule;
    private ArrayList<String> automatedList;
    private static final String unAutomatedName = "NOSCHED";
    public static final String[] JSCHStub;
    private static final String[] TaskStub;
    private Path unAutomatedscheduleFileName;
    private TriggeredJobsHandler triggeredJobsHandler;

    protected UC4ObjectTablesMap(Path datasourcePath) {
        this.init(datasourcePath);
    }

    void init(Path datasourcePath) {
        UC4ObjectTablesMapCreator uC4ObjectTablesMapCreator = new UC4ObjectTablesMapCreator(this);
        uC4ObjectTablesMapCreator.load(datasourcePath);
        this.removeCircularJOBP();
        this.handleUC4EventsScriptActivateObject();
        this.unAutomatedscheduleFileName = datasourcePath.resolve("NOSCHED.csv");
        this.updateExternalDependences();
        if (unAutomatedSchedule == null) {
            this.generateUnAutomatedEntities();
        }
    }

    static void setInstanceForTesting(UC4ObjectTablesMap instance) {
        UC4ObjectTablesMap.instance = instance;
    }

    private void removeCircularJOBP() {
        Collection<UC4Object> allJOBP = this.objMap.get((Object)UC4Globals.UC4_TYPES.JOBP).values();
        ArrayList<String> removedTasks = new ArrayList<String>();
        for (UC4Object jobp : allJOBP) {
            ArrayList<String> fullPath = new ArrayList<String>();
            this.removeCycles(jobp, fullPath, removedTasks);
        }
        if (!removedTasks.isEmpty()) {
            this.showSelfReferencingTasksWarning(removedTasks);
        }
    }

    private boolean removeCycles(UC4Object root, List<String> path, List<String> removedTasks) {
        if (root == null) {
            return false;
        }
        if (path.contains(root.getName()) && UC4Globals.UC4_TYPES.JOBP == root.getType()) {
            path.add(root.getName());
            removedTasks.add(String.join((CharSequence)"/", path));
            return true;
        }
        path.add(root.getName());
        AttrHolderList children = root.getChildren();
        if (children != null) {
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                IAttrHolder child = (IAttrHolder)iterator.next();
                boolean isCircularJOBP = this.removeCycles(this.getChild(child), new ArrayList<String>(path), removedTasks);
                if (!isCircularJOBP) continue;
                iterator.remove();
            }
        }
        return false;
    }

    void showSelfReferencingTasksWarning(List<String> removed) {
        BaseMessageDialog.showMessageDialog((String)"Self-referencing tasks", (String)"Self-referencing tasks were detected. The self-referencing tasks will not be converted", (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.WARNING_MESSAGE, (String)"The following tasks references themselves.\nThe self-referencing tasks will not be converted.\nThe full path of the self-referencing tasks are:\n%s".formatted(String.join((CharSequence)"\n", removed)));
    }

    private void handleUC4EventsScriptActivateObject() {
        UC4EventsHandler uc4EventsHandler = new UC4EventsHandler(this.objMap.get((Object)UC4Globals.UC4_TYPES.EVNT));
        this.triggeredJobsHandler = new TriggeredJobsHandler(uc4EventsHandler, this);
    }

    private void updateExternalDependences() {
        HashMap<String, UC4Object> tmpTaskObects = new HashMap<String, UC4Object>();
        HashMap<String, UC4Object> getJSCHMap = this.objMap.get((Object)UC4Globals.UC4_TYPES.JSCH);
        HashMap<String, UC4Object> getJobPMap = this.objMap.get((Object)UC4Globals.UC4_TYPES.JOBP);
        tmpTaskObects.putAll(getJSCHMap);
        tmpTaskObects.putAll(getJobPMap);
        for (UC4Object obj : tmpTaskObects.values()) {
            AttrHolderList tmpTasksList = obj.getMultiAttributes(String.format("%s_%s", obj.getType().toString(), "task"));
            if (tmpTasksList == null || tmpTasksList.isEmpty()) continue;
            for (IAttrHolder task : tmpTasksList) {
                UC4Object tmpUC4Object;
                String type = task.getAttr("task_OType");
                String name = task.getAttr("task_Object");
                if (!"<XTRNL>".equalsIgnoreCase(type) || (tmpUC4Object = this.getObjById(name)) == null) continue;
                String lnrOfXtrnl = task.getAttr("task_Lnr");
                AttrHolderList dependencyJobs = ((UC4ObjectProcessFlow)obj).getJobByPrePreLnr(lnrOfXtrnl);
                for (IAttrHolder job : dependencyJobs) {
                    UC4Object dependentOnXTRNLJob = this.getObjById(job.getAttr("task_Object"));
                    if (dependentOnXTRNLJob == null) continue;
                    tmpUC4Object.addExternalJob(dependentOnXTRNLJob);
                }
                tmpUC4Object.setIsExternalDependences(true);
            }
        }
    }

    public static UC4ObjectTablesMap instance(Path dataSourcrPath) {
        if (instance == null) {
            unAutomatedSchedule = null;
            instance = new UC4ObjectTablesMap(dataSourcrPath);
        }
        return instance;
    }

    public void setUnAutomated(boolean includeUnautomated) {
        if (includeUnautomated) {
            this.objMap.get((Object)UC4Globals.UC4_TYPES.JSCH).put(unAutomatedName, unAutomatedSchedule);
        } else {
            this.objMap.get((Object)UC4Globals.UC4_TYPES.JSCH).remove(unAutomatedName);
        }
    }

    public void setSchedInObjectMap(String name, UC4Object obj) {
        this.objMap.get((Object)UC4Globals.UC4_TYPES.JSCH).put(name, obj);
    }

    public static void destroy() {
        instance = null;
    }

    public HashMap<String, UC4Object> getObj(UC4Globals.UC4_TYPES type) {
        return this.objMap.computeIfAbsent(type, k -> new HashMap());
    }

    public UC4Object getObjById(String id) {
        for (UC4Globals.UC4_TYPES type : UC4Globals.UC4_TYPES.values()) {
            HashMap<String, UC4Object> typeObjList = this.getObj(type);
            if (!typeObjList.containsKey(id)) continue;
            return typeObjList.get(id);
        }
        return null;
    }

    public HashMap<String, ArrayList<UC4Object>> getDuplicateObj(UC4Globals.UC4_TYPES type) {
        return this.duplicateObjMap.computeIfAbsent(type, k -> new HashMap());
    }

    private void generateUnAutomatedEntities() {
        ArrayList<String> JSCHHeaders = XMLStructureNode.getHeaders(UC4XMLStructure.getXMLStructure(UC4Globals.UC4_TYPES.JSCH), true);
        String JSCHHeadersStr = JSCHHeaders.toString().replace(" ", "");
        JSCHHeadersStr = JSCHHeadersStr.substring(1, JSCHHeadersStr.lastIndexOf("]"));
        HashMap attrName2Index = AttrHolder.buildHeadersMap((String)JSCHHeadersStr);
        AttrHolder attr = new AttrHolder(JSCHStub, (Map)attrName2Index);
        unAutomatedSchedule = new UC4ObjectSchedule((IAttrHolder)attr, UC4Globals.UC4_TYPES.JSCH);
        this.automatedList = new ArrayList();
        try {
            for (UC4Object topLevelObj : this.objMap.get((Object)UC4Globals.UC4_TYPES.JSCH).values()) {
                this.fillAutomatedListRecursive(topLevelObj);
            }
            if (!Files.exists(this.unAutomatedscheduleFileName, new LinkOption[0])) {
                Files.createFile(this.unAutomatedscheduleFileName, new FileAttribute[0]);
            }
            BufferedWriter writer = Files.newBufferedWriter(this.unAutomatedscheduleFileName, new OpenOption[0]);
            writer.write("Line,Name,Type,TypeShortName\n");
            UC4Globals.UC4_TYPES[] entities = new UC4Globals.UC4_TYPES[]{UC4Globals.UC4_TYPES.JOBP, UC4Globals.UC4_TYPES.JOBS, UC4Globals.UC4_TYPES.SCRI, UC4Globals.UC4_TYPES.JOBF};
            int lnrCnt = 1;
            for (UC4Globals.UC4_TYPES type : entities) {
                Collection<UC4Object> uc4Objects = this.objMap.get((Object)type).values();
                for (UC4Object obj : uc4Objects) {
                    if (this.automatedList.contains(obj.getName())) continue;
                    this.addTaskToSchedule(unAutomatedSchedule, obj, lnrCnt);
                    writer.write(lnrCnt++ + "," + obj.getName() + "," + obj.getType().toString() + "," + obj.getType().getTagName() + "\n");
                    if (!type.equals((Object)UC4Globals.UC4_TYPES.JOBP)) continue;
                    this.fillAutomatedListRecursive(obj);
                }
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void addTaskToSchedule(UC4Object schedule, UC4Object obj, int entryCount) {
        String multiAttrTaskName = String.format("%s_%s", new Object[]{UC4Globals.UC4_TYPES.JSCH, "task"});
        IAttrHolder taskAttr = this.createTaskAttrInSched(entryCount, obj.getName(), obj.getType().getTagName());
        schedule.addMultiAttributes(multiAttrTaskName, taskAttr);
    }

    @NotNull
    private IAttrHolder createTaskAttrInSched(int lnrCnt, String objName, String typeTagName) {
        ArrayList<String> taskHeaders = XMLStructureNode.getHeaders(UC4XMLStructure.getMultiXMLStructure(UC4Globals.UC4_TYPES.JSCH, "task"), false);
        String taskHeadersStr = taskHeaders.toString().replace(" ", "");
        taskHeadersStr = taskHeadersStr.substring(1, taskHeadersStr.lastIndexOf("]"));
        HashMap taskAttrName2Index = AttrHolder.buildHeadersMap((String)taskHeadersStr);
        String[] record = (String[])TaskStub.clone();
        record[2] = Integer.toString(lnrCnt);
        record[3] = objName;
        record[4] = record[7] = typeTagName;
        AttrHolder taskAttr = new AttrHolder(record, (Map)taskAttrName2Index);
        return taskAttr;
    }

    private void fillAutomatedListRecursive(UC4Object root) {
        if (root == null) {
            return;
        }
        this.automatedList.add(root.getName());
        AttrHolderList childList = root.getChildren();
        if (childList != null) {
            childList = this.triggeredJobsHandler.getChildrenWithTriggeredJobs(root);
            for (IAttrHolder child : childList) {
                this.fillAutomatedListRecursive(this.getChild(child));
            }
        }
    }

    public UC4Object getChild(IAttrHolder child) {
        String currType = child.getAttr("task_OType");
        String currId = child.getAttr("task_Object");
        UC4Object toRet = null;
        try {
            UC4Globals.UC4_TYPES currUC4Type = UC4Globals.UC4_TYPES.valueOf(currType);
            toRet = this.objMap.get((Object)currUC4Type).get(currId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return toRet;
    }

    public TriggeredJobsHandler getTriggeredJobsHandler() {
        return this.triggeredJobsHandler;
    }

    static {
        unAutomatedSchedule = null;
        JSCHStub = new String[]{"JSCH", "0001", unAutomatedName, "", "", "", "0", "0", "0", "", "", "", "0", "1", "00:00", "0", "0", "0", "0", ".0", "", "", "00:00", "1", "design", "0", "YES", "0", "0|", "0", "0", "0", "0", "2|Average", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "00:00", "", "0", "0", "0", "0", "0", "0", "0", "", "", "", "", "", "", "", "", "", "", "", "text", ""};
        TaskStub = new String[]{unAutomatedName, "", "<lnr>", "<ObjName>", "<ObjType>", "", "", "<ObjType>", "", "", "", "", "00:00", "", "0", "00:00", "0", "", "0", "0", "0", "0", "0", "0", "0", "0", "00:00", "", "0", "0", "0", "0", "0", "0", "0", "", "", "", "0", "", "0", "0", "0", "0", "0", "0", "0", "", "0", "0", "0", "0", "0"};
    }
}

