/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.UC4Objects;

import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UC4EventsHandler {
    private static final String ACTIVATE_JOB_REGEX = "(.?)*((:SET(\\s*)(\\S*)(\\s*)=(\\s*)('?\"?)([^'\"]+))|(ACTIVATE_UC_OBJECT\\('?\"?)(?<ucObject>(?<ucType>[^ \",\\)']+)(.*))(\\)))";
    private Map<String, List<UC4Object>> jobNameToTriggerringEventMap;
    private HashMap<String, UC4Object> eventsMap;
    private Map<String, List<String>> eventNameToTriggeredUC4ObjectsMap;
    private Map<String, String> variableNamesMap;
    private List<String> activateVariablesNamesList;

    public UC4EventsHandler(HashMap<String, UC4Object> eventsMap) {
        this.eventsMap = eventsMap;
        this.eventNameToTriggeredUC4ObjectsMap = new HashMap<String, List<String>>();
        this.jobNameToTriggerringEventMap = new HashMap<String, List<UC4Object>>();
        this.variableNamesMap = new HashMap<String, String>();
        this.activateVariablesNamesList = new ArrayList<String>();
    }

    public void findTriggeredUC4ObjectNames() {
        for (String eventName : this.eventsMap.keySet()) {
            UC4Object uc4EventObject = this.eventsMap.get(eventName);
            if (uc4EventObject == null) continue;
            String script = uc4EventObject.getAttribute("MSCRI");
            List<String> uc4ObjectNameList = new ArrayList<String>();
            this.readScriptContent(script, uc4ObjectNameList);
            List distinctUc4ObjectNameList = (uc4ObjectNameList = this.resolveVariablesToObjectNamesList(uc4ObjectNameList)).stream().distinct().toList();
            if (distinctUc4ObjectNameList.isEmpty()) continue;
            this.eventNameToTriggeredUC4ObjectsMap.put(eventName, distinctUc4ObjectNameList);
            distinctUc4ObjectNameList.forEach(job -> this.jobNameToTriggerringEventMap.computeIfAbsent((String)job, k -> new ArrayList()).stream().filter(e -> e.equals(uc4EventObject)).findAny().orElseGet(() -> {
                this.jobNameToTriggerringEventMap.get(job).add(uc4EventObject);
                return uc4EventObject;
            }));
        }
    }

    private List<String> resolveVariablesToObjectNamesList(List<String> uc4ObjectNameList) {
        ArrayList<String> resolvedNamesList = new ArrayList<String>();
        for (String uc4Object : uc4ObjectNameList) {
            if (this.variableNamesMap.containsKey(uc4Object)) {
                resolvedNamesList.add(this.variableNamesMap.get(uc4Object));
                continue;
            }
            resolvedNamesList.add(uc4Object);
        }
        return resolvedNamesList;
    }

    private String findTriggeredUC4Object(String script) {
        String uc4ObjectName = "";
        script = script.toUpperCase();
        Pattern pattern = Pattern.compile(ACTIVATE_JOB_REGEX);
        Matcher matcher = pattern.matcher(script);
        if (matcher.find()) {
            uc4ObjectName = matcher.group("ucType");
            String string = uc4ObjectName = uc4ObjectName == null ? "" : uc4ObjectName;
            if (!uc4ObjectName.isEmpty()) {
                String[] complexName = matcher.group("ucObject").split(",");
                String variableName = (complexName.length == 2 ? complexName[1] : complexName[0]).trim();
                if (!matcher.group(11).contains(",")) {
                    variableName = uc4ObjectName;
                }
                if (!variableName.isEmpty()) {
                    if (variableName.startsWith("'") && variableName.endsWith("'")) {
                        variableName = variableName.substring(1, variableName.length() - 1);
                    }
                    return variableName;
                }
            }
            String key = matcher.group(5);
            String value = matcher.group(9);
            if (key != null && value != null) {
                this.variableNamesMap.put(key, value);
            }
        }
        return uc4ObjectName;
    }

    private void readScriptContent(String script, List<String> uc4ObjectNameList) {
        try (Scanner scanner = new Scanner(script);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String triggerdUc4ObjectName = this.findTriggeredUC4Object(line);
                if (triggerdUc4ObjectName.isEmpty()) continue;
                uc4ObjectNameList.add(triggerdUc4ObjectName);
            }
        }
    }

    public Map<String, List<UC4Object>> getJobNameToTriggerringEventMap() {
        return new HashMap<String, List<UC4Object>>(this.jobNameToTriggerringEventMap);
    }

    public Map<String, List<String>> getEventNameToTriggeredUC4ObjectsMap() {
        return new HashMap<String, List<String>>(this.eventNameToTriggeredUC4ObjectsMap);
    }

    public Map<String, String> getVariablesNamesMap() {
        return new HashMap<String, String>(this.variableNamesMap);
    }
}

