/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TimeEventHandler {
    private final UC4Object obj;
    private final Map<String, String> startTimes;
    private String timeToStr;
    private final UC4Job uc4Job;
    private final IAttrHolder uc4TaskAttr;
    private final UC4Globals.UC4_TYPES uc4Type;

    public TimeEventHandler(UC4Object obj, UC4Job uc4Job) {
        this.obj = obj;
        this.uc4Job = uc4Job;
        this.uc4TaskAttr = uc4Job.getTaskAttr();
        this.uc4Type = uc4Job.getUC4Type();
        this.startTimes = new HashMap<String, String>();
        this.timeToStr = "";
    }

    public void handleTimeEvent() {
        if (this.obj.isCyclicEvent()) {
            this.setCyclicAttributes();
        } else {
            if (!this.obj.getAttribute("TimePeriodTS").isEmpty()) {
                this.startTimes.put("TimePeriodTS", this.obj.getAttribute("TimePeriodTS"));
            }
            if (this.obj.getAttribute("TExecTypeN").equals("1")) {
                this.timeToStr = this.convertTimeToCtmTime(this.obj.getAttribute("TimePeriodTS"), true);
            }
        }
        this.handleStartTime(this.startTimes);
        if (!this.timeToStr.isEmpty() && this.uc4Job.getAttr("TIMEFROM").equals(this.obj.getAttribute("TimePeriodTS").replace(":", ""))) {
            this.uc4Job.addAttribute("TIMETO", this.timeToStr);
        }
    }

    private void setCyclicAttributes() {
        this.uc4Job.addAttribute("CYCLIC", "1");
        this.uc4Job.addAttribute("CYCLIC_TYPE", "Interval");
        int interval = Integer.parseInt(this.obj.getAttribute("TimePeriodTT"));
        this.uc4Job.addAttribute("INTERVAL", String.format("%05dM", interval));
        this.uc4Job.addAttribute("IND_CYCLIC", "END");
        if (this.obj.getAttribute("RepeatTypeS").equals("1")) {
            this.uc4Job.addAttribute("MAXRERUN", "1");
        }
    }

    private String convertTimeToCtmTime(String time, boolean isTimeTo) {
        if (time == null || time.isEmpty() || time.equals("0")) {
            return "0000";
        }
        Object toRet = "";
        String[] timpArr = time.split(":");
        toRet = timpArr.length > 1 ? (String)toRet + timpArr[0] : (String)toRet + "00";
        int min = Integer.parseInt(timpArr[1]);
        if (isTimeTo) {
            ++min;
        }
        toRet = (String)toRet + String.valueOf(min);
        return toRet;
    }

    private void handleStartTime(Map<String, String> startTimes) {
        String startTime = "";
        if (this.uc4TaskAttr != null) {
            if (this.uc4TaskAttr.isFieldExist("after_ErlstStTime") && !(startTime = this.uc4TaskAttr.getAttr("after_ErlstStTime")).isEmpty()) {
                startTimes.put("ErlstStTime", startTime);
            }
            if (this.uc4TaskAttr.isFieldExist("TimePeriod_TimePeriodValue") && !(startTime = this.uc4TaskAttr.getAttr("TimePeriod_TimePeriodValue")).isEmpty()) {
                startTimes.put("TimePeriodValue", startTime);
            }
        }
        if (this.uc4Type.equals((Object)UC4Globals.UC4_TYPES.JSCH) && !(startTime = this.obj.getAttribute("StartTime")).isEmpty()) {
            startTimes.put("StartTime", startTime);
        }
        this.setStartTime(startTimes);
    }

    private void setStartTime(Map<String, String> startTimes) {
        boolean isMoreOneValue;
        Optional<String> firstTimeFrom = startTimes.values().stream().findFirst();
        firstTimeFrom.ifPresent(timeFrom -> this.uc4Job.addAttribute("TIMEFROM", timeFrom.replace(":", "")));
        boolean bl = isMoreOneValue = startTimes.values().stream().distinct().count() > 1L;
        if (isMoreOneValue) {
            String foundStartTimes = startTimes.entrySet().stream().map(e -> (String)e.getKey() + " = " + (String)e.getValue()).collect(Collectors.joining(" and "));
            firstTimeFrom.ifPresent(f -> this.uc4Job.addMessage("WRN8067", this.uc4Job.getOriginalJobName(), this.uc4Job.getJobName(), this.uc4Job.getAttr("TIMEFROM"), foundStartTimes));
        }
    }
}

